"use strict";
this.name = "TCAT_mantis";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Thargoid base script.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
function TCAT_localMines(entity) {
	var isWeapon = entity.isWeapon,
		isActive = entity.AI !== "TCAT_deactivatedAI.plist",
		mines = ["EQ_QC_MINE", "EQ_RMB_CASCADE_MISSILE", "EQ_RMB_LAW_MISSILE", "EQ_RMB_OVERRIDE_MISSILE",
			"energy-bomb", "EQ_NUKE2_MISSILE", "EQ_HARPOON_NUKE2_MISSILE", "EQ_PHOTON_MISSILE", "RANDOM_HITS_MINE"],
		isLocalMine = mines.some(function (mine, i, array) { return entity.hasRole(mine); });
	return isWeapon && isActive && isLocalMine;
}

//----------------------------------------------------------------------------------------
function targetShips(entity) { return entity.isShip && !entity.docked && entity.scanClass != "CLASS_ROCK" && entity.scanClass != "CLASS_CARGO" && !entity.isThargoid && !entity.isCloaked };

//----------------------------------------------------------------------------------------
this.shipSpawned = function () {
	this.armadaGroup = system.addGroup("TCAT_armada", 6, this.ship.position, 15000);
	this.armadaGroup.leader = this.ship;

	if (this.scanTimer) {
		this.scanTimer.start();
	} else {
		this.scanTimer = new Timer(this, this.mineScan, 0, 4.75);
	}
	this.scrambleFlag = null;
}

//----------------------------------------------------------------------------------------
this.playerWillEnterWitchspace = function () {
	if (this.scanTimer) {
		this.scanTimer.stop();
	}
}

//----------------------------------------------------------------------------------------
this.checkTarget = function () {
	if (this.ship.target && !this.ship.target.scanClass == "CLASS_THARGOID" && !this.ship.target.hasRole("thargoid") && !this.ship.target.hasRole("thargon")) {
		this.ship.reactToAIMessage("TARGET_VALID");
	} else {
		this.ship.reactToAIMessage("NO_TARGET");
	}
}

//----------------------------------------------------------------------------------------
this.mineScan = function () {
	this.mineArray = system.filteredEntities(this, TCAT_localMines, this.ship, 25600);

	if (this.mineArray.length > 0) {
		player.consoleMessage(expandMissionText("IR_cascade_suppressed"), 6);
		this.mineArray.forEach(
			function (mine) {
				mine.setAI("TCAT_deactivatedAI.plist");
				mine.displayName = "Disarmed " + mine.displayName;
				mine.scannerDisplayColor1 = "whiteColor";
				mine.scannerDisplayColor2 = "whiteColor";
			}
		)
	}
}

//----------------------------------------------------------------------------------------
this.findStation = function () {
	this.stationArray = system.shipsWithPrimaryRole("TCAT_navyStation");
	if (this.stationArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		this.ship.target = this.stationArray[0];
		this.ship.reactToAIMessage("STATION_FOUND");
	}
}

//----------------------------------------------------------------------------------------
this.scramble = function () {
	this.scrambleFlag = "LAUNCH";
	this.launchGuards();
}

//----------------------------------------------------------------------------------------
this.launchGuards = function () {
	this.subLength = this.ship.subEntities.length;
	if (this.subLength == 0) {
		return;
	}

	this.guardArray = [];
	for (var guardCounter = 0; guardCounter < this.subLength; guardCounter++) {
		if (this.ship.subEntities[guardCounter].hasRole("TCAT_guardRot")) {
			this.guardArray.push(guardCounter);
		}
	}

	if (this.guardArray.length == 0) {
		return;
	}

	for (var guardCounter = this.guardArray.length - 1; guardCounter >= 0; guardCounter--) {
		if (Math.random() < 0.1 || this.scrambleFlag == "LAUNCH") {
			this.guardPosition = this.ship.subEntities[this.guardArray[guardCounter]].position;
			this.guardOrientation = this.ship.subEntities[this.guardArray[guardCounter]].orientation;
			this.ship.subEntities[this.guardArray[guardCounter]].remove();
			var subGuard = this.ship.spawnOne("TCAT_guardRot");
			subGuard.position = this.localToGlobal(this.guardPosition);
			subGuard.orientation = this.guardOrientation.multiply(this.ship.orientation);
			this.armadaGroup.addShip(subGuard);
		}
	}
}

//----------------------------------------------------------------------------------------
this.localToGlobal = function (position) { // sub-ent position is relative to mother, but for swapping we need the absolute global position
	let orientation = this.ship.orientation;
	orientation.w = -orientation.w; // this is needed to get things in the right place for some reason?
	return this.ship.position.add(position.rotateBy(orientation));
}

//----------------------------------------------------------------------------------------
this.shipEnteredWitchspace = function () {
	this.scanTimer.stop();
	if (this.ship.escorts.length > 0) // could we use escortGroup here?
	{
		for (var escortCounter = this.ship.escorts.length - 1; escortCounter >= 0; escortCounter--) {
			this.ship.escorts[escortCounter].remove();
		}
	}
	this.ship.remove();
}

//----------------------------------------------------------------------------------------
this.shipFiredMissile = function (missile, target) {
	if (missile.hasRole("TCAT_guard") || missile.hasRole("TCAT_armada")) { // if the mantis launched a ship "missile" add it to the ship group
		this.armadaGroup.addShip(missile);
	}
}

//----------------------------------------------------------------------------------------
this.shipDied = function (who, why) {
	this.scanTimer.stop();

	if (missionVariables.TCAT_mission && (missionVariables.TCAT_mission == "INCOMING" || missionVariables.TCAT_mission == "ARMADA")) {
		missionVariables.TCAT_mission = "REPELLED";
	}

	this.fuelCount = 15 + Math.ceil(Math.random() * 10);
	this.largeCount = 4 + Math.ceil(Math.random() * 3);
	this.smallCount = 5 + Math.ceil(Math.random() * 5);

	//system.legacy_addShipsWithinRadius("TCAT_burningFuel", this.fuelCount, "abs", this.ship.position, 10);
	system.addShips("TCAT_burningFuel", this.fuelCount, this.ship.position, 10);
	//system.legacy_addShipsWithinRadius("TCAT_smallWreckage", this.smallCount, "abs", this.ship.position, 5);
	system.addShips("TCAT_smallWreckage", this.smallCount, this.ship.position, 5);

	if (this.largeCount > 0) {
		//system.legacy_addShipsWithinRadius("TCAT_largeWreckage", this.largeCount, "abs", this.ship.position, 5);
		system.addShips("TCAT_largeWreckage", this.largeCount, this.ship.position, 5);
	}
}