"use strict";
this.name = "TCAT_jumpGate";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Script for Thargoid jumpgates";
this.version = "2.0";

function TCAT_allGates(entity) { return entity.isShip && entity != this.ship && entity.hasRole("TCAT_jumpGate") }; // all gates except this one
function TCAT_clients(entity) { return entity.isShip && !entity.isStation && entity.primaryRole != "TCAT_gateGuard" && !entity.isWeapon && !entity.isRock && !entity.isCargo && (!entity.hasOwnProperty("TCAT_receivingGate") || entity.TCAT_receivingGate == null) }; // ships that can use jumpgates (exclude spawned defenders, missiles, mines, asteroids and cargo pods
function TCAT_oldClients(entity) { return entity.isShip && entity.hasOwnProperty("TCAT_receivingGate") && entity.TCAT_receivingGate != null && entity.position.distanceTo(this.ship.position) > 500 && entity.position.distanceTo(this.ship.position) < 5000 }; // ships which have come through this gate and are now between 500m and 5km from it

//----------------------------------------------------------------------------------------
this.shipSpawned = function () {
	this.ship.orientation = [1, 0, 0, 0]; // point them all in the same direction, along universal Z.
	this.defenderCount = 10; // max number of defenders that can be launched overall by the gate if attacked

	if (this.scanTimer) {
		this.scanTimer.start();
	} else {
		this.scanTimer = new Timer(this, this.shipApproach, 0, 1.0); // scan for jumping ships every 1 second - too long/short?
	}
}

//----------------------------------------------------------------------------------------
this.playerWillEnterWitchspace = this.shipDied = function () {
	if (this.scanTimer) {
		this.scanTimer.stop();
	}
}

//----------------------------------------------------------------------------------------
this.shipApproach = function () {
	var pastClients = system.filteredEntities(this, TCAT_oldClients, this.ship, 5000) // if any old clients are around, strip their client status
	if (pastClients.length > 0) {
		for (var i = 0; i < pastClients.length; i++) {
			pastClients[i].TCAT_receivingGate = null;
			if (pastClients[i].isPlayer) {
				player.consoleMessage(expandMissionText("TCAT_jumpgate_cleared"), 6);
			}
		}
	}

	var queue = system.filteredEntities(this, TCAT_clients, this.ship, 250); // if there is no-one wanting to jump, end the test
	if (queue.length == 0) {
		return;
	}

	var gates = system.filteredEntities(this, TCAT_allGates, this.ship); // check whether there is a second gate to receive the jumper
	if (gates.length == 0) {
		if (queue[0].isPlayer) {
			player.consoleMessage(expandMissionText("TCAT_jumpgate_offline"), 6);
		}
		return;
	}

	if (queue[0].hasOwnProperty("TCAT_receivingGate") && queue[0].TCAT_receivingGate == this.ship) { // if the jumper has just arrived, end the test
		return;
	}

	if (queue[0].isPlayer) {
		player.consoleMessage(expandMissionText("TCAT_jumpgate_activated"), 6);
		player.ship.target = null;
	}
	queue[0].TCAT_receivingGate = gates[0]; // note the gate that is about to receive the jumper
	queue[0].position = gates[0].position; // move the jumper to the receiving gate
	queue[0].orientation = gates[0].orientation; // re-orient the jumper to point out of the gate
	if (queue[0].AI == "TCAT_useGateAI.plist") {
		queue[0].reactToAIMessage("JUMPED");
	}
}

//----------------------------------------------------------------------------------------
this.findGates = function () {
	var gates = system.filteredEntities(this, TCAT_allGates, this.ship);
	if (gates.length == 0) {
		this.ship.reactToAIMessage("NO_GATE");
	} else {
		this.ship.reactToAIMessage("GATE_FOUND");
	}
};

//----------------------------------------------------------------------------------------
this.underAttack = function () {
	if (this.defenderCount > 0 && worldScripts["TCAT_masterScript"] && worldScripts["TCAT_masterScript"].defenderAllowed()) {
		var defender = this.ship.spawnOne("TCAT_gateGuard");
		defender.position = this.ship.position;
		defender.orientation = this.ship.orientation;
		this.defenderCount -= 1;
	}
}