"use strict";
this.name = "TCAT_jammer";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Ship script for Thargon jammer mine";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.performJamming = function () {
	if (player.ship && this.ship.position.distanceTo(player.ship.position) < 25600) {
		player.consoleMessage(expandMissionText("TCAT_jmine_launched"));
	}

	function isThargon(entity) {
		return (entity.isShip && (entity.primaryRole == "thargon" || entity.primaryRole == "tharglet" || entity.primaryRole == "CT_thargon"));
	}

	var thargonArray = system.filteredEntities(this, isThargon, this.ship, 25600)
	if (thargonArray.length > 0) {
		var thargCounter = 0; // reset the counter
		for (thargCounter = 0; thargCounter < thargonArray.length; thargCounter++) {
			this.jamChance = (this.ship.position.distanceTo(thargonArray[thargCounter].position)) / 25600;
			this.diceRole = Math.random();
			if (this.diceRole > this.jamChance) {
				thargonArray[thargCounter].switchAI("TCAT_uncontrolledThargonAI.plist");
			}
		}
	}
}