"use strict";
this.name = "TCAT_guard";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Thargoid Guardian ship script.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.launchOrbiters = function () {
	this.subLength = this.ship.subEntities.length;

	if (this.subLength > 0) {
		for (var subCounter = this.subLength - 1; subCounter >= 0; subCounter--) {
			var subOrientation = this.ship.subEntities[subCounter].orientation;
			var offsetVector = this.ship.subEntities[subCounter].orientation.vectorForward();
			var subOffset = offsetVector.multiply(500);
			this.ship.subEntities[subCounter].remove();

			var orbiter = this.ship.spawnOne('TCAT_freeOrbiter');
			orbiter.orientation = subOrientation;
			orbiter.position = this.ship.position.add(subOffset);
			if (this.ship.target) { orbiter.target = this.ship.target; }
		}
	}
}

//----------------------------------------------------------------------------------------
this.findNonThargoid = function () {
	function targetShips(entity) { return entity.isShip && !entity.docked && entity.scanClass != "CLASS_ROCK" && entity.scanClass != "CLASS_CARGO" && entity.scanClass != "CLASS_THARGOID" && !entity.isCloaked && !entity.hasRole("thargoid") && !entity.hasRole("thargon") && !entity.hasRole("TCAT_jumpGate") };
	this.nearArray = system.filteredEntities(this, targetShips, this.ship, 25600);
	this.farArray = system.filteredEntities(this, targetShips, this.ship, 60000);

	if (this.nearArray.length > 0) {
		this.targetNumber = Math.floor(Math.random() * this.nearArray.length);
		if (this.targetNumber > this.nearArray.length) {
			log(this.name, "script error, target number too high - please report");
			this.targetNumber = 0;
		}
		this.ship.target = this.nearArray[this.targetNumber];
		this.ship.reactToAIMessage("TARGET_FOUND");
	} else {
		if (this.farArray.length > 0) {
			this.ship.target = this.farArray[0]; // set to the closest target off-scanner but in range
			this.ship.reactToAIMessage("INTERCEPT_TARGET");
		} else {
			this.ship.reactToAIMessage("NOTHING_FOUND")
		}
	}
}

//----------------------------------------------------------------------------------------
this.checkTarget = function () {
	if (this.ship.target && this.ship.target.scanClass != "CLASS_THARGOID" && !this.ship.target.hasRole("thargoid") && !this.ship.target.hasRole("thargon")) {
		this.ship.reactToAIMessage("TARGET_VALID");
	} else {
		this.ship.AIState = "LOOK_FOR_TARGETS";
	}
}
