"use strict";
this.name = "ECM_jammerScript";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Script for ECM Jammer";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.ECMJammer_ecmShips = function(entity) { return entity.isShip && (entity.equipmentStatus("EQ_TCAT_DISABLED_ECM") === "EQUIPMENT_OK" || entity.equipmentStatus("EQ_ECM") === "EQUIPMENT_OK") };

//----------------------------------------------------------------------------------------
this.activated = function () {
	if (!this.ecmTimer) {
		player.consoleMessage(expandMissionText("TCAT_ecm_jammer_on"), 6);
		this.ecmTimer = new Timer(this, this.disableECM, 0, 0.25)
	} else {
		player.consoleMessage(expandMissionText("TCAT_ecm_jammer_off"), 6);
		this.stopTimer();
	}
}

//----------------------------------------------------------------------------------------
this.stopTimer = this.shipWillEnterWitchspace = this.shipWillDockWithStation = this.shipDied = function () {
	if (this.ecmTimer && this.ecmTimer.isRunning) {
		this.enableECM();
		this.ecmTimer.stop();
		delete this.ecmTimer;
	}
}

//----------------------------------------------------------------------------------------
this.disableECM = function () {
	player.ship.energy = player.ship.energy - 4;
	if (player.ship.energy < 64) {
		player.consoleMessage(expandMissionText("TCAT_ecm_energy_low"), 6);
		this.stopTimer();
		return;
	}

	var fullList = system.filteredEntities(this, this.ECMJammer_ecmShips, player.ship); // all ships in the system with ECM or disabled ECM
	var closeList = system.filteredEntities(this, this.ECMJammer_ecmShips, player.ship, 25600); // all ships in scanner range with ECM or disabled ECM

	if (fullList.length > 0) {
		var ecmCounter = 0; // reset the counter
		for (ecmCounter = 0; ecmCounter < fullList.length; ecmCounter++) {
			fullList[ecmCounter].removeEquipment("EQ_TCAT_DISABLED_ECM");
			fullList[ecmCounter].awardEquipment("EQ_ECM");
		}
	}

	if (closeList.length > 0) {
		var ecmCounter = 0; // reset the counter
		for (ecmCounter = 0; ecmCounter < closeList.length; ecmCounter++) {
			closeList[ecmCounter].removeEquipment("EQ_ECM");
			closeList[ecmCounter].awardEquipment("EQ_TCAT_DISABLED_ECM");
		}
	}
}

//----------------------------------------------------------------------------------------
this.enableECM = function () {
	var fullList = system.filteredEntities(this, this.ECMJammer_ecmShips, player.ship); // all ships in the system with ECM or disabled ECM
	if (fullList.length > 0) {
		var ecmCounter = 0; // reset the counter
		for (ecmCounter = 0; ecmCounter < fullList.length; ecmCounter++) {
			fullList[ecmCounter].removeEquipment("EQ_TCAT_DISABLED_ECM");
			fullList[ecmCounter].awardEquipment("EQ_ECM");
		}
	}
}

//----------------------------------------------------------------------------------------
this.equipmentDamaged = this.equipmentDestroyed = function (equipment) {
	if (equipment == "EQ_TCAT_ECM_JAMMER") {
		// if the jammer's broken in-flight
		this.stopTimer();
	}

	var fullList = system.filteredEntities(this, this.ECMJammer_ecmShips, player.ship); // all ships in the system with ECM or disabled ECM
	if (fullList.length > 0) {
		var ecmCounter = 0; // reset the counter
		for (ecmCounter = 0; ecmCounter < fullList.length; ecmCounter++) {
			fullList[ecmCounter].removeEquipment("EQ_TCAT_DISABLED_ECM");
			fullList[ecmCounter].awardEquipment("EQ_ECM");
		}
	}
}