"use strict";
this.name = "TCAT_conditions";
this.author = "phkb";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Condition script for equipment.";
this.version = "2.0";

this._trueValues = ["yes", "1", 1, "true", true];

//----------------------------------------------------------------------------------------
this.allowAwardEquipment = function(equipment, ship, context) {
    if (context === "scripted") return true;
    if (player.ship.dockedStation.dataKey != "TCAT_navyStation") return false;
    if (galaxyNumber != 2 || system.ID != 138) return false;
    var tv = this._trueValues;
    switch (equipment) {
        case "EQ_TCAT_NPC_TRIDENT_MISSILE":
        case "EQ_TCAT_NPC_DRONE_MISSILE":
        case "EQ_TCAT_NPC_NAILBOMB_MISSILE":
        case "EQ_TCAT_MANTIS_FLEET_MISSILE":
        case "EQ_TCAT_DISABLED_ECM":
            return false;

        case "EQ_TCAT_JAMMER_MINE":
        case "EQ_TCAT_EU_UPGRADE":
        case "EQ_TCAT_EU_FIXGRADE":
        case "EQ_TCAT_NEU_REPAIR":
        case "EQ_TCAT_DUMMY_MINE":
        case "EQ_TCAT_DUMMY_MISSILE":
        case "EQ_TCAT_DUMMY_NEU":
        case "EQ_TCAT_DUMMY_SHIELDS":
            if (tv.indexOf(missionVariables.TCAT_navalEquipment) >= 0 && tv.indexOf(missionVariables.TCAT_qDept) >= 0 && missionVariables.TCAT_mission != "ARMADA") {
                return true;
            }
            break;
        case "EQ_TCAT_ECM_JAMMER":
            if (tv.indexOf(missionVariables.TCAT_navalEquipment) >= 0 && tv.indexOf(missionVariables.TCAT_qDept) >= 0) {
                return true;
            }
            break;
        case "EQ_TCAT_FREE_MINE":
        case "EQ_TCAT_FREE_MISSILE":
        case "EQ_TCAT_FREE_JAMMER_MINE":
        case "EQ_TCAT_CLEARPYLONS":
            if (tv.indexOf(missionVariables.TCAT_navalEquipment) >= 0 && missionVariables.TCAT_mission == "ARMADA") {
                return true;
            }
            break;
    }
    return false;
}
