"use strict";
this.name = "TCAT_bugStation";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Thargoid station ship script.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
function TCAT_localMines(entity) {
	var isWeapon = entity.isWeapon,
		isActive = entity.AI !== "TCAT_deactivatedAI.plist",
		mines = ["EQ_QC_MINE", "EQ_RMB_CASCADE_MISSILE", "EQ_RMB_LAW_MISSILE", "EQ_RMB_OVERRIDE_MISSILE",
			"energy-bomb", "EQ_NUKE2_MISSILE", "EQ_HARPOON_NUKE2_MISSILE", "EQ_PHOTON_MISSILE", "RANDOM_HITS_MINE"],
		isLocalMine = mines.some(function (mine) { return entity.isShip && entity.hasRole(mine); });
	return isWeapon && isActive && isLocalMine;
}

//----------------------------------------------------------------------------------------
function targetShips(entity) { return entity.isShip && !entity.docked && entity.scanClass != "CLASS_ROCK" && entity.scanClass != "CLASS_CARGO" && !entity.isThargoid && !entity.isCloaked };

//----------------------------------------------------------------------------------------
this.shipSpawned = function () {
	this.ship.target = player.ship;
	this.ship.alertCondition = 2;
	if (this.scanTimer) {
		this.scanTimer.start();
	} else {
		this.scanTimer = new Timer(this, this.mineScan, 0, 4.75);
	}

	if (this.cavalryTimer) {
		this.cavalryTimer.start();
	} else {
		this.cavalryTimer = new Timer(this, this.addRaptor, 60, 60);
	}
	this.cavalryChance = 0;
	this.cavalryCount = 0;

	missionVariables.TCAT_door = "DROPPED";
	this.spawnDoor();
}

//----------------------------------------------------------------------------------------
this.findNonThargoid = function () {
	if (this.ship.target) {
		this.ship.reactToAIMessage("TARGET_FOUND");
		return;
	}

	this.targetArray = system.filteredEntities(this, targetShips, this.ship, 25600);

	if (this.targetArray.length > 0) {
		this.targetNumber = Math.floor(Math.random() * this.targetArray.length);
		if (this.targetNumber > this.targetArray.length) {
			log(this.name, "script error, target number too high - please report");
			this.targetNumber = 0;
		}
		this.ship.target = this.targetArray[this.targetNumber];
		this.ship.reactToAIMessage("TARGET_FOUND");
	} else {
		this.ship.reactToAIMessage("NOTHING_FOUND")
	}
};

//----------------------------------------------------------------------------------------
this.playerWillEnterWitchspace = this.shipDied = function () {
	if (this.doorTimer && this.doorTimer.isRunning) {
		this.doorTimer.stop();
	}
	if (this.scanTimer && this.scanTimer.isRunning) {
		this.scanTimer.stop();
	}
	if (this.cavalryTimer && this.cavalryTimer.isRunning) {
		this.cavalryTimer.stop();
	}
}

//----------------------------------------------------------------------------------------
this.mineScan = function () {
	this.mineArray = system.filteredEntities(this, TCAT_localMines, this.ship, 25600);

	if (this.mineArray.length > 0) {
		player.consoleMessage(expandMissionText("TCAT_cascade_suppressed"), 6);
		this.mineArray.forEach(
			function (mine) {
				mine.setAI("TCAT_deactivatedAI.plist");
				mine.displayName = expandMissionText("TCAT_disarmed", {name:mine.displayName});
				mine.scannerDisplayColor1 = "whiteColor";
				mine.scannerDisplayColor2 = "whiteColor";
			}
		)
	}

	if (player.ship.isCloaked && this.ship && this.ship.position.distanceTo(player.ship.position) < 512000 && Math.random() > 0.33) {// so that the cloak can't really be used to defeat the mission
		player.ship.removeEquipment("EQ_CLOAKING_DEVICE"); // done this way rather than by setEquipmentStatus to 
		player.ship.awardEquipment("EQ_CLOAKING_DEVICE"); // avoid triggering repair bots, repair system or DCN.
		player.consoleMessage(expandMissionText("TCAT_cloak_failed"), 6);
	}
}

//----------------------------------------------------------------------------------------
this.addRaptor = function () {
	if (Math.random() < this.cavalryChance) {
		//system.legacy_addShipsAtPrecisely("TCAT_raptor", 1, "abs", this.ship.position.add([2000, 5000, -22000]));
		system.addShips("TCAT_raptor", 1, this.ship.position.add([2000, 5000, -22000]), 0);
		this.cavalryChance = 0;
		this.cavalryCount += 1;
	} else {
		this.cavalryChance += 0.1;
	}
	if (this.cavalryCount == 3 || !this.ship || !this.ship.isValid) {
		this.cavalryTimer.stop();
	}
}

//----------------------------------------------------------------------------------------
this.otherShipDocked = function (whom) {
	if (whom.isPlayer) { // if we're in the bug station
		player.ship.hudHidden = true;
		mission.runScreen({ title: expandMissionText("TCAT_fat_lady"), overlay: {name:"TCAT_thargoidDock_background.png", height:546}, messageKey: "TCAT_bugStation" }, this.bugBang);
	}
}

//----------------------------------------------------------------------------------------
this.stationLaunchedShip = function (whom) {
	if (!whom.isPlayer && missionVariables.TCAT_door == "DROPPED") {
		this.doorTimer = new Timer(this, this.spawnDoor, 2);
	}
	if (whom.isPlayer) {
		player.consoleMessage(expandMissionText("TCAT_quirium_explosion_soon"), 6);
		this.doorArray = system.shipsWithRole("TCAT_blastDoor");
		if (this.doorArray.length > 0) {
			this.doorArray[0].remove();
			missionVariables.TCAT_door = "DESTROYED";
		}
	}
}

//----------------------------------------------------------------------------------------
this.bugBang = function () {
	player.ship.hudHidden = false;
	missionVariables.TCAT_mission = "SUCCESS";
	mission.setInstructionsKey("TCAT_shortSuccess", "TCAT_missionScript");
	mission.unmarkSystem(168);
	mission.markSystem(138);
	this.ship.switchAI("TCAT_stationExplodeAI.plist");
	player.ship.launch();
}

//----------------------------------------------------------------------------------------
this.spawnDoor = function () {
	var blastDoor = this.ship.spawnOne("TCAT_blastDoor");
	blastDoor.orientation = this.ship.orientation;
	blastDoor.position = this.ship.position.add(this.ship.orientation.vectorForward().multiply(500));
	missionVariables.TCAT_door = "PRESENT";
}

//----------------------------------------------------------------------------------------
this.dropDoor = function () {
	this.doorArray = system.shipsWithRole("TCAT_blastDoor");
	if (this.doorArray.length > 0) {
		this.doorArray[0].remove();
		missionVariables.TCAT_door = "DROPPED";
	}
	this.ship.reactToAIMessage("LAUNCH_DEFENDER");
}