"use strict";
this.name = "TCAT_base";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Thargoid base script.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.shipSpawned = function () {
	this.ship.target = player.ship;
	this.ship.alertCondition = 2;

	if (this.scanTimer) {
		this.scanTimer.start();
	} else {
		this.scanTimer = new Timer(this, this.mineScan, 0, 4.75);
	}
	this.launchAllFlag = "NO";
}

//----------------------------------------------------------------------------------------
this.playerWillEnterWitchspace = function () {
	if (this.scanTimer) {
		this.scanTimer.stop();
	}
}

//----------------------------------------------------------------------------------------
this.mineScan = function () {
	function TCAT_localMines(entity) {
		var isWeapon = entity && entity.isValid && entity.isWeapon,
			isActive = entity.AI !== "TCAT_deactivatedAI.plist",
			mines = ["EQ_QC_MINE", "EQ_RMB_CASCADE_MISSILE", "EQ_RMB_LAW_MISSILE", "EQ_RMB_OVERRIDE_MISSILE",
				"energy-bomb", "EQ_NUKE2_MISSILE", "EQ_HARPOON_NUKE2_MISSILE", "EQ_PHOTON_MISSILE", "RANDOM_HITS_MINE"],
			isLocalMine = mines.some(function (mine) { return entity.isShip && entity.hasRole(mine); });
		return isWeapon && isActive && isLocalMine;
	}

	this.mineArray = system.filteredEntities(this, TCAT_localMines, this.ship, 25600);

	if (this.mineArray.length > 0) {
		player.consoleMessage(expandMissionText("TCAT_cascade_suppressed"), 6);
		this.mineArray.forEach(
			function (mine) {
				mine.setAI("TCAT_deactivatedAI.plist");
				mine.displayName = expandMissionText("TCAT_disarmed", {name:mine.displayName});
				mine.scannerDisplayColor1 = "whiteColor";
				mine.scannerDisplayColor2 = "whiteColor";
			}
		)
	}
}

//----------------------------------------------------------------------------------------
this.findNonThargoid = function () {
	function targetShips(entity) { return entity.isShip && !entity.docked && entity.scanClass != "CLASS_ROCK" && entity.scanClass != "CLASS_CARGO" && entity.scanClass != "CLASS_BUOY" && entity.scanClass != "CLASS_THARGOID" && !entity.isCloaked && !entity.hasRole("thargoid") && !entity.hasRole("thargon") && !entity.hasRole("TCAT_jumpGate") };
	this.nearArray = system.filteredEntities(this, targetShips, this.ship, 25600);

	if (this.nearArray.length > 0) {
		this.targetNumber = Math.floor(Math.random() * this.nearArray.length);
		if (this.targetNumber > this.nearArray.length) {
			log(this.name, "script error, target number too high - please report");
			this.targetNumber = 0;
		}
		this.ship.target = this.nearArray[this.targetNumber];
		this.ship.reactToAIMessage("TARGET_FOUND");
	}
	else {
		this.ship.reactToAIMessage("NOTHING_FOUND")
	}
}

//----------------------------------------------------------------------------------------
this.launchAll = function () {
	this.launchAllFlag = "LAUNCH";
	this.launchGuards();
}

//----------------------------------------------------------------------------------------
this.launchGuards = function () {
	this.guardLength = this.ship.subEntities.length;

	if (this.guardLength > 1) {
		for (var guardCounter = this.guardLength - 1; guardCounter >= 1; guardCounter--) {
			if (Math.random() > 0.25 || this.launchAllFlag == "LAUNCH") {
				this.guardPosition = this.ship.subEntities[guardCounter].position;
				this.guardOrientation = this.ship.subEntities[guardCounter].orientation;
				this.ship.subEntities[guardCounter].remove();

				var subGuard = this.ship.spawnOne("TCAT_guardRot");
				subGuard.position = this.localToGlobal(this.guardPosition);
				subGuard.orientation = this.guardOrientation.multiply(this.ship.orientation);
			}
		}
	}
}

//----------------------------------------------------------------------------------------
this.localToGlobal = function (position) { // sub-ent position is relative to mother, but for swapping we need the absolute global position
	let orientation = this.ship.orientation;
	orientation.w = -orientation.w; // this is needed to get things in the right place for some reason?
	return this.ship.position.add(position.rotateBy(orientation));
}

//----------------------------------------------------------------------------------------
this.otherShipDocked = function (whom) {
	if (whom.isPlayer) { // if we're in the bug station
		player.ship.hudHidden = true;
		mission.runScreen({ title: expandMissionText("TCAT_wrong_place"), overlay: {name:"TCAT_thargoidDock_background2.png", height:546}, messageKey: "TCAT_bugBase" }, this.relaunch);
	}
}

//----------------------------------------------------------------------------------------
this.relaunch = function () {
	player.ship.hudHidden = false;
	player.ship.launch();
}

//----------------------------------------------------------------------------------------
this.shipDied = function (who, why) {
	if (this.scanTimer && this.scanTimer.isRunning) {
		this.scanTimer.stop();
	}

	this.fuelCount = 15 + Math.ceil(Math.random() * 10);
	this.largeCount = 4 + Math.ceil(Math.random() * 3);
	this.smallCount = 5 + Math.ceil(Math.random() * 5);

	//system.legacy_addShipsWithinRadius("TCAT_burningFuel", this.fuelCount, "abs", this.ship.position, 10);
	system.addShips("TCAT_burningFuel", this.fuelCount, this.ship.position, 10);
	//system.legacy_addShipsWithinRadius("TCAT_smallWreckage", this.smallCount, "abs", this.ship.position, 5);
	system.addShips("TCAT_smallWreckage", this.smallCount, this.ship.position, 5);

	if (this.largeCount > 0) {
		//system.legacy_addShipsWithinRadius("TCAT_largeWreckage", this.largeCount, "abs", this.ship.position, 5);
		system.addShips("TCAT_largeWreckage", this.largeCount, this.ship.position, 5);
	}
}