"use strict";
this.name           = "SC_equipment_events";
this.author         = "Lone_Wolf";
this.copyright      = "(C) 2011-2012, 2014-2015, 2025 Lone_Wolf.";
this.licence        = "CC-BY-SA 4.0";
this.description    = "SC equipment event handler";
this.version        = "2.1.1";


//--------------------------------------------------------------------------------------------------//
this.activated = function _sc_activated() {// player ship only
    var wsc = worldScripts["Shield Cycler"];
    var new_config;

    if (wsc == null) return;
    if (wsc.$sc_disabled) return; 
    // Triggered by pressing n-key while shieldcycler is primed
    // is only called when player has a manual configurator installed and player presses n-key while device is primed
    var loop_ready = false;
    var new_position = wsc.$sc_settings.current_cycle_position;
    //var new_config = wsc.$sc_const.cycle[new_position];
    do {
        new_position = (new_position + 1) % wsc.$sc_const.cycle.length;
        new_config = wsc.$sc_const.cycle[new_position];
        loop_ready = !(wsc.$sc_settings.cycler_mask & Math.pow(2, new_config));
        if (wsc.$debug) log(wsc.name, "new_position:"+new_position+", new_config:"+new_config+" ("+wsc.$sc_const.mode_names[new_config]+"), math:"+Math.pow(2, new_config)+", loop_ready:"+loop_ready);
    } while (loop_ready);
    wsc.$sc_settings.current_cycle_position = new_position;
    wsc.$sc_settings.current_configuration = new_config;
    wsc._sc_sc_adjust(true, "Shield Cycler");
}

//--------------------------------------------------------------------------------------------------//
this.mode = function _sc_mode() {// player ship only
    var wsc = worldScripts["Shield Cycler"];

    if (wsc == null) return;
    if (wsc.$sc_disabled) {
        player.commsMessage("Shield Cycler is disabled",10);
        if (wsc.$logging) log(wsc.name, "Shield Cycler disabled");
        return; 
    }
    wsc.$sc_settings.current_cycle_position = 0;
    wsc.$sc_settings.current_configuration = wsc.$sc_const.cycle[0];
    var error = wsc._sc_sc_adjust(true, "Shield Cycler");
    if (error < 0 ) {
        player.commsMessage( "Error - check latest log",10);
        log(wsc.name,"error while resetting to start configuration");
    }
}

