"use strict";
this.name           = "SC equipment condtion script";
this.author         = "Lone_Wolf";
this.copyright      = "(C) 2011-2012, 2014-2015, 2025 Lone_Wolf.";
this.licence        = "CC-by-SA 4.0";
this.description    = "SC equipment condition script";
this.version        = "2.1.1";

//----------------------------------------------------------------------------------------
this.allowAwardEquipment = function _sc_allowAwardEquipment(equipment, ship, context) {
    var allowed = false;
    switch (equipment) {
        case "EQ_SC_SHIELD_CYCLER_INTERNAL":
        case "EQ_SC_MANUAL_CONFIGURATOR_INTERNAL":
            allowed = (context === "scripted") ? true : false;
            break;
        case "EQ_SC_SC_REPAIR":
            allowed = (worldScripts["Shield Cycler"].$sc_settings.functional < 100 ) ? true : false;
            break;
        default:
            break;
    };
    return allowed;
};

//----------------------------------------------------------------------------------------
this.updateEquipmentPrice = function _sc_updateEquipmentPrice(equipment, price) {
    var ws = worldScripts["Shield Cycler"];
    var repair_cost = price;
    if ( equipment === "EQ_SC_SC_REPAIR" ) {
        repair_cost = ws.$sc_worm.sc_cost[ws.$sc_settings.version];
        repair_cost += ws.$sc_worm.manual_cost[ws.$sc_settings.manual_version ];
        repair_cost *= 0.1;
        repair_cost = 0.5 * repair_cost * (100 - ws.$sc_settings.functional) / 100;
    };
    return repair_cost;
};
