"use strict";

 // worldScripts["Wildeblood Manor"]
    this.name = "Wildeblood Manor";

    this._affectedGalaxy  = 0;
    this._affectedSystem  = 100;
    this._backgroundImage = "distant_space_wildeblood_manor.png";
    this._imageHeight     = 512;
    this._tempDescription = "Visit Vetitice to see the traditional mountain-top yurt-fortress-dome manor houses.";

    this._showImage = false;

    this.infoSystemChanged = function (to, from) {
        if (to === this._affectedSystem &&
            system.ID !== this._affectedSystem &&
            galaxyNumber === this._affectedGalaxy) {
            this._showImage = true;
            // Setting radius to 0 hides the animated planet image,
            // so we can see the background image better.
            System.infoForSystem(galaxyNumber, to).radius = 0;
            System.infoForSystem(galaxyNumber, to).description = this._tempDescription;
        }
    };

    this.guiScreenChanged = function (to, from) {
        if (this._showImage) {
            if (from === "GUI_SCREEN_SYSTEM_DATA") {
                System.infoForSystem(this._affectedGalaxy, this._affectedSystem).radius = null; // Unset the 0.
                System.infoForSystem(this._affectedGalaxy, this._affectedSystem).description = null; // Reset to the usual description.
                this._showImage = false;
                return;
            }
            if (to === "GUI_SCREEN_SYSTEM_DATA" &&
                guiScreen === "GUI_SCREEN_SYSTEM_DATA") {
                // The setScreenBackground method is a temporary over-ride, which resets as soon as
                // the player changes screens, we don't need to do anything to reset it.
                setScreenBackground({ name: (this._backgroundImage), height: (this._imageHeight) });
            }
        }
    };

    this.startUp = function () {
        if (missionVariables.WildebloodManor_galaxy) {
            this._affectedGalaxy = missionVariables.WildebloodManor_galaxy;
        }
        if (missionVariables.WildebloodManor_system) {
            this._affectedSystem = missionVariables.WildebloodManor_system;
        }
        if (missionVariables.WildebloodManor_image) {
            this._backgroundImage = missionVariables.WildebloodManor_image;
        }
        if (missionVariables.WildebloodManor_height) {
            this._imageHeight = missionVariables.WildebloodManor_height;
        }
        if (missionVariables.WildebloodManor_description) {
            this._tempDescription = missionVariables.WildebloodManor_description;
        }
        delete this.startUp;
    };

    this.playerWillSaveGame = function () {
        missionVariables.WildebloodManor_galaxy = this._affectedGalaxy;
        missionVariables.WildebloodManor_system = this._affectedSystem;
        missionVariables.WildebloodManor_image = this._backgroundImage;
        missionVariables.WildebloodManor_height = this._imageHeight;
        missionVariables.WildebloodManor_description = this._tempDescription;
    };
