"use strict";

this.name = "taxi_galactica_main";
this.author = "Pleb";
this.copyright = "(C) Copyright 2012 Pleb Inc.";
this.license = "CC BY-NC-SA 3.0";
this.description = "This is the main script for the Taxi Galactica OXP.";
this.version = "2.2";

this._taxiModels = ["taxi_adder_1", "taxi_adder_2", "taxi_adder_3", "taxi_adder_4", "taxi_adder_5", "taxi_adder_6"];
this._model = "";

/**** Functions ****/

this._addTaxiStatIfPossible = function () {
	// Check if current system is a Corporate system that hasn't gone Nova and make sure Player is not in Interstellar Space:
	if (system.government === 7 && !system.isInterstellarSpace && !system.sun.isGoingNova) {
		// Add Taxi Station to current system near planet and angle toward planet:
		var posTaxi = Vector3D(0, 0, 0.1).fromCoordinateSystem("psu");
		system.setPopulator("taxi_station", {
			callback: function (pos) {
				if (system.countShipsWithRole("taxi_station") == 0) {
					var taxistat = system.addShips("taxi_station", 1, pos, 0)[0];
					if (!taxistat) {
						log(this.name, "!!ERROR - Taxi Station not spawned");
						return;
					}
					var targetVector = system.mainPlanet.position.subtract(taxistat.position).direction();
					var angle = taxistat.heading.angleTo(targetVector);
					var cross = taxistat.heading.cross(targetVector).direction();
					taxistat.orientation = taxistat.orientation.rotate(cross, -angle);
					worldScripts.taxi_galactica_main._addShipsNoRings("taxi_billboard", 1, taxistat.position.add(taxistat.heading.multiply(10E3)), 1);
				}
			},
			location: "COORDINATES",
			coordinates: posTaxi,
			deterministic: true
		});
	}
}

this._addShipsNoRings = function (role, count, position, radius) {
	var offset = new Vector3D(0, 50000, 0);
	var ships = system.addShips(role, count, offset, radius);
	offset = new Vector3D(position).subtract(offset);
	var i = 0;
	while (i < ships.length) {
		ships[i].position = ships[i].position.add(offset);
		i++;
	}
	return ships;
}

this._generateTaxiJobs = function () {
	// Generate names for passenger contracts:
	missionVariables.taxi_job_name_1 = randomName() + " " + randomName();
	missionVariables.taxi_job_name_2 = randomName() + " " + randomName();
	missionVariables.taxi_job_name_3 = randomName() + " " + randomName();
	// Generate destinations for passenger contracts:
	missionVariables.taxi_job_dest_1 = this._generateTaxiDest(40); // these three functions are identical, but I'm no sure why we need three versions of it. Random number generator problems, maybe?
	missionVariables.taxi_job_dest_2 = this._generateTaxiDest(40);
	missionVariables.taxi_job_dest_3 = this._generateTaxiDest(40);
	missionVariables.taxi_job_dest_name_1 = System.systemNameForID(missionVariables.taxi_job_dest_1);
	missionVariables.taxi_job_dest_name_2 = System.systemNameForID(missionVariables.taxi_job_dest_2);
	missionVariables.taxi_job_dest_name_3 = System.systemNameForID(missionVariables.taxi_job_dest_3);
	// Generate time limits for passenger contracts:
	missionVariables.taxi_job_time_1 = Math.floor(Math.random() * (20 - 10 + 1) + 10);
	missionVariables.taxi_job_time_2 = Math.floor(Math.random() * (20 - 10 + 1) + 10);
	missionVariables.taxi_job_time_3 = Math.floor(Math.random() * (20 - 10 + 1) + 10);
	// Generate difficulty levels for passenger contracts and use that and distance to determine the fee:
	missionVariables.taxi_job_diff_1 = Math.floor(Math.random() * (2 - 0 + 1) + 0);
	var taxi_mission_distance_1 = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_job_dest_1)));
	var taxi_mission_distance_2 = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_job_dest_2)));
	var taxi_mission_distance_3 = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_job_dest_3)));
	if (missionVariables.taxi_job_diff_1 === 0) {
		missionVariables.taxi_job_diff_name_1 = "Easy";
		missionVariables.taxi_job_pay_1 = Math.floor(Math.random() * (300 - 100 + 1) + 100);
		missionVariables.taxi_job_pay_1 = missionVariables.taxi_job_pay_1 * taxi_mission_distance_1 / 2;
	}
	else if (missionVariables.taxi_job_diff_1 === 1) {
		missionVariables.taxi_job_diff_name_1 = "Medium";
		missionVariables.taxi_job_pay_1 = Math.floor(Math.random() * (500 - 300 + 1) + 300);
		missionVariables.taxi_job_pay_1 = missionVariables.taxi_job_pay_1 * taxi_mission_distance_1 / 2;
	}
	else if (missionVariables.taxi_job_diff_1 === 2) {
		missionVariables.taxi_job_diff_name_1 = "Hard";
		missionVariables.taxi_job_pay_1 = Math.floor(Math.random() * (800 - 500 + 1) + 500);
		missionVariables.taxi_job_pay_1 = missionVariables.taxi_job_pay_1 * taxi_mission_distance_1 / 2;
	}
	missionVariables.taxi_job_diff_2 = Math.floor(Math.random() * (2 - 0 + 1) + 0);
	if (missionVariables.taxi_job_diff_2 === 0) {
		missionVariables.taxi_job_diff_name_2 = "Easy";
		missionVariables.taxi_job_pay_2 = Math.floor(Math.random() * (300 - 100 + 1) + 100);
		missionVariables.taxi_job_pay_2 = missionVariables.taxi_job_pay_2 * taxi_mission_distance_2 / 2;
	}
	else if (missionVariables.taxi_job_diff_2 === 1) {
		missionVariables.taxi_job_diff_name_2 = "Medium";
		missionVariables.taxi_job_pay_2 = Math.floor(Math.random() * (500 - 300 + 1) + 300);
		missionVariables.taxi_job_pay_2 = missionVariables.taxi_job_pay_2 * taxi_mission_distance_2 / 2;
	}
	else if (missionVariables.taxi_job_diff_2 === 2) {
		missionVariables.taxi_job_diff_name_2 = "Hard";
		missionVariables.taxi_job_pay_2 = Math.floor(Math.random() * (800 - 500 + 1) + 500);
		missionVariables.taxi_job_pay_2 = missionVariables.taxi_job_pay_2 * taxi_mission_distance_2 / 2;
	}
	missionVariables.taxi_job_diff_3 = Math.floor(Math.random() * (2 - 0 + 1) + 0);
	if (missionVariables.taxi_job_diff_3 === 0) {
		missionVariables.taxi_job_diff_name_3 = "Easy";
		missionVariables.taxi_job_pay_3 = Math.floor(Math.random() * (300 - 100 + 1) + 100);
		missionVariables.taxi_job_pay_3 = missionVariables.taxi_job_pay_3 * taxi_mission_distance_3 / 2;
	}
	else if (missionVariables.taxi_job_diff_3 === 1) {
		missionVariables.taxi_job_diff_name_3 = "Medium";
		missionVariables.taxi_job_pay_3 = Math.floor(Math.random() * (500 - 300 + 1) + 300);
		missionVariables.taxi_job_pay_3 = missionVariables.taxi_job_pay_3 * taxi_mission_distance_3 / 2;
	}
	else if (missionVariables.taxi_job_diff_3 === 2) {
		missionVariables.taxi_job_diff_name_3 = "Hard";
		missionVariables.taxi_job_pay_3 = Math.floor(Math.random() * (800 - 500 + 1) + 500);
		missionVariables.taxi_job_pay_3 = missionVariables.taxi_job_pay_3 * taxi_mission_distance_3 / 2;
	}
}

this._generateTaxiDest = function (maxDist) {
	// Generate destination for passenger contract within maxDist light years of current system:
	var thisSystem = system.info;
	var targetSystems = SystemInfo.systemsInRange(maxDist);
	if (!targetSystems) return system.ID;
	var count = targetSystems.length;
	targetSystems.sort(function (a, b) { return Math.random() - 0.5; });
	var i = -1; // start here, so the first interation is 0, which is the real first index
	var targetSystem = null;
	var realDistance = 0;
	while ((!realDistance || realDistance > maxDist) && i < count) {
		targetSystem = targetSystems[i++];
		if (targetSystem) {
			// make sure there's a route to this system
			var routeSystem = System.infoForSystem(galaxyNumber, targetSystem.systemID).routeToSystem(thisSystem);
			if (routeSystem) realDistance = System.infoForSystem(galaxyNumber, targetSystem.systemID).routeToSystem(thisSystem).distance;
		}
	}
	return targetSystem.systemID;
}

this._initInterface = function (station) {
	if (!station) return;
	if (station.hasRole("taxi_station")) {
		station.setInterface(this.name, {
			title: expandMissionText("taxi_bb_title"),
			category: expandDescription("[interfaces-category-deliveries]"),
			summary: expandMissionText("taxi_bb_summary"),
			callback: this._showBB.bind(this)
		});
	} else {
		station.setInterface(this.name, null);
	}
}

this._showBB = function () {
	missionVariables.taxistat = "REVISIT";
	this.missionScreenOpportunity();
}

/**** Event handlers ****/

this.startUp = function () {
	// Make sure that the variable used for the Taxi Station mission screens is reset every time:
	missionVariables.taxistat = "REVISIT";
	this._newGalaxy = false;
}

this.startUpComplete = function () {
	this._initInterface(player.ship.dockedStation);
}

this.systemWillPopulate = function () {
	this._model = "[" + this._taxiModels[Math.floor(Math.random() * 6)] + "]";
	if (!missionVariables.taxi_station_contact || missionVariables.taxi_station_contact == "")
		missionVariables.taxi_station_contact = randomName() + " " + randomName();

	// Try to add Taxi Station to current system:
	this._addTaxiStatIfPossible();
	// Random chance (%) for pirate encounters:
	this._piraterandomnumber = Math.floor(Math.random() * (100 - 1 + 1) + 1);
	// If current contract is Easy difficulty then 20% chance pirates will be spawned:
	if (missionVariables.taxi_diff === 0) {
		if (system.ID === missionVariables.taxi_dest) {
			// If current system is contract destination spawn 3 pirates:
			if (this._piraterandomnumber > 80) system.addShipsToRoute("taxi_pirate", 3, null, "wp");
		}
		else {
			// If current system is not contract destination spawn 1 pirate:
			if (this._piraterandomnumber > 80) system.addShipsToRoute("taxi_pirate", 1, null, "wp");
		}
	}
	// If current contract is Medium difficulty then 40% chance pirates will be spawned:
	else if (missionVariables.taxi_diff === 1) {
		if (system.ID === missionVariables.taxi_dest) {
			// If current system is contract destination spawn 4 pirates:
			if (this._piraterandomnumber > 60) system.addShipsToRoute("taxi_pirate", 4, null, "wp");
		}
		else {
			// If current system is not contract destination spawn 2 pirates:
			if (this._piraterandomnumber > 60) system.addShipsToRoute("taxi_pirate", 2, null, "wp");
		}
	}
	// If current contract is Hard difficulty then 60% chance pirates will be spawned:
	else if (missionVariables.taxi_diff === 2) {
		if (system.ID === missionVariables.taxi_dest) {
			// If current system is contract destination spawn 5 pirates:
			if (this._piraterandomnumber > 40) system.addShipsToRoute("taxi_pirate", 5, null, "wp");
		}
		else {
			// If current system is contract destination spawn 3 pirates:
			if (this._piraterandomnumber > 40) system.addShipsToRoute("taxi_pirate", 3, null, "wp");
		}
	}
	// If on special mission #1 then separatist ships might be spawned:
	else if (missionVariables.taxi_diff === 3) {
		// If current system is mission destination spawn 8 separatist fighters:
		if (system.ID === missionVariables.taxi_dest) {
			system.addShipsToRoute("taxi_separatist", 8, null, "wp");
		}
		// If current system is not mission destination there is 70% chance to spawn 4 separatist fighters:
		else {
			if (this._piraterandomnumber > 30) system.addShipsToRoute("taxi_separatist", 4, null, "wp");
		}
	}
}

this.shipWillLaunchFromStation = function () {
	// Reset the variable used for the Taxi Station mission screens:
	missionVariables.taxistat = "REVISIT";
}

this.shipWillDockWithStation = function (station) {
	if (this._newGalaxy === true) {
		// Inform Player that contract has expired due to leaving previous galaxy:
		player.addMessageToArrivalReport(expandMissionText("taxi_passenger_angry"));
		// Remove passenger from manifest:
		var name = missionVariables.taxi_passenger;
		player.ship.removePassenger(name);
		// Change variables to reflect Player no longer having passenger contract:
		missionVariables.taxistatus = "NOT_ON_JOB";
		missionVariables.taxi_diff = -1;
		this._newGalaxy = false;
	}
	this._initInterface(station);
}

this.shipWillEnterWitchspace = function (cause, destination) {
	missionVariables.taxi_station_contact = "";
}

this.playerBoughtEquipment = function (equipmentKey) {
	if (equipmentKey === "EQ_PASSENGER_BERTH_TAXI") {
		// swap out our dummy one for the real one.
		player.ship.removeEquipment("EQ_PASSENGER_BERTH_TAXI");
		player.ship.awardEquipment("EQ_PASSENGER_BERTH");
	}
}

this.missionScreenOpportunity = function () {
	// If Player is not docked do nothing:
	if (!player.ship.docked) {
		return;
	}
	// Mission text screen choices are below:
	function choiceEvaluation(choice) {
		// Welcome screen choices:
		if (missionVariables.taxistat === "REVISIT_1") {
			if (choice === "1BOARD") {
				// Display the bulletin board screen:
				missionVariables.taxistat = "BOARD";
			}
			else if (choice === "2EXPLORE") {
				// Return to the manifest screen:
				missionVariables.taxistat = "EXPLORE";
			}
		}
		// 'On The Job' screen choices:
		if (missionVariables.taxistat === "ON_THE_JOB_1") {
			if (choice === "1EXPLORE") {
				// Return to the manifest screen:
				missionVariables.taxistat = "EXPLORE";
			}
			else if (choice === "2LAUNCH") {
				// Leave the station:
				player.ship.launch();
			}
		}
		// Bulletin Board screen choices:
		if (missionVariables.taxistat === "BOARD_1") {
			if (choice === "1JOB1") {
				// Display passenger contract #1 details:
				missionVariables.taxistat = "JOB1";
			}
			else if (choice === "2JOB2") {
				// Display passenger contract #2 details:
				missionVariables.taxistat = "JOB2";
			}
			else if (choice === "3JOB3") {
				// Display passenger contract #3 details:
				missionVariables.taxistat = "JOB3";
			}
			else if (choice === "4EXPLORE") {
				// Return to the manifest screen:
				missionVariables.taxistat = "EXPLORE";
			}
		}
		// Passenger Contract #1 screen choices:
		if (missionVariables.taxistat === "JOB1_1") {
			if (choice === "1ACCEPT") {
				// Store passenger contract #1 details into variables and add passenger to ship & manifest:
				missionVariables.taxi_passenger = missionVariables.taxi_job_name_1;
				missionVariables.taxi_dest = missionVariables.taxi_job_dest_1;
				missionVariables.taxi_dest_name = missionVariables.taxi_job_dest_name_1;
				missionVariables.taxi_diff = missionVariables.taxi_job_diff_1;
				missionVariables.taxi_pay = missionVariables.taxi_job_pay_1;
				missionVariables.taxi_time = missionVariables.taxi_job_time_1;
				missionVariables.taxistatus = "ON_THE_JOB";
				var name = missionVariables.taxi_passenger;
				var curloc = system.ID;
				var dest = missionVariables.taxi_dest;
				var time = missionVariables.taxi_time;
				var pay = missionVariables.taxi_pay;
				player.ship.addPassenger(name, curloc, dest, clock.seconds + time * 24 * 3600, pay);
				missionVariables.taxistat = "ACCEPTED";
			}
			else if (choice === "2DECLINE") {
				// Return to bulletin board screen:
				missionVariables.taxistat = "BOARD";
			}
		}
		// Passenger Contract #2 screen choices:
		if (missionVariables.taxistat === "JOB2_1") {
			if (choice === "1ACCEPT") {
				// Store passenger contract #3 details into variables and add passenger to ship & manifest:
				missionVariables.taxi_passenger = missionVariables.taxi_job_name_2;
				missionVariables.taxi_dest = missionVariables.taxi_job_dest_2;
				missionVariables.taxi_dest_name = missionVariables.taxi_job_dest_name_2;
				missionVariables.taxi_diff = missionVariables.taxi_job_diff_2;
				missionVariables.taxi_pay = missionVariables.taxi_job_pay_2;
				missionVariables.taxi_time = missionVariables.taxi_job_time_2;
				missionVariables.taxistatus = "ON_THE_JOB";
				var name = missionVariables.taxi_passenger;
				var curloc = system.ID;
				var dest = missionVariables.taxi_dest;
				var time = missionVariables.taxi_time;
				var pay = missionVariables.taxi_pay;
				player.ship.addPassenger(name, curloc, dest, clock.seconds + time * 24 * 3600, pay);
				missionVariables.taxistat = "ACCEPTED";
			}
			else if (choice === "2DECLINE") {
				// Return to bulletin board screen:
				missionVariables.taxistat = "BOARD";
			}
		}
		// Passenger Contract #3 screen choices:
		if (missionVariables.taxistat === "JOB3_1") {
			if (choice === "1ACCEPT") {
				// Store passenger contract #3 details into variables and add passenger to ship & manifest:
				missionVariables.taxi_passenger = missionVariables.taxi_job_name_3;
				missionVariables.taxi_dest = missionVariables.taxi_job_dest_3;
				missionVariables.taxi_dest_name = missionVariables.taxi_job_dest_name_3;
				missionVariables.taxi_diff = missionVariables.taxi_job_diff_3;
				missionVariables.taxi_pay = missionVariables.taxi_job_pay_3;
				missionVariables.taxi_time = missionVariables.taxi_job_time_3;
				missionVariables.taxistatus = "ON_THE_JOB";
				var name = missionVariables.taxi_passenger;
				var curloc = system.ID;
				var dest = missionVariables.taxi_dest;
				var time = missionVariables.taxi_time;
				var pay = missionVariables.taxi_pay;
				player.ship.addPassenger(name, curloc, dest, clock.seconds + time * 24 * 3600, pay);
				missionVariables.taxistat = "ACCEPTED";
			}
			else if (choice === "2DECLINE") {
				// Return to bulletin board screen:
				missionVariables.taxistat = "BOARD";
			}
		}
		// Special Mission #1 screen choices:
		if (missionVariables.taxistat === "SPEC_MIS_01_1") {
			if (choice === "1ACCEPT") {
				// Store special mission #1 details into variables and add passenger to ship & manifest:
				missionVariables.taxi_passenger = missionVariables.taxi_specmis_1_ambassador;
				missionVariables.taxi_dest = missionVariables.taxi_specmis1_dest;
				missionVariables.taxi_dest_name = missionVariables.taxi_specmis1_dest_name;
				missionVariables.taxi_diff = 3;
				missionVariables.taxi_pay = 10000;
				missionVariables.taxi_time = missionVariables.taxi_specmis1_time;
				missionVariables.taxistatus = "ON_THE_JOB";
				var name = missionVariables.taxi_passenger;
				var curloc = system.ID;
				var dest = missionVariables.taxi_dest;
				var time = missionVariables.taxi_time;
				var pay = missionVariables.taxi_pay;
				player.ship.addPassenger(name, curloc, dest, clock.seconds + time * 24 * 3600, pay);
				missionVariables.taxistat = "ACCEPTED";
			}
			else if (choice === "2DECLINE") {
				// Return to bulletin board screen:
				missionVariables.taxistat = "BOARD";
			}
		}
		return;
	}
	// Check if Player is currently docked at the main station:
	if (player.ship.dockedStation.isMainStation) {
		// Check if Player is doing a contract and is at the contract mission destination:
		if (missionVariables.taxistatus === "ON_THE_JOB" && system.ID === missionVariables.taxi_dest) {
			// Change variable to reflect no longer doing contract:
			missionVariables.taxistatus = "NOT_ON_JOB";
			// Increase variable to reflect another contract completed:
			missionVariables.taxijobstotal += 1;
			// Refuel Player ship:
			player.ship.fuel = 7.0;
			// Check if Player was doing special mission #1:
			if (missionVariables.taxi_diff === 3) {
				// Change variable to reflect special mission #1 complete:
				missionVariables.taxi_specmiss_1 = "MISSION_COMPLETE";
				// Check if Snoopers OXP is installed and if so insert news story about events of special mission #1:
				if (worldScripts.snoopers) worldScripts.snoopers.insertNews({ ID: this.name, Agency: 1, Message: expandDescription("[taxi_snoopers_specmiss_1]") });
				if (worldScripts.GNN) worldScripts.GNN._insertNews({ ID: this.name, Agency: 1, Message: expandDescription("[taxi_snoopers_specmiss_1]") });
			}
		}
	}
	// Check if Player is current docked at a Taxi Station:
	if (player.ship.dockedStation.hasRole("taxi_station")) {
		if (missionVariables.taxistat === "REVISIT") {
			// Check if Player is currently doing a contract and if so prompt Player that they need to complete contract:
			if (missionVariables.taxistatus === "ON_THE_JOB") {
				mission.runScreen(
					{
						titleKey: "taxi_welcome_title",
						screenID: "taxi_galactica_welcome",
						messageKey: "mission_taxi_on_job",
						model: this._model,
						choicesKey: "mission_taxi_on_job_choices"
					},
					choiceEvaluation);
				missionVariables.taxistat = "ON_THE_JOB_1";
				return;
			}
			else {
				// Check if Player has completed 5 or more contracts, has not yet completed special mission #1 and has a free passenger berth:
				if (missionVariables.taxijobstotal >= 5 && missionVariables.taxi_specmiss_1 !== "MISSION_COMPLETE" && player.ship.passengerCount < player.ship.passengerCapacity) {
					// Generate name for ambassador for special mission #1 briefing:
					missionVariables.taxi_specmis_1_ambassador = randomName() + " " + randomName();
					// Generate special mission #1 destination:
					missionVariables.taxi_specmis1_dest = this._generateTaxiDest(20);
					missionVariables.taxi_specmis1_dest_name = System.systemNameForID(missionVariables.taxi_specmis1_dest);
					// Get special mission #1 destination government type and assign name to variable: 
					missionVariables.taxi_specmis1_dest_gov = System.infoForSystem(galaxyNumber, missionVariables.taxi_specmis1_dest).government;
					if (missionVariables.taxi_specmis1_dest_gov === 0) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_0");
					if (missionVariables.taxi_specmis1_dest_gov === 1) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_1");
					if (missionVariables.taxi_specmis1_dest_gov === 2) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_2");
					if (missionVariables.taxi_specmis1_dest_gov === 3) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_3");
					if (missionVariables.taxi_specmis1_dest_gov === 4) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_4");
					if (missionVariables.taxi_specmis1_dest_gov === 5) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_5");
					if (missionVariables.taxi_specmis1_dest_gov === 6) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_6");
					if (missionVariables.taxi_specmis1_dest_gov === 7) missionVariables.taxi_specmis1_dest_gov_name = expandMissionText("taxi_system_gov_7");
					// Generate time limit for special mission #1:
					missionVariables.taxi_specmis1_time = Math.floor(Math.random() * (20 - 10 + 1) + 10);
					// Determine special mission #1 destination distance and assign to variable:
					missionVariables.taxi_specmis1_dist = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_specmis1_dest)) * 5) / 5;
					// Display special mission #1 briefing screen:
					mission.runScreen(
						{
							titleKey: "taxi_contract_offer",
							screenID: "taxi_galactica_intro",
							messageKey: "mission_taxi_spec_mis_1_intro",
							model: this._model,
							choicesKey: "mission_taxi_spec_mis_1_intro_choices"
						}, choiceEvaluation);
					missionVariables.taxistat = "SPEC_MIS_01_1";
					return;
				}
				else {
					// Display welcome screen for Taxi Station and generate new contract destinations:
					mission.runScreen(
						{
							titleKey: "taxi_welcome_title",
							screenID: "taxi_galactica_mission_intro",
							messageKey: "mission_taxi_intro",
							model: this._model,
							choicesKey: "mission_taxi_intro_choices"
						}, choiceEvaluation);
					this._generateTaxiJobs();
					missionVariables.taxistat = "REVISIT_1";
					return;
				}
			}
		}
		if (missionVariables.taxistat === "BOARD") {
			// Check Player has free passenger berth:
			if (player.ship.passengerCount >= player.ship.passengerCapacity) {
				// If no free passenger berth then cannot display bulletin board:
				mission.runScreen(
					{
						titleKey: "taxi_bb_title",
						screenID: "taxi_galactica_no_room",
						messageKey: "mission_taxi_no_room",
						model: this._model,
						choicesKey: "mission_taxi_on_job_choices"
					}, choiceEvaluation);
				missionVariables.taxistat = "ON_THE_JOB_1";
				return;
			}
			else {
				// If free passenger berth available then display bulletin board:
				mission.runScreen(
					{
						titleKey: "taxi_bb_title",
						screenID: "taxi_galactica_bb",
						messageKey: "mission_taxi_bulletin_board",
						model: this._model,
						choicesKey: "mission_taxi_bulletin_board_choices"
					}, choiceEvaluation);
				missionVariables.taxistat = "BOARD_1";
				return;
			}
		}
		if (missionVariables.taxistat === "JOB1") {
			// Calculate passenger contract #1 distance and store to variable:
			missionVariables.taxi_mission_distance_1 = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_job_dest_1)) * 5) / 5;
			// Display passenger contract #1 details:
			mission.runScreen(
				{
					titleKey: "taxi_contract_offer",
					screenID: "taxi_galactica_job_1",
					messageKey: "mission_taxi_job_1",
					model: this._model,
					choicesKey: "mission_taxi_job_1_choices"
				}, choiceEvaluation);
			missionVariables.taxistat = "JOB1_1";
			return;
		}
		if (missionVariables.taxistat === "JOB2") {
			// Calculate passenger contract #2 distance and store to variable:
			missionVariables.taxi_mission_distance_2 = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_job_dest_2)) * 5) / 5;
			// Display passenger contract #2 details:
			mission.runScreen(
				{
					titleKey: "taxi_contract_offer",
					screenID: "taxi_galactica_job_2",
					messageKey: "mission_taxi_job_2",
					model: this._model,
					choicesKey: "mission_taxi_job_2_choices"
				}, choiceEvaluation);
			missionVariables.taxistat = "JOB2_1";
			return;
		}
		if (missionVariables.taxistat === "JOB3") {
			// Calculate passenger contract #3 distance and store to variable:
			missionVariables.taxi_mission_distance_3 = Math.round(system.info.distanceToSystem(System.infoForSystem(galaxyNumber, missionVariables.taxi_job_dest_3)) * 5) / 5;
			// Display passenger contract #3 details:
			mission.runScreen(
				{
					titleKey: "taxi_contract_offer",
					screenID: "taxi_galactica_job_3",
					messageKey: "mission_taxi_job_3",
					model: this._model,
					choicesKey: "mission_taxi_job_3_choices"
				}, choiceEvaluation);
			missionVariables.taxistat = "JOB3_1";
			return;
		}
		if (missionVariables.taxistat === "ACCEPTED") {
			// Display contract accepted screen:
			mission.runScreen(
				{
					titleKey: "taxi_contract_accepted",
					screenID: "taxi_galactica_accepted",
					messageKey: "mission_taxi_accepted",
					model: this._model,
					choicesKey: "mission_taxi_on_job_choices"
				}, choiceEvaluation);
			missionVariables.taxistat = "ON_THE_JOB_1";
			return;
		}
		if (missionVariables.taxistat === "EXPLORE") {
			// Leave mission screen and return to manifest screen:
			return;
		}
	}
}

this.playerEnteredNewGalaxy = function () {
	// Check if Player had a passenger contract in progress:
	if (missionVariables.taxistatus === "ON_THE_JOB") {
		// set a flag we can check the next time we dock
		this._newGalaxy = true;
	}
}
