"use strict";
this.name = "coyoteZorra1";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteZorra1.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
	this.ship.fuel = 7.0;
	this.firstMessage = false;
}

this.fMessage = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S130_00]"), player.ship);
	this.firstMessage = true;
	this.ship.reactToAIMessage("LOOKFOR_TARGET");
}

this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 25000) {
			if (this.firstMessage == false) {
				this.ship.commsMessage(expandDescription("[COYOTE_S130_00]"), player.ship);
				this.firstMessage = true;
				this.ship.reactToAIMessage("LOOKFOR_TARGET");
			}
		}
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.scanFor200 = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoteAnaconda");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}

this.scanFor200E = function () {
	this.shArray = system.shipsWithRole("coyotemambaescort");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}

this.scanFor201 = function () {
	this.shArray = system.shipsWithPrimaryRole("coyotePython201");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
			this.ship.commsMessage(expandDescription("[COYOTE_S180_02]"), player.ship);
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}

this.informPlayer = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S130_01]"), player.ship);
	worldScripts["Coyote-Main"].setMissionInstructions("CE_MI_S_130_01");
	mission.unmarkSystem(128);
	mission.markSystem(72);
}

this.exitSystem = function () {
	this.ship.fuel = 7.0;
	this.ship.exitSystem(72);
	missionVariables.Coyote_status = "STAGE_140";
}

this.removeMe = function () {
	this.ship.remove(true);
}