"use strict";
this.name = "coyoteTractorBeam";
this.copyright = "(C) 2011 Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Tractor Beam Implementation";

this.activated = function () {
	if (!missionVariables.coyote_beam) {
		if (!player.ship.target) {
			player.consoleMessage("No active target", 6);
			return;
		}
		if (player.ship.target.mass > 200000000) {
			player.consoleMessage("Target has too much mass for this equipment", 6);
			return;
		}
		if (player.ship.target.position.distanceTo(player.ship.position) > 1000) {
			player.consoleMessage("Target is too far away to engage", 6);
			return;
		}
		var targetVector = player.ship.target.position.subtract(player.ship.position).direction();
		var angle = player.ship.heading.multiply(-1).angleTo(targetVector);
		if (angle > .10) {
			player.consoleMessage("Target must be on your rear to engage.", 6);
			return;
		}

		worldScripts["Coyote-Main"].tractorBeam();
	} else {
		worldScripts["Coyote-Main"].dtractorBeam();
	}
}