"use strict";
this.name = "coyoteSahana2";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteSahana2.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
	this.ship.fuel = 7.0;
}

this.addFuel = function () {
	this.ship.fuel = 7.0;
}

this.shipDockedWithStation = function () {
	player.commsMessage(expandDescription("[COYOTE_S225_10]"), 6);
	missionVariables.Coyote_status = "STAGE_229";
}

this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 25000) {}
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.checkFacing = function () {
	this.stationBuoy = system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000)[0];
	let idealVector = system.mainStation.position.subtract(this.stationBuoy.position).direction(); // direction 
	let targetVector = system.mainStation.position.subtract(this.ship.position).direction(); // direction unit 
	let shipOrientation = this.ship.orientation;
	let shipHeading = shipOrientation.vectorForward().direction(); // the way the ship is pointing (Z-axis)
	let shipPitch = shipOrientation.vectorUp(); // ship's up and down (Y-axis)
	let shipYaw = shipOrientation.vectorRight(); // ship's left and right (X-axis)
	this.shipAngle = shipHeading.angleTo(targetVector); // how accurately ship is pointing at the station centre
	this.shipUD = Math.abs(shipPitch.dot(idealVector)); // how far off-axis we are in the Y direction
	this.shipLR = Math.abs(shipYaw.dot(idealVector)); // how far off-axis we are in the X direction
	if (this.shipUD < 0.02 && this.shipLR < 0.02) {
		this.ship.fuel = 7.0;
		this.ship.reactToAIMessage("DOCK_WITH_INJECTORS");
		this.dockSahanaTId = addFrameCallback(this.dockSahana.bind(this));
	}
}

this.dockSahana = function () {
	if (this.ship.isValid) {
		var norient = system.mainStation.orientation.rotate(system.mainStation.vectorForward, 3.14159 / 2);
		this.ship.orientation = norient.rotate(system.mainStation.vectorUp, 3.14159);
	} else {
		if (isValidFrameCallback(this.dockSahanaTId)) {
			removeFrameCallback(this.dockSahanaTId);
		}
	}
}

this.scanFor200 = function () {
	this.shArray = system.shipsWithPrimaryRole("coyotepython230");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}

this.scanFor200E = function () {
	this.shArray = system.shipsWithRole("coyotepirateescort2");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}

this.scanFor201 = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoteferdie230");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}

this.scanFor202 = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoteasp230");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("TARGET_FAR");
		}
	}
}