"use strict";
this.name = "coyoteNavystationMarket";
this.author = "spara";
this.copyright = "2014 spara";
this.license     = "CC BY-NC-SA 4.0";

this.$originalDefs = {
      "food" : [0, 0, 13, 0, 0, 0, 0, 0, 0],
      "textiles" : [0, 0, 19, 0, 0, 0, 0, 0, 0],
      "radioactives" : [0, 0, 98, 0, 0, 0, 0, 0, 0],
      "slaves" : [0, 0, 0, 0, 0, 0, 0, 0, 0],
      "liquor_wines" : [0, 0, 104, 0, 0, 0, 0, 0, 0],
      "luxuries" : [0, 0, 189, 0, 0, 0, 0, 0, 0],
      "narcotics" : [0, 0, 0, 0, 0, 0, 0, 0, 0],
      "computers" : [0, 0, 150, 0, 0, 0, 0, 0, 0],
      "machinery" : [0, 0, 122, 0, 0, 0, 0, 0, 0],
      "alloys" : [0, 0, 107, 0, 0, 0, 0, 0, 0],
      "firearms" : [0, 0, 0, 0, 0, 0, 0, 0, 0],
      "furs" : [0, 0, 0, 0, 0, 0, 0, 0, 0],
      "minerals" : [0, 0, 0, 0, 0, 0, 0, 0, 0],
      "gold" : [0, 0, 92, 0, 0, 0, 0, 0, 1],
      "platinum" : [0, 0, 183, 0, 0, 0, 0, 0, 1],
      "gem_stones" : [0, 0, 53, 0, 0, 0, 0, 0, 2],
      "alien_items" : [0, 0, 224, 0, 0, 0, 0, 0, 0]
};

this.updateLocalCommodityDefinition = function(goodDefinition) {
	var commodity = goodDefinition.key;
	var oldDefs = this.$originalDefs[commodity];
	//old style definition found for the good. calculate it the old way
	if (oldDefs) {
		var market_base_price = oldDefs[2];
		var market_eco_adjust_price = oldDefs[3];
		var market_eco_adjust_quantity = oldDefs[4];
		var market_base_quantity = oldDefs[5];
		var market_mask_price = oldDefs[6];
		var market_mask_quantity = oldDefs[7];
		var market_rnd = Math.floor(Math.random() * 256);

		var economy = system.economy;

		var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
		price *= 0.4;

		var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
		if (quantity > 127) quantity = 0;
		quantity &= 63;

		goodDefinition.price = price * 10;
		goodDefinition.quantity = quantity;
	}
	//no definition found. nullify the goods.
	else {
		goodDefinition.price = 0;
		goodDefinition.quantity = 0;
	}
	return goodDefinition;
};
