"use strict";
this.name = "coyoteLobo1";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteLebo1.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
	this.ship.fuel = 7.0;
}

this.locatePlayer = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoteviper1");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("VIPER_DEAD");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
			return;
		} else {}
	}
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.informPlayer = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S140_01]"), player.ship);
	worldScripts["Coyote-Main"].setMissionInstructions("CE_MI_S_140_01");
}

this.informPlayer2 = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S150_01]"), player.ship);
	worldScripts["Coyote-Main"].setMissionInstructions("CE_MI_S_150_01");
	this.ship.bounty = 0;
	player.ship.bounty = 0;
	mission.unmarkSystem(72);
}

this.shipStartAttack = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoteviper1");
	if (this.shArray.length == 0) {
		this.ship.reactToAIMessage("VIPER_DEAD");
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
		} else {
			this.ship.reactToAIMessage("NOTHING_FOUND");
		}
	}
}

this.clearLegalStatus = function () {
	this.ship.bounty = 0;
}

this.locatePlayer2 = function () {
	this.playerArray = system.shipsWithPrimaryRole("player", this.ship);
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 10000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}