"use strict";
this.name = "coyoteKatikBoss3Escort";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteKatikBoss3Escort.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
	this.ship.fuel = 7.0;
	this.attackCount = 0;
}

this.findSahana = function () {
	this.shpArray = system.shipsWithRole("coyotesahanapod");
	if (this.shpArray.length == 0) {} else {
		this.ship.target = this.shpArray[0];
		this.ship.reactToAIMessage("TARGET_FOUND");
	}
}

this.findBoss = function () {
	this.shpArray = system.shipsWithRole("coyotekatikboss2pod");
	if (this.shpArray.length == 0) {} else {
		this.ship.target = this.shpArray[0];
		this.ship.reactToAIMessage("TARGET_FOUND");
	}
}

this.message1 = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S225_08]"), player.ship);
}

this.message2 = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S225_09]"), player.ship);
	mission.setInstructionsKey("CE_MI_S_225_03", "Coyote-Main");
	this.checkDistanceTimer = new Timer(this, this.checkDistance, 10, 10);
}

this.message4 = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S225_11]"), player.ship);
}

this.message5 = function () {
	player.commsMessage(expandDescription("[COYOTE_S225_12]"), 6);
}

this.message6 = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S225_13]"), player.ship);
}

this.message7 = function () {
	this.ship.fuel = 7;
	this.ship.exitSystem(185);
	mission.setInstructionsKey("CE_MI_S_225_05", "Coyote-Main");
}

this.checkDistance = function () {
	if (this.ship.position.distanceTo(system.mainStation.position) < 350000 && this.attackCount == 0) {
		if (this.ship.position.distanceTo(player.ship.position) < 25000) {
			var pos = this.ship.position.add(this.ship.vectorForward.multiply(25000));
			system.addShips("coyoteasp225", 2, pos, 500);
			system.addShips("coyoteferdie225", 1, pos, 500);
			system.addShips("coyoteferdie226", 1, pos, 500);
			this.ship.commsMessage(expandDescription("[COYOTE_S225_09a]"), player.ship);
			mission.setInstructionsKey("CE_MI_S_225_04", "Coyote-Main");
			this.ship.reactToAIMessage("AMBUSH_1");
			this.attackCount += 1;
			this.checkDistanceTimer.stop();
		}
	}
}

this.shipDied = function (whom, why) {
	this.ship.spawnOne("coyotesahanapod2");
}

this.addFuel = function () {
	this.ship.fuel = 7.0;
}

this.shipDockedWithStation = function () {
	player.commsMessage(expandDescription("[COYOTE_S225_10]"), 6);
	missionVariables.Coyote_status = "STAGE_229";
}

this.checkFacing = function () {
	this.stationBuoy = system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000)[0];
	let idealVector = system.mainStation.position.subtract(this.stationBuoy.position).direction(); // direction 
	let targetVector = system.mainStation.position.subtract(this.ship.position).direction(); // direction unit 
	let shipOrientation = this.ship.orientation;
	let shipHeading = shipOrientation.vectorForward().direction(); // the way the ship is pointing (Z-axis)
	let shipPitch = shipOrientation.vectorUp(); // ship's up and down (Y-axis)
	let shipYaw = shipOrientation.vectorRight(); // ship's left and right (X-axis)
	this.shipAngle = shipHeading.angleTo(targetVector); // how accurately ship is pointing at the station centre
	this.shipUD = Math.abs(shipPitch.dot(idealVector)); // how far off-axis we are in the Y direction
	this.shipLR = Math.abs(shipYaw.dot(idealVector)); // how far off-axis we are in the X direction
	if (this.shipUD < 0.02 && this.shipLR < 0.02) {
		this.ship.fuel = 7.0;
		this.ship.reactToAIMessage("DOCK_WITH_INJECTORS");
		this.dockSahanaTId = addFrameCallback(this.dockSahana.bind(this));
	}
}

this.dockSahana = function () {
	if (this.ship.isValid) {
		var norient = system.mainStation.orientation.rotate(system.mainStation.vectorForward, 3.14159 / 2);
		this.ship.orientation = norient.rotate(system.mainStation.vectorUp, 3.14159);
	} else {
		if (isValidFrameCallback(this.dockSahanaTId)) {
			removeFrameCallback(this.dockSahanaTId);
		}
	}
}

this.shipScoopedOther = function (whom) {
	if (whom.primaryRole == "coyotesahanapod") {
		this.podTimer = new Timer(this, this.podTim, 4, 0);
	}
}

this.podTim = function () {
	this.ship.displayName = "Sahana";
	this.ship.commsMessage(expandDescription("[COYOTE_S225_07]"), player.ship);
	this.ship.spawnOne("coyotesahanapod2");
}

this.removeMe = function () {
	this.ship.remove(true);
}