"use strict";
this.name = "coyoteGreer2";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteGreer2.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
}

this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3300) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.informPlayer = function () {}

this.informPlayer2 = function () {}

this.shipStartAttack = function () {
	this.shArray = system.shipsWithPrimaryRole("coyotepiratepython");
	if (this.shArray.length == 0) {
		this.shArray = system.shipsWithRole("coyotepirateescort");
		if (this.shArray.length == 0) {
			this.ship.reactToAIMessage("END_OF_BATTLE");
		} else {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
		}
	} else {
		this.ship.target = this.shArray[0];
		this.ship.reactToAIMessage("VIPER_FOUND");
	}
}

this.locatePlayer1 = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 2000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.desired = function () {
	this.ship.commsMessage(expandDescription("[COYOTE_S310_11]"), player.ship);
}

this.startMove = function () {
	this.count = 0;
	this.originalDistance = this.ship.position.distanceTo(player.ship.position);
	this.originalPosition = this.ship.position;
	var des = player.ship.position.add(player.ship.vectorRight.multiply(200)).add(player.ship.vectorForward.multiply(-200));
	log(this.name, des.distanceTo(this.ship.position) / 240);
}

this.startMove1 = function () {
	if (this.count >= 240) {
		this.ship.reactToAIMessage("IN_POSITION");
		worldScripts["Coyote-Main"].greer(this.ship);
	} else {
		this.count += 1;
		//var d = this.originalPosition
		var des = player.ship.position.add(player.ship.vectorRight.multiply(200)).add(player.ship.vectorForward.multiply(-200));
		var targetVector = des.subtract(this.ship.position).direction();
		var angle = this.ship.heading.angleTo(targetVector);
		var cross = this.ship.heading.cross(targetVector).direction();
		this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
		if (des.distanceTo(this.ship.position) < 10) {
			this.ship.reactToAIMessage("IN_POSITION");
			worldScripts["Coyote-Main"].greer(this.ship);
		} else {
			this.ship.position = this.ship.position.add(targetVector.multiply(des.distanceTo(this.ship.position) / 240));
		}
	}
}

this.startMove2 = function () {
	if (this.count >= 240) {
		this.ship.reactToAIMessage("IN_POSITION");
		worldScripts["Coyote-Main"].greerT1(this.ship);
	} else {
		this.count += 1;
		//var d = this.originalPosition
		var des = player.ship.position.add(player.ship.vectorRight.multiply(200)).add(player.ship.vectorForward.multiply(-200));
		var targetVector = des.subtract(this.ship.position).direction();
		var angle = this.ship.heading.angleTo(targetVector);
		var cross = this.ship.heading.cross(targetVector).direction();
		this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
		if (des.distanceTo(this.ship.position) < 10) {
			this.ship.reactToAIMessage("IN_POSITION");
			worldScripts["Coyote-Main"].greerT1(this.ship);
		} else {
			this.ship.position = this.ship.position.add(targetVector.multiply(des.distanceTo(this.ship.position) / 240));
		}
	}
}

this.checkSunskim1 = function () {
	var P = system.mainPlanet;
	var targetVector = P.position.subtract(this.ship.position).direction();
	var angle = this.ship.heading.angleTo(targetVector);
	var cross = this.ship.heading.cross(targetVector).direction();
	this.ship.orientation = this.ship.orientation.rotate(cross, -angle);

}

this.checkSunskim = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			var pos = this.ship.position;
			this.shArray = system.shipsWithPrimaryRole("coyotecameron1");

			this.ship.exitSystem(84);
			if (this.shArray.length > 0) {
				this.shArray[0].position = pos;
			}
		} else if (this.ship.position.distanceTo(player.ship.position) < 15000) {
			if (this.firstMessage) {
				this.ship.commsMessage("Come near to us to follow our wormhole", player.ship);
				this.firstMessage = false;
			}
		}
	}
}

this.removeMe = function () {
	this.ship.remove(true);
}

this.cheatPlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length > 0) {
		if (this.ship.position.distanceTo(player.ship.position) > 40000) {
			if (this.ship.savedCoordinates.distanceTo(this.ship.position) > 21000) {
				this.ship.position = this.ship.position.add(this.ship.vectorForward.multiply(20000));
			}
		}
	}
}

this.cheatPlayer1 = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length > 0) {
		if (this.ship.position.distanceTo(player.ship.position) > 50000) {
			if (player.ship.position.distanceTo(this.ship.position) > 21000) {
				this.ship.position = this.ship.position.add(this.ship.vectorForward.multiply(20000));
			}
		} else {
			if (system.countShipsWithPrimaryRole("coyotebandit2") !== 0) {
				this.ship.reactToAIMessage("WAIT_FOR_BANDITS");
			}
		}
	}
}

this.checkBandit = function () {
	if (system.countShipsWithPrimaryRole("coyotebandit2") == 0) {
		this.ship.reactToAIMessage("HOSTILES_SMASHED");
	}
}