"use strict";
this.name = "coyoteGreer1";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteGreer1.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
	this.firstMessage = true;
}

this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.informPlayer = function () {}

this.informPlayer2 = function () {}

this.shipStartAttack = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoterogueviper2");
	if (this.shArray.length == 0) {
		this.shArray = system.shipsWithPrimaryRole("coyoterogueviper1");
		if (this.shArray.length == 0) {
			this.shArray = system.shipsWithPrimaryRole("coyoteinterceptor1");
			if (this.shArray.length == 0) {
				if (!missionVariables.Coyote_BattleAtBiarra) {
					this.ship.reactToAIMessage("NOTHING_FOUND");
				} else {
					this.ship.reactToAIMessage("END_OF_BATTLE");
				}
			} else {
				this.ship.target = this.shArray[0];
				this.ship.reactToAIMessage("VIPER_FOUND");
			}
		} else {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
		}
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
		} else {
			this.ship.reactToAIMessage("NOTHING_FOUND");
		}
	}
}

this.locatePlayer1 = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 2000) {
			if (missionVariables.coyote_escapePodKilled == "TRUE") {
				this.ship.reactToAIMessage("POD_KILLED");
			} else {
				this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
			}
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.startMove = function () {
	this.count = 0;
	this.originalDistance = this.ship.position.distanceTo(player.ship.position);
	this.originalPosition = this.ship.position;
	var des = player.ship.position.add(player.ship.vectorRight.multiply(200)).add(player.ship.vectorForward.multiply(-200));
	log(this.name, des.distanceTo(this.ship.position) / 240);
}

this.startMove1 = function () {
	if (this.count >= 240) {
		this.ship.reactToAIMessage("IN_POSITION");
		worldScripts["Coyote-Main"]["greer"](this.ship);
	} else {
		this.count += 1;
		//var d = this.originalPosition
		var des = player.ship.position.add(player.ship.vectorRight.multiply(200)).add(player.ship.vectorForward.multiply(-200));
		var targetVector = des.subtract(this.ship.position).direction();
		var angle = this.ship.heading.angleTo(targetVector);
		var cross = this.ship.heading.cross(targetVector).direction();
		this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
		if (des.distanceTo(this.ship.position) < 10) {
			this.ship.reactToAIMessage("IN_POSITION");
			worldScripts["Coyote-Main"].greer(this.ship);
		} else {
			this.ship.position = this.ship.position.add(targetVector.multiply(des.distanceTo(this.ship.position) / 240));
		}
	}
}

this.checkSunskim1 = function () {
	var P = system.mainPlanet;
	var targetVector = P.position.subtract(this.ship.position).direction();
	var angle = this.ship.heading.angleTo(targetVector);
	var cross = this.ship.heading.cross(targetVector).direction();
	this.ship.orientation = this.ship.orientation.rotate(cross, -angle);

}

this.checkSunskim = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			var pos = this.ship.position;
			this.shArray = system.shipsWithPrimaryRole("coyotecameron1");
			mission.unmarkSystem(66);
			mission.markSystem(84);
			this.ship.fuel = 7.0;
			this.ship.exitSystem(84);
			missionVariables.Coyote_status = "STAGE_325"
			if (this.shArray.length > 0) {
				this.shArray[0].position = pos;
			}
		} else if (this.ship.position.distanceTo(player.ship.position) < 15000) {
			if (this.firstMessage) {
				this.ship.commsMessage("Come near to us to follow our wormhole", player.ship);
				worldScripts["Coyote-Main"].setMissionInstructions("CE_MI_S_310_03");
				this.firstMessage = false;
			}
		}
	}
}

this.removeMe = function () {
	this.ship.remove(true);
}

this.cheatThePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length > 0) {
		if (this.ship.position.distanceTo(player.ship.position) > 40000) {
			this.shArray = system.shipsWithPrimaryRole("coyotebandit1");
			var i = this.shArray.length - 1;
			while (i >= 0) {
				this.shArray[0].remove();
				i -= 1;
			}
		}
	}
}