"use strict";
this.name = "coyoteCameron4";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteCameron4.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
}

this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3500) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.startMove = function () {
	this.count = 0;
	this.originalDistance = this.ship.position.distanceTo(player.ship.position);
	this.originalPosition = this.ship.position;
}

this.startMove1 = function () {
	if (this.count >= 240) {
		this.ship.reactToAIMessage("IN_POSITION");
		worldScripts["Coyote-Main"].camT1(this.ship);
	} else {
		this.count += 1;
		//var d = this.originalPosition
		var des = player.ship.position.add(player.ship.vectorRight.multiply(-200)).add(player.ship.vectorForward.multiply(-200));
		var targetVector = des.subtract(this.ship.position).direction();
		var angle = this.ship.heading.angleTo(targetVector);
		var cross = this.ship.heading.cross(targetVector).direction();
		this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
		if (des.distanceTo(this.ship.position) < 10) {
			this.ship.reactToAIMessage("IN_POSITION");
			worldScripts["Coyote-Main"].camT1(this.ship);
		} else {
			this.ship.position = this.ship.position.add(targetVector.multiply(des.distanceTo(this.ship.position) / 240));
		}
	}
}

this.removeMe = function () {
	this.ship.remove(true);
}