"use strict";
this.name = "coyoteCameron1";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "Ship script for coyoteLebo1.";

this.shipSpawned = function () {
	//this.ship.reportAIMessages = true;
}

this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 3000) {
			this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.informPlayer = function () {
	player.consoleMessage(expandDescription("[COYOTE_S310_01]"), 6);

	this.ship.commsMessage(expandDescription("[COYOTE_S310_02]"), player.ship);
	this.shArray = system.shipsWithPrimaryRole("coyotegreer1");
	if (this.shArray.length > 0) {
		this.shArray[0].commsMessage(expandDescription("[COYOTE_S310_03]"), player.ship);
	}

}

this.informPlayer2 = function () {}

this.shipStartAttack = function () {
	this.shArray = system.shipsWithPrimaryRole("coyoterogueviper1");
	if (this.shArray.length == 0) {
		this.shArray = system.shipsWithPrimaryRole("coyoterogueviper2");
		if (this.shArray.length == 0) {
			this.shArray = system.shipsWithPrimaryRole("coyoteinterceptor1");
			if (this.shArray.length == 0) {
				if (!missionVariables.Coyote_BattleAtBiarra) {
					this.ship.reactToAIMessage("NOTHING_FOUND");
				} else {
					this.ship.reactToAIMessage("END_OF_BATTLE");
				}
			} else {
				this.ship.target = this.shArray[0];
				this.ship.reactToAIMessage("VIPER_FOUND");
			}
		} else {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
		}
	} else {
		if (this.ship.position.distanceTo(this.shArray[0].position) < 25000) {
			this.ship.target = this.shArray[0];
			this.ship.reactToAIMessage("VIPER_FOUND");
		} else {
			this.ship.reactToAIMessage("NOTHING_FOUND");
		}
	}
}

this.locatePlayer1 = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length == 0) {
		this.ship.remove();
	} else {
		this.ship.target = this.playerArray[0];
		if (this.ship.position.distanceTo(player.ship.position) < 2000) {
			if (missionVariables.coyote_escapePodKilled == "TRUE") {
				this.ship.reactToAIMessage("POD_KILLED");
			} else {
				this.ship.reactToAIMessage("DESIRED_RANGE_ACHIEVED");
			}
		} else {
			this.ship.reactToAIMessage("PLAYER_FOUND");
		}
	}
}

this.startMove = function () {
	this.count = 0;
	this.originalDistance = this.ship.position.distanceTo(player.ship.position);
	this.originalPosition = this.ship.position;
}

this.startMove1 = function () {
	if (this.count >= 240) {
		this.ship.reactToAIMessage("IN_POSITION");
		worldScripts["Coyote-Main"]["cam"](this.ship);
	} else {
		this.count += 1;
		//var d = this.originalPosition
		var des = player.ship.position.add(player.ship.vectorRight.multiply(-200)).add(player.ship.vectorForward.multiply(-200));
		var targetVector = des.subtract(this.ship.position).direction();
		var angle = this.ship.heading.angleTo(targetVector);
		var cross = this.ship.heading.cross(targetVector).direction();
		this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
		if (des.distanceTo(this.ship.position) < 10) {
			this.ship.reactToAIMessage("IN_POSITION");
			worldScripts["Coyote-Main"]["cam"](this.ship);
		} else {
			this.ship.position = this.ship.position.add(targetVector.multiply(des.distanceTo(this.ship.position) / 240));
		}
	}
}

this.checkSunskim1 = function () {
	var P = system.mainPlanet;
	var targetVector = P.position.subtract(this.ship.position).direction();
	var angle = this.ship.heading.angleTo(targetVector);
	var cross = this.ship.heading.cross(targetVector).direction();
	this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
	if (this.ship.speed == 0) {
		this.playerArray = system.shipsWithPrimaryRole("coyotegreer1");
		if (this.playerArray.length == 0) {} else {
			// this.ship.target = this.playerArray[0];
			this.ship.position = this.playerArray[0].position.add(this.playerArray[0].vectorUp.multiply(200));
		}
	}
}

this.checkSunskim = function () {
	if (this.ship.speed == 0) {
		var P = system.mainPlanet;
		var targetVector = P.position.subtract(this.ship.position).direction();
		var angle = this.ship.heading.angleTo(targetVector);
		var cross = this.ship.heading.cross(targetVector).direction();
		this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
		this.playerArray = system.shipsWithPrimaryRole("coyotegreer1");
		if (this.playerArray.length == 0) {} else {
			// this.ship.target = this.playerArray[0];
			this.ship.position = this.playerArray[0].position.add(this.playerArray[0].vectorUp.multiply(200));
			this.ship.orientation = this.playerArray[0].orientation;
		}
	}
}

this.removeMe = function () {
	this.ship.remove(true);
}