"use strict";
this.name = "Coyote-Main";
this.author = "Okti";
this.copyright = "(C) Okti";
this.licence = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description = "A mission based On Coyote by EL Viejo.";

/*
	todo: 
		maybe implement a more 'natural' way of giving the player a full fuel tank at the start of the mission
			add a special cargo pod near the witchpoint, which, when scooped, will give the player full fuel and kick off the mission?
		have an MFD which displays the most current comms instructional message, so it doesn't get lost off the screen?
*/

this.startUp = function () {
	this.CamAndGreerTrackId = null;
	this.cam1 = null;
	this.greer1 = null;
	this.showScreen = true;
}

this.startUpComplete = function () {
	this.$initInterface(player.ship.dockedStation);
}

this.$disableMarketObserver = function $disableMarketObserver(station) {
	if (station.primaryRole == "Coyoteinterstellarstation" || station.primaryRole == "Coyoteinterstellarstationgg" || station.primaryRole == "coyoterockhermit") {
		if (worldScripts.market_ads) {
			var ma = worldScripts.market_ads;
			if (ma.guiScreenChanged) {
				ma.$cm_hold_guiScreenChanged = ma.guiScreenChanged;
				delete ma.guiScreenChanged;
			}
		}
		if (worldScripts.market_observer3) {
			var mo = worldScripts.market_observer3;
			if (mo.guiScreenChanged) {
				mo.$cm_hold_guiScreenChanged = mo.guiScreenChanged;
				delete mo.guiScreenChanged;
			}
		}
		if (worldScripts.NoMarketNotification) {
			var nmn = worldScripts.NoMarketNotification;
			if (nmn.guiScreenChanged) {
				nmn.$cm_hold_guiScreenChanged = nmn.guiScreenChanged;
				nmn.$cm_hold_guiScreenWillChange = nmn.guiScreenWillChange;
				delete nmn.guiScreenChanged;
				delete nmn.guiScreenWillChange;
			}
		}
	}
}

this.$enableMarketObserver = function $enableMarketObserver (station) {
	if (!station) return;
	if (station.primaryRole == "Coyoteinterstellarstation" || station.primaryRole == "Coyoteinterstellarstationgg" || station.primaryRole == "coyoterockhermit") {
		if (worldScripts.market_ads) {
			var ma = worldScripts.market_ads;
			if (ma.$cm_hold_guiScreenChanged) {
				ma.guiScreenChanged = ma.$cm_hold_guiScreenChanged;
				delete ma.$cm_hold_guiScreenChanged;
			}
		}
		if (worldScripts.market_observer3) {
			var mo = worldScripts.market_observer3;
			if (mo.$cm_hold_guiScreenChanged) {
				mo.guiScreenChanged = mo.$cm_hold_guiScreenChanged;
				delete mo.$cm_hold_guiScreenChanged;
			}
		}
		if (worldScripts.NoMarketNotification) {
			var nmn = worldScripts.NoMarketNotification;
			if (nmn.$cm_hold_guiScreenChanged) {
				nmn.guiScreenChanged = nmn.$cm_hold_guiScreenChanged;
				nmn.guiScreenWillChange = nmn.$cm_hold_guiScreenWillChange;
				delete nmn.$cm_hold_guiScreenChanged;
				delete nmn.$cm_hold_guiScreenWillChange;
			}
		}
	}
}

this.guiScreenChanged = function (to, from) {
	/*if (to == "GUI_SCREEN_SYSTEM_DATA" && this.showScreen && player.ship.docked) {
		this.showScreen = false;
		this.displayPreviousScreens();
	}*/
	if (to == "GUI_SCREEN_MARKET" && player.ship.docked) {
		if (player.ship.dockedStation.primaryRole == "Coyoteinterstellarstation" || player.ship.dockedStation.primaryRole == "Coyoteinterstellarstationgg") {
			mission.runScreen({
				title: "Avernus Commodity Market",
				messageKey: "Avernus_Commodity_Market",
				choicesKey: "Avernus_Commodity_Market_choices"
			}, this.choices);
		}
		if (player.ship.dockedStation.primaryRole == "coyoterockhermit") {
			mission.runScreen({
				title: "Rock Hermit Commodity Market",
				messageKey: "Labruja_Commodity_Market"
			});
		}
	}
}

this.shipSpawned = function (ship) {
	if (!player.ship.docked) {
		if (ship.primaryRole == "EQ_QC_MINE" || ship.primaryRole == "EQ_RMB_CASCADE_MISSILE" || ship.primaryRole == "EQ_RMB_LAW_MISSILE" || ship.primaryRole == "EQ_RMB_OVERRIDE_MISSILE" || ship.primaryRole == "EQ_NUKE2_MISSILE" || ship.primaryRole == "EQ_HARPOON_NUKE2_MISSILE" || ship.primaryRole == "EQ_PHOTON_MISSILE" || ship.primaryRole == "RANDOM_HITS_MINE") {
			if ((missionVariables.Coyote_status == "STAGE_200" || missionVariables.Coyote_status == "STAGE_210" || missionVariables.Coyote_status == "STAGE_220") && galaxyNumber == 4 && system.ID == 185) {
				this.shArray = system.shipsWithPrimaryRole("coyotekatikrockhermit");
				if (this.shArray.length > 0) {
					if (this.shArray[0].position.distanceTo(player.ship.position) < 25600) {
						player.consoleMessage(ship.primaryRole + " has been disarmed", 6);
						ship.remove(true);
					}
				}
			}
			if (!missionVariables.Coyote_status || missionVariables.Coyote_status == "COMPLETED") {
				return;
			}
			if (ship.position.distanceTo(player.ship.position) < 25600) {
				player.consoleMessage(ship.primaryRole + " has been disarmed", 6);
				ship.remove(true);
			}
		}
	}
}

this.shipDockedWithStation = function (station) {
	this.$initInterface(station);
	this.$disableMarketObserver(station);
}

this.shipLaunchedFromStation = function (station) {
	this.$enableMarketObserver(station);
	if (missionVariables.Coyote_status == "STAGE_310" && galaxyNumber == 4 && system.ID == 58) {
		this.station = station;
		station.launchShipWithRole("coyoteinterceptor")
	}
}

this.shipWillLaunchFromStation = function (station) {
	this.showScreen = true;
	// Anbedi
	if (missionVariables.Coyote_status == "STAGE_350" && galaxyNumber == 4 && system.ID == 20) {
		if (system.countShipsWithRole("coyotecameron4") == 0) {
			system.addShips("coyotegreer4", 1, station.position.add(station.vectorForward.multiply(5000)), 100);
			system.addShips("coyotecameron4", 1, station.position.add(station.vectorForward.multiply(5000)), 100);
		}
	}
	// Zaquesso
	/*if (galaxyNumber == 4 && system.ID == 25) {
		if (system.countShipsWithRole("CoyoteNavystation1") == 0) {
			var P = system.addPlanet("Coyote_planet1")
			P.solarGasGiant = true;
			var P2 = system.addPlanet("Coyote_planet2")
			P2.solarGasGiant = true;
			var M = system.addMoon("Coyote_moon1");
			tv = P.position.subtract(M.position).direction();

			var stationPos = M.position.add(tv.multiply(-15000));
			//stationPos.x = 267107;
			//stationPos.y = -172013;
			//stationPos.z = 563825;
			S = system.addShips("CoyoteNavystation1", 1, stationPos, 100)[0];
			var targetVector = M.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
	}*/
	// Leteisan
	/*
	if (missionVariables.Coyote_status == "STAGE_200" && galaxyNumber == 4 && system.ID == 185) {
		if (system.countShipsWithRole("coyotekatikrockhermit") == 0) {
			var RH = system.addShips("coyotekatikrockhermit", 1, Vector3D(0, 0, 4).fromCoordinateSystem("sws"))[0];
			var targetVector = system.sun.position.subtract(RH.position).direction();
			var angle = RH.heading.angleTo(targetVector);
			var cross = RH.heading.cross(targetVector).direction();
			RH.orientation = RH.orientation.rotate(cross, -angle);
			system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
			system.addShips("coyotePython200", 1, RH.position, 3000);
			system.addShips("coyotePython201", 1, RH.position, 3000);
			system.addShips("coyotePython202", 1, RH.position, 3000);
			system.addShips("coyotePython203", 1, RH.position, 3000);
			this.lobo = system.addShips("coyotelobo4", 1)[0];
			this.zorra = system.addShips("coyotezorra4", 1)[0];
			this.massedLocked = false;
			this.trackId = addFrameCallback(this.loboAndZorra.bind(this));
		}
	}
	// Leteisan
	if (missionVariables.Coyote_status == "STAGE_210" && galaxyNumber == 4 && system.ID == 185) {
		if (system.countShipsWithRole("coyotekatikrockhermit") == 0) {
			var RH = system.addShips("coyotekatikrockhermit", 1, Vector3D(0, 0, 4).fromCoordinateSystem("sws"))[0];
			var targetVector = system.sun.position.subtract(RH.position).direction();
			var angle = RH.heading.angleTo(targetVector);
			var cross = RH.heading.cross(targetVector).direction();
			RH.orientation = RH.orientation.rotate(cross, -angle);
			system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
			system.addShips("coyotelobo5", 1, RH.position, 3000);
			system.addShips("coyotezorra5", 1, RH.position, 3000);
		}
	}
	// Leteisan
	if (missionVariables.Coyote_status == "STAGE_220" && galaxyNumber == 4 && system.ID == 185) {
		if (system.countShipsWithRole("coyotekatikrockhermit") == 0) {
			var RH = system.addShips("coyotekatikrockhermit", 1, Vector3D(0, 0, 4).fromCoordinateSystem("sws"))[0];
			var targetVector = system.sun.position.subtract(RH.position).direction();
			var angle = RH.heading.angleTo(targetVector);
			var cross = RH.heading.cross(targetVector).direction();
			RH.orientation = RH.orientation.rotate(cross, -angle);
			system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
			system.addShips("coyotelobo5", 1, RH.position, 3000);
			system.addShips("coyotezorra5", 1, RH.position, 3000);
		}
	}
	// Tirizaan
	if (galaxyNumber == 4 && system.ID == 40) {
		if (system.countShipsWithRole("CoyoteNavystation1") == 0) {
			var stationPos = new Vector3D;
			stationPos.x = 377799;
			stationPos.y = 157513;
			stationPos.z = 624280;
			S = system.addShips("CoyoteNavystation1", 1, stationPos, 100)[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
	}
	// Inmaarxe
	if (galaxyNumber == 4 && system.ID == 124) {
		if (system.countShipsWithRole("CoyoteNavystation1") == 0) {
			var stationPos = new Vector3D;
			stationPos.x = -65000;
			stationPos.y = -52600;
			stationPos.z = 809500;
			S = system.addShips("CoyoteNavystation1", 1, stationPos, 100)[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
	}
	// Zaeredre
	if (galaxyNumber == 4 && system.ID == 39) {
		if (system.countShipsWithRole("CoyoteNavystation2") == 0) {
			S = system.addShipsToRoute("CoyoteNavystation2", 1, 0.5, "sp")[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
	}
	// Bizalein
	if (galaxyNumber == 4 && system.ID == 89) {
		if (system.countShipsWithRole("CoyoteNavystation2") == 0) {
			var stationPos = new Vector3D;
			stationPos.x = -67015;
			stationPos.y = 56389;
			stationPos.z = 594198;
			S = system.addShips("CoyoteNavystation2", 1, stationPos, 100)[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
	}
	// Ergeso
	if (system.ID == 87 && galaxyNumber == 4) {
		if (system.countShipsWithRole("coyoterockhermit") == 0) {
			var rh = system.addShips("coyoterockhermit", 1, Vector3D(0, 0, 3).fromCoordinateSystem("sws"))[0];
			system.addShips("asteroid", 10, rh.position, 10000);
		}
	}*/
}

this.shipWillDockWithStation = function (station) {
	if (galaxyNumber == 4) {
		if (missionVariables.Coyote_status == "STAGE_20" && system.ID == 25 && station.primaryRole == "CoyoteNavystation1") {
			player.addMessageToArrivalReport("For Capturing Ka'eli Tun, a slimmy rodent from Ririqu, you're paid a bounty of " + formatCredits(74.9, true, true));
			player.credits += 74.9;
		}
		if (missionVariables.Coyote_status == "STAGE_350" && system.ID == 39 && player.ship.dockedStation.primaryRole == "CoyoteNavystation") {
			this.cam1.remove(true);
		}
		if (missionVariables.Coyote_status == "STAGE_60") {
			this.deactivateSkimTracking()
		}
	}
}

this.shipTargetAcquired = function (target) {
	if (!target) return;
	//player.consoleMessage(target.primaryRole,3);
	if (target.primaryRole == "coyotepythonstart" && !missionVariables.Coyote_status) {
		mission.setInstructionsKey("CE_MI_S_10_01");
		player.commsMessage(expandDescription("[COYOTE_START5]"), 10);
		missionVariables.Coyote_status = "STAGE_10";
	}
}

this.systemWillPopulate = function () {
	if (galaxyNumber == 4) {
		if (system.ID == 39) {
			var posNS = Vector3D(0, 0, 0.5).fromCoordinateSystem("spu");
			system.setPopulator("coyoteNS2", {
				location: "COORDINATES",
				coordinates: posNS,
				deterministic: true,
				callback: function (pos) {
					var S = system.addShips("CoyoteNavystation2", 1, pos, 0)[0];
					var targetVector = system.mainPlanet.position.subtract(S.position).direction();
					var angle = S.heading.angleTo(targetVector);
					var cross = S.heading.cross(targetVector).direction();
					S.orientation = S.orientation.rotate(cross, -angle);
				}
			});
		}
		// Zaquesso
		if (system.ID == 25) {
			var P = system.addPlanet("Coyote_planet1");
			P.solarGasGiant = true;
			var P2 = system.addPlanet("Coyote_planet2");
			P2.solarGasGiant = true;
			var M = system.addMoon("Coyote_moon1");
			var tv = P.position.subtract(M.position).direction();
			var stationPos = M.position.add(tv.multiply(-15000));
			system.setPopulator("coyteNS1", {
				location: "COORDINATES",
				coordinates: stationPos,
				deterministic: true,
				callback: function (pos) {
					//stationPos.x = 267107;
					//stationPos.y = -172013;
					//stationPos.z = 563825;
					var S = system.addShips("CoyoteNavystation1", 1, pos, 0)[0];
					var mn = null;
					for (var i = 0; i < system.planets.length; i++) {
						if (system.planets[i].texture == "Coyotemoon.png") {
							mn = system.planets[i];
						}
					}
					var targetVector = mn.position.subtract(S.position).direction();
					var angle = S.heading.angleTo(targetVector);
					var cross = S.heading.cross(targetVector).direction();
					S.orientation = S.orientation.rotate(cross, -angle);
				}
			});
		}
		// Bizalein
		if (system.ID == 89) {
			var stationPos = new Vector3D;
			stationPos.x = -67015;
			stationPos.y = 56389;
			stationPos.z = 594198;
			system.setPopulator("coyoteNS2", {
				location: "COORDINATES",
				coordinates: stationPos,
				deterministic: true,
				callback: function (pos) {
					var S = system.addShips("CoyoteNavystation2", 1, pos, 0)[0];
					var targetVector = system.mainPlanet.position.subtract(S.position).direction();
					var angle = S.heading.angleTo(targetVector);
					var cross = S.heading.cross(targetVector).direction();
					S.orientation = S.orientation.rotate(cross, -angle);
				}
			});
		}
		// Tirizaan
		if (system.ID == 40) {
			var stationPos = new Vector3D;
			stationPos.x = 377799;
			stationPos.y = 157513;
			stationPos.z = 624280;
			system.setPopulator("coyoteNS1", {
				location: "COORDINATES",
				coordinates: stationPos,
				deterministic: true,
				callback: function (pos) {
					var S = system.addShips("CoyoteNavystation1", 1, pos, 0)[0];
					var targetVector = system.mainPlanet.position.subtract(S.position).direction();
					var angle = S.heading.angleTo(targetVector);
					var cross = S.heading.cross(targetVector).direction();
					S.orientation = S.orientation.rotate(cross, -angle);
				}
			});
		}
		// Inmaarxe
		if (system.ID == 124) {
			var stationPos = new Vector3D;
			stationPos.x = -65000;
			stationPos.y = -52600;
			stationPos.z = 809500;
			system.setPopulator("coyoteNS1", {
				location: "COORDINATES",
				coordinates: stationPos,
				deterministic: true,
				callback: function (pos) {
					var S = system.addShips("CoyoteNavystation1", 1, pos, 0)[0];
					var targetVector = system.mainPlanet.position.subtract(S.position).direction();
					var angle = S.heading.angleTo(targetVector);
					var cross = S.heading.cross(targetVector).direction();
					S.orientation = S.orientation.rotate(cross, -angle);
				}
			});
		}
		// Leteisan
		if (system.ID == 185) {
			if (missionVariables.Coyote_status == "STAGE_200") {
				var stationPos = Vector3D(0, 0, 4).fromCoordinateSystem("sws");
				system.setPopulator("coyoteKRH1", {
					location: "COORDINATES",
					coordinates: stationPos,
					callback: function (pos) {
						var RH = system.addShips("coyotekatikrockhermit", 1, pos, 0)[0];
						var targetVector = system.sun.position.subtract(RH.position).direction();
						var angle = RH.heading.angleTo(targetVector);
						var cross = RH.heading.cross(targetVector).direction();
						var cr = worldScripts["Coyote-Main"];
						RH.orientation = RH.orientation.rotate(cross, -angle);
						system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
						system.addShips("coyotePython200", 1, RH.position, 3000);
						system.addShips("coyotePython201", 1, RH.position, 3000);
						system.addShips("coyotePython202", 1, RH.position, 3000);
						system.addShips("coyotePython203", 1, RH.position, 3000);
						cr.lobo = system.addShips("coyotelobo4", 1)[0];
						cr.zorra = system.addShips("coyotezorra4", 1)[0];
						cr.massedLocked = false;
						cr.trackId = addFrameCallback(cr.loboAndZorra.bind(cr));
					}
				});
			} else if (missionVariables.Coyote_status == "STAGE_210" || missionVariables.Coyote_status == "STAGE_220") {
				var stationPos = Vector3D(0, 0, 4).fromCoordinateSystem("sws");
				system.setPopulator("coyoteKRH1", {
					location: "COORDINATES",
					coordinates: stationPos,
					callback: function (pos) {
						var RH = system.addShips("coyotekatikrockhermit", 1, pos, 0)[0];
						var targetVector = system.sun.position.subtract(RH.position).direction();
						var angle = RH.heading.angleTo(targetVector);
						var cross = RH.heading.cross(targetVector).direction();
						RH.orientation = RH.orientation.rotate(cross, -angle);
						system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
						system.addShips("coyotelobo5", 1, RH.position, 3000);
						system.addShips("coyotezorra5", 1, RH.position, 3000);
					}
				});
			}
		}
		// Ergeso
		if (system.ID == 87) {
			var stationPos = Vector3D(0, 0, 3).fromCoordinateSystem("sws");
			system.setPopulator("coyoteRH1", {
				location: "COORDINATES",
				coordinates: stationPos,
				deterministic: true,
				callback: function (pos) {
					if (system.countShipsWithRole("coyoterockhermit") == 0) {
						var S = system.addShips("coyoterockhermit", 1, pos, 0)[0];
						system.addShips("asteroid", 10, S.position, 10000);
					}
				}
			});
		}
	}
}

this.interstellarSpaceWillPopulate = function () {
	if (this.addInterstellarPlanet) {
		var stationPos = new Vector3D;
		stationPos.x = 22172;
		stationPos.y = -20312;
		stationPos.z = 696652;
		system.setPopulator("coyoteNS2a", {
			location: "COORDINATES",
			coordinates: stationPos,
			deterministic: true,
			callback: function (pos) {
				var P = system.addPlanet("Coyote_interstellar_planet");
				P.solarGasGiant = true;
				var stn = "Coyoteinterstellarstation";
				if (worldScripts["ev_green_gecko"]) {
					//log("Coyote-Main", "gg");
					stn = "Coyoteinterstellarstationgg";
				} else {
					//log("Coyote-Main", "not gg");
				}
				var S = system.addShips(stn, 1, pos, 0)[0];
				// add an event to track when ships are launched - so we can attached destinations to shuttles

				var targetVector = P.position.subtract(S.position).direction();
				var angle = S.heading.angleTo(targetVector);
				var cross = S.heading.cross(targetVector).direction();
				S.orientation = S.orientation.rotate(cross, -angle);

				var targetVector1 = S.position.subtract(player.ship.position).direction();
				var pos1 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) / 2));
				system.addShips("asteroid", 30, pos1, 30000);
				var pos2 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 1 / 6));
				system.addShips("asteroid", 30, pos2, 30000);
				var pos3 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 2 / 6));
				system.addShips("asteroid", 30, pos3, 30000);
				var pos4 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 4 / 6));
				system.addShips("asteroid", 30, pos4, 30000);
				var pos5 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 5 / 6));
				system.addShips("asteroid", 30, pos5, 30000);
			}
		});
	}
}


this.shipWillEnterWitchspace = function (cause) {
	if (galaxyNumber == 4 && ((system.ID == 55 && player.ship.targetSystem == 128) || (system.ID == 128 && player.ship.targetSystem == 55) || (system.ID == 55 && player.ship.targetSystem == 55))) {
		this.addInterstellarPlanet = true;
	}
	if (missionVariables.Coyote_status == "STAGE_60") {
		this.deactivateSkimTracking();
	}
}

this.shipWillExitWitchspace = function () {
	if (galaxyNumber == 4) {
		// Laquused - this is the start point of the mission set
		if (!missionVariables.Coyote_status && system.ID == 159 && player.ship.equipmentStatus("EQ_CLOAKING_DEVICE") == "EQUIPMENT_OK") {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					shArr[j].remove(true);
				}
				j -= 1;
			}
			system.sendAllShipsAway();
			player.ship.position = player.ship.vectorForward.multiply(50000);
			this.MST_Count = 0;
			this.MissionStartTimer = new Timer(this, this.MST, 10, 10);
		}
		// Ririqu
		if (missionVariables.Coyote_status == "STAGE_10" && system.ID == 144) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			player.ship.removeEquipment("EQ_CLOAKING_DEVICE");
			player.ship.awardEquipment("EQ_CLOAKING_DEVICE");
			mission.setInstructionsKey("CE_MI_S_20_01");
			system.addShips("coyoteferdie2", 1, player.ship.position, 6000);
			system.addShips("coyotepython2", 1, player.ship.position, 6000);
		}
		// Lazaso
		else if (missionVariables.Coyote_status == "STAGE_120" && system.ID == 128) {
			system.addShips("coyoteAnaconda", 1, player.ship.position.add(player.ship.vectorForward.multiply(6000)), 100);
			system.addShips("coyotezorra1", 1, player.ship.position.add(player.ship.vectorForward.multiply(25000)));
		}
		// Xemageat
		else if (missionVariables.Coyote_status == "STAGE_140" && system.ID == 72) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			system.addShips("coyoteviper1", 1, player.ship.position.add(player.ship.vectorForward.multiply(40000)));
			system.addShips("coyotelobo1", 1, player.ship.position, 2000);
			system.addShips("coyotezorra2", 1, player.ship.position, 2000);
		}
		// steel halo: Zaenza, Lazaso, Xemageat, Leteisan, Cecear, Tiuson
		else if (missionVariables.Coyote_status == "STAGE_160") {
			missionVariables.Coyote_jumpCount += 1;
			if (system.ID == 55 || system.ID == 128 || system.ID == 72 || system.ID == 185 || system.ID == 126 || system.ID == 100) {
				this.Stage160();
			}
		}
		// Ortema
		else if (missionVariables.Coyote_status == "STAGE_180" && system.ID == 109) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						shArr[j].remove(true);
					}
				}
				j -= 1;
			}
			missionVariables.Coyote_KatikHunt = 0;
			system.addShips("coyotezorra3", 1, player.ship.position, 6000);
			system.addShips("coyotelobo2", 1, player.ship.position, 6000);
			this.S180TimerCount = 0;
			this.S180Timer = new Timer(this, this.Stage180, 60, 120);
		}
		// Cecear
		else if (missionVariables.Coyote_status == "STAGE_225" && system.ID == 126) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						shArr[j].remove(true);
					}
				}
				j -= 1;
			}
		}
		// Leteisan
		else if (missionVariables.Coyote_status == "STAGE_227" && system.ID == 185) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {

						shArr[j].remove(true);
					}
				}
				j -= 1;
			}
			system.addShips("coyoteasp230", 2, player.ship.position.add(player.ship.vectorForward.multiply(10000)).add(player.ship.vectorRight.multiply(10000)), 2000);
			system.addShips("coyoteferdie230", 2, player.ship.position.add(player.ship.vectorForward.multiply(10000)).add(player.ship.vectorRight.multiply(10000)), 2000);
			system.addShips("coyotepython230", 2, player.ship.position.add(player.ship.vectorForward.multiply(10000)).add(player.ship.vectorRight.multiply(10000)), 2000);
			system.addShips("coyotepirateescort2", 6, player.ship.position.add(player.ship.vectorForward.multiply(10000)).add(player.ship.vectorRight.multiply(10000)), 2000);
			system.addShips("coyotesahana2", 1, player.ship.position, 1000);
			system.addShips("coyotecuervo", 1, player.ship.position.add(player.ship.vectorForward.multiply(24000)), 0);
			mission.setInstructionsKey("CE_MI_S_225_06", "Coyote-Main");
		}
		// Bizalein
		else if (missionVariables.Coyote_status == "STAGE_240" && system.ID == 89) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			system.addShips("coyoteviper2", 4, player.ship.position, 5000);
			system.addShips("coyoteferdie4", 3, player.ship.position, 5000);
		}
		// Atbiarxe SCAN
		else if (missionVariables.Coyote_status == "STAGE_280" && system.ID == 49) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			system.addShips("coyoteviperleader", 1, player.ship.position.add(player.ship.vectorForward.multiply(-5000)), 100);
		}
		// Biceri
		else if (missionVariables.Coyote_status == "STAGE_300" && system.ID == 58) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						shArr[j].remove(true);
					}
				}
				j -= 1;
			}
		}
		// Biarra
		else if (missionVariables.Coyote_status == "STAGE_310" && system.ID == 66) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			this.BiarraTimer = new Timer(this, this.BiarraBattle, 10);
			system.addShips("coyotegreer1", 1, player.ship.position, 2000);
			system.addShips("coyotecameron1", 1, player.ship.position, 2000);
		}
		// Teesbi
		else if (missionVariables.Coyote_status == "STAGE_325" && system.ID == 84) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			system.addShips("coyotepiratepython", 1, player.ship.position, 6000);
			system.addShips("coyotegreer2", 1, player.ship.position, 2000);
			system.addShips("coyotecameron2", 1, player.ship.position, 2000);
			mission.unmarkSystem(66);
			mission.markSystem(84);
			mission.setInstructionsKey("CE_MI_S_310_04");
			missionVariables.Coyote_status = "STAGE_330";
		}
		// Anbedi Scan
		else if (missionVariables.Coyote_status == "STAGE_335" && system.ID == 20) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						} else {
							if (shArr[j].bounty !== 0) {
								shArr[j].remove(true);
							}

						}
					}
				}
				j -= 1;
			}
			system.addShips("coyoteviperleader", 1, player.ship.position.add(player.ship.vectorForward.multiply(-5000)), 100);
			this.lobo = system.addShips("coyotecameron3", 1)[0];
			this.zorra = system.addShips("coyotegreer3", 1)[0];
			this.massedLocked = false;
			this.trackId = addFrameCallback(this.loboAndZorra.bind(this));
			mission.unmarkSystem(84);
			mission.markSystem(20);
			mission.setInstructionsKey("CE_MI_S_310_08");
		}
		// Zaeredre
		else if (missionVariables.Coyote_status == "STAGE_350" && system.ID == 39) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						shArr[j].remove(true);
					}
				}
				j -= 1;
			}
			system.addShips("coyotegreer5", 1, player.ship.position.add(player.ship.vectorForward.multiply(-100)));
			system.addShips("coyotecameron5", 1, player.ship.position.add(player.ship.vectorForward.multiply(-200)));
			system.addShips("coyoteasp10", 1, player.ship.position.add(player.ship.vectorForward.multiply(-3000)), 100);
			system.addShips("coyoteasp11", 1, player.ship.position.add(player.ship.vectorForward.multiply(-3000)), 100);
			system.addShips("coyoteasp12", 1, player.ship.position.add(player.ship.vectorForward.multiply(-3000)), 100);
			system.addShips("coyoteasp13", 1, player.ship.position.add(player.ship.vectorForward.multiply(-3000)), 100);
			system.addShips("coyoteferdie10", 1, player.ship.position.add(player.ship.vectorForward.multiply(-3000)), 100);
			system.addShips("coyoteferdie11", 2, player.ship.position.add(player.ship.vectorForward.multiply(-3000)), 100);

			/*S = system.addShipsToRoute("CoyoteNavystation2", 1, 0.5, "sp")[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);*/

			mission.setInstructionsKey("CE_MI_S_360_01");
		}
		// on the way to Xele
		else if (missionVariables.Coyote_status == "STAGE_260" && system.ID !== 65) {
			if (Math.random() > 0.30) {
				this.pirateAmbush();
			}
		}
		// Edceon,Atrare
		else if (missionVariables.Coyote_status == "STAGE_280" && (system.ID == 242 || system.ID == 125)) {
			this.pirateAmbush();
		}
		// Zaquesso
		// >> sysWillPop
		/*
		if (system.ID == 25) {
			P = system.addPlanet("Coyote_planet1")
			P.solarGasGiant = true;
			P2 = system.addPlanet("Coyote_planet2")
			P2.solarGasGiant = true;
			M = system.addMoon("Coyote_moon1");
			tv = P.position.subtract(M.position).direction();

			var stationPos = M.position.add(tv.multiply(-15000));
			//stationPos.x = 267107;
			//stationPos.y = -172013;
			//stationPos.z = 563825;
			S = system.addShips("CoyoteNavystation1", 1, stationPos, 100)[0];
			var targetVector = M.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
		*/
		// Second system after Bizaar
		if (missionVariables.Coyote_status == "STAGE_55" && system.ID !== -1) {
			missionVariables.Coyote_status = "STAGE_60";
			this.sunSkimCounter = 0;
			this.sunSkimTimer = new Timer(this, this.sunSkimT, 3, 3);
		}
		// First system after Bizaar
		if (missionVariables.Coyote_status == "STAGE_50" && system.ID !== -1) {
			missionVariables.Coyote_status = "STAGE_55";
			system.addShips("coyoteferdie3", 1, player.ship.position, 10000);
			system.addShips("coyotemamba1", 1, player.ship.position, 10000);
		}
		// Ergeso
		/*
		if (system.ID == 87) {
			var rh = system.addShips("coyoterockhermit", 1, Vector3D(0, 0, 3).fromCoordinateSystem("sws"))[0];
			system.addShips("asteroid", 10, rh.position, 10000);
		}
		*/
		// interstellar space Avernus
		// >> intsysWillPop
		/*
		if (system.ID == -1 && this.addInterstellarPlanet) {
			P = system.addPlanet("Coyote_interstellar_planet")
			P.solarGasGiant = true;
			var stationPos = new Vector3D;
			stationPos.x = 22172;
			stationPos.y = -20312;
			stationPos.z = 696652;
			if (worldScripts["gg-character"]) {
				log(this.name, "gg");
				S = system.addShips("Coyoteinterstellarstationgg", 1, stationPos, 100)[0];
				var targetVector = P.position.subtract(S.position).direction();
				var angle = S.heading.angleTo(targetVector);
				var cross = S.heading.cross(targetVector).direction();
				S.orientation = S.orientation.rotate(cross, -angle);
				var targetVector1 = S.position.subtract(player.ship.position).direction();
				var pos1 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) / 2));
				system.addShips("asteroid", 30, pos1, 30000);
				var pos2 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 1 / 6));
				system.addShips("asteroid", 30, pos2, 30000);
				var pos3 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 2 / 6));
				system.addShips("asteroid", 30, pos3, 30000);
				var pos4 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 4 / 6));
				system.addShips("asteroid", 30, pos4, 30000);
				var pos5 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 5 / 6));
				system.addShips("asteroid", 30, pos5, 30000);
			} else {
				log(this.name, "not gg");
				S = system.addShips("Coyoteinterstellarstation", 1, stationPos, 100)[0];
				var targetVector = P.position.subtract(S.position).direction();
				var angle = S.heading.angleTo(targetVector);
				var cross = S.heading.cross(targetVector).direction();
				S.orientation = S.orientation.rotate(cross, -angle);
				var targetVector1 = S.position.subtract(player.ship.position).direction();
				var pos1 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) / 2));
				system.addShips("asteroid", 30, pos1, 30000);
				var pos2 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 1 / 6));
				system.addShips("asteroid", 30, pos2, 30000);
				var pos3 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 2 / 6));
				system.addShips("asteroid", 30, pos3, 30000);
				var pos4 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 4 / 6));
				system.addShips("asteroid", 30, pos4, 30000);
				var pos5 = player.ship.position.add(targetVector1.multiply(player.ship.position.distanceTo(S.position) * 5 / 6));
				system.addShips("asteroid", 30, pos5, 30000);
			}
		}
		*/
		/*
		// Bizalein
		if (system.ID == 89) {
			var stationPos = new Vector3D;
			stationPos.x = -67015;
			stationPos.y = 56389;
			stationPos.z = 594198;
			S = system.addShips("CoyoteNavystation2", 1, stationPos, 100)[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
		// Tirizaan
		if (system.ID == 40) {
			var stationPos = new Vector3D;
			stationPos.x = 377799;
			stationPos.y = 157513;
			stationPos.z = 624280;
			S = system.addShips("CoyoteNavystation1", 1, stationPos, 100)[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}
		// Inmaarxe
		if (system.ID == 124) {
			var stationPos = new Vector3D;
			stationPos.x = -65000;
			stationPos.y = -52600;
			stationPos.z = 809500;
			S = system.addShips("CoyoteNavystation1", 1, stationPos, 100)[0];
			var targetVector = system.mainPlanet.position.subtract(S.position).direction();
			var angle = S.heading.angleTo(targetVector);
			var cross = S.heading.cross(targetVector).direction();
			S.orientation = S.orientation.rotate(cross, -angle);
		}*/
	}
}

this.shipExitedWitchspace = function () {
	if (galaxyNumber == 4) {
		// Leteisan
		if (system.ID == 185) {
			/*if (missionVariables.Coyote_status == "STAGE_200") {
				var RH = system.addShips("coyotekatikrockhermit", 1, Vector3D(0, 0, 4).fromCoordinateSystem("sws"))[0];
				var targetVector = system.sun.position.subtract(RH.position).direction();
				var angle = RH.heading.angleTo(targetVector);
				var cross = RH.heading.cross(targetVector).direction();
				RH.orientation = RH.orientation.rotate(cross, -angle);
				system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
				system.addShips("coyotePython200", 1, RH.position, 3000);
				system.addShips("coyotePython201", 1, RH.position, 3000);
				system.addShips("coyotePython202", 1, RH.position, 3000);
				system.addShips("coyotePython203", 1, RH.position, 3000);
				this.lobo = system.addShips("coyotelobo4", 1)[0];
				this.zorra = system.addShips("coyotezorra4", 1)[0];
				this.massedLocked = false;
				this.trackId = addFrameCallback(this.loboAndZorra.bind(this));
			}
			else if (missionVariables.Coyote_status == "STAGE_210") {
				var RH = system.addShips("coyotekatikrockhermit", 1, Vector3D(0, 0, 4).fromCoordinateSystem("sws"))[0];
				var targetVector = system.sun.position.subtract(RH.position).direction();
				var angle = RH.heading.angleTo(targetVector);
				var cross = RH.heading.cross(targetVector).direction();
				RH.orientation = RH.orientation.rotate(cross, -angle);
				system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
				system.addShips("coyotelobo5", 1, RH.position, 3000);
				system.addShips("coyotezorra5", 1, RH.position, 3000);
			}
			else if (missionVariables.Coyote_status == "STAGE_220") {
				var RH = system.addShips("coyotekatikrockhermit", 1, Vector3D(0, 0, 4).fromCoordinateSystem("sws"))[0];
				var targetVector = system.sun.position.subtract(RH.position).direction();
				var angle = RH.heading.angleTo(targetVector);
				var cross = RH.heading.cross(targetVector).direction();
				RH.orientation = RH.orientation.rotate(cross, -angle);
				system.addShips("coyotekatikasteroid", 10, RH.position, 12000);
				system.addShips("coyotelobo5", 1, RH.position, 3000);
				system.addShips("coyotezorra5", 1, RH.position, 3000);
			}*/
			if (missionVariables.Coyote_status == "STAGE_200") {
				this.zorra.commsMessage(expandDescription("[COYOTE_S200_00]"), player.ship);
			}
		}
		// Cecear
		if (missionVariables.Coyote_status == "STAGE_225" && system.ID == 126) {
			var shArr = system.allShips;
			var j = shArr.length - 1;
			while (j > 0) {
				if (!shArr[j].isMainStation) {
					if (!shArr[j].isBeacon) {
						if (shArr[j].position.distanceTo(player.ship.position) < 100000) {
							shArr[j].remove(true);
						}
					}
				}
				j -= 1;
			}
			system.addShips("coyotekatikboss2", 1, player.ship.position.add(player.ship.vectorForward.multiply(-5000)), 300);
			system.addShips("coyotekatikboss2escort", 1, player.ship.position.add(player.ship.vectorForward.multiply(-5000)), 300);
			system.addShips("coyotekatikboss3escort", 1, player.ship.position.add(player.ship.vectorForward.multiply(-5000)), 300);
			mission.setInstructionsKey("CE_MI_S_225_01", "Coyote-Main");
		}
		// Teesbi
		if (missionVariables.Coyote_status == "STAGE_330" && system.ID == 84) {
			mission.unmarkSystem(66);
			mission.markSystem(84);
		}
		// Zaenza
		if (missionVariables.Coyote_status == "STAGE_110" && system.ID == 55) {
			this.ComTimer = new Timer(this, this.ComTimerCB, 5);
		}
		// steel halo: Zaenza, Lazaso, Xemageat, Leteisan, Cecear, Tiuson
		if (missionVariables.Coyote_status == "STAGE_160" && (system.ID == 55 || system.ID == 128 || system.ID == 72 || system.ID == 185 || system.ID == 126 || system.ID == 100)) {
			var MessageText = "";
			if (missionVariables.Coyote_KatikHunt <= 7) {
				if (missionVariables.Coyote_jumpCount >= 3) {
					missionVariables.Coyote_jumpCount = Math.floor(Math.random() * 2) + 1;
					var SType = Math.floor(Math.random() * 2);
					MessageText = expandDescription("[COYOTE_S160_02]");
					var RType = "";
					if (SType == 0) {
						RType = "coyoteAnaconda160";
						MessageText = MessageText.replace("$$$", "Anaconda");
					} else {
						RType = "coyotePython160";
						MessageText = MessageText.replace("$$$", "Python");
					}
					var DType = Math.floor(Math.random() * 4)
					if (DType == 0) {
						system.addShipsToRoute(RType, 1, 0.25, "wp");
						MessageText = MessageText + expandDescription("[COYOTE_S160_03]");
					} else if (DType == 1) {
						system.addShipsToRoute(RType, 1, 0.50, "wp");
						MessageText = MessageText + expandDescription("[COYOTE_S160_04]");
					} else {
						system.addShipsToRoute(RType, 1, 0.75, "wp");
						MessageText = MessageText + expandDescription("[COYOTE_S160_05]");
					}
				} else {
					MessageText = expandDescription("[COYOTE_S160_06]");
				}
			} else {
				MessageText = expandDescription("[COYOTE_S160_01]");
			}
			this.agentshp.commsMessage(MessageText, player.ship);
		}
	}
}

this.playerStartedJumpCountdown = function (type) {
	if (galaxyNumber == 4) {
		this.massblocked = false;
		if (missionVariables.Coyote_status == "STAGE_280" && system.ID == 40 && player.ship.targetSystem !== 242) {
			this.massblocker = system.addShips("coyotemassblocker", 1, player.ship.position.add(player.ship.vectorForward.multiply(-50)))[0];
			this.massblocked = true;
			this.masstrackId = addFrameCallback(this.moveMass.bind(this));

		}
		if (missionVariables.Coyote_status == "STAGE_310" && system.ID == 58) {
			if (system.countShipsWithRole("coyotevipermember1") !== 4) {
				this.massblocker = system.addShips("coyotemassblocker", 1, player.ship.position.add(player.ship.vectorForward.multiply(-50)))[0];
				this.massblocked = true;
				this.masstrackId = addFrameCallback(this.moveMass.bind(this));
			}
		}
	}
}

this.playerCancelledJumpCountdown = function () {
	if (isValidFrameCallback(this.masstrackId)) {
		removeFrameCallback(this.masstrackId);
		this.massblocker.position = player.ship.position.add(player.ship.vectorForward.multiply(-1000000));
		this.massblocked = false;
	}
}

this.playerJumpFailed = function (reason) {
	if (this.massblocked) {
		if (isValidFrameCallback(this.masstrackId)) {
			removeFrameCallback(this.masstrackId);
		}
		if (missionVariables.Coyote_status == "STAGE_280" && system.ID == 40 && player.ship.targetSystem !== 242) {
			this.massblocker.position = player.ship.position.add(player.ship.vectorForward.multiply(-1000000));
			player.consoleMessage(expandDescription("[COYOTE_S280_00]"), 6);
			player.consoleMessage(expandDescription("[COYOTE_S280_01]"), 6);
			this.massblocked = false;
		}
		if (missionVariables.Coyote_status == "STAGE_310" && system.ID == 58) {
			this.massblocker.position = player.ship.position.add(player.ship.vectorForward.multiply(-1000000));
			player.consoleMessage(expandDescription("[COYOTE_S280_00]"), 6);
			player.consoleMessage(expandDescription("[COYOTE_S300_01]"), 6);
			this.massblocked = false;
		}
	}
}

this.missionScreenOpportunity = function () {
	if (galaxyNumber !== 4) {
		return;
	}
	if (!missionVariables.Coyote_status) {
		return;
	}
	if (missionVariables.Coyote_status == "COMPLETED") {
		return;
	}
	this.missionScreens();
}

this.missionScreens = function () {
	// Zaquesso navy station
	if (missionVariables.Coyote_status == "STAGE_20" && system.ID == 25 && player.ship.dockedStation.primaryRole == "CoyoteNavystation1") {
		missionVariables.Coyote_status = "STAGE_30";
		mission.setInstructionsKey("CE_MI_S_30_01");
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Zaquesso_navystation_1"
		});
	}
	// Zaquesso main station	
	else if (missionVariables.Coyote_status == "STAGE_30" && system.ID == 25 && player.ship.dockedStation.isMainStation) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Zaquesso_mainstation_1",
			choicesKey: "Coyote_Zaquesso_mainstation_1_choices"
		}, this.choices);
	}
	// Bizaar
	else if (missionVariables.Coyote_status == "STAGE_40" && system.ID == 101 && player.ship.dockedStation.isMainStation) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Bizaar_mainstation_1",
			choicesKey: "Coyote_Bizaar_mainstation_1_choices"
		}, this.choices);
	}
	// Bizalein navy station
	else if (missionVariables.Coyote_status == "STAGE_60" && system.ID == 89 && player.ship.dockedStation.primaryRole == "CoyoteNavystation2") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Bizalein_mainstation_1",
			choicesKey: "Coyote_Bizalein_mainstation_1_choices"
		}, this.choices);
	}
	// Ergeso Rock Hermit
	else if (missionVariables.Coyote_status == "STAGE_70" && system.ID == 87 && player.ship.dockedStation.primaryRole == "coyoterockhermit") {
		missionVariables.Coyote_status = "STAGE_80";
		mission.setInstructionsKey("CE_MI_S_80_01");
		mission.unmarkSystem(87);
		mission.markSystem(89);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Ergeso_rockhermit"
		});
	}
	// Bizalein
	else if (missionVariables.Coyote_status == "STAGE_80" && system.ID == 89 && player.ship.dockedStation.isMainStation) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Bizalein_mainstation_3",
			choicesKey: "Coyote_Bizalein_mainstation_3_choices"
		}, this.choices);
	}
	// Ortema
	else if (missionVariables.Coyote_status == "STAGE_90" && system.ID == 109 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_100";
		mission.setInstructionsKey("CE_MI_S_100_01");
		mission.unmarkSystem(109);
		mission.markSystem(128);
		clock.addSeconds(24 * 3600);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Ortema_mainstation"
		});
	}
	// Avernus
	else if (missionVariables.Coyote_status == "STAGE_100" && system.isInterstellarSpace && (player.ship.dockedStation.primaryRole == "Coyoteinterstellarstation" || player.ship.dockedStation.primaryRole == "Coyoteinterstellarstationgg")) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Avernus_1",
			choicesKey: "Coyote_Avernus_1_choices"
		}, this.choices);
	}
	// A station in Halo
	else if (missionVariables.Coyote_status == "STAGE_150" && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_160";
		mission.setInstructionsKey("CE_MI_S_160_01");
		missionVariables.Coyote_jumpCount = Math.floor(Math.random() * 2) + 1;
		missionVariables.Coyote_KatikHunt = 0;
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Stage_150",
			model: "coyoteAnaconda160"
		});
	}
	// A station in Halo
	else if (missionVariables.Coyote_status == "STAGE_160" && system.ID !== 100 && player.ship.dockedStation.isMainStation && missionVariables.Coyote_KatikHunt >= 7) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Stage_160_1",
			choicesKey: "Coyote_Stage_160_1_choices"
		}, this.choices);
	}
	// Tiuson
	else if (missionVariables.Coyote_status == "STAGE_170" && system.ID == 100 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_180";
		mission.setInstructionsKey("CE_MI_S_180_01");
		mission.unmarkSystem(100);
		mission.markSystem(109);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Stage_Tiuson_1",
			model: "coyotePython200"
		});
	}
	// Tiuson
	else if (missionVariables.Coyote_status == "STAGE_190" && system.ID == 100 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_200";
		mission.setInstructionsKey("CE_MI_S_200_01");
		mission.unmarkSystem(100);
		mission.markSystem(185);
		if (worldScripts["Coyote-Griff"]) {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_Tiuson_2",
				model: "coyotetriogriff",
				spinModel: false
			});
		} else {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_Tiuson_2",
				model: "coyotetrio",
				spinModel: false
			});
		}
	}
	// Avernus
	else if (missionVariables.Coyote_status == "STAGE_210" && system.isInterstellarSpace && (player.ship.dockedStation.primaryRole == "Coyoteinterstellarstation" || player.ship.dockedStation.primaryRole == "Coyoteinterstellarstationgg")) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Avernus_3",
			choicesKey: "Coyote_Avernus_3_choices"
		}, this.choices);
	}
	// Cecear
	//else if(missionVariables.Coyote_status == "STAGE_229" && system.ID == 126 && player.ship.dockedStation.isMainStation)
	//{
	//	missionVariables.Coyote_status = "STAGE_230";
	//	mission.setInstructionsKey("CE_MI_S_230_01");
	//	mission.runScreen({title: "Coyote's Run", messageKey: "Coyote_Cecear_mainstation"});
	//}
	// Leteisan
	else if (missionVariables.Coyote_status == "STAGE_229" && system.ID == 185 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_240";
		mission.setInstructionsKey("CE_MI_S_240_01");
		mission.unmarkSystem(185);
		mission.markSystem(89);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Leteisan_mainstation",
			model: "coyotesahana2"
		});
	}
	// Bizalein Navy Station
	else if (missionVariables.Coyote_status == "STAGE_240" && system.ID == 89 && player.ship.dockedStation.primaryRole == "CoyoteNavystation2") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Bizalein_navystation",
			choicesKey: "Coyote_Bizalein_navystation_choices"
		}, this.choices);
	}
	// Qulecele
	else if (missionVariables.Coyote_status == "STAGE_250" && system.ID == 152 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_260";
		mission.setInstructionsKey("CE_MI_S_260_01");
		mission.unmarkSystem(152);
		mission.markSystem(65);
		clock.addSeconds(24 * 3600);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Qulecele"
		});
	}
	// Xele
	else if (missionVariables.Coyote_status == "STAGE_260" && system.ID == 65 && player.ship.dockedStation.isMainStation) {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Xele",
			choicesKey: "Coyote_Xele_choices"
		}, this.choices);
	}
	// Tirizaan
	else if (missionVariables.Coyote_status == "STAGE_270" && system.ID == 40 && player.ship.dockedStation.primaryRole == "CoyoteNavystation1") {
		missionVariables.Coyote_status = "STAGE_280";
		mission.setInstructionsKey("CE_MI_S_280_01");
		mission.unmarkSystem(40);
		mission.markSystem(49);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Tirizaan_navystation",
			choicesKey: "Coyote_Tirizaan_navystation_choices"
		}, this.choices);
	}
	// Atbiarxe
	else if (missionVariables.Coyote_status == "STAGE_290" && system.ID == 49 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_300";
		mission.setInstructionsKey("CE_MI_S_300_01");
		mission.unmarkSystem(49);
		mission.markSystem(58);
		clock.addSeconds(48 * 3600);
		//		if(player.credits > 210000)
		//		{
		//			player.credits -= 200000;
		//			missionVariables.Coyote_prePayment = 200000;
		//		}
		//		else
		//		{
		//			missionVariablesCoyote_prePayment = player.credits -10000;
		//			player.credits = 10000;
		//		}
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Atbiarxe"
		});
	}
	// Biceri
	else if (missionVariables.Coyote_status == "STAGE_300" && system.ID == 58 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_ViperCount = 0;
		missionVariables.Coyote_status = "STAGE_310";
		mission.setInstructionsKey("CE_MI_S_310_01");
		mission.unmarkSystem(58);
		mission.markSystem(66);
		clock.addSeconds(4 * 3600);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Biceri"
		});
	}
	// Anbedi
	else if (missionVariables.Coyote_status == "STAGE_340" && system.ID == 20 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_350";
		mission.setInstructionsKey("CE_MI_S_350_01");
		mission.unmarkSystem(20);
		mission.markSystem(39);
		clock.addSeconds(24 * 3600);
		if (worldScripts["Coyote-Griff"]) {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Anbedi",
				model: "coyotetriogriff"
			});
		} else {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Anbedi",
				model: "coyotetrio"
			});
		}
	}
	// Zaeredre navy station
	else if (missionVariables.Coyote_status == "STAGE_350" && system.ID == 39 && player.ship.dockedStation.primaryRole == "CoyoteNavystation2") {
		missionVariables.Coyote_status = "STAGE_360";
		mission.setInstructionsKey("CE_MI_S_360_03");
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Zaeredre_navystation"
		});
	}
	// Zaeredre main station
	else if (missionVariables.Coyote_status == "STAGE_360" && system.ID == 39 && player.ship.dockedStation.isMainStation) {
		missionVariables.Coyote_status = "STAGE_370";
		mission.setInstructionsKey("CE_MI_S_370_01");
		mission.unmarkSystem(39);
		mission.markSystem(124);
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Zaeredre"
		});
	}
	// Inmaarxe navy station
	else if (missionVariables.Coyote_status == "STAGE_370" && system.ID == 124 && player.ship.dockedStation.primaryRole == "CoyoteNavystation1") {
		missionVariables.Coyote_status = null;
		mission.setInstructions(null);
		player.credits += 200000;
		mission.unmarkSystem(124);
		missionVariables.CoyoteFerdie_status = null;
		missionVariables.CoyotePhythonPilot = null;
		missionVariables.Coyote_BattleAtBiarra = null;
		missionVariables.Coyote_KatikHunt = null;
		missionVariables.Coyote_ViperCount = null;
		missionVariables.Coyote_jumpCount = null;
		missionVariables.coyote_escapePodKilled = null;
		if (!missionVariables.CoyoteCompletionCount) {
			missionVariables.CoyoteCompletionCount = 1;
		} else {
			missionVariables.CoyoteCompletionCount += 1;
		}
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_Inmaarxe_navystation"
		});
	}
}

this.choices = function (choice) {
	switch (choice) {
		case "1_Cont": {
			mission.setInstructionsKey("CE_MI_S_40_01");
			missionVariables.Coyote_status = "STAGE_40";
			var Boo = player.ship.awardContract(1000, "Platinum", 25, 101, clock.seconds + 18 * 24 * 3600, 50000);
			mission.unmarkSystem(25);
			clock.addSeconds(48 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Zaquesso_mainstation_2"
			});
			break;
		}
		case "2_Cont": {
			missionVariables.Coyote_status = "STAGE_50";
			mission.setInstructionsKey("CE_MI_S_50_01");
			mission.markSystem(89);
			clock.addSeconds(24 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizaar_mainstation_2"
			});
			break;
		}
		case "3_Cont": {
			missionVariables.Coyote_status = "STAGE_70";
			mission.setInstructionsKey("CE_MI_S_70_01");
			mission.unmarkSystem(89);
			mission.markSystem(87);
			clock.addSeconds(1 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_mainstation_2"
			});
			break;
		}
		case "4_Cont": {
			missionVariables.Coyote_status = "STAGE_90";
			mission.setInstructionsKey("CE_MI_S_90_01");
			mission.unmarkSystem(89);
			mission.markSystem(109);
			clock.addSeconds(120 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_mainstation_4"
			});
			break;
		}
		case "5_Cont": {
			missionVariables.Coyote_status = "STAGE_110";
			mission.setInstructionsKey("CE_MI_S_110_01");
			mission.unmarkSystem(128);
			mission.markSystem(55);
			clock.addSeconds(120 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Avernus_2",
				model: "Coyoteinterstellarstation"
			});
			break;
		}
		case "6_Cont": {
			missionVariables.Coyote_status = "STAGE_170";
			mission.setInstructionsKey("CE_MI_S_170_01");
			mission.markSystem(100);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_160_2"
			});
			break;
		}
		case "7_Cont": {
			missionVariables.Coyote_status = "STAGE_220";
			mission.setInstructionsKey("CE_MI_S_220_01");
			//EquipmentInfo.infoForKey("EQ_AVERNUS_TRACTOR_BEAM").effectiveTechLevel = 14;
			mission.unmarkSystem(128);
			clock.addSeconds(24 * 3600);
			mission.markSystem(185);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Avernus_4"
			});
			break;
		}
		case "8_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_navystation_2",
				choicesKey: "Coyote_Bizalein_navystation_choices_2"
			}, this.choices);
			break;
		}
		case "9_Cont": {
			missionVariables.Coyote_status = "STAGE_250";
			mission.setInstructionsKey("CE_MI_S_250_01");
			mission.unmarkSystem(89);
			mission.markSystem(152);
			clock.addSeconds(120 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_navystation_3"
			});
			break;
		}
		case "10_Cont": {
			missionVariables.Coyote_status = "STAGE_270";
			mission.setInstructionsKey("CE_MI_S_270_01");
			mission.unmarkSystem(65);
			mission.markSystem(40);
			clock.addSeconds(24 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Xele_2"
			});
			break;
		}
		case "11_Cont": {
			clock.addSeconds(12 * 3600);
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Tirizaan_navystation_2"
			});
			break;
		}
		case "XX1_Cont": {
			mission.runScreen({
				title: "L\'Auberge de Lago",
				overlay: {
					name: "menu3.png",
					height: 546
					//width: 1024,
					//height: 512
				}
			});
			break;
		}
		case "100_Cont": {
			break;
		}
		case "101_Previous_Screens": {
			this.displayPreviousScreens();
			break;
		}
	}
}

this.displayPreviousScreens = function () {
	this.longScreen = false;
	if (missionVariables.Coyote_status == "STAGE_30") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_1"
		}, this.previousScreenChoices);

	} else if (missionVariables.Coyote_status == "STAGE_40") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_2"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_50") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_3"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_60") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_3"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_70") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_4"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_80") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_5"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_90") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_6"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_100") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_7"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_110") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_8"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_160") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_9"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_170") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_10"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_180") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_11"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_200") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_12"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_220") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_13"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_240") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_14"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_250") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_15"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_260") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_16"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_270") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_17"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_280") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_18"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_300") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_19"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_310") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_20"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_350") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_21"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_360") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_22"
		}, this.previousScreenChoices);
	} else if (missionVariables.Coyote_status == "STAGE_370") {
		mission.runScreen({
			title: "Coyote's Run",
			messageKey: "Coyote_All_Mission_Screens",
			choicesKey: "Coyote_All_Mission_Screens_23"
		}, this.previousScreenChoices);
	} else {
		mission.runScreen({
			title: "Coyote's Run",
			message: "No mission information currently available."
		});
	}
	return;
}

this.previousScreenChoices = function (choice) {
	switch (choice) {
		case "98_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Zaquesso_navystation_1",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "97_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Zaquesso_mainstation_1",
				choicesKey: "Coyote_Zaquesso_mainstation_1_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "96_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizaar_mainstation_1",
				choicesKey: "Coyote_Bizaar_mainstation_1_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "95_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_mainstation_1",
				choicesKey: "Coyote_Bizalein_mainstation_1_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "94_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Ergeso_rockhermit",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "93_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_mainstation_3",
				choicesKey: "Coyote_Bizalein_mainstation_3_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "92_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Ortema_mainstation",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "91_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Avernus_1",
				choicesKey: "Coyote_Avernus_1_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "90_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_150",
				choicesKey: "Coyote_All_Mission_Screens_prompt",
				model: "coyoteAnaconda160"
			}, this.previousScreenChoices);
			break;
		}
		case "89_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_160_1",
				choicesKey: "Coyote_Stage_160_1_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "88_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_Tiuson_1",
				choicesKey: "Coyote_All_Mission_Screens_prompt",
				model: "coyotePython200"
			}, this.previousScreenChoices);
			break;
		}
		case "87_MS": {
			if (worldScripts["Coyote-Griff"]) {
				mission.runScreen({
					title: "Coyote's Run",
					messageKey: "Coyote_Stage_Tiuson_2",
					choicesKey: "Coyote_All_Mission_Screens_prompt",
					model: "coyotetriogriff",
					spinModel: false
				}, this.previousScreenChoices);
			} else {
				mission.runScreen({
					title: "Coyote's Run",
					messageKey: "Coyote_Stage_Tiuson_2",
					choicesKey: "Coyote_All_Mission_Screens_prompt",
					model: "coyotetrio",
					spinModel: false
				}, this.previousScreenChoices);
			}
			break;
		}
		case "86_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Avernus_3",
				choicesKey: "Coyote_Avernus_3_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "85_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Leteisan_mainstation",
				model: "coyotesahana2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "84_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_navystation",
				choicesKey: "Coyote_Bizalein_navystation_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "83_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Qulecele",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "82_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Xele",
				choicesKey: "Coyote_Xele_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "81_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Tirizaan_navystation",
				choicesKey: "Coyote_Tirizaan_navystation_choices"
			}, this.previousScreenChoices);
			break;
		}
		case "80_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Atbiarxe",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "79_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Biceri",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "78_MS": {
			if (worldScripts["Coyote-Griff"]) {
				mission.runScreen({
					title: "Coyote's Run",
					messageKey: "Coyote_Anbedi",
					choicesKey: "Coyote_All_Mission_Screens_prompt",
					model: "coyotetriogriff"
				}, this.previousScreenChoices);
			} else {
				mission.runScreen({
					title: "Coyote's Run",
					messageKey: "Coyote_Anbedi",
					choicesKey: "Coyote_All_Mission_Screens_prompt",
					model: "coyotetrio"
				}, this.previousScreenChoices);
			}
			break;
		}
		case "77_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Zaeredre_navystation",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "76_MS": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Zaeredre",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}

		case "99_BPrev": {
			this.longScreen = true;
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_All_Mission_Screens",
				choicesKey: "Coyote_All_Mission_Screens_14a"
			}, this.previousScreenChoices);
			break;
		}

		case "98_return": {
			if (!this.longScreen) {
				this.displayPreviousScreens();
			} else {
				mission.runScreen({
					title: "Coyote's Run",
					messageKey: "Coyote_All_Mission_Screens",
					choicesKey: "Coyote_All_Mission_Screens_14a"
				}, this.previousScreenChoices);
			}
			break;
		}
		case "99_APrev": {
			this.displayPreviousScreens();
			break;
		}
		case "1_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Zaquesso_mainstation_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "2_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizaar_mainstation_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "3_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_mainstation_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "4_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_mainstation_4",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "5_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Avernus_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt",
				model: "Coyoteinterstellarstation"
			}, this.previousScreenChoices);
			break;
		}
		case "6_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Stage_160_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "7_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Avernus_4",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "8_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_navystation_2",
				choicesKey: "Coyote_Bizalein_navystation_choices_2"
			}, this.previousScreenChoices);
			break;
		}
		case "9_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Bizalein_navystation_3",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "10_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Xele_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
		case "11_Cont": {
			mission.runScreen({
				title: "Coyote's Run",
				messageKey: "Coyote_Tirizaan_navystation_2",
				choicesKey: "Coyote_All_Mission_Screens_prompt"
			}, this.previousScreenChoices);
			break;
		}
	}
}

this.MST = function () {
	this.MST_Count += 1;
	if (this.MST_Count == 1) {
		//player.consoleMessage("\n\n\n\n\n\n\n\n\n\n\n", 10);
		player.consoleMessage(expandDescription("[COYOTE_START1]"), 10);
		//player.consoleMessage("\n", 10)
	} else if (this.MST_Count == 2) {
		//player.consoleMessage("\n\n\n\n\n\n\n\n\n\n\n", 10);
		//player.consoleMessage(expandDescription("[COYOTE_START1]"), 10);
		player.consoleMessage(expandDescription("[COYOTE_START2]"), 10);
		//player.consoleMessage("\n", 10)
		player.ship.fuel = 7.0;
	} else if (this.MST_Count == 3) {
		//player.consoleMessage("\n\n\n\n\n\n\n\n\n\n\n", 10);
		//player.consoleMessage(expandDescription("[COYOTE_START1]"), 10);
		//player.consoleMessage(expandDescription("[COYOTE_START2]"), 10);
		player.consoleMessage(expandDescription("[COYOTE_START2a]"), 10);
		//player.consoleMessage("\n", 10)
	} else if (this.MST_Count == 4) {
		//player.consoleMessage("\n\n\n\n\n\n\n\n\n\n\n", 10);
		//player.consoleMessage(expandDescription("[COYOTE_START1]"), 10);
		//player.consoleMessage(expandDescription("[COYOTE_START2]"), 10);
		//player.consoleMessage(expandDescription("[COYOTE_START2a]"), 10);
		player.consoleMessage(expandDescription("[COYOTE_START3]"), 10);
		//player.consoleMessage("\n", 10)
	} else {
		if (player.ship.isCloaked) {
			var pos = player.ship.position.add(player.ship.vectorForward.multiply(25600));
			system.addShips("coyotepythonstart", 1, pos, 100);
			//player.consoleMessage("\n\n\n\n\n\n\n\n\n\n\n", 10);
			player.commsMessage(expandDescription("[COYOTE_START4]"), 10);
			this.MissionStartTimer.stop();
		}
	}
}

this.setMissionInstructions = function (message) {
	mission.setInstructionsKey(message, "Coyote-Main");
}

this.ComTimerCB = function () {
	var witchBuoy = system.shipsWithPrimaryRole("buoy-witchpoint")[0];
	witchBuoy.commsMessage(expandDescription("[COYOTE_S110_01]"), player.ship);
	missionVariables.Coyote_status = "STAGE_120";
	mission.unmarkSystem(55);
	mission.markSystem(128);
	mission.setInstructionsKey("CE_MI_S_120_01");
}

this.Stage160 = function () {
	this.agentshp = system.addShips("coyotelabrujaagent", 1, player.ship.position.add(player.ship.vectorForward.multiply(-6000)))[0];
}

this.Stage180 = function () {
	this.S180TimerCount += 1;
	if (this.S180TimerCount == 5) {
		this.S180Timer.stop();
	}
	if (this.S180TimerCount < 6) {
		system.addShips("coyotePython180", 1, player.ship.position.add(player.ship.vectorForward.multiply(6000)));
	}
}

this.loboAndZorra = function () {
	this.lobo.position = player.ship.position.add(player.ship.vectorForward.multiply(-50)).add(player.ship.vectorRight.multiply(200));
	this.lobo.orientation = player.ship.orientation;
	this.zorra.position = player.ship.position.add(player.ship.vectorForward.multiply(-50)).add(player.ship.vectorRight.multiply(-200));
	this.zorra.orientation = player.ship.orientation;
	if (player.alertMassLocked) {
		this.shArray = system.shipsWithPrimaryRole("coyotekatikrockhermit");
		if (this.shArray.length > 0) {
			if (this.shArray[0].position.distanceTo(player.ship.position) < 25600) {
				this.massLocked = true;
			}
		}
	}
	if (this.massLocked) {
		this.shArray = system.shipsWithPrimaryRole("coyotekatikrockhermit");
		if (this.shArray.length > 0) {
			if (this.shArray[0].position.distanceTo(player.ship.position) < 12000) {
				this.massLocked = true;
				this.zorra.reactToAIMessage("HOSTILES_NEAR");
				this.lobo.reactToAIMessage("HOSTILES_NEAR");

				if (isValidFrameCallback(this.trackId)) {
					removeFrameCallback(this.trackId);
				}
			}
		}
	}
}

this.tractorBeam = function () {
	this.tractorDistance = player.ship.target.position.distanceTo(player.ship.position);
	missionVariables.coyote_beam = "WORKING";
	this.TRCount = 0;
	this.TRtrackId = addFrameCallback(this.tractorCallBack.bind(this));
}

this.dtractorBeam = function () {
	missionVariables.coyote_beam = null;
	if (isValidFrameCallback(this.TRtrackId)) {
		removeFrameCallback(this.TRtrackId);
	}
}

this.tractorCallBack = function (delta) {
	if (!player.ship.target) {
		if (isValidFrameCallback(this.TRtrackId)) {
			removeFrameCallback(this.TRtrackId);
		}
	} else {
		if (delta !== 0) {
			this.TRCount += 1;
			if (this.TRCount >= 4) {

				player.ship.energy -= 1;
				this.TRCount = 0;
			}
		}
		player.ship.target.position = player.ship.position.add(player.ship.vectorForward.multiply(-1 * this.tractorDistance));
	}
}

this.moveMass = function () {
	this.massblocker.position = player.ship.position.add(player.ship.vectorForward.multiply(-50));
}

this.BiarraBattle = function () {
	if (system.ID == 66) {
		system.addShips("coyoteinterceptor1", 1, player.ship.position.add(player.ship.vectorForward.multiply(-6000)));
		system.addShips("coyoterogueviper1", 2, player.ship.position.add(player.ship.vectorForward.multiply(-6000)));
		system.addShips("coyoterogueviper2", 2, player.ship.position.add(player.ship.vectorForward.multiply(-6000)));
	}
}

this.cam = function (cam1) {
	this.camCount = 0;
	this.cam1 = cam1;
	if (!isValidFrameCallback(this.CamAndGreerTrackId)) {
		this.CamAndGreerTrackId = addFrameCallback(this.CamAndGreer.bind(this));
		this.checkDistanceFirstTime = true;
		this.massLocked = false;
		this.informTimer = new Timer(this, this.checkDistance, 5, 5);
	}
}

this.checkDistance = function () {
	if (this.checkDistanceFirstTime && this.greerCount == 150 && this.camCount == 150) {
		this.checkDistanceFirstTime = false;
		mission.setInstructionsKey("CE_MI_S_310_02", this.name);
		if (system.ID == 66) {
			this.greer1.commsMessage(expandDescription("[COYOTE_S310_04]"), player.ship);
			mission.setInstructionsKey("CE_MI_S_310_02", this.name);
			missionVariables.Coyote_status = "STAGE_320"
		}
		if (system.ID == 84) {
			this.greer1.commsMessage(expandDescription("[COYOTE_S310_05]"), player.ship);
			mission.setInstructionsKey("CE_MI_S_310_05", this.name);
			missionVariables.Coyote_status = "STAGE_335"
		}
	}
	var S = system.sun;
	if (system.ID == 66) {
		if (player.ship.position.distanceTo(S.position) < 300000) {
			this.informTimer.stop();
			system.addShips("coyotebandit1", 4, player.ship.position.add(player.ship.vectorForward.multiply(25000)));
			this.massLock = "coyotebandit1";
			this.massLocked = true;
			this.greer1.commsMessage(expandDescription("[COYOTE_S310_06]"), player.ship);
			this.informTimer.stop();
		}
	}
	if (system.ID == 84) {
		if (player.ship.position.distanceTo(S.position) < 600000) {
			this.informTimer.stop();
			system.addShips("coyotebandit2", 4, player.ship.position.add(player.ship.vectorForward.multiply(25000)));
			this.massLock = "coyotebandit2";
			this.massLocked = true;
			this.greer1.commsMessage(expandDescription("[COYOTE_S310_07]"), player.ship);
			mission.setInstructionsKey("CE_MI_S_310_06", "Coyote-Main");
			this.informTimer.stop();
		}
	}
}

this.greer = function (greer1) {
	this.greerCount = 0;
	this.greer1 = greer1;
	if (!isValidFrameCallback(this.CamAndGreerTrackId)) {
		this.CamAndGreerTrackId = addFrameCallback(this.CamAndGreer.bind(this));
		this.checkDistanceFirstTime = true;
		this.massLocked = false;
		this.informTimer = new Timer(this, this.checkDistance, 5, 5);
	}
}

this.CamAndGreer = function () {
	//rVector=new Vector3D;
	//rVector.x=Math.random()*2;
	//rVector.y=Math.random()*2;
	//rVector.z=Math.random()*2;
	var pos = 0;
	if (!this.cam1) {} else {
		pos = -50;
		if (this.camCount < 150) {
			this.camCount += 1;
			pos = -200 + this.camCount;
		}
		//this.cam1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(-200)).add(rVector);
		this.cam1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(-200));
		this.cam1.orientation = player.ship.orientation;
	}
	if (!this.greer1) {} else {
		pos = -50;
		if (this.greerCount < 150) {
			this.greerCount += 1;
			pos = -200 + this.greerCount;
		}
		//this.greer1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(200)).add(rVector);
		this.greer1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(200));
		this.greer1.orientation = player.ship.orientation;
	}
	if (this.massLocked) {
		this.shArray = system.shipsWithRole(this.massLock);
		if (this.shArray.length > 0) {
			if (this.shArray[0].position.distanceTo(player.ship.position) < 12000) {
				this.massLocked = true;
				this.cam1.reactToAIMessage("HOSTILES_NEAR");
				this.greer1.reactToAIMessage("HOSTILES_NEAR");
				this.greerCount = 0;
				this.camCount = 0;
				this.cam1 = null;
				this.greer1 = null;
				if (isValidFrameCallback(this.CamAndGreerTrackId)) {
					removeFrameCallback(this.CamAndGreerTrackId);
				}
			}
		}
	}
}

this.camT1 = function (cam1) {
	this.camCount = 0;
	this.cam1 = cam1;
	if (!isValidFrameCallback(this.CamAndGreerT1TrackId)) {
		this.greer1 = null;
		this.checkDistanceFirstTime = true;
		this.hyperSpaceTimer = new Timer(this, this.hyperSpace, 5, 1);
		this.CamAndGreerT1TrackId = addFrameCallback(this.CamAndGreerT1.bind(this));
	}
}

this.greerT1 = function (greer1) {
	this.greerCount = 0;
	this.greer1 = greer1;
	if (!isValidFrameCallback(this.CamAndGreerT1TrackId)) {
		this.cam1 = null;
		this.checkDistanceFirstTime = true;
		this.hyperSpaceTimer = new Timer(this, this.hyperSpace, 5, 1);
		this.CamAndGreerT1TrackId = addFrameCallback(this.CamAndGreerT1.bind(this));
	}
}

this.CamAndGreerT1 = function () {
	//rVector=new Vector3D;
	//rVector.x=Math.random()*2;
	//rVector.y=Math.random()*2;
	//rVector.z=Math.random()*2;
	var pos = 0;
	if (!this.cam1) {} else {
		pos = -50;
		if (this.camCount < 150) {
			this.camCount += 1;
			pos = -200 + this.camCount;
		}
		//this.cam1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(-200)).add(rVector);
		this.cam1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(-200));
		this.cam1.orientation = player.ship.orientation;
	}
	if (!this.greer1) {} else {
		pos = -50;
		if (this.greerCount < 150) {
			this.greerCount += 1;
			pos = -200 + this.greerCount;
		}
		//this.greer1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(200)).add(rVector);
		this.greer1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(200));
		this.greer1.orientation = player.ship.orientation;
	}
	if (this.massLocked) {
		this.shArray = system.shipsWithRole(this.massLock);
		if (this.shArray.length > 0) {
			if (this.shArray[0].position.distanceTo(player.ship.position) < 12000) {
				this.massLocked = true;
				this.cam1.reactToAIMessage("HOSTILES_NEAR");
				this.greer1.reactToAIMessage("HOSTILES_NEAR");

				if (isValidFrameCallback(this.CamAndGreerTrackId)) {
					removeFrameCallback(this.CamAndGreerTrackId);
				}
			}
		}
	}
}

this.hyperSpace = function () {
	if (this.checkDistanceFirstTime && this.greerCount == 150 && this.camCount == 150) {
		this.checkDistanceFirstTime = false;
		if (system.ID == 84) {
			this.cam1.commsMessage(expandDescription("[COYOTE_S310_08]"), player.ship);
		}
		if (system.ID == 20) {
			this.cam1.commsMessage(expandDescription("[COYOTE_S310_09]"), player.ship);
		}
		this.hyperSpaceTimer.stop();
		this.jumpCount = 0;
		this.jumpTimer = new Timer(this, this.jump, 1, 1);
	}
}

this.jump = function () {
	if (this.jumpCount <= 14) {
		this.cam1.commsMessage("\n\n\n\n\n\n\n\n\n\ Jumping in " + (15 - this.jumpCount) + " secs.", player.ship);
		this.jumpCount += 1;
	} else {
		this.jumpTimer.stop();
		if (isValidFrameCallback(this.CamAndGreerT1TrackId)) {
			removeFrameCallback(this.CamAndGreerT1TrackId);
		}
		var pos = this.cam1.position;
		this.cam1.fuel = 7.0;
		if (system.ID == 20) {
			while (!this.cam1.exitSystem(39)) {}
		} else {
			while (!this.cam1.exitSystem(20)) {}
			missionVariables.Coyote_status = "STAGE_335"
		}
		player.ship.position = pos;
	}
}

this.releaseUS = function () {
	log(this.name, "Release Us");
	if (isValidFrameCallback(this.trackId)) {
		removeFrameCallback(this.trackId);
	}
	this.lobo.commsMessage(expandDescription("[COYOTE_S310_10]"), player.ship);
}

this.camT2 = function (cam1) {
	this.camCount = 0;
	this.cam1 = cam1;
	this.checkDistanceFirstTime = true;
	this.stationNearTimer = new Timer(this, this.stationNear, 5, 5);
	this.CamFRMT1TrackId = addFrameCallback(this.CamFRMT1.bind(this));
}

this.CamFRMT1 = function () {
	var pos = -50;
	if (this.camCount < 150) {
		this.camCount += 1;
		pos = -200 + this.camCount;
	}
	this.cam1.position = player.ship.position.add(player.ship.vectorForward.multiply(pos)).add(player.ship.vectorRight.multiply(-200));
	this.cam1.orientation = player.ship.orientation;
}

this.stationNear = function () {
	this.shArray = system.shipsWithRole("CoyoteNavystation2");
	if (this.shArray.length > 0) {
		if (this.shArray[0].position.distanceTo(player.ship.position) < 12000) {
			this.cam1.reactToAIMessage("STATION_NEAR");

			if (isValidFrameCallback(this.CamFRMT1TrackId)) {
				removeFrameCallback(this.CamFRMT1TrackId);
			}
		}
	}
}

this.pirateAmbush = function () {
	var SC = Math.floor(Math.random() * 3) + 5;
	system.addShips("pirate", SC, player.ship.position, 10000);
}

this.sunSkimT = function () {
	this.sunSkimCounter += 1;
	if (this.sunSkimCounter == 1) {
		player.commsMessage(expandDescription("[COYOTE_S60_01]"), 6)
	} else {
		this.sunSkimTimer.stop();
		this.autoskimmer = system.addShips("coyoteautoskimmer", 1, player.ship.position.add(player.ship.vectorRight.multiply(100)).add(player.ship.vectorUp.multiply(100)), 0)[0];
		this.autoskimmer.orientation = player.ship.orientation;
		this.skimTrackId = addFrameCallback(this.followAutoSkimmer.bind(this));
		player.consoleMessage(expandDescription("[COYOTE_S60_02]"), 6);
		this.skimProgressTimer = new Timer(this, this.skimProgress, 2, 2);
	}
}

this.skimProgress = function () {
	if (player.alertMassLocked) {
		// don't tell the player to engage injectors if ShipConfig is installed - too much heat!
		// also, don't tell the player to use injectors if they don't have any
		if (!worldScripts.ShipConfiguration_Core || player.ship.hasEquipmentProviding("EQ_FUEL_INJECTION") === true) {
			if (player.ship.speed <= player.ship.maxSpeed) {
				player.consoleMessage(expandDescription("[COYOTE_S60_03]"), 6);
			}
		}
	} else {
		if (player.ship.speed <= player.ship.maxSpeed * 10) {
			player.consoleMessage(expandDescription("[COYOTE_S60_04]"), 6);
		}
	}
}

this.followAutoSkimmer = function () {
	player.ship.orientation = this.autoskimmer.orientation;
	player.ship.position = this.autoskimmer.position.add(this.autoskimmer.vectorRight.multiply(-100)).add(this.autoskimmer.vectorUp.multiply(-100));
}

this.deactivateSkimTracking = function () {
	if (isValidFrameCallback(this.skimTrackId)) {
		removeFrameCallback(this.skimTrackId);
		this.autoskimmer.remove(true);
		player.commsMessage(expandDescription("[COYOTE_S60_05]"), 6);
		player.commsMessage(expandDescription("[COYOTE_S60_06]"), 6);
		this.skimProgressTimer.stop();
	}
}

this.startSahanaFun = function () {
	this.sahanaFunCount = 0;
	this.sahanaFunTimer = new Timer(this, this.sahanaFun, 5, 1);
}

this.sahanaFun = function () {
	this.sahanaFunCount += 1;
	if (this.sahanaFunCount == 1) {
		player.commsMessage(expandDescription("[COYOTE_S225_01]"), 6);
	}
	if (this.sahanaFunCount == 3) {
		player.commsMessage(expandDescription("[COYOTE_S225_02]"), 6);
	}
	if (this.sahanaFunCount == 5) {
		player.commsMessage(expandDescription("[COYOTE_S225_03]"), 6);
	}
	if (this.sahanaFunCount == 7) {
		player.commsMessage(expandDescription("[COYOTE_S225_04]"), 6);
	} else if (this.sahanaFunCount == 12) {
		this.sahanaPod = system.addShips("coyotesahanapod", 1, player.ship.position.add(player.ship.vectorForward.multiply(-30)), 0)[0];
		this.shpArray = system.shipsWithPrimaryRole("coyotekatikboss3escort");
		if (this.shpArray.length == 0) {} else {
			this.mambaEscort = this.shpArray[0]
			this.shpArray[0].reactToAIMessage("SCOOP_SAHANA");
		}
		mission.setInstructionsKey("CE_MI_S_225_02", "Coyote-Main");
	} else if (this.sahanaFunCount == 15) {
		player.commsMessage(expandDescription("[COYOTE_S225_05]"), 6);
	} else if (this.sahanaFunCount == 20) {
		this.mambaEscort.commsMessage(expandDescription("[COYOTE_S225_06]"), player.ship);
	}
}

this.$initInterface = function (station) {
	if (galaxyNumber == 4) {
		station.setInterface(this.name, {
			title: "Coyote's Run History",
			category: expandDescription("[interfaces-category-logs]"),
			summary: "Views previous mission data for Coyote's Run mission",
			callback: this.displayPreviousScreens.bind(this)
		});
	}
	if (station.primaryRole == "Coyoteinterstellarstation" || station.primaryRole == "Coyoteinterstellarstationgg") {
		station.setInterface(this.name + "_menu", {
			title: "Avernus Orbital 'L\'Auberge de Lago' Restaurant",
			category: "Station Interfaces",
			summary: "View the menu for Avernus Orbital Restaurant 'L\'Auberge de Lago'",
			callback: this.$displayRestaurantMenu.bind(this)
		});
	}
}

this.$displayRestaurantMenu = function $displayRestaurantMenu() {
	mission.runScreen({
		title: "L\'Auberge de Lago",
		overlay: {
			name: "menu3.png",
			height: 546
		}
	});
}