"use strict";
this.name = "BlackMarket_ProximityMine";
this.author = "phkb";
this.copyright = "2023 phkb";
this.description = "Ship script for proximity mine";
this.licence = "CC BY-NC-SA 4.0";

this._counter = 0;

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
	this._timer = new Timer(this, this.$proximityMine, 1, 1);
	this.ship.switchAI("oolite-nullAI.js");
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function () {
	if (this._timer.isRunning) this._timer.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.shipTakingDamage = function (amount, whom, type) {
	if (amount > this.ship.energy) {
		this._timer.stop();
		if (this.ship.is_cascade_weapon) {
			this.ship.becomeCascadeExplosion();
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$proximityMine = function $proximityMine() {
	if (!this.ship || this.ship.isValid === false) {
		this._timer.stop();
		return;
	}
	if (this._counter <= 5) {
		var s = this.ship.checkScanner(true);
		if (s.length > 0) {
			this.ship.commsMessage((5 - this._counter).toString());
			this._counter += 1;
			if (this._counter === 6) {
				log(this.name, "boom");
				this._timer.stop();
				if (this.ship.hasOwnProperty("is_cascade_weapon") && this.ship.is_cascade_weapon) {
					this.ship.becomeCascadeExplosion();
				} else {
					this.$detonation();
				}
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$detonation = function () {
	delete this.shipTakingDamage; // because otherwise, the game will crash!
	this.ship.explode();
	this.ship.dealEnergyDamage(300, 1000, 0.5);
	if (this.ship.position.distanceTo(player.ship) < 2000) {
		player.ship.fuelLeakRate = 0.5;
		this.$playSound("leak");
	}
}

//-------------------------------------------------------------------------------------------------------------
// plays the hydraulic sound of the silicone sealant being applied
this.$playSound = function $playSound(type) {
	var mySound = new SoundSource;
    switch (type) {
        case "leak":
            mySound.sound = "[fuel-leak]";
            break;
    }
	mySound.loop = false;
	mySound.play();
}
