"use strict";
this.name = "LaserBooster_Conditions";
this.author = "phkb";
this.copyright = "2025 phkb";
this.description = "Condition script to handle equipment items";
this.licence = "CC BY-NC-SA 4.0";

// can only repair laser in primary position (if LMSS is installed)

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {
	if (context == "scripted") return true; // note: this doesn't fire when changing weapons
    var lb = worldScripts["laserBooster_worldScript.js"];
	if (lb._switching == true) return true;
	if (worldScripts.LMSS_Core && worldScripts.LMSS_Core._switching == true) return true;

    var p = player.ship;
	if (equipment == "EQ_WEAPON_LBOOST_DAMAGED_LASER") return false;
    if (equipment.indexOf("LBOOST_REPAIRITEM") == -1) return false;

    var key = "";
    if (equipment == "EQ_FORWARD_LBOOST_REPAIRITEM") {
		if (p.forwardWeapon.equipmentKey == lb._damagedEq) {
			var key = lb._holdDamage["FORWARD"].primary;
		}
	}
	if (equipment == "EQ_AFT_LBOOST_REPAIRITEM") {
		if (p.aftWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["AFT"].primary;
		}
	}
	if (equipment == "EQ_PORT_LBOOST_REPAIRITEM") {
		if (p.portWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["PORT"].primary;
		}
	}
	if (equipment == "EQ_STARBOARD_LBOOST_REPAIRITEM") {
		if (p.starboardWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["STARBOARD"].primary;
		}
	}

    if (equipment == "EQ_FORWARD_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["FORWARD"].secondary != "") {
			key = lb._holdDamage["FORWARD"].secondary;
		}
	}
	if (equipment == "EQ_AFT_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["AFT"].secondary != "") {
			key = lb._holdDamage["AFT"].secondary;
		}
	}
	if (equipment == "EQ_PORT_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["PORT"].secondary != "") {
			key = lb._holdDamage["PORT"].secondary;
		}
	}
	if (equipment == "EQ_STARBOARD_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["STARBOARD"].secondary != "") {
			key = lb._holdDamage["STARBOARD"].secondary;
		}
	}
    if (key != "") {
        var eq = EquipmentInfo.infoForKey(key);
        if (p.dockedStation.equivalentTechLevel >= eq.techLevel) return true;
    }

    return false;
}

//-------------------------------------------------------------------------------------------------------------
this.updateEquipmentPrice = function (equipment, price) {
	var newprice = price;
	var p = player.ship;
    var lb = worldScripts["laserBooster_worldScript.js"];

    if (equipment.indexOf("LBOOST_REPAIRITEM") == -1) return newprice;

    var key = "";

    if (equipment == "EQ_FORWARD_LBOOST_REPAIRITEM") {
		if (p.forwardWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["FORWARD"].primary;
		}
	}
	if (equipment == "EQ_AFT_LBOOST_REPAIRITEM") {
		if (p.aftWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["AFT"].primary;
		}
	}
	if (equipment == "EQ_PORT_LBOOST_REPAIRITEM") {
		if (p.portWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["PORT"].primary;
		}
	}
	if (equipment == "EQ_STARBOARD_LASER_REPAIRITEM") {
		if (p.starboardWeapon.equipmentKey == lb._damagedEq) {
			key = lb._holdDamage["STARBOARD"].primary;
		}
	}

    if (equipment == "EQ_FORWARD_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["FORWARD"].secondary != "") {
			key = lb._holdDamage["FORWARD"].secondary;
		}
	}
	if (equipment == "EQ_AFT_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["AFT"].secondary != "") {
			key = lb._holdDamage["AFT"].secondary;
		}
	}
	if (equipment == "EQ_PORT_SECONDARY_LBOOST_REPAIRITEM") {
		if (lb._holdDamage["PORT"].secondary != "") {
			key = lb._holdDamage["PORT"].secondary;
		}
	}
	if (equipment == "EQ_STARBOARD_SECONDARY_LASER_REPAIRITEM") {
		if (lb._holdDamage["STARBOARD"].secondary != "") {
			key = lb._holdDamage["STARBOARD"].secondary;
		}
	}
    var eq = EquipmentInfo.infoForKey(key);
    if (eq) {
		newprice = eq.price;
	}
	return newprice;
}