"use strict";

this.name    = "Home_Control";
this.version = "1.2"; // August 20th, 2025

this._season = null;

/* ====================================================================================
			EVENT LISTENERS
======================================================================================= */

    this.startUpComplete = function () {
        delete this.startUpComplete;
        if (player.ship.equipmentStatus("EQ_SMART_HOME_CONTROL") === "EQUIPMENT_OK") {
            delete this.playerBoughtEquipment;
            if (player.ship.docked) {
                this.shipDockedWithStation(player.ship.dockedStation);
            }
        }
    }

    this.playerBoughtEquipment = function (equipment) {
        if (equipment === "EQ_SMART_HOME_CONTROL") {
            delete this.playerBoughtEquipment;
            this.shipDockedWithStation(player.ship.dockedStation);
        }
    }

    this.shipDockedWithStation = function (station) {
        if (player.ship.equipmentStatus("EQ_SMART_HOME_CONTROL") === "EQUIPMENT_OK") {
            station.setInterface("smart_aircon", {
                title: "Turn on the air conditioner",
                category: "A TEST",
                summary: "Requires internet-enabled air conditioner and Google Home.",
                callback: this._sequence.bind(this)
            });
            station.setInterface("smart_kettle", {
                title: "Turn on the kettle",
                category: "A TEST",
                summary: "Requires internet-enabled kettle and Google Home.",
                callback: this._sequence.bind(this)
            });
        }
    }

    this.shipWillLaunchFromStation = function (station) {
        station.setInterface("smart_aircon", null);
        station.setInterface("smart_kettle", null);
    }

/* ====================================================================================
			HOME CONTROL SEQUENCES
======================================================================================= */

    this._sequence = function (callback) {
        if (callback === "smart_aircon") {
            if (!this._season) {
                mission.runScreen({
                    title: "Air Conditioner",
                    message: "Do you need warmth for winter, or cooling for summer?",
                 // choices: {"summer": {text: "Summer"}, "winter": {text: "Winter"} },
                    choices: {"summer": "Summer", "winter": "Winter"},
                    exitScreen: "GUI_SCREEN_INTERFACES"
                }, function (season) {this._season = season;});
            }
            this._airConControl(true);
            this.$airConTimer = new Timer(this, function () {this._airConControl(false);}, 20);
        }
        if (callback === "smart_kettle") {
            this._kettleControl(true);
            this.$kettleTimer = new Timer(this, function () {this._kettleControl(false);}, 30);
            this.$OoliteTimer = new Timer(this, function () {pauseGame();}, 50);
        }
    }

/* ====================================================================================
			SMART KETTLE CONTROL
======================================================================================= */

    this._kettleControl = function _kettleControl (start) {
        if (start) {
            if (oolite.gameSettings.speechOn > 1) {
                player.audioMessage("Hey Google, turn on the kettle.");
            } else {
                var googleBoss = new SoundSource;
                googleBoss.sound = "dt_turn_on_the_kettle.ogg";
                googleBoss.volume = 1.0; // Full volume
                googleBoss.play();
            }
        } else {
            if (oolite.gameSettings.speechOn > 1) {
                player.audioMessage("Hey Google, what is the temperature of the kettle?");
            } else {
                var googleBoss = new SoundSource;
                googleBoss.sound = "dt_what_is_the_temperature_of_the_kettle.ogg";
                googleBoss.volume = 1.0; // Full volume
                googleBoss.play();
            }
        }
    }

/* ====================================================================================
			SMART AIR-CON CONTROL
======================================================================================= */

    this._airConControl = function _airConControl (start) {
        if (start) {
            if (oolite.gameSettings.speechOn > 1) {
                player.audioMessage("Hey Google, turn on the air conditioner.");
            } else {
                var googleBoss = new SoundSource;
                googleBoss.sound = "dt_turn_on_the_air_conditioner.ogg";
                googleBoss.volume = 1;
                googleBoss.play();
            }
        } else {
            if (this._season === "summer") {
                if (oolite.gameSettings.speechOn > 1) {
                    player.audioMessage("Hey Google, set the air conditioner to cool.");
                } else {
                    var googleBoss = new SoundSource;
                    googleBoss.sound = "dt_set_the_air_conditioner_to_cool.ogg";
                    googleBoss.volume = 1;
                    googleBoss.play();
                }
            } else if (this._season === "winter") {
                if (oolite.gameSettings.speechOn > 1) {
                    player.audioMessage("Hey Google, set the air conditioner to heat.");
                } else {
                    var googleBoss = new SoundSource;
                    googleBoss.sound = "dt_set_the_air_conditioner_to_heat.ogg";
                    googleBoss.volume = 1;
                    googleBoss.play();
                }
            }
        }
    }

/* ====================================================================================
			THE END
======================================================================================= */