"use strict";
this.name = "LMSS_Conditions";
this.author = "phkb";
this.copyright = "2015 phkb";
this.description = "Condition script for LMSS equipment items.";
this.licence = "CC BY-NC-SA 4.0";

this.allowAwardEquipment = function (equipment, ship, context) {
	// none of these items should be on a new ship
	if (context === "newShip") return false;

	if (equipment === "EQ_LMSS_ACTIVATOR") {
		if (context === "purchase") return false;
	}

	// these can only be installed via a script.
	if ((equipment === "EQ_LMSS_FRONT_WEAPON" || equipment === "EQ_LMSS_AFT_WEAPON" || equipment === "EQ_LMSS_PORT_WEAPON" || equipment === "EQ_LMSS_STARBOARD_WEAPON") && context != "scripted") return false;

	// old equipment items aren't available for purchase anymore, but we need them for backwards compatibility
	if (equipment.indexOf("EQ_LMSS_FRONT_") >= 0 && equipment.indexOf("_WEAPON") === -1) return false;
	if (equipment.indexOf("EQ_LMSS_AFT_") >= 0 && equipment.indexOf("_WEAPON") === -1) return false;
	if (equipment.indexOf("EQ_LMSS_PORT_") >= 0 && equipment.indexOf("_WEAPON") === -1) return false;
	if (equipment.indexOf("EQ_LMSS_STARBOARD_") >= 0 && equipment.indexOf("_WEAPON") === -1) return false;

	if (equipment === "EQ_LMSS_FRONT") {
		// does the ship have a forward mount?
		if (" 1 3 5 7 9 11 13 15 ".indexOf(" " + ship.weaponFacings.toString() + " ") === -1)
			return false;
	}
	if (equipment === "EQ_LMSS_AFT") {
		// does the ship have an aft mount?
		if (" 2 3 6 7 10 11 14 15 ".indexOf(" " + ship.weaponFacings.toString() + " ") === -1)
			return false;
	}
	if (equipment === "EQ_LMSS_PORT") {
		// does the ship have a port mount?
		if (" 4 5 6 7 12 13 14 15 ".indexOf(" " + ship.weaponFacings.toString() + " ") === -1)
			return false;
	}
	if (equipment === "EQ_LMSS_STARBOARD") {
		// does the ship have a starboard mount?
		if (" 8 9 10 11 12 13 14 15 ".indexOf(" " + ship.weaponFacings.toString() + " ") === -1)
			return false;
	}

	// OXP hook to allow stations to forbid specific equipment
	if (context === "purchase" && player.ship.dockedStation && player.ship.dockedStation.scriptInfo["oolite-barred-equipment"]) {
		if (player.ship.dockedStation.scriptInfo["oolite-barred-equipment"].indexOf(equipment) != -1) {
			return false;
		}
	}

	// OXP hook to allow ships to forbid specific "available to all" equipment
	if (ship.scriptInfo && ship.scriptInfo["oolite-barred-equipment"] && ship.scriptInfo["oolite-barred-equipment"].indexOf(equipment) != -1) {
		return false;
	}

	// otherwise allowed
	return true;
}