"use strict";
this.name = "IR-weiss.js";
this.author = "Ramirez";
this.copyright = "November 2010";
this.description = "Script for Weiss' ships";
this.version = "2.0";

//-------------------------------------------------------------------------------------------------------------
this.shipExitedWitchspace = function () {
	this.ship.setAI("IR-weiss2AI.plist");
}

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
	if (missionVariables.IR_status == "IR_WEISS_1") {
		worldScripts["IR-mfd.js"].$updateMFD("IR_weiss_depart", null, this.ship);
		this.ship.setAI("IR-weiss1AI.plist");
	}
	if (missionVariables.IR_status == "IR_WEISS_2b") {
		this.ship.setAI("IR-weiss2AI.plist");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.performJump = function () {
	this.ship.commsMessage(expandMissionText("IR-engaging"));
	this.ship.fuel = 10.0;
	if (missionVariables.IR_status == "IR_WEISS_1") {
		this.ship.exitSystem(175);
		missionVariables.IR_status = "IR_WEISS_2a";
	}
	if (missionVariables.IR_status == "IR_WEISS_2b") {
		this.ship.exitSystem(119);
		missionVariables.IR_status = "IR_WEISS_3";
	}
}

//-------------------------------------------------------------------------------------------------------------
this.preJumpComms = function() {
	this.ship.commsMessage(expandMissionText("IR-weiss-prejump-comms"));
}

//-------------------------------------------------------------------------------------------------------------
this.preJumpSystem = function() {
	this.ship.commsMessage(expandMissionText("IR-weiss-prejump-system"));
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function () {
	if (this.ship.primaryRole == "IR-weiss-shuttle") {
		this.ship.spawn("IR-weiss-pod");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipWasScooped = function (whom) {
	if (this.ship.primaryRole == "IR-weiss-pod") {
		if (whom == player.ship) {
			missionVariables.IR_status = "IR_weiss_scooped";
			worldScripts["IR-mfd.js"].$updateMFD("IR_weiss_captured"); // who is sending this message?
		}
	}
}