"use strict";
this.name = "IR-transport.js";
this.author = "Ramirez";
this.copyright = "July 2010";
this.description = "Ship script for armoured transports";
this.version = "2.0";

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
	if (missionVariables.IR_shipment_quest == "ENROUTE") {
		this.ship.setAI("IR-transport-exitAI.plist");
		var route = system.info.routeToSystem(System.infoForSystem(galaxyNumber, 112));
		if (route && route.route && route.route.length > 1) {
			this.ship.destinationSystem = route.route[1];
		}
	}

	if (missionVariables.IR_shipment_quest == "AMBUSH")
		this.ship.setAI("route1TraderAI.plist");

}

//-------------------------------------------------------------------------------------------------------------
this.leaveSystem = function () {
	if (missionVariables.IR_shipment_quest == "ENROUTE" && !missionVariables.IR_convoy_exited) {
		if (missionVariables.IR_alsto == "HELP_ACCEPTED") {
			missionVariables.IR_convoy_exited = "TRUE";
			worldScripts["IR-mfd.js"].$updateMFD("IR_report_abonlo");
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function () {
	var mfd = worldScripts["IR-mfd.js"];
	if (this.ship.primaryRole == "IR-transport-alternate") {
		this.ship.spawn("IR-disabled-transport", 1);
		++missionVariables.IR_transport_kill_count;
		mfd.$updateMFD("IR_transports_disabled", {count: missionVariables.IR_transport_kill_count});

		if (missionVariables.IR_transport_kill_count == 4) {
			missionVariables.IR_transport_kill_count = null;
			missionVariables.IR_transport_exit_count = null;
			missionVariables.IR_shipment_quest = "SUCCESS";

			if (missionVariables.IR_alsto == "INFORMED") {
				missionVariables.IR_shipment_quest_method = "PIRATE_AMBUSH";
				mfd.$updateMFD("IR_abonlo_report", null, null, expandMissionText("IR_abonlo_name"));
			} else {
				missionVariables.IR_shipment_quest_method = "SOLO_AMBUSH";
				mfd.$updateMFD("IR_solo_ambush");
			}
		}
	}

	if (this.ship.primaryRole == "IR-transport") {
		++missionVariables.IR_transport_kill_count;
		if (missionVariables.IR_transport_kill_count == 4) {
			missionVariables.IR_shipment_quest = "SUCCESS";
			mfd.$updateMFD("IR_solo_ambush");
			if (missionVariables.IR_shipment_quest == "ENROUTE") {
				missionVariables.IR_shipment_quest_method = "YOKOHAMA_AMBUSH";
			}
		}
	}
}