"use strict";
this.name = "IR-main-script.js";
this.author = "Ramirez";
this.copyright = "February 2014";
this.description = "Iron Raven main world script";
this.version = "2.0";

this._line = "";
this._spacer = "";
this._manifest = {};
this._pf = false;
this._defaultSelection = "";
this._mfd = null;
this._resetSettings = false;

// central control over overlays applied to mission screens.
// this is so we can define it in one location, but use it in multiple spots
this._overlays = {
	IR_CHERKASOVA_1a: "IR_KSR_logo.png",
	IR_CHERKASOVA_1b: "IR_KSR_logo.png",
	IR_CHERKASOVA_1c: "IR_KSR_logo.png",
	IR_CHERKASOVA_1d: "IR_KSR_logo.png",
	IR_defences_quest_1: { name: "IR_quico_logo.png", height: 546 },
	IR_defences_quest_1_alt: { name: "IR_quico_logo.png", height: 546 },
	IR_defences_quest_2a: { name: "IR_NWE_logo.png", height: 546 },
	IR_defences_quest_2b: { name: "IR_NWE_logo.png", height: 546 },
	IR_defences_quest_3: { name: "IR_NWE_logo.png", height: 546 },
	IR_defences_quest_4: { name: "IR_quico_logo.png", height: 546 },
	IR_defences_quest_5a: { name: "IR_quico_logo.png", height: 546 },
	IR_final: "IR_iNews.png",
	IR_finance_quest_1: { name: "IR_korsh_logo.png", height: 546 },
	IR_finance_quest_2: { name: "IR_korsh_logo.png", height: 546 },
	IR_finance_quest_3: { name: "IR_korsh_logo.png", height: 546 },
	IR_finance_quest_3alt: { name: "IR_korsh_logo.png", height: 546 },
	IR_finance_quest_4: "IR_bloomberg.png",
	IR_finance_quest_6a: { name: "IR_GSE_logo.png", height: 546 },
	IR_finance_quest_6b: { name: "IR_GSE_logo.png", height: 546 },
	IR_finance_quest_8: { name: "IR_GSE_logo.png", height: 546 },
	IR_finance_quest_9_confirm: { name: "IR_GSE_logo.png", height: 546 },
	IR_finance_quest_9_deny: { name: "IR_GSE_logo.png", height: 546 },
	IR_finance_quest_10: "IR_bloomberg.png",
	IR_finance_quest_part: { name: "IR_korsh_logo.png", height: 546 },
	IR_GSE_finance_answer_1a: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_finance_answer_1b: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_intro: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_loan_agreed: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_loan_deferred: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_loan_demand: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_loan_offer: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_loan_rejected: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_loan_repeat_offer: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_pay_accepted: { name: "IR_GSE_logo.png", height: 546 },
	IR_GSE_pay_deferred: { name: "IR_GSE_logo.png", height: 546 },
	IR_IBANEZ_1: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_2a: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_2b: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_2c: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_3: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_4a: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_4b: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_4c: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_4d: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_5: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_5_debrief: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_5a: { name: "IR_galcop.png", height: 546 },
	IR_IBANEZ_5b: { name: "IR_galcop.png", height: 546 },
	IR_invite: { name: "IR_galcop.png", height: 546 },
	IR_JANES_1a: { name: "IR_janes_logo.png", height: 546 },
	IR_JANES_1b: { name: "IR_janes_logo.png", height: 546 },
	IR_JANES_1c: { name: "IR_janes_logo.png", height: 546 },
	IR_JANES_defences_answer: { name: "IR_janes_logo.png", height: 546 },
	IR_JANES_intro: { name: "IR_janes_logo.png", height: 546 },
	IR_JANES_SDF_answer: { name: "IR_janes_logo.png", height: 546 },
	IR_kinnaird_1: { name: "IR_galcop.png", height: 546 },
	IR_kinnaird_4a: "IR_pw_logo.png",
	IR_kinnaird_4b: "IR_nightclub.png",
	IR_KORSHKOV_finance_answer_1a: { name: "IR_korsh_logo.png", height: 546 },
	IR_KORSHKOV_finance_answer_1b: { name: "IR_korsh_logo.png", height: 546 },
	IR_KORSHKOV_intro: { name: "IR_korsh_logo.png", height: 546 },
	IR_LEXICON_1: { name: "IR_galcop.png", height: 546 },
	IR_LEXICON_3a: "IR_nightclub.png",
	IR_LEXICON_3b: "IR_nightclub.png",
	IR_LOA_1: "IR_KSR_logo.png",
	IR_LOA_6: { name: "IR_quico_logo.png", height: 546 },
	IR_LOA_7: "IR_iNews.png",
	IR_LOA_8: "IR_iNews.png",
	IR_MAENES_defences_answer_1: { name: "IR_quico_logo.png", height: 546 },
	IR_MAENES_intro: { name: "IR_quico_logo.png", height: 546 },
	IR_NWE_defences_answer_1: { name: "IR_NWE_logo.png", height: 546 },
	IR_NWE_intro: { name: "IR_NWE_logo.png", height: 546 },
	IR_NWE_SDF_answer_1a: { name: "IR_NWE_logo.png", height: 546 },
	IR_NWE_SDF_answer_1b: { name: "IR_NWE_logo.png", height: 546 },
	IR_PW_intro: "IR_pw_logo.png",
	IR_PW_SDF_answer_1: "IR_pw_logo.png",
	IR_PW_SDF_answer_2: "IR_devries.png",
	IR_reward_a: { name: "IR_galcop.png", height: 546 },
	IR_reward_b: { name: "IR_galcop.png", height: 546 },
	IR_reward_c: "IR_maenesmedal.png",
	IR_reward_d: { name: "IR_galcop.png", height: 546 },
	IR_SDF_quest_6: { name: "IR_korsh_logo.png", height: 546 },
	IR_SDF_quest_7a: { name: "IR_korsh_logo.png", height: 546 },
	IR_SDF_quest_8a: "IR_kinnaird.png",
	IR_SDF_quest_8b: "IR_match.png",
	IR_sources_1: "IR_KSR_logo.png",
	IR_sources_5a: { name: "IR_quico_logo.png", height: 546 },
	IR_sources_6: "IR_iNews.png",
	IR_sources_7: "IR_iNews.png",
	IR_theend: { name: "IR_title.png", height: 546 },
	IR_weiss_1: { name: "IR_galcop.png", height: 546 },
	IR_weiss_3a: "IR_pw_logo.png",
	IR_weiss_3b: "IR_pw_logo.png",
	IR_YOKOHAMA_intro: { name: "IR_yk_logo.png", height: 546 },
	IR_YOKOHAMA_shipment_answer_1: { name: "IR_yk_logo.png", height: 546 },
	IR_YOKOHAMA_shipment_answer_2: { name: "IR_yk_logo.png", height: 546 },
	IR_YOKOHAMA_shipment_declined: { name: "IR_yk_logo.png", height: 546 },
	IR_YOKOHAMA_shipment_defer: { name: "IR_yk_logo.png", height: 546 },
	IR_YOKOHAMA_shipment_nomoney: { name: "IR_yk_logo.png", height: 546 },
	IR_YOKOHAMA_shipment_toolate: { name: "IR_yk_logo.png", height: 546 },
};

this._padInfo = [];

this.$dataStore = {
	"GALCOP.INTELLIGENCE": { keyDisplay: expandMissionText("IR_key_intelligence"), name: "", entry: clock.clockString, enlisted: "", kills: 0, missions: [], awards: [], info: [], t0: 30, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.GHC": { keyDisplay: expandMissionText("IR_key_ghc"), name: expandMissionText("IR_name_ghc"), location: expandMissionText("IR_planet_ghc"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.KSR": { keyDisplay: expandMissionText("IR_key_ksr"), name: expandMissionText("IR_name_ksr"), location: "", beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.OKB": { keyDisplay: expandMissionText("IR_key_okb"), name: expandMissionText("IR_name_okb"), location: expandMissionText("IR_planet_okb"), beacon: "", purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.GSE": { keyDisplay: expandMissionText("IR_key_gse"), name: expandMissionText("IR_name_gse"), location: expandMissionText("IR_planet_gse"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.QUICO": { keyDisplay: expandMissionText("IR_key_quico"), name: expandMissionText("IR_name_quico"), location: expandMissionText("IR_planet_quico"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.NWE": { keyDisplay: expandMissionText("IR_key_nwe"), name: expandMissionText("IR_name_nwe"), location: expandMissionText("IR_planet_nwe"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.YOKOHAMA": { keyDisplay: expandMissionText("IR_key_yoko"), name: expandMissionText("IR_name_yoko"), location: expandMissionText("IR_planet_yoko"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.JANES": { keyDisplay: expandMissionText("IR_key_janes"), name: expandMissionText("IR_name_janes"), location: expandMissionText("IR_planet_janes"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.SIRIUS": { keyDisplay: expandMissionText("IR_key_sirius"), name: expandMissionText("IR_name_sirius"), location: expandMissionText("IR_planet_sirius"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.SDF": { keyDisplay: expandMissionText("IR_key_sdf"), name: expandMissionText("IR_name_sdf"), location: expandMissionText("IR_planet_sdf"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.LOA": { keyDisplay: expandMissionText("IR_key_loa"), name: expandMissionText("IR_name_loa"), location: expandMissionText("IR_planet_loa"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"INFOS.PW": { keyDisplay: expandMissionText("IR_key_pw"), name: expandMissionText("IR_name_pw"), location: expandMissionText("IR_planet_pw"), beacon: expandMissionText("IR_generic_none"), purpose: "", special: [], notes: [], t0: 0, t1: 0, t2: 0, t3: 0, t4: 0, t5: 0 },
	"SYSTEMS.VEGEDIUS": { keyDisplay: expandMissionText("IR_key_vegedius"), name: expandMissionText("IR_name_vegedius"), info: [expandMissionText("IR_info_vegedius_1"), expandMissionText("IR_info_vegedius_2")], notes: [] },
	"SYSTEMS.AARZARI": { keyDisplay: expandMissionText("IR_key_aarzari"), name: expandMissionText("IR_name_aarzari"), info: [expandMissionText("IR_info_aarzari_1"), expandMissionText("IR_info_aarzari_2")], notes: [] },
	"SYSTEMS.USTIZA": { keyDisplay: expandMissionText("IR_key_ustiza"), name: expandMissionText("IR_name_ustiza"), info: [expandMissionText("IR_info_ustiza_1"), expandMissionText("IR_info_ustiza_2")], notes: [] },
	"SYSTEMS.MAENES": { keyDisplay: expandMissionText("IR_key_maenes"), name: expandMissionText("IR_name_maenes"), info: [expandMissionText("IR_info_maenes_1"), expandMissionText("IR_info_maenes_2")], notes: [] },
	"SYSTEMS.ARANCE": { keyDisplay: expandMissionText("IR_key_arance"), name: expandMissionText("IR_name_arance"), info: [expandMissionText("IR_info_arance_1"), expandMissionText("IR_info_arance_2")], notes: [] },
	"SYSTEMS.ALETIUS": { keyDisplay: expandMissionText("IR_key_aletius"), name: expandMissionText("IR_name_aletius"), info: [expandMissionText("IR_info_aletius_1"), expandMissionText("IR_info_aletius_2")], notes: [] },
	"SYSTEMS.LAXESORI": { keyDisplay: expandMissionText("IR_key_laxesori"), name: expandMissionText("IR_name_laxesori"), info: [expandMissionText("IR_info_laxesori_1"), expandMissionText("IR_info_laxesori_2")], notes: [] },
	"SYSTEMS.BIRAA": { keyDisplay: expandMissionText("IR_key_biraa"), name: expandMissionText("IR_name_biraa"), info: [expandMissionText("IR_info_biraa_1"), expandMissionText("IR_info_biraa_2")], notes: [] },
	"SYSTEMS.TEVEBEBI": { keyDisplay: expandMissionText("IR_key_tevebebi"), name: expandMissionText("IR_name_tevebebi"), info: [expandMissionText("IR_info_tevebebi_1"), expandMissionText("IR_info_tevebebi_2")], notes: [] },
	"SYSTEMS.EDZAAR": { keyDisplay: expandMissionText("IR_key_edzaar"), name: expandMissionText("IR_name_edzaar"), info: [expandMissionText("IR_info_edzaar_1"), expandMissionText("IR_info_edzaar_2")], notes: [] },
};
this.$peopleStore = {
	"PERSONS.ADMIRAL IBANEZ": { keyDisplay: expandMissionText("IR_ibanez_key"), name: expandMissionText("IR_ibanez_name"), origin: expandMissionText("LIB_CHAR_RESTRICTED"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 56, ship: expandMissionText("IR_ibanez_ship"), rank: expandMissionText("IR_ibanez_rank"), t0: 21, t1: "lib_ovc67.png", t2: 11 },
	"PERSONS.JANNE LINDBERG": { keyDisplay: expandMissionText("IR_lindberg_key"), name: expandMissionText("IR_lindberg_name"), origin: expandMissionText("IR_lindberg_planet"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 41, ship: expandMissionText("IR_generic_none"), rank: expandMissionText("IR_lindberg_rank"), info: [expandMissionText("IR_lindberg_info")], t1: "lib_ovc07.png" },
	"PERSONS.LEXICON": { keyDisplay: expandMissionText("IR_lexicon_key"), name: expandMissionText("IR_lexicon_name"), origin: expandMissionText("LIB_CHAR_RESTRICTED"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: expandMissionText("IR_generic_unknown"), ship: expandMissionText("IR_generic_none"), rank: "", info: [expandMissionText("IR_lexicon_info")] },
	"PERSONS.TOBIAS KING": { keyDisplay: expandMissionText("IR_tobias_key"), name: expandMissionText("IR_tobias_name"), origin: expandMissionText("IR_tobias_planet"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 29, ship: expandMissionText("IR_generic_none"), rank: "", info: [expandMissionText("IR_tobias_info_1"), expandMissionText("IR_tobias_info_2")], t1: "lib_ovc27.png" },
	"PERSONS.ISABELLA KING": { keyDisplay: expandMissionText("IR_isabella_key"), name: expandMissionText("IR_isabella_name"), origin: expandMissionText("IR_isabella_planet"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_FEMALE"), age: 27, ship: expandMissionText("IR_generic_none"), rank: "", info: [expandMissionText("IR_isabella_info")], t1: "lib_ovc24.png" },
	"PERSONS.COMMANDER NASH": { keyDisplay: expandMissionText("IR_nash_key"), name: expandMissionText("IR_nash_name"), origin: expandMissionText("IR_nash_planet"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 31, ship: "", rank: expandMissionText("IR_nash_rank"), info: [expandMissionText("IR_nash_info")], t1: "lib_ovc09.png", t2: 5 },
	"PERSONS.REINHARDT WEISS": { keyDisplay: expandMissionText("IR_weiss_key"), name: expandMissionText("IR_weiss_name"), origin: expandMissionText("IR_weiss_planet"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 25, ship: expandMissionText("IR_generic_none"), rank: "", info: [expandMissionText("IR_weiss_info_1"), expandMissionText("IR_weiss_info_2"), expandMissionText("IR_weiss_info_3")], t1: "lib_ovc03.png" },
	"PERSONS.PIETER KINNAIRD": { keyDisplay: expandMissionText("IR_kinnaird_key"), name: expandMissionText("IR_kinnaird_name"), origin: "", species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 36, ship: expandMissionText("IR_kinnaird_ship"), rank: "", info: [expandMissionText("IR_kinnaird_info_1"), expandMissionText("IR_kinnaird_info_2")], t1: "IR_lib_kinnaird.png" },
	"PERSONS.MAJOR CHERKASOVA": { keyDisplay: expandMissionText("IR_cherkasova_key"), name: expandMissionText("IR_cherkasova_name"), origin: expandMissionText("LIB_CHAR_RESTRICTED"), species: expandMissionText("LIB_PAD_GENDER_MALE"), gender: expandMissionText("LIB_PAD_GENDER_FEMALE"), age: 42, ship: expandMissionText("IR_cherkasova_ship"), rank: expandMissionText("IR_cherkasova_rank"), info: [expandMissionText("IR_cherkasova_info")], t1: "lib_ovc60.png", t2: 8 },
	"PERSONS.COLONEL RUIZ": { keyDisplay: expandMissionText("IR_ruiz_key"), name: expandMissionText("IR_ruiz_name"), origin: expandMissionText("IR_generic_unknown"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_FEMALE"), age: 34, ship: "", rank: expandMissionText("IR_ruiz_rank"), info: [expandMissionText("IR_ruiz_info")], t1: "lib_ovc58.png", t2: 8 },
	"PERSONS.CAPTAIN ABONLO": { keyDisplay: expandMissionText("IR_abonlo_key"), name: expandMissionText("IR_abonlo_name"), origin: expandMissionText("IR_generic_unknown"), species: expandMissionText("LIB_PAD_SPECIES_HUMAN"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), age: 44, ship: "", rank: expandMissionText("IR_abonlo_rank"), info: [expandMissionText("IR_abonlo_info")], t1: "lib_ovc66.png" },
	"PERSONS.JACOB DE VRIES": { keyDisplay: expandMissionText("IR_devries_key"), name: expandMissionText("IR_devries_name"), origin: expandMissionText("IR_generic_unknown"), species: expandMissionText("IR_generic_unknown"), gender: expandMissionText("LIB_PAD_GENDER_MALE"), ship: expandMissionText("IR_kinnaird_ship") },
};
this.$categoryLinks = {
	"SYSTEMS.VEGEDIUS": ["INFOS.GHC"],
	"SYSTEMS.AARZARI": ["INFOS.OKB"],
	"SYSTEMS.USTIZA": ["INFOS.GSE"],
	"SYSTEMS.MAENES": ["INFOS.QUICO"],
	"SYSTEMS.ARANCE": ["INFOS.NWE"],
	"SYSTEMS.ALETIUS": ["INFOS.YOKOHAMA"],
	"SYSTEMS.LAXESORI": ["INFOS.PW"],
	"SYSTEMS.BIRAA": ["INFOS.JANES"],
	"SYSTEMS.TEVEBEBI": ["INFOS.SIRIUS", "INFOS.SDF"],
	"SYSTEMS.EDZAAR": ["INFOS.LOA"],
	"PERSONS.ADMIRAL IBANEZ": ["GALCOP.NAVY", "INFOS.GHC", "SYSTEMS.VEGEDIUS"],
	"PERSONS.JANNE LINDBERG": ["GALCOP.INTELLIGENCE", "INFOS.JANES", "SYSTEMS.BIRAA"],
	"PERSONS.LEXICON": ["GALCOP.INTELLIGENCE"],
	"PERSONS.TOBIAS KING": ["INFOS.GSE", "SYSTEMS.USTIZA"],
	"PERSONS.ISABELLA KING": ["PERSONS.TOBIAS KING"],
	"PERSONS.COMMANDER NASH": ["INFOS.NWE", "SYSTEMS.ARANCE"],
	"PERSONS.REINHARDT WEISS": ["INFOS.QUICO", "SYSTEMS.MAENES"],
	"PERSONS.PIETER KINNAIRD": ["INFOS.SDF", "SYSTEMS.TEVEBEBI"],
	"PERSONS.MAJOR CHERKASOVA": ["INFOS.KSR"],
	"PERSONS.COLONEL RUIZ": ["INFOS.QUICO", "SYSTEMS.MAENES"],
	"PERSONS.CAPTAIN ABONLO": ["INFOS.LOA", "SYSTEMS.EDZAAR"],
};
this.$data = {};

// configuration settings for use in Lib_Config
this._IRConfig = {
	Name: this.name,
	Alias: expandMissionText("IR_config_alias"),
	Display: expandMissionText("IR_config_display"),
	Alive: "_IRConfig",
	Notify: "$resetSettings",
	Bool: {
		B0: { Name: "_resetSettings", Def: false, Desc: expandMissionText("IR_config_reset") },
		Info: expandMissionText("IR_config_info")
	},
};

//-------------------------------------------------------------------------------------------------------------
this.$resetSettings = function () {
	if (this._resetSettings) {
		this.clearIRMissionVariables();
		player.consoleMessage(expandMissionText("IR_reset"), 6);
		log(this.name, expandMissionText("IR_reset_confirm"));
		this._resetSettings = false;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	this.addIRinterface();

	this._mfd = worldScripts["IR-mfd.js"];

	if (!missionVariables.IR_screen_log)
		missionVariables.IR_screen_log = "";
	if (!missionVariables.IR_screen_location)
		missionVariables.IR_screen_location = "";

	// rather than redo every mission screen to work with Xenon UI, it's easier just to add the exception.
	var w = worldScripts.XenonUI;
	if (w) w.$addMissionScreenException("iron_raven_special");

	// build up a screen-width line with the current font
	while (defaultFont.measureString(this._line) <= 31) {
		this._line += "–";
	}
	while (defaultFont.measureString(this._spacer) < 6.5) {
		this._spacer += " ";
	}

	if (worldScripts.PlanetFall2) this._pf = true;

	if (worldScripts["nuit_space_station_populator"]) {
		log(this.name, "Monkey patching Nuit to have control over population in mission system.");
		worldScripts["nuit_space_station_populator"].hold_systemWillPopulate = worldScripts["nuit_space_station_populator"].systemWillPopulate;
		delete worldScripts["nuit_space_station_populator"].systemWillPopulate;
	}
	if (worldScripts["NuitMarkII"]) {
		log(this.name, "Monkey patching Nuit Mark II to have control over population in mission system.");
		worldScripts["NuitMarkII"].hold_systemWillPopulate = worldScripts["NuitMarkII"].systemWillPopulate;
		delete worldScripts["NuitMarkII"].systemWillPopulate;
	}

	// cleanup when completed
	if (missionVariables.IR_status == "IR_completed") this.$cleanUp();
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function () {
	// suppress a Nuit Station spawn in Inorle
	if (worldScripts["nuit_space_station_populator"] && (galaxyNumber != 7 || system.ID != 82)) {
		worldScripts["nuit_space_station_populator"].hold_systemWillPopulate();
	}
	// suppress a Nuit Mark II Station spawn in Inorle
	if (worldScripts["NuitMarkII"] && (galaxyNumber != 7 || system.ID != 82)) {
		worldScripts["NuitMarkII"].hold_systemWillPopulate();
	}

	if (galaxyNumber != 7) return;

	if (system.ID == 82) { //Inorle
		if (system.countShipsWithRole("IR-luft-core") == 0) {
			var stnPos = Vector3D(104399.93, 209.23, -11641.69).fromCoordinateSystem("pwm");
			system.setPopulator("IR-luftslotte", {
				priority: 200,
				location: "COORDINATES",
				coordinates: stnPos,
				groupCount: 1,
				callback: function (pos) {
					//system.legacy_addShipsAtPrecisely("IR-luft-core", 1, "pwm", );
					var l6 = system.addShips("IR-luft-core", 1, pos, 0)[0];
					worldScripts["IR-main-script.js"].turnStation(l6, system.mainPlanet);

					if (missionVariables.IR_SDF_quest == "JUMPED" || missionVariables.IR_SDF_quest == "CONTAMINATED" || missionVariables.IR_SDF_quest == "KRAIT") {
						if (system.countShipsWithRole("IR-krait") == 0) {
							system.addShips("IR-krait", 1, pos, 21000);
						}
					}
				},
				deterministic: true
			});
		}
	}

	if (system.ID == 23) { // Maenes
		//system.legacy_addShipsWithinRadius("IR-cannon-core", 40, "pwm", [23038, -39901, 102398], 20000);
		var pos23 = Vector3D(23098, -39901, 102398).fromCoordinateSystem("pwm");
		system.setPopulator("IR-cannons", {
			priority: 300,
			location: "COORDINATES",
			coordinates: pos23,
			groupCount: 1,
			callback: function (pos) {
				if (system.countShipsWithRole("IR-scannon-core") == 0) {
					system.addShips("IR-cannon-core", 40, pos, 20000);
					system.addShips("IR-cannon-core", 10, pos, 10000);
				}
			}
		});
	}

	if (system.ID == 240) { //Pirate Cove
		var pos240 = this.$systemShipsPosition(1.0);
		system.setPopulator("IR-piratecove", {
			priority: 300,
			location: "COORDINATES",
			coordinates: pos240,
			groupCount: 1,
			callback: function (pos) {
				//var ap = system.addShips("IR-anarchypython", 10, pos, 5000);
				var ws = worldScripts["IR-main-script.js"];
				ws._pirate_group = system.addGroup("IR-anarchypython", 10, pos, 5000); // new ShipGroup("anarchists", ap[0]);
				/*for (var i = 0; i < ap.length; i++) {
					var py = ap[i];
					ws._pirate_group.addShip(py);
					for (var j = 0; j < py.escorts.length; j++) {
						ws._pirate_group.addShip(py.escorts[j]);
					}
				}*/
			}
		});
	}

	if (system.ID == 114) { //Releleat
		var pos114 = this.$systemShipsPosition(0.75);
		mission.unmarkSystem({ name: this.name, system: 114 });
		system.setPopulator("IR-fuelprocessor", {
			priority: 300,
			location: "COORDINATES",
			coordinates: pos114,
			groupCount: 1,
			callback: function (pos) {
				if (system.countShipsWithRole("IR-fuelprocessor") == 0) {
					//system.legacy_addSystemShips("IR-fuelprocessor", 1, 0.75);
					system.addShips("IR-fuelprocessor", 1, pos);
				}
			},
			deterministic: true
		});
	}
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (worldScripts.Lib_Config) {
		worldScripts.Lib_Config._registerSet(this._IRConfig);
	}

	if (missionVariables.IR_manifest) this._manifest = JSON.parse(missionVariables.IR_manifest);
	var pad = worldScripts.Lib_PAD;
	if (pad) {
		if (missionVariables.IR_paddata) this.$data = JSON.parse(missionVariables.IR_paddata);
		var keys = Object.keys(this.$data);
		for (var i = 0; i < keys.length; i++) {
			pad._addPageInCategory(keys[i], this.$data[keys[i]], this.$categoryLinks[keys[i]], true);
		}
		if (missionVariables.IR_padchars) {
			this._padInfo = JSON.parse(missionVariables.IR_padchars);
			for (var i = 0; i < this._padInfo.length; i++) {
				this.$addPadCharacter(this._padInfo[i]);
			}
		}
	}

	if (worldScripts.WireframeShipImages) {
		worldScripts.WireframeShipImages._gameShips["Luftslotte 6"] = "nuit2";
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
	missionVariables.IR_manifest = JSON.stringify(this._manifest);
	var pad = worldScripts.Lib_PAD;
	if (pad) {
		// store any infos we've added to pad
		var keys = Object.keys(this.$dataStore);
		for (var i = 0; i < keys.length; i++) {
			var data = pad._getData(keys[i]);
			if (data) this.$data[keys[i]] = data;
		}
		missionVariables.IR_paddata = JSON.stringify(this.$data);

		missionVariables.IR_padchars = JSON.stringify(this._padInfo);
	}
}

//-------------------------------------------------------------------------------------------------------------
// ship encounters
this.shipWillLaunchFromStation = function () {
	missionVariables.IR_offer = null;
	missionVariables.IR_onceOnly = null;

	if (galaxyNumber == 7) {
		if (missionVariables.IR_status == "IR_IBANEZ_5" && clock.days > missionVariables.IR_cherkasova_deadline) {
			if (system.countShipsWithRole("IR-cherkasova-alt") == 0) {
				//system.legacy_addSystemShips("IR-cherkasova-alt", 1, 1.0);
				this.$addSystemShips("IR-cherkasova-alt", 1, 1.0);
			}
		}

		if (system.ID == 171) { // Aletius
			if (missionVariables.IR_shipment_quest == "ENROUTE") {
				if (system.countShipsWithRole("IR-transport") == 0) {
					//system.legacy_addSystemShips("IR-transport", 4, 1.0);
					var pos = this.$systemShipsPosition(1.0);
					this._trans_group = system.addGroup("IR-transport", 4, pos, 8000);
					for (var i = 0; i < this._trans_group.ships.length; i++) {
						// make the first ship the leader
						if (i == 0) this._trans_group.leader = this._trans_group.ships[i];
						// make sure all the escorts have bounties
						if (this._trans_group.ships[i].escorts.length > 0) {
							var es = this._trans_group.ships[i].escorts;
							for (var j = 0; j < es.length; j++) {
								if (es[j].bounty == 0) es[j].bounty = Math.floor(Math.random() * 30) + 15;
								this._trans_group.addShip(es[j]);
								es[j].group = this._trans_group;
							}
						}
					}

					this._mfd.$updateMFD("IR_transport_clear", null, null, "Aletius Control");
					missionVariables.IR_transport_kill_count = 0;
				}
			}
		}

		if (system.ID == 23) { //Maenes
			//if (system.countShipsWithRole("IR-cannon-core") == 0) {
			//system.legacy_addShipsWithinRadius("IR-cannon-core", 40, "pwm", [23038, -39901, 102398], 20000);
			//system.addShips("IR-cannon-core", 40, Vector3D(23038, -39901, 102398).fromCoordinateSystem("pwm"), 20000);
			//system.legacy_addShipsWithinRadius("IR-cannon-core", 10, "pwm", [23038, -39901, 102398], 10000);
			//system.addShips("IR-cannon-core", 10, Vector3D(23038, -39901, 102398).fromCoordinateSystem("pwm"), 10000);
			//}

			if (missionVariables.IR_defences_quest == "DEMO_1") {
				if (system.countShipsWithRole("IR-target-drone") == 0) {
					//system.legacy_addShipsAtPrecisely("IR-target-drone", 10, "pwm", [52000, -35898, 84329]);
					system.addShips("IR-target-drone", 10, Vector3D(52000, -35898, 84329).fromCoordinateSystem("pwm"));
					this._mfd.$updateMFD("IR_gecko_drones", null, null, expandMissionText("IR_ruiz_key"));
					missionVariables.IR_defences_kill_count = 0;
					worldScripts["IR-defences.js"].incrementDefencesStatus();
				}
			}

			if (missionVariables.IR_defences_quest == "DEMO_5") {
				if (system.countShipsWithRole("IR-target-drone") == 0) {
					//system.legacy_addShipsAtPrecisely("IR-target-drone", 10, "pwm", [52000, -35898, 84329]);
					system.addShips("IR-target-drone", 10, Vector3D(52000, -35898, 84329).fromCoordinateSystem("pwm"));
					this._mfd.$updateMFD("IR_gecko_drones_2", null, null, expandMissionText("IR_ruiz_key"));
				}
			}

			if (missionVariables.IR_status == "IR_LOA_5") {
				if (system.countShipsWithRole("IR-cherkasova") == 0) {
					//system.legacy_addSystemShips("IR-cherkasova", 1, 1.0);
					//system.legacy_addSystemShips("IR-sdf-imperator", 1, 0.9);
					//system.legacy_addSystemShips("IR-sdf-transporter", 8, 0.9);
					this.$addSystemShips("IR-cherkasova", 1, 1.0);
					this.$addSystemShips("IR-sdf-imperator", 1, 0.9);
					this.$addSystemShips("IR-sdf-transporter", 8, 0.9);
					missionVariables.IR_lander_kill_count = 0;
					var cannons = system.shipsWithRole("IR-cannon-core");
					for (var i = 0; i < cannons.length; i++) {
						cannons[i].setAI("IR-dumb-cannonAI.plist");
					}

					if (!this.MaenesTimer) {
						missionVariables.IR_count = 0;
						this.MaenesTimer = new Timer(this, this.MaenesReply, null, 1);
					} else {
						this.MaenesTimer.start();
					}
				}
			}
		}

		if (system.ID == 119) { //Laxesori
			if (missionVariables.IR_status == "IR_LEXICON_4") {
				if (system.countShipsWithRole("IR-weiss-shuttle") == 0) {
					//system.legacy_addSystemShips("IR-weiss-shuttle", 1, 1.0);
					//system.legacy_addSystemShips("IR-kinnaird", 1, 1.0);
					//system.legacy_addSystemShips("police", 5, 1.0);
					//system.legacy_addSystemShips("pirate", 10, 1.0);
					this.$addSystemShips("IR-weiss-shuttle", 1, 1.0);
					this.$addSystemShips("IR-kinnaird", 1, 1.0);
					this.$addSystemShips("police", 5, 1.0);
					this.$addSystemShips("pirate", 10, 1.0);
				}
			}
		}

		if (system.ID == 240) { //Pirate cove
			if (missionVariables.IR_status == "IR_LOA_2") {
				if (system.countShipsWithRole("IR-starstrike") == 0) {
					var pos240 = this.$systemShipsPosition(1.0);

					//system.legacy_addSystemShips("IR-starstrike", 5, 1.0);
					//system.legacy_addSystemShips("IR-anarchypython", 10, 1.0);
					//system.legacy_addSystemShips("IR-cherkasova", 1, 1.0);
					//system.legacy_addSystemShips("IR-comray", 10, 1.0);
					//system.legacy_addSystemShips("IR-giantray", 1, 1.0);
					this.$addSystemShips("IR-starstrike", 5, 1.0);
					//this.$addSystemShips("IR-anarchypython", 10, 1.0); // don't need this here, as they're spawned in system populator

					// remove the original pythons
					var pythons = system.shipsWithRole("IR-anarchypython");
					for (var i = 0; i < pythons.length; i++) {
						pythons[i].remove(true);
					}
					// replace with pythons that have escorts
					this._pirate_group = system.addGroup("IR-anarchypython-alt", 10, pos240, 5000);
					// add beacons to all the pythons
					var pythonCount = 0;
					for (var i = 0; i < this._pirate_group.ships.length; i++) {
						if (this._pirate_group.ships[i].dataKey == "IR-anarchypython-alt") {
							this._pirate_group.ships[i].beaconCode = "P";
							this._pirate_group.ships[i].beaconLabel = expandMissionText("IR_anarchist_name");
							this._pirate_group.ships[i].bounty = 50; // make sure these ships are flagged as pirates
							pythonCount += 1;
						}
						// make the first ship the leader
						if (i == 0) this._pirate_group.leader = this._pirate_group.ships[i];
						// make sure all the escorts have bounties
						if (this._pirate_group.ships[i].escorts.length > 0) {
							var es = this._pirate_group.ships[i].escorts;
							for (var j = 0; j < es.length; j++) {
								if (es[j].bounty == 0) es[j].bounty = Math.floor(Math.random() * 30) + 15;
								this._pirate_group.addShip(es[j]);
								es[j].group = this._pirate_group;
							}
						}
					}
					// set the maximum count for the pythons (in case some have been destroyed before we get to this point)
					missionVariables.IR_pythonCount_max = pythonCount;

					this.$addSystemShips("IR-cherkasova", 1, 1.0);
					this.$addSystemShips("IR-comray", 10, 1.0);
					this.$addSystemShips("IR-giantray", 1, 1.0);
					this._mfd.$updateMFD("IR_python_cruisers", null, null, expandMissionText("IR_cherkasova_key"));
					//system.legacy_addSystemShips("pirate", 10, 1.0);
					//var pirates = this.$addSystemShips("pirate", 10, 1.0);
					/*for (var i = 0; i < pirates.length; i++) {
						pirates[i].setAI("IR-piratepatrolAI.plist");
						pirates[i].bounty = 100;
						this._pirate_group.addShip(pirates[i]);
						for (var j = 0; j < pirates[i].escorts.length; j++) {
							this._pirate_group.addShips(pirates[i].escorts[j]);
						}
					}*/
				}
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipExitedWitchspace = function () {
	missionVariables.IR_comms = null;
	var p = player.ship;

	if (galaxyNumber == 7) {
		if (missionVariables.IR_finance_quest == "WIFE_IDENTIFIED")
			missionVariables.IR_finance_quest = "WIFE";

		if (system.ID == 142) { // Tibiri
			if (missionVariables.IR_finance_quest == "WIFE")
				this.$addSystemShips("IR-isabella", 1, 0.8);
			//system.legacy_addSystemShips("IR-isabella", 1, 0.8);
		}

		if (missionVariables.IR_shipment_quest == "ENROUTE") {
			missionVariables.IR_shipment_quest = "AMBUSH";
			missionVariables.IR_convoy_exited = null;
			missionVariables.IR_transport_kill_count = 0;
		}

		if (missionVariables.IR_shipment_quest == "AMBUSH" && !missionVariables.IR_alsto) {
			++missionVariables.IR_jumpcount;
			if (missionVariables.IR_jumpcount > 1) {
				missionVariables.IR_shipment_quest = "DISPATCHED";
				missionVariables.IR_jumpcount = null;
			}
		}

		if (missionVariables.IR_shipment_quest == "ATMALA")
			missionVariables.IR_shipment_quest = "DISPATCHED";

		if (missionVariables.IR_loan_deadline) {
			if (missionVariables.IR_loan_deadline > clock.days) {
				missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days;
				this._setInstructionsKey("IR_loan_amount");
			} else
				this._setInstructionsKey("IR_loan_due");
		}

		if (system.ID == 112) { //Atmala
			if (missionVariables.IR_shipment_quest == "AMBUSH") {
				mission.unmarkSystem({ name: this.name, system: system.ID });
				//system.legacy_addShipsAt("IR-transport-alternate", 4, "wpu", [0, 0, 0.1]);
				system.addShips("IR-transport-alternate", 4, Vector3D(0, 0, 0.1).fromCoordinateSystem("wpu"));
				//system.legacy_addShipsAt("IR-sdf-asp", 4, "wpu", [0, 0, 0.1]);
				system.addShips("IR-sdf-asp", 4, Vector3D(0, 0, 0.1).fromCoordinateSystem("wpu"));
				missionVariables.IR_transport_kill_count = 0;
				missionVariables.IR_comms = null;
				missionVariables.IR_shipment_quest = "ATMALA";

				if (missionVariables.IR_alsto == "INFORMED") {
					this._mfd.$updateMFD("IR_prepare_ambush", null, null, expandMissionText("IR_abonlo_name"));
					//system.legacy_addShipsAt("pirate", 40, "wpu", [0, 0, 0.6]);
					var pirates = system.addShips("pirate", 40, Vector3D(0, 0, 0.6).fromCoordinateSystem("wpu"));
					//var pirates = system.shipsWithRole("pirate");
					for (var i = 0; i < pirates.length; i++) {
						pirates[i].setAI("IR-pirateAI.plist");
					}
				}
			}
		}

		if (missionVariables.IR_shipment_quest == "COMPLETED" || missionVariables.IR_shipment_quest == "TIPPEDOFF") {
			var randomNumber = Math.random();
			if (randomNumber < 0.5) {
				//system.legacy_addSystemShips("IR-sdf-asp", 3, 0.1);
				this.$addSystemShips("IR-sdf-asp", 3, 0.1);
				var sdf = system.shipsWithRole("IR-sdf-asp");
				for (var i = 0; i < sdf.length; i++) {
					sdf[i].setAI("pirateAI.plist");
				}
			}
		}

		if (system.ID == 23) { // Maenes
			if (missionVariables.IR_status == "IR_LOA_5") {
				if (system.countShipsWithRole("IR-cherkasova") == 0) {
					//system.legacy_addSystemShips("IR-cherkasova", 1, 0.85);
					//system.legacy_addSystemShips("IR-sdf-imperator", 1, 0.85);
					//system.legacy_addSystemShips("IR-sdf-transporter", 8, 0.85);
					this.$addSystemShips("IR-cherkasova", 1, 0.85);
					this.$addSystemShips("IR-sdf-imperator", 1, 0.85);
					this.$addSystemShips("IR-sdf-transporter", 8, 0.85);

					missionVariables.IR_lander_kill_count = 0;
					var cannons = system.shipsWithRole("IR-cannon-core");
					for (var i = 0; i < cannons.length; i++) {
						cannons[i].setAI("IR-dumb-cannonAI.plist");
					}
					if (!this.MaenesTimer) {
						missionVariables.IR_count = 0;
						this.MaenesTimer = new Timer(this, this.MaenesReply, null, 1);
					} else {
						this.MaenesTimer.start();
					}
				}
			}
		}

		if (missionVariables.IR_status == "IR_WEISS_2a") {
			missionVariables.IR_status = "IR_WEISS_2b";
		}

		if (system.ID == 175) { //Reenaten
			if (missionVariables.IR_status == "IR_WEISS_2b") {
				var weiss = system.shipsWithRole("IR-quico-transporter")[0];
				weiss.remove();
				p.spawn("IR-quico-transporter", 1);
			}
		}

		if (system.ID == 119) { //Laxesori
			if (missionVariables.IR_status == "IR_WEISS_3") {
				var weiss = system.shipsWithRole("IR-quico-transporter")[0];
				weiss.remove();

				if (!this.LaxesoriTimer) {
					this.LaxesoriTimer = new Timer(this, this.LaxesoriReply, 10, 0);
				} else {
					this.LaxesoriTimer.start();
				}
			}
		}

		if (system.ID == 130 && missionVariables.IR_status == "IR_sources_4") { //Tiatza
			mission.unmarkSystem({ name: this.name, system: 130 });
			missionVariables.IR_tanker_kill_count = 0;
			p.spawn("IR-cherkasova", 1);

			if (!this.JulietTimer) {
				missionVariables.IR_count = 0;
				this.JulietTimer = new Timer(this, this.JulietReply, null, 1);
			} else {
				this.JulietTimer.start();
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipEnteredStationAegis = function () {
	if (system.ID == 31 && missionVariables.IR_SDF_quest == "KORSHKOV" && galaxyNumber == 7) {
		this._mfd.$updateMFD("IR_radiation_damage");
		if (!this.KorshkovTimer) {
			this.KorshkovTimer = new Timer(this, this.KorshkovReply, null, 10);
		} else {
			this.KorshkovTimer.start();
		}
	}

	if (system.ID == 23 && missionVariables.IR_status == "IR_WEISS_1" && galaxyNumber == 7) {
		if (system.countShipsWithRole("IR-quico-transporter") == 0) {
			//system.legacy_addSystemShips("IR-quico-transporter", 1, 1.0);
			this.$addSystemShips("IR-quico-transporter", 1, 1.0);
			this._mfd.$updateMFD("IR_transport_depart", null, null, "Quico Transporter");
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenEnded = function () {
	if (player.ship.hudHidden == true) player.ship.hudHidden = false;
}

//-------------------------------------------------------------------------------------------------------------
this.shipDockedWithStation = function (station) {
	this.addIRinterface();
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function () {
	if (missionVariables.IR_status == "IR_epilogue" && clock.days > missionVariables.IR_epilogue_deadline) {
		this._runScreen({ messageKey: "IR_final", choicesKey: "IR_continue" }, function (choice) {
			this._runScreen({ messageKey: "IR_theend" });
			this._setInstructionsKey(null);
			// we don't want to clear the variables by default, as it will generate errors when viewing the mission log.
			//this.clearIRMissionVariables();
			missionVariables.IR_status = "IR_completed";
		});
	}

	if (player.ship.docked && galaxyNumber == 7) this.missionScreens();
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenChanged = function (to, from) {
	var p = player.ship;
	if (p.docked && p.dockedStation.hasRole("IR-luft-core")) {
		var invalid = ["GUI_SCREEN_EQUIP_SHIP", "GUI_SCREEN_SHIPYARD", "GUI_SCREEN_MARKET", "GUI_SCREEN_MARKETINFO"];
		if (invalid.indexOf(to) >= 0) {
			mission.runScreen({
				screenID: "iron-raven",
				titleKey: "IR-invalid",
				messageKey: "IR-not-available",
				overlay: { name: "IR_noentry.png", height: 546 },
				exitScreen: "GUI_SCREEN_STATUS",
			});
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipTargetAcquired = function (target) {
	var p = player.ship;

	if (missionVariables.IR_finance_quest == "WIFE") {
		var isabella = system.shipsWithRole("IR-isabella")[0];
		if (p.target == isabella) {
			this._mfd.$updateMFD("IR_wife_identified");
			missionVariables.IR_finance_quest = "WIFE_IDENTIFIED";
		}
	}

	if (missionVariables.IR_shipment_quest == "ENROUTE" && missionVariables.IR_alsto == "HELP_ACCEPTED") {
		var transport = system.shipsWithRole("IR-transport")[0];
		if (p.target == transport && !missionVariables.IR_comms) {
			this._mfd.$updateMFD("IR_transport_identified");
			missionVariables.IR_comms = "TRUE";
		}
	}

	if (missionVariables.IR_shipment_quest == "AMBUSH") {
		var transport = system.shipsWithRole("IR-transport-alternate")[0];
		if (p.target == transport && !missionVariables.IR_comms) {
			missionVariables.IR_comms = "TRUE";

			if (missionVariables.IR_alsto == "INFORMED")
				this._mfd.$updateMFD("IR_ambush_abonlo", null, null, expandMissionText("IR_abonlo_name"));
			else
				this._mfd.$updateMFD("IR_ambush_solo");
		}
	}

	var krait = system.shipsWithRole("IR-krait")[0];
	if (p.target == krait && !missionVariables.IR_comms) {
		if (missionVariables.IR_SDF_quest == "KRAIT") {
			this._mfd.$updateMFD("IR_krait_seen");
			krait.reactToAIMessage("PREPARE_JUMP");
			missionVariables.IR_comms = "TRUE";
		}

		if (missionVariables.IR_SDF_quest == "JUMPED") {
			this._mfd.$updateMFD("IR_krait_seen2");
			krait.reactToAIMessage("PREPARE_EJECT");
			missionVariables.IR_SDF_quest_location = system.ID;
			missionVariables.IR_SDF_quest_location_name = System.infoForSystem(7, [missionVariables.IR_SDF_quest_location]).name;
			missionVariables.IR_comms = "TRUE";
		}
	}

	var weiss = system.shipsWithRole("IR-quico-transporter")[0];
	if (p.target == weiss && !missionVariables.IR_comms) {
		if (missionVariables.IR_status == "IR_WEISS_1") {
			this._mfd.$updateMFD("IR_follow_weiss");
			weiss.reactToAIMessage("HEAD_FOR_AEGIS");
			missionVariables.IR_comms = "TRUE";
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipBeingAttacked = function () {
	if (missionVariables.IR_defences_quest == "DEPLOYED") {
		if (!this.DefencesTimer) {
			player.ship.fuelLeakRate = 15;
			this._mfd.$updateMFD("IR_help_attacked");
			missionVariables.IR_count = 70;
			this.DefencesTimer = new Timer(this, this.DefencesReply, null, 1);
		}
		else {
			this.DefencesTimer.start();
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtNewShip = function () {
	if (missionVariables.IR_shipment_quest == "TIPPEDOFF")
		missionVariables.IR_shipment_quest = null;
}

//-------------------------------------------------------------------------------------------------------------
this.playerJumpFailed = function () {
	if (missionVariables.IR_status == "IR_IBANEZ_5") {
		if (system.shipsWithRole("IR-cherkasova-alt") != 0) {
			var cherkasova = system.shipsWithRole("IR-cherkasova-alt")[0];
			cherkasova.setAI("IR-cherkasova-enterAI.plist");
			missionVariables.IR_status = "IR_CHERKASOVA_1";
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function () {
	if (missionVariables.offering) missionVariables.offering = null;
	if (missionVariables.IR_status == "IR_CHERKASOVA_1") {
		if (system.shipsWithRole("IR-cherkasova-alt") != 0) {
			var cherkasova = system.shipsWithRole("IR-cherkasova-alt")[0];
			cherkasova.remove();
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.addIRinterface = function () {
	player.ship.dockedStation.setInterface("IR_log", {
		title: expandMissionText("IR_mission_log_title"),
		category: expandMissionText("IR_mission_log_category"),
		summary: expandMissionText("IR_mission_log_summary"),
		callback: this.showIRlog.bind(this)
	});

	if (missionVariables.IR_status == "IR_IBANEZ_4") {
		var scrTitle = "";
		switch (system.ID) {
			case 23: scrTitle = "IR_revisit_quico"; break;
			case 171: scrTitle = "IR_revisit_yoko"; break;
			case 232: scrTitle = "IR_revisit_janes"; break;
			case 240: scrTitle = "IR_revisit_spacebar"; break;
			case 119: scrTitle = "IR_revisit_pw"; break;
			case 180: scrTitle = "IR_revisit_nwe"; break;
			case 219: scrTitle = "IR_revisit_gse"; break;
			case 31: scrTitle = "IR_revisit_okb"; break;
		}
		if (scrTitle == "") return;
		player.ship.dockedStation.setInterface("IR_questions", {
			title: expandMissionText(scrTitle),
			category: expandMissionText("IR_mission_log_category"),
			summary: expandMissionText("IR_mission_revisit_summary"),
			callback: this.questionScreens.bind(this)
		});
	}
}

//-------------------------------------------------------------------------------------------------------------
this.questionScreens = function () {
	if (system.ID == 23) { // Maenes
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this.$addPadCharacter("ruiz");
			this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_MAENES_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_MAENES_QUESTIONS";
		}
	}

	if (system.ID == 171) { // Yokohama
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS";
		}
	}

	if (system.ID == 232) { //Janes
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this._runScreen({ title: expandMissionText("IR_name_janes"), messageKey: "IR_JANES_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_JANES_QUESTIONS";
		}
	}

	if (system.ID == 240) { // Edzaar Pirate Cove
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this.$addPadCharacter("abonlo");
			if (!missionVariables.IR_alsto) {
				this._runScreen({ title: " ", messageKey: "IR_PIRATE_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_PIRATE_QUESTIONS";
				missionVariables.IR_alsto = "MET";
			} else {
				this._runScreen({ title: " ", messageKey: "IR_PIRATE_intro_alt", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_PIRATE_QUESTIONS";
			}
		}
	}

	if (system.ID == 119) { // PleasureWorld
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this._runScreen({ title: expandMissionText("IR_name_pw"), messageKey: "IR_PW_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_PW_QUESTIONS";
		}
	}

	if (system.ID == 180) { // NWE
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this.$addPadCharacter("nash");
			this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_NWE_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_NWE_QUESTIONS";
		}
	}

	if (system.ID == 219) { // GSE
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this.$addPadCharacter("tobias");
			this._runScreen({ screenID: "IR_gse", title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_GSE_QUESTIONS";
		}
	}

	if (system.ID == 31) { // KORSHKOV
		if (missionVariables.IR_status == "IR_IBANEZ_4") {
			this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_KORSHKOV_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
			missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS";
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.showIRlog = function () {
	//need to do length - 2 to get the number of the latest array element, as first element is actually [0] and the last element is a blank 
	this.IRlogArray = missionVariables.IR_screen_log.split(",");
	this.IRlocationArray = missionVariables.IR_screen_location.split(",");
	this.IRlogArrayTotal = this.IRlogArray.length - 1;
	this.logCounter = this.IRlogArray.length - 1;

	this.showIRlogPage();
}

//-------------------------------------------------------------------------------------------------------------
this.showIRlogPage = function () {
	var overlay = this._overlays[this.IRlogArray[this.logCounter - 1]];
	var text = expandMissionText(this.IRlogArray[this.logCounter - 1], { drawline: this._line });
	if (text.indexOf("{") >= 0) {
		text = this._formatText(text);
	}

	var scrn = {
		screenID: "IR_mission_log",
		title: expandMissionText("IR_log_title", { location: this.IRlocationArray[this.logCounter - 1], entry: this.logCounter, total: this.IRlogArrayTotal }),
		message: text,
		exitScreen: "GUI_SCREEN_INTERFACES",
		initialChoicesKey: this._defaultSelection,
		choicesKey: "IR_log_choices"
	}
	if (overlay) scrn.overlay = overlay;
	mission.runScreen(scrn, this.logChoices);
}

//-------------------------------------------------------------------------------------------------------------
this.logChoices = function (choice) {
	if (choice == 1) {
		this._defaultSelection = "1";
		if (this.logCounter != 1) --this.logCounter;
	}

	if (choice == 2) {
		this._defaultSelection = "2";
		if (this.logCounter != this.IRlogArray.length - 1) ++this.logCounter;
	}

	if (choice != 3) this.showIRlogPage();
}

//-------------------------------------------------------------------------------------------------------------
this._runScreen = function (params, callback) {
	player.ship.hudHidden = true;

	if (params && !params.hasOwnProperty("screenID")) params.screenID = "iron_raven";

	// because we might need to pass in the screen-width line, we need to 
	// manually expand the mission text, rather than just relying on the key
	var mkey = "";
	if (params.hasOwnProperty("messageKey")) {
		mkey = params.messageKey;
		delete params.messageKey;
		params.message = expandMissionText(mkey, { drawline: this._line, spacerline: this._spacer });
		// look for special formatting codes
		if (params.message.indexOf("{") >= 0) {
			params.message = this._formatText(params.message);
		}
		// if no overlay has been provided, check if we have one in the central repository
		if (!params.hasOwnProperty("overlay")) {
			var overlay = this._overlays[mkey];
			if (overlay) params.overlay = overlay;
		}
	}

	if (callback)
		mission.runScreen(params, callback);
	else
		mission.runScreen(params);

	// check for cases we don't want to add to the log
	if (mkey == "") return;
	if (mkey == "IR_negative_answer" || mkey == "IR_no_more_answer") return;
	if (mkey.indexOf("intro") != -1) return;

	missionVariables.IR_screen_log = missionVariables.IR_screen_log + mkey + ",";
	missionVariables.IR_screen_location = missionVariables.IR_screen_location + system.name + ",";
}

//-------------------------------------------------------------------------------------------------------------
this._formatText = function (text) {
	var result = "";
	var lines = text.split("\n");
	for (var i = 0; i < lines.length; i++) {
		var line = lines[i];
		if (line.indexOf("{centre}") >= 0) {
			line = line.replace("{centre}", "");
			var len = defaultFont.measureString(line);
			var cen = (32 - len) / 2;
			line = this.$padTextRight(" ", cen) + line;
		}
		if (line.indexOf("{col:") >= 0) {
			var cols = line.split("|");
			line = "";
			for (var j = 0; j < cols.length; j++) {
				var right = true;
				var col = cols[j];
				var p1 = col.indexOf("{");
				var p2 = col.indexOf("}");
				var colText = col.slice(p1 + 1, p2);
				col = col.substring(p2 + 1, col.length);
				var wid = colText.split(":")[1];
				if (wid.indexOf("L") >= 0) {
					wid = wid.replace("L", "");
					right = false;
				}
				line += this.$padTextRight(col, parseInt(wid), !right);
			}
		}
		result += line + "\n";
	}
	return result;
}

//-------------------------------------------------------------------------------------------------------------
this._setInstructionsKey = function (instructionKey, src) {
	if (!src) src = this.name;

	if (instructionKey == null) {
		delete this._manifest[src];
	} else {
		var text = expandMissionText(instructionKey);
		// if we've been passed something in instructionKey, but the lookup for it is null - assume it's straight text
		if (instructionKey.length > 0 && text == null) text = instructionKey;
		this._manifest[src] = text;
	}

	var srcitems = Object.keys(this._manifest);
	if (srcitems.length == 0) {
		mission.setInstructions(null, this.name);
		return;
	}

	var final = [expandMissionText("IR_manifest_title")];
	for (var i = 0; i < srcitems.length; i++) {
		final.push(this._manifest[srcitems[i]]);
	}
	mission.setInstructions(final, this.name);
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreens = function () {
	var p = player.ship;

	if (p.dockedStation.hasRole("IR-luft-core")) {
		if (missionVariables.IR_SDF_quest == "JACOB" || missionVariables.IR_SDF_quest == "LUFTSLOTTE") {
			this._runScreen({ title: expandMissionText("IR_location_luftslotte"), messageKey: "IR_SDF_quest_4" });
			missionVariables.IR_SDF_quest = "KRAIT";
			return;
		}
	}

	// special cases: if planetfall in use, player needs to fly down to the surface.
	if (system.ID == 230) { // RAAED
		if (((!this._pf && p.dockedStation.isMainStation) || p.dockedStation.hasRole("planetFall2_mainSurface")) && missionVariables.IR_offer == null) {
			if (missionVariables.IR_status == "IR_IBANEZ_2") {
				mission.unmarkSystem({ name: this.name, system: 230 });
				this._runScreen({ messageKey: "IR_RAAED_1a", screenID: "iron_raven_special", overlay: "IR_forest.png", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_RAAED_1b", screenID: "iron_raven_special", overlay: "IR_forest.png", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ messageKey: "IR_RAAED_1c", screenID: "iron_raven_special", overlay: "IR_forest.png", choicesKey: "IR_continue" }, function (choice) {
							this._runScreen({ messageKey: "IR_RAAED_1d", screenID: "iron_raven_special", overlay: "IR_forest.png", choicesKey: "IR_continue" }, function (choice) {
								this.$addPadCharacter("lexicon");
								this._runScreen({ messageKey: "IR_RAAED_1e", screenID: "iron_raven_special", overlay: "IR_forest.png" });
								missionVariables.IR_status = "IR_RAAED_1";
								this._setInstructionsKey("IR_IBANEZ_INFO");
								mission.markSystem({ name: this.name, system: 7 });
							});
						});
					});
				});
				return;
			}
		}
	}

	if (p.dockedStation.isMainStation && missionVariables.IR_offer == null) {
		if (missionVariables.IR_status == null) {
			this._runScreen({ overlay: { name: "IR_title.png", height: 546 }, choicesKey: "IR_continue" }, function (choice) {
				this._runScreen({ messageKey: "IR_IBANEZ_1" });
				this._setInstructionsKey("IR_IBANEZ_INFO");
				mission.markSystem({ name: this.name, system: 7 });
				missionVariables.IR_status = "IR_IBANEZ_1";
				missionVariables.IR_order_date = clock.days - 30;
				this.$addDataToPad("GALCOP.INTELLIGENCE");
				this.$addDataToPad("INFOS.GHC");
				this.$addDataToPad("SYSTEMS.VEGEDIUS");
			});
			return;
		}

		if (missionVariables.IR_finance_quest == "REPROCESSED" && clock.days >= missionVariables.IR_KORSHKOV_deadline) { //this is 20 days
			this._runScreen({ title: expandMissionText("IR_name_janes"), messageKey: "IR_finance_quest_4" });
			missionVariables.IR_finance_quest = "JANES_NEWS";
			missionVariables.IR_KORSHKOV_deadline = null;
			worldScripts["IR-finance.js"].incrementFinanceStatus();
			return;
		}

		if (missionVariables.IR_SDF_quest == "ADDRESS" && clock.days >= missionVariables.IR_SDF_deadline) {
			this._runScreen({ messageKey: "IR_SDF_quest_2" });
			missionVariables.IR_SDF_quest = "JACOB";
			worldScripts["IR-SDF.js"].incrementSDFStatus();
			return;
		}

		if (missionVariables.IR_SDF_quest == "POD_SCOOPED") {
			this._runScreen({ messageKey: "IR_SDF_quest_5" });
			player.ship.useSpecialCargo(expandMissionText("IR_fuel_sample_warning"));
			missionVariables.IR_SDF_quest = "KORSHKOV";
			worldScripts["IR-SDF.js"].incrementSDFStatus();
			return;
		}

		if (missionVariables.IR_SDF_quest == "PHOTO" && clock.days >= missionVariables.IR_SDF_deadline) {
			this._runScreen({ messageKey: "IR_SDF_quest_8a", choicesKey: "IR_continue" }, function (choice) {
				this._runScreen({ messageKey: "IR_SDF_quest_8b", choicesKey: "IR_continue" }, function (choice) {
					missionVariables.IR_SDF_quest = "COMPLETED";
					worldScripts["IR-SDF.js"].clearSDFStatus();
					missionVariables.IR_SDF_status_no = null;
					missionVariables.IR_SDF_deadline = null;
					++missionVariables.IR_quest_count;
					this.$addPadCharacter("kinnaird");
					this._runScreen({ messageKey: "IR_SDF_quest_8c" });
				});
			});
			return;
		}

		if (missionVariables.IR_finance_quest == "WAIT3" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
			this._runScreen({ title: " ", messageKey: "IR_finance_quest_10" });
			missionVariables.IR_KORSHKOV_deadline = null;
			worldScripts["IR-finance.js"].clearFinanceStatus();
			missionVariables.IR_finance_status_no = null;
			missionVariables.IR_finance_quest = "COMPLETED";
			++missionVariables.IR_quest_count;
			return;
		}

		if (missionVariables.IR_shipment_quest == "SUCCESS") {
			this._runScreen({ messageKey: "IR_shipment_success" });
			worldScripts["IR-shipment.js"].clearShipmentStatus();
			missionVariables.IR_shipment_status_no = null;
			missionVariables.IR_shipment_quest = "COMPLETED";
			missionVariables.IR_YOKOHAMA_deadline = null;
			++missionVariables.IR_quest_count;
			missionVariables.IR_tipoff_deadline = clock.days + 10;
			return;
		}

		if (missionVariables.IR_shipment_quest == "DISPATCHED") {
			this._runScreen({ messageKey: "IR_shipment_failure" });
			worldScripts["IR-shipment.js"].clearShipmentStatus();
			missionVariables.IR_shipment_status_no = null;
			missionVariables.IR_shipment_quest = "FAILED";
			++missionVariables.IR_quest_count;
			missionVariables.IR_YOKOHAMA_deadline = null;
			return;
		}

		if (missionVariables.IR_shipment_quest == "COMPLETED") {
			if (clock.days >= missionVariables.IR_tipoff_deadline) {
				this._runScreen({ messageKey: "IR_tipoff" });
				missionVariables.IR_tipoff_deadline = null;
				missionVariables.IR_shipment_quest = "TIPPEDOFF";
				return;
			}
		}

		if (missionVariables.IR_loan_deadline) {
			if (clock.days >= missionVariables.IR_loan_deadline) {
				this._runScreen({ title: expandMissionText("IR_name_fgb"), messageKey: "IR_GSE_loan_warning" });
				this._setInstructionsKey(null);
				missionVariables.IR_loan_deadline = null;
				missionVariables.IR_load_remaining = null;
				player.credits -= 550000;
				missionVariables.IR_GSE_loan = "DEFAULTED";
				return;
			}
		}

		if (missionVariables.IR_defences_quest == "DEMO_6" && clock.days > missionVariables.IR_defences_quest_deadline) {
			this.$addPadCharacter("weiss");
			this._runScreen({ messageKey: "IR_defences_quest_6" });
			++missionVariables.IR_quest_count;
			missionVariables.IR_defences_quest = "COMPLETED";
			missionVariables.IR_defences_quest_deadline = null;
			missionVariables.IR_defences_status_no = null;
			worldScripts["IR-defences.js"].clearDefencesStatus();
			return;
		}

		if (missionVariables.IR_status == "IR_KINNAIRD_2" && system.ID != 35 && system.ID != 41 && missionVariables.IR_onceOnly != "TRUE") {
			missionVariables.IR_onceOnly = "TRUE";
			missionVariables.IR_saved_location_1 = system.name;
			this._runScreen({ messageKey: "IR_kinnaird_3alt" });
			return;
		}

		if (missionVariables.IR_status == "IR_LEXICON_1" && clock.days > missionVariables.IR_LEXICON_deadline) {
			missionVariables.IR_saved_location_2 = system.name;
			this._runScreen({ messageKey: "IR_LEXICON_2" });
			missionVariables.IR_status = "IR_LEXICON_2";
			this._setInstructionsKey("IR_LEXICON_brief_2");
			mission.markSystem({ name: this.name, system: 119 });
			missionVariables.IR_LEXICON_deadline = null;
			return;
		}

		if (missionVariables.IR_status == "IR_CHERKASOVA_1") { // briefing with Cherkasova
			missionVariables.IR_saved_location_3 = system.name;
			this._runScreen({ messageKey: "IR_CHERKASOVA_1a", choicesKey: "IR_continue" }, function (choice) {
				this._runScreen({ messageKey: "IR_CHERKASOVA_1b", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_CHERKASOVA_1c", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ messageKey: "IR_CHERKASOVA_1d", choicesKey: "IR_cherkasova_choices" }, function (choice) {
							this.$addPadCharacter("cherkasova");
							if (choice == 1) {
								this._runScreen({ messageKey: "IR_LOA_1" });
								this._setInstructionsKey("IR_LOA_brief_1");
								mission.markSystem({ name: this.name, system: 240 });
								missionVariables.IR_status = "IR_LOA_1";
								missionVariables.IR_cherkasova_deadline = null;
							}
							if (choice == 2) {
								this._runScreen({ messageKey: "IR_sources_1" }); //screen fails to run
								this._setInstructionsKey("IR_LEXICON_brief_1");
								missionVariables.IR_status = "IR_sources_1";
								missionVariables.IR_cherkasova_deadline = null;
								missionVariables.IR_sources_deadline = clock.days + 15;
							}
						});
					});
				});
			});
		}

		if (missionVariables.IR_status == "IR_sources_1" && clock.days > missionVariables.IR_sources_deadline) {
			this._runScreen({ messageKey: "IR_sources_2" });
			missionVariables.IR_status = "IR_sources_2";
			this._setInstructionsKey("IR_waitforinfo_brief");
			missionVariables.IR_sources_deadline = clock.days + 7;
		}

		if (missionVariables.IR_status == "IR_sources_2" && clock.days > missionVariables.IR_sources_deadline) {
			missionVariables.IR_saved_location_5 = system.name;
			this._runScreen({ messageKey: "IR_sources_3" });
			missionVariables.IR_status = "IR_sources_3";
			missionVariables.IR_sources_deadline = null;
			this._setInstructionsKey("IR_sources_brief_1");
			mission.markSystem({ name: this.name, system: 63 });
		}

		if (missionVariables.IR_status == "IR_LOA_4" && clock.days > missionVariables.IR_attack_deadline) {
			missionVariables.IR_saved_location_4 = system.name;
			this._runScreen({ messageKey: "IR_LOA_5" });
			missionVariables.IR_status = "IR_LOA_5";
			missionVariables.IR_attack_deadline = null;
			this._setInstructionsKey("IR_LOA_brief_4");
			mission.markSystem({name:"IR-main-script.js", system:23});
		}

		if (missionVariables.IR_status == "IR_LOA_7" && clock.days > missionVariables.IR_epilogue_deadline) {
			this._runScreen({ messageKey: "IR_LOA_7" });
			missionVariables.IR_status = "IR_LOA_8";
			missionVariables.IR_epilogue_deadline = clock.days + 10;
		}

		if (missionVariables.IR_status == "IR_LOA_8" && clock.days > missionVariables.IR_epilogue_deadline) {
			this._runScreen({ messageKey: "IR_LOA_8" });
			missionVariables.IR_status = "IR_LOA_9";
			missionVariables.IR_epilogue_deadline = clock.days + 7;
			return;
		}

		if (missionVariables.IR_status == "IR_LOA_9" && clock.days > missionVariables.IR_epilogue_deadline) {
			this._runScreen({ messageKey: "IR_invite" });
			missionVariables.IR_status = "IR_invite";
			this._setInstructionsKey("IR_invite_brief");
			mission.markSystem({ name: "IR-main-script.js", system: 7 });
			missionVariables.IR_epilogue_deadline = null;
			return;
		}

		if (missionVariables.IR_status == "IR_sources_6" && clock.days > missionVariables.IR_epilogue_deadline) {
			this._runScreen({ messageKey: "IR_sources_6" });
			missionVariables.IR_status = "IR_sources_7";
			missionVariables.IR_epilogue_deadline = clock.days + 15;
			return;
		}

		if (missionVariables.IR_status == "IR_sources_7" && clock.days > missionVariables.IR_epilogue_deadline) {
			this._runScreen({ messageKey: "IR_invite" });
			missionVariables.IR_status = "IR_invite";
			this._setInstructionsKey("IR_invite_brief");
			mission.markSystem({ name: "IR-main-script.js", system: 7 });
			missionVariables.IR_epilogue_deadline = null;
			return;
		}

		if (missionVariables.IR_convoy_exited == "TRUE" && missionVariables.IR_alsto == "HELP_ACCEPTED") {
			this._runScreen({ messageKey: "IR_shipment_contact_report" });
			worldScripts["IR-shipment.js"].incrementShipmentStatus();
			missionVariables.IR_alsto = "INFORMED";
			missionVariables.IR_convoy_exited = null;
			return;
		}

		//Location Specific
		if (system.ID == 7) { //Vegedius
			if (missionVariables.IR_status == "IR_IBANEZ_1") {
				mission.unmarkSystem({ name: this.name, system: 7 });

				this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_2a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_2b", choicesKey: "IR_continue" }, function (choice) {
						this.$addPadCharacter("ibanez");
						this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_2c" });
						missionVariables.IR_status = "IR_IBANEZ_2";
						if (this._pf) {
							this._setInstructionsKey("IR_RAAED_PF_INFO");
						} else {
							this._setInstructionsKey("IR_RAAED_INFO");
						}
						mission.markSystem({ name: this.name, system: 230 });
					});
				});
				return;
			}

			if (missionVariables.IR_status == "IR_RAAED_1") { //return to Ibanez
				mission.unmarkSystem({ name: this.name, system: 7 });

				this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_3" });
				missionVariables.IR_status = "IR_IBANEZ_3";
				this._setInstructionsKey("IR_JANES_INFO");
				mission.markSystem({ name: this.name, system: 232 });
				this.$addDataToPad("INFOS.JANES");
				this.$addDataToPad("SYSTEMS.BIRAA");
				return;
			}

			if (missionVariables.IR_status == "IR_JANES_1") { // return to Ibanez for big briefing
				mission.unmarkSystem({ name: this.name, system: 7 });

				this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_4a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_4b", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_4c", choicesKey: "IR_continue" }, function (choice) {
							this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_4d" });
							missionVariables.IR_status = "IR_IBANEZ_4";
							this._setInstructionsKey(null);
							this.setupQuestions();
							this.setupStatus();
							worldScripts["IR-brief.js"]._registerIRBrief();
							missionVariables.IR_quest_count = 0;
							this.addIRinterface();
						});
					});
				});
				return;
			}

			if (missionVariables.IR_status == "IR_IBANEZ_4" && missionVariables.IR_quest_count == 4) {
				missionVariables.IR_quest_count = null;

				if (missionVariables.IR_shipment_quest_method == "YOKOHAMA_AMBUSH") {
					this._runScreen({ messageKey: "IR_IBANEZ_5a", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ overlay: { name: "IR_title.png", height: 546 }, messageKey: "IR_theend" });
						missionVariables.IR_status = "IR_completed";
						this._setInstructionsKey(null);
						missionVariables.IR_epilogue_deadline = null;
						missionVariables.IR_shipment_quest = null;
						missionVariables.IR_SDF_quest = null;
						missionVariables.IR_defences_quest = null;
						missionVariables.IR_finance_quest = null;
						missionVariables.IR_shipment_quest_method = null;
					});
					return;
				}

				if (missionVariables.IR_shipment_quest == "FAILED") {
					this._runScreen({ messageKey: "IR_IBANEZ_5b", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ overlay: { name: "IR_title.png", height: 546 }, messageKey: "IR_theend" });
						missionVariables.IR_status = "IR_completed";
						this._setInstructionsKey(null);
						missionVariables.IR_epilogue_deadline = null;
						missionVariables.IR_shipment_quest = null;
						missionVariables.IR_SDF_quest = null;
						missionVariables.IR_defences_quest = null;
						missionVariables.IR_finance_quest = null;
						missionVariables.IR_shipment_quest_method = null;
					});
					return;
				} else {
					this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_5", choicesKey: "IR_IBANEZ_choices" }, function (choice) {
						if (choice == "IR_IBANEZ_A_weiss") {
							this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_weiss_1" });
							missionVariables.IR_status = "IR_WEISS_1";
							this._setInstructionsKey("IR_weiss_brief_1");
							mission.markSystem({ name: this.name, system: 23 });
						}
						if (choice == "IR_IBANEZ_B_kinnaird") {
							this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_kinnaird_1" });
							missionVariables.IR_status = "IR_KINNAIRD_1";
							this._setInstructionsKey("IR_kinnaird_brief_1");
							mission.markSystem({ name: this.name, system: 35 });
						}
						if (choice == "IR_IBANEZ_C_moreinfo") {
							this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_LEXICON_1" });
							missionVariables.IR_status = "IR_LEXICON_1";
							this._setInstructionsKey("IR_LEXICON_1");
							missionVariables.IR_LEXICON_deadline = clock.days + 15;
						}
					});
					return;
				}
			}

			if (missionVariables.IR_status == "IR_WEISS_4" || missionVariables.IR_status == "IR_KINNAIRD_4") {
				this._runScreen({ title: expandMissionText("IR_name_ghc"), messageKey: "IR_IBANEZ_5_debrief" });
				missionVariables.IR_status = "IR_IBANEZ_5";
				mission.unmarkSystem({ name: this.name, system: 7 });
				this._setInstructionsKey("IR_waitforinfo_brief");
				missionVariables.IR_cherkasova_deadline = clock.days + 20;
				return;
			}

			if (missionVariables.IR_status == "IR_invite" && clock.days > missionVariables.IR_epilogue_deadline) {
				this._runScreen({ messageKey: "IR_reward_a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_reward_b", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ messageKey: "IR_reward_c" }, function (choice) {
							this._runScreen({ messageKey: "IR_reward_d", choicesKey: "IR_continue" }, function (choice) {
								this._runScreen({ messageKey: "IR_reward_e" });
								missionVariables.IR_status = "IR_epilogue";
								missionVariables.IR_epilogue_deadline = clock.days + 5;
								player.credits += 50000;

								if (worldScripts.GalCopBB_Reputation) {
									var rep = worldScripts.GalCopBB_Reputation;
									rep.$addAward({
										title: expandMissionText("IR_award_medal_title"),
										entity: expandDescription("[gcm_reputation_galcop]"),
										worldScript: "IR-main-script.js",
										description: expandMissionText("IR_award_medal_info"),
										source: expandMissionText("IR_award_medal_planet"),
										galaxy: 7,
										received: clock.adjustedSeconds,
										image: {name: "IR_maenesmedal_centred.png", height:546}
									});
									rep.$adjustReputationForEntity(expandDescription("[gcm_reputation_galcop]"), system.ID, "Success", 3, 1);
								}

								this._setInstructionsKey(null);
							});
						});
					});
				});
				return;
			}
		}

		if (system.ID == 232) { // Janes (Biraa)
			if (missionVariables.IR_status == "IR_IBANEZ_3") { // quick visit to Janes
				mission.unmarkSystem({ name: this.name, system: 232 });
				this._runScreen({ messageKey: "IR_JANES_1a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_JANES_1b", choicesKey: "IR_continue" }, function (choice) {
						this.$addPadCharacter("lindberg");
						this._runScreen({ messageKey: "IR_JANES_1c" });
						missionVariables.IR_status = "IR_JANES_1";
						this._setInstructionsKey("IR_IBANEZ_INFO");
						mission.markSystem({ name: this.name, system: 7 });
					});
				});
				return;
			}

			if (missionVariables.IR_status == "IR_IBANEZ_4") {
				this._runScreen({ title: expandMissionText("IR_name_janes"), messageKey: "IR_JANES_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_JANES_QUESTIONS";
				return;
			}
		}

		if (system.ID == 171) { // Yokohama (Aletius)
			mission.unmarkSystem({ name: this.name, system: 171 });
			if (missionVariables.IR_status == "IR_IBANEZ_4") {
				this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS";
				return;
			}
		}

		if (system.ID == 240) { // Pirate Cove (Edzaar)
			mission.unmarkSystem({ name: this.name, system: 240 });
			if (missionVariables.IR_status == "IR_IBANEZ_4") {
				if (!missionVariables.IR_alsto) {
					this._runScreen({ title: " ", messageKey: "IR_PIRATE_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
					missionVariables.IR_offer = "IR_PIRATE_QUESTIONS";
					missionVariables.IR_alsto = "MET";
					this.$addPadCharacter("abonlo");
				} else {
					this._runScreen({ title: " ", messageKey: "IR_PIRATE_intro_alt", choicesKey: "IR_questions" }, this.choiceEvaluation);
					missionVariables.IR_offer = "IR_PIRATE_QUESTIONS";
				}
				return;
			}

			if (missionVariables.IR_status == "IR_LOA_1") {
				if (missionVariables.IR_alsto)
					missionVariables.IR_LOA_text = "known";
				if (missionVariables.IR_alsto == "INFORMED")
					missionVariables.IR_LOA_text = "helped";
				if (!missionVariables.IR_alsto) {
					missionVariables.IR_LOA_text = "unknown";
					this.$addPadCharacter("abonlo");
				}

				this._runScreen({ messageKey: "IR_LOA_" + [missionVariables.IR_LOA_text] + "_2a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_LOA_" + [missionVariables.IR_LOA_text] + "_2b", choicesKey: "IR_continue" }, function (choice) {
						this._runScreen({ messageKey: "IR_LOA_2c", choicesKey: "IR_continue" }, function (choice) {
							this._runScreen({ messageKey: "IR_LOA_2d" });
							missionVariables.IR_status = "IR_LOA_2";
							this._setInstructionsKey("IR_LOA_brief_2");
							missionVariables.IR_alsto = null;
							missionVariables.IR_LOA_text = null;
						});
					});
				});
				return;
			}
		}

		if (system.ID == 119) { // PleasureWorld (Laxesori)
			mission.unmarkSystem({ name: this.name, system: 119 });
			if (missionVariables.IR_status == "IR_IBANEZ_4") {
				this._runScreen({ title: expandMissionText("IR_name_pw"), messageKey: "IR_PW_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_PW_QUESTIONS";
				return;
			}

			if (missionVariables.IR_status == "IR_WEISS_3") {
				this._runScreen({ title: expandMissionText("IR_name_pw"), messageKey: "IR_weiss_3a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ overlay: "IR_pw_logo.png", messageKey: "IR_weiss_3b" });
					missionVariables.IR_status = "IR_WEISS_4";
					this._setInstructionsKey("IR_weiss_brief_3");
					mission.markSystem({ name: this.name, system: 7 });
				});
				return;
			}

			if (missionVariables.IR_status == "IR_KINNAIRD_3") {
				this._runScreen({ title: expandMissionText("IR_name_pw"), messageKey: "IR_kinnaird_4a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_kinnaird_4b" });
					missionVariables.IR_status = "IR_KINNAIRD_4";
					this._setInstructionsKey("IR_kinnaird_brief_4");
					mission.markSystem({ name: this.name, system: 7 });
				});
				return;
			}

			if (missionVariables.IR_status == "IR_LEXICON_2") {
				this._runScreen({ messageKey: "IR_LEXICON_3a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_LEXICON_3b", choicesKey: "IR_launch_choice" }, function (choice) {
						this._setInstructionsKey("IR_LEXICON_brief_3");
						mission.markSystem({ name: this.name, system: 119 });
						missionVariables.IR_status = "IR_LEXICON_4";
						p.launch();
					});
				});
				return;
			}

			if (missionVariables.IR_status == "IR_weiss_scooped") {
				this._runScreen({ messageKey: "IR_LEXICON_4a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_LEXICON_4b" });
					missionVariables.IR_status = "IR_IBANEZ_5";
					this._setInstructionsKey("IR_waitforinfo_brief");
					missionVariables.IR_cherkasova_deadline = clock.days + 20;
				});
				return;
			}
		}

		if (system.ID == 180) { // NWE (Arance)
			mission.unmarkSystem({ name: this.name, system: 180 });
			if (missionVariables.IR_status == "IR_IBANEZ_4") {
				this.$addPadCharacter("nash");
				this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_NWE_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_NWE_QUESTIONS";
				return;
			}

			if (missionVariables.IR_defences_quest == "DEMO_2") {
				this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_defences_quest_2a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_defences_quest_2b" });
					missionVariables.IR_defences_quest_deadline = clock.days + 7;
					missionVariables.IR_defences_quest = "DEMO_3";
					worldScripts["IR-defences.js"].incrementDefencesStatus();
				});
				return;
			}

			if (missionVariables.IR_defences_quest == "DEMO_3" && clock.days > missionVariables.IR_defences_quest_deadline) {
				this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_defences_quest_3" });
				missionVariables.IR_defences_quest_deadline = null;
				missionVariables.IR_defences_quest = "DEMO_4";
				worldScripts["IR-defences.js"].incrementDefencesStatus();
				return;
			}
		}

		if (system.ID == 82) { // Inorle
			mission.unmarkSystem({ name: this.name, system: 82 });
			if (missionVariables.IR_SDF_quest == "JACOB") {
				this._runScreen({ messageKey: "IR_SDF_quest_3" });
				missionVariables.IR_SDF_quest = "LUFTSLOTTE";
				return;
			}
		}

		if (system.ID == 219) { // GSE (Ustiza)
			mission.unmarkSystem({ name: this.name, system: 219 });
			if (missionVariables.IR_status == "IR_IBANEZ_4" && missionVariables.IR_finance_quest == null) {
				this.$addPadCharacter("tobias");
				this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_GSE_QUESTIONS";
				return;
			}

			if (missionVariables.IR_finance_quest == "JANES_NEWS") {
				this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_finance_quest_6a", choicesKey: "IR_continue" }, function (choice) {
					this.$addPadCharacter("isabella");
					this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_finance_quest_6b" });
					worldScripts["IR-finance.js"].incrementFinanceStatus();
					missionVariables.IR_offer = null;
					missionVariables.IR_finance_quest = "WIFE";
				});
				return;
			}

			if (missionVariables.IR_finance_quest == "WIFE_MET") {
				this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_finance_quest_8", choicesKey: "IR_wife_choices" }, function (choice) {
					if (choice == "IR_wife_yes") {
						this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_finance_quest_9_confirm" });
						missionVariables.IR_wife_status = "AFFAIR_CONFIRMED";
					}

					if (choice == "IR_wife_no") {
						this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_finance_quest_9_deny" });
						missionVariables.IR_wife_status = "AFFAIR_DENIED";
					}

					worldScripts["IR-finance.js"].incrementFinanceStatus()
					missionVariables.IR_finance_quest = "WAIT3";
					missionVariables.IR_KORSHKOV_deadline = clock.days + 10;
					missionVariables.IR_offer = null;
				});
				return;
			}
		}

		if (system.ID == 31) { // KORSHKOV (Aarzari)
			mission.unmarkSystem({ name: this.name, system: 31 });
			if (missionVariables.IR_finance_quest == "WAIT" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
				this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_finance_quest_1" });
				missionVariables.IR_cargo_radioactives = 10;
				missionVariables.IR_cargo_alloys = 5;
				missionVariables.IR_cargo_minerals = 2;
				missionVariables.IR_cargo_alien_items = 2;
				missionVariables.IR_cargo_platinum = 1;
				worldScripts["IR-finance.js"].incrementFinanceStatus();
				missionVariables.IR_finance_quest = "COLLECTION";
				missionVariables.IR_KORSHKOV_deadline = null;
				missionVariables.IR_onceOnly = "TRUE"; // so we don't go straight in the "You don't have the materials" message
				return;
			}

			if (missionVariables.IR_finance_quest == "COLLECTION") {
				// need to be able to do a part load?
				// because even if we store the cargo in storage, is has to be in the ship to be checked.
				this.checkManifest();

				if (missionVariables.IR_manifestOK == "PART" && missionVariables.IR_onceOnly != "TRUE") {
					missionVariables.IR_onceOnly = "TRUE";
					this._runScreen({ title: expandDescription("IR_name_okb"), messageKey: "IR_finance_quest_part", choicesKey: "IR_finance_part" }, function (choice) {
						if (choice == "IR_part_yes") {
							if (p.manifest.radioactives > 0 && missionVariables.IR_cargo_radioactives > 0) {
								var diff = p.manifest.radioactives - missionVariables.IR_cargo_radioactives;
								if (diff >= 0) {
									p.manifest.radioactives -= missionVariables.IR_cargo_radioactives;
									missionVariables.IR_cargo_radioactives = 0;
								} else {
									missionVariables.IR_cargo_radioactives -= p.manifest.radioactives;
									p.manifest.radioactives = 0;
								}
							}
							if (p.manifest.alloys > 0 && missionVariables.IR_cargo_alloys > 0) {
								var diff = p.manifest.alloys - missionVariables.IR_cargo_alloys;
								if (diff >= 0) {
									p.manifest.alloys -= missionVariables.IR_cargo_alloys;
									missionVariables.IR_cargo_alloys = 0;
								} else {
									missionVariables.IR_cargo_alloys -= p.manifest.alloys;
									p.manifest.alloys = 0;
								}
							}
							if (p.manifest.minerals > 0 && missionVariables.IR_cargo_minerals > 0) {
								var diff = p.manifest.minerals - missionVariables.IR_cargo_minerals;
								if (diff >= 0) {
									p.manifest.minerals -= missionVariables.IR_cargo_minerals;
									missionVariables.IR_cargo_minerals = 0;
								} else {
									missionVariables.IR_cargo_minerals -= p.manifest.minerals;
									p.manifest.minerals = 0;
								}
							}
							if (p.manifest.alien_items > 0 && missionVariables.IR_cargo_alien_items > 0) {
								var diff = p.manifest.alien_items - missionVariables.IR_cargo_alien_items;
								if (diff >= 0) {
									p.manifest.alien_items -= missionVariables.IR_cargo_alien_items;
									missionVariables.IR_cargo_alien_items = 0;
								} else {
									missionVariables.IR_cargo_alien_items -= p.manifest.alien_items;
									p.manifest.alien_items = 0;
								}
							}
							if (p.manifest.platinum > 0 && missionVariables.IR_cargo_platinum > 0) {
								var diff = p.manifest.platinum - missionVariables.IR_cargo_platinum;
								if (diff >= 0) {
									p.manifest.platinum -= missionVariables.IR_cargo_platinum;
									missionVariables.IR_cargo_platinum = 0;
								} else {
									missionVariables.IR_cargo_platinum -= p.manifest.platinum;
									p.manifest.platinum = 0;
								}
							}
							this._setInstructionsKey(worldScripts["IR-finance.js"].buildBrief2Instructions(), "IR-finance.js");
						}
						return;
					});
					return;
				}

				if (missionVariables.IR_manifestOK == "TRUE") {
					this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_finance_quest_2" });
					missionVariables.IR_KORSHKOV_deadline = clock.days + 10;
					worldScripts["IR-finance.js"].incrementFinanceStatus();
					missionVariables.IR_finance_quest = "WAIT2";
					p.manifest.radioactives -= missionVariables.IR_cargo_radioactives;
					p.manifest.alloys -= missionVariables.IR_cargo_alloys;
					p.manifest.minerals -= missionVariables.IR_cargo_minerals;
					p.manifest.alien_items -= missionVariables.IR_cargo_alien_items;
					p.manifest.platinum -= missionVariables.IR_cargo_platinum;
					missionVariables.IR_manifestOK = null;
					missionVariables.IR_cargo_radioactives = null;
					missionVariables.IR_cargo_alloys = null;
					missionVariables.IR_cargo_minerals = null;
					missionVariables.IR_cargo_alien_items = null;
					missionVariables.IR_cargo_platinum = null;
					return;
				}

				if (missionVariables.IR_manifestOK != "TRUE" && missionVariables.IR_manifestOK != "PART" && missionVariables.IR_onceOnly != "TRUE") {
					this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_finance_quest_3alt" });
					missionVariables.IR_onceOnly = "TRUE";
					return;
				}
				//else return;
			}

			if (missionVariables.IR_finance_quest == "WAIT2" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
				this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_finance_quest_3" });
				worldScripts["IR-finance.js"].incrementFinanceStatus();
				missionVariables.IR_KORSHKOV_deadline = null;
				missionVariables.IR_finance_quest = "IRRADIATE";
				return;
			}

			if (missionVariables.IR_SDF_quest == "KORSHKOV") {
				this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_SDF_quest_6" });
				worldScripts["IR-SDF.js"].incrementSDFStatus();
				missionVariables.IR_SDF_deadline = clock.days + 10;
				missionVariables.IR_SDF_quest = "ANALYSIS";
				p.removeAllCargo();
				missionVariables.IR_cargoCount = null;
				return;
			}

			if (missionVariables.IR_SDF_quest == "ANALYSIS" && clock.days >= missionVariables.IR_SDF_deadline) {
				this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_SDF_quest_7a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_SDF_quest_7b" });
					missionVariables.IR_SDF_quest = "DATA";
					worldScripts["IR-SDF.js"].incrementSDFStatus();
					this.incrementSDFQuestion();
				});
				return;
			}

			if (missionVariables.IR_status == "IR_IBANEZ_4") {
				this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_KORSHKOV_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS";
				return;
			}
		}

		if (system.ID == 142) { // Tibiri bar
			mission.unmarkSystem({ name: this.name, system: 142 });
			if (missionVariables.IR_finance_quest == "WIFE_DOCKED") {
				this._runScreen({ messageKey: "IR_finance_quest_7a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_finance_quest_7b" });
					worldScripts["IR-finance.js"].incrementFinanceStatus();
					player.credits += 1000;
					missionVariables.IR_offer = null;
					missionVariables.IR_finance_quest = "WIFE_MET";
				});
				return;
			}
			if ((missionVariables.IR_finance_quest == "WIFE" || missionVariables.IR_finance_quest == "WIFE_IDENTIFIED") && missionVariables.IR_onceOnly != "TRUE") {
				this._runScreen({ messageKey: "IR_finance_quest_7alt" });
				missionVariables.IR_onceOnly = "TRUE";
				return;
			}
		}

		if (system.ID == 23) { // Maenes
			mission.unmarkSystem({ name: this.name, system: 23 });
			if (missionVariables.IR_status == "IR_IBANEZ_4" && !missionVariables.IR_defences_quest) {
				this.$addPadCharacter("ruiz");
				this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_MAENES_intro", choicesKey: "IR_questions" }, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_MAENES_QUESTIONS";
				return;
			}

			if (missionVariables.IR_defences_question_no == 3 && !missionVariables.IR_defences_quest) {
				if (!missionVariables.IR_Maenes_visit) {
					this.$addPadCharacter("ruiz");
					this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_defences_quest_1_alt" });
					missionVariables.IR_defences_quest = "DEMO_1";
					this._setInstructionsKey("IR_defences_brief_1a", "IR-defences.js");
				}
				if (missionVariables.IR_Maenes_visit == "TRUE") {
					this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_defences_quest_1" });
					missionVariables.IR_defences_quest = "DEMO_1";
					this._setInstructionsKey("IR_defences_brief_1a", "IR-defences.js");
					missionVariables.IR_Maenes_visit = null;
				}
				return;
			}
			if (missionVariables.IR_defences_quest == "DEMO_4") {
				this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_defences_quest_4" });
				missionVariables.IR_defences_quest = "DEMO_5";
				return;
			}

			if (missionVariables.IR_defences_quest == "SABOTAGED") {
				this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_defences_quest_5a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_defences_quest_5b" });
					worldScripts["IR-defences.js"].incrementDefencesStatus();
					missionVariables.IR_defences_quest = "DEMO_6";
					missionVariables.IR_defences_quest_deadline = clock.days + 15;
				});
				return;
			}

			if (missionVariables.IR_status == "IR_sources_5") {
				this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_sources_5a", choicesKey: "IR_continue" }, function (choice) {
					this._runScreen({ messageKey: "IR_sources_5b" });
					this._setInstructionsKey("IR_waitforinfo_brief");
					missionVariables.IR_status = "IR_sources_6";
					missionVariables.IR_epilogue_deadline = clock.days + 10;
				});
				return;
			}

			if (missionVariables.IR_status == "IR_LOA_6") {
				this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_LOA_6" });
				this._setInstructionsKey("IR_waitforinfo_brief");
				missionVariables.IR_status = "IR_LOA_7";
				missionVariables.IR_epilogue_deadline = clock.days + 10;
				return;
			}
		}

		if (system.ID == 35 && missionVariables.IR_status == "IR_KINNAIRD_1") { //Atanon
			this._runScreen({ messageKey: "IR_kinnaird_2" });
			mission.unmarkSystem({ name: this.name, system: 35 });
			missionVariables.IR_status = "IR_KINNAIRD_2";
			return;
		}

		if (system.ID == 41 && missionVariables.IR_status == "IR_KINNAIRD_2") { //Orlaroor
			this._runScreen({ messageKey: "IR_kinnaird_3" });
			missionVariables.IR_status = "IR_KINNAIRD_3";
			this._setInstructionsKey("IR_kinnaird_brief_3");
			mission.markSystem({ name: this.name, system: 119 });
			return;
		}

		if (system.ID == 149 && missionVariables.IR_status == "IR_LOA_3") { //Arenxeon
			mission.unmarkSystem({ name: this.name, system: 149 });
			this._runScreen({ messageKey: "IR_LOA_4a", choicesKey: "IR_continue" }, function (choice) {
				this._runScreen({ messageKey: "IR_LOA_4b" });
				missionVariables.IR_status = "IR_LOA_4";
				missionVariables.IR_attack_deadline = clock.days + 10;
				this._setInstructionsKey("IR_waitforinfo_brief");
			});
			return;
		}

		if (system.ID == 63 && missionVariables.IR_status == "IR_sources_3") { //Edsoan
			mission.unmarkSystem({ name: this.name, system: 63 });
			this._runScreen({ messageKey: "IR_sources_4a", choicesKey: "IR_continue" }, function (choice) {
				this._runScreen({ messageKey: "IR_sources_4b" });
				missionVariables.IR_status = "IR_sources_4";
				this._setInstructionsKey("IR_sources_brief_2");
				mission.markSystem({ name: this.name, system: 130 });
			});
		}
		//keep brackets    
	}
}

//-------------------------------------------------------------------------------------------------------------
this.checkManifest = function () {
	var p = player.ship;
	var radioactivesAmount = p.manifest.radioactives;
	var alloysAmount = p.manifest.alloys;
	var mineralsAmount = p.manifest.minerals;
	var alienItemsAmount = p.manifest.alien_items; // 16.06.2020 Milo: changed from alienItems because Oolite v1.82 removed that alias
	var platinumAmount = p.manifest.platinum;

	if (alloysAmount >= missionVariables.IR_cargo_alloys &&
		mineralsAmount >= missionVariables.IR_cargo_minerals &&
		alienItemsAmount >= missionVariables.IR_cargo_alien_items &&
		radioactivesAmount >= missionVariables.IR_cargo_radioactives &&
		platinumAmount >= missionVariables.IR_cargo_platinum) {
		missionVariables.IR_manifestOK = "TRUE";
		return;
	}

	if (alloysAmount + mineralsAmount + alienItemsAmount + radioactivesAmount + platinumAmount > 0)
		missionVariables.IR_manifestOK = "PART";
}

//-------------------------------------------------------------------------------------------------------------
this.choiceEvaluation = function (choice) {
	switch (missionVariables.IR_offer) {
		case "IR_GSE_QUESTIONS":
			{
				if (choice == "IR_B_finance_question_key") {
					if (missionVariables.IR_finance_question_no == 1) {
						this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_finance_answer_1a", choicesKey: "IR_continue" }, function (choice) {
							this.incrementFinanceQuestion();
							this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_finance_answer_1b", choicesKey: "IR_questions" }, this.choiceEvaluation);
							missionVariables.IR_offer = "IR_GSE_QUESTIONS";
						});
						break;
					}

					if (missionVariables.IR_finance_question_no > 1) {
						missionVariables.IR_asked_question = missionVariables.IR_finance_question_string;
						this._runScreen({
							title: expandMissionText("IR_name_gse"), overlay: { name: "IR_GSE_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}
				}

				if (choice == "IR_A_shipment_question_key") {
					if (missionVariables.IR_shipment_question_no == 2 && !missionVariables.IR_GSE_loan) {
						this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_offer", choicesKey: "IR_loan_choices" }, function (choice) {
							if (choice == "IR_loan_yes") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_agreed" });
								missionVariables.IR_GSE_loan = "ACCEPTED";
								player.credits += 500000;
								missionVariables.IR_loan_deadline = clock.days + 60;
								missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days;
								missionVariables.IR_loan_remaining_saved = missionVariables.IR_loan_deadline - clock.days;
								this._setInstructionsKey("IR_loan_amount");
								missionVariables.IR_offer = null;
							}
							if (choice == "IR_loan_no") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_rejected", choicesKey: "IR_questions" }, this.choiceEvaluation);
								missionVariables.IR_offer = null;
								missionVariables.IR_GSE_loan = "REJECTED";
							}
							if (choice == "IR_loan_defer") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_deferred", choicesKey: "IR_questions" }, this.choiceEvaluation);
								missionVariables.IR_offer = "IR_GSE_QUESTIONS";
								missionVariables.IR_GSE_loan = "DEFERRED";
							}
						});
						break;
					}

					if (missionVariables.IR_GSE_loan == "DEFERRED") {
						this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_repeat_offer", choicesKey: "IR_loan_choices" }, function (choice) {
							if (choice == "IR_loan_yes") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_agreed" });
								missionVariables.IR_GSE_loan = "ACCEPTED";
								player.credits += 500000;
								missionVariables.IR_loan_deadline = clock.days + 60;
								missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days;
								missionVariables.IR_loan_remaining_saved = missionVariables.IR_loan_deadline - clock.days;
								this._setInstructionsKey("IR_loan_amount");
								missionVariables.IR_offer = null;
							}
							if (choice == "IR_loan_no") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_rejected", choicesKey: "IR_questions" }, this.choiceEvaluation);
								missionVariables.IR_offer = "IR_GSE_QUESTIONS";
								missionVariables.IR_GSE_loan = "REJECTED";
							}
							if (choice == "IR_loan_defer") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_deferred", choicesKey: "IR_questions" }, this.choiceEvaluation);
								missionVariables.IR_offer = "IR_GSE_QUESTIONS";
								missionVariables.IR_GSE_loan = "DEFERRED";
							}
						});
						break;
					}

					if (missionVariables.IR_GSE_loan == "ACCEPTED") {
						this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_loan_demand", choicesKey: "IR_pay_choices" }, function (choice) {
							if (choice == "IR_pay_yes") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_pay_accepted", choicesKey: "IR_questions" }, this.choiceEvaluation);
								missionVariables.IR_GSE_loan = "PAID";
								player.credits -= 550000;
								missionVariables.IR_loan_deadline = null;
								missionVariables.IR_loan_remaining = null;
								this._setInstructionsKey(null);
								missionVariables.IR_offer = "IR_GSE_QUESTIONS";
							}
							if (choice == "IR_pay_no") {
								this._runScreen({ title: expandMissionText("IR_name_gse"), messageKey: "IR_GSE_pay_deferred", choicesKey: "IR_questions" }, this.choiceEvaluation);
								missionVariables.IR_offer = "IR_GSE_QUESTIONS";
							}
						});
						break;
					}
				}

				if (choice == "IR_E_exit_question_key")
					return;
				else
					this._runScreen({
						title: expandMissionText("IR_name_gse"), overlay: { name: "IR_GSE_logo.png", height: 546 }, messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_GSE_QUESTIONS";
				break;
			}

		case "IR_KORSHKOV_QUESTIONS":
			{
				if (choice == "IR_B_finance_question_key") {
					if (missionVariables.IR_finance_question_no == 2) {
						this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_KORSHKOV_finance_answer_1a", choicesKey: "IR_continue" }, function (choice) {
							this.incrementFinanceQuestion();
							this._runScreen({ title: expandMissionText("IR_name_okb"), messageKey: "IR_KORSHKOV_finance_answer_1b" });
							missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS";
							missionVariables.IR_KORSHKOV_deadline = clock.days + 5;
							worldScripts["IR-finance.js"].incrementFinanceStatus();
							missionVariables.IR_offer = null;
							missionVariables.IR_finance_quest = "WAIT";
						});
						break;
					}

					if (missionVariables.IR_finance_question_no > 2) {
						missionVariables.IR_asked_question = missionVariables.IR_finance_question_string;
						this._runScreen({
							title: expandMissionText("IR_name_okb"), overlay: { name: "IR_korsh_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}
				}

				if (choice == "IR_E_exit_question_key") {
					return;
				} else
					this._runScreen({
						title: expandMissionText("IR_name_okb"), overlay: { name: "IR_korsh_logo.png", height: 546 }, messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS";
				break;
			}


		case "IR_JANES_QUESTIONS":
			{
				if (choice == "IR_A_shipment_question_key") {
					this._runScreen({
						title: expandMissionText("IR_name_janes"), overlay: { name: "IR_janes_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
					break;
				}

				if (choice == "IR_C_SDF_question_key") {
					if (missionVariables.IR_SDF_question_no == 1) {
						this.incrementSDFQuestion();
						this._runScreen({
							title: expandMissionText("IR_name_janes"), messageKey: "IR_JANES_SDF_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}

					if (missionVariables.IR_SDF_question_no > 1) {
						this._runScreen({
							title: expandMissionText("IR_name_janes"), overlay: { name: "IR_janes_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}
				}

				if (choice == "IR_D_defences_question_key") {
					this._runScreen({
						title: expandMissionText("IR_name_janes"), messageKey: "IR_JANES_defences_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
					break;
				}

				if (choice == "IR_E_exit_question_key")
					return;

				else
					this._runScreen({
						title: expandMissionText("IR_name_janes"), overlay: { name: "IR_janes_logo.png", height: 546 }, messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_JANES_QUESTIONS";
				break;
			}

		case "IR_PIRATE_QUESTIONS":
			{
				if (choice == "IR_A_shipment_question_key") {
					if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_shipment_quest == "SET") {
						this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_answer", choicesKey: "IR_continue" }, function (choice) {
							this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_offer", choicesKey: "IR_pirate_choices" }, function (choice) {
								if (choice == "IR_pirate_yes") {
									this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_accepted" });
									missionVariables.IR_alsto = "HELP_ACCEPTED";
									player.credits -= 250000;
									worldScripts["IR-shipment.js"].incrementShipmentStatus();
									missionVariables.IR_offer = null;
								}
								if (choice == "IR_pirate_no") {
									this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_declined" });
									missionVariables.IR_offer = null;
									missionVariables.IR_alsto = "HELP_DECLINED";
								}
							});
						});
						break;
					}

					if (missionVariables.IR_shipment_question_no == 1) {
						this._runScreen({ title: " ", messageKey: "IR_negative_answer", choicesKey: "IR_questions" }, this.choiceEvaluation);
						missionVariables.IR_offer = "IR_PIRATE_QUESTIONS";
						break;
					}

					if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_alsto == "HELP_ACCEPTED")
						this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_confirm_help" });

					if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_alsto == "HELP_DECLINED") {
						this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_deferred_help", choicesKey: "IR_pirate_choices" }, function (choice) {
							if (choice == "IR_pirate_yes") {
								this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_accepted" });
								missionVariables.IR_alsto = "HELP_ACCEPTED";
								player.credits -= 250000;
								worldScripts["IR-shipment.js"].incrementShipmentStatus();
								missionVariables.IR_offer = null;
							}
							if (choice == "IR_pirate_no") {
								this._runScreen({ title: " ", messageKey: "IR_PIRATE_shipment_declined" });
								missionVariables.IR_offer = null;
								missionVariables.IR_alsto = "HELP_DECLINED";
							}

						});

						if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_shipment_quest != "SET") {
							missionVariables.IR_asked_question = missionVariables.IR_shipment_question_string;
							this._runScreen({
								title: " ", messageKey: "IR_no_more_answer",
								choicesKey: "IR_questions"
							}, this.choiceEvaluation);
							break;
						}
					}
				}

				if (choice == "IR_C_SDF_question_key") {
					if (missionVariables.IR_SDF_question_no < 2)
						this._runScreen({ title: " ", messageKey: "IR_PIRATE_SDF_answer_1", choicesKey: "IR_questions" }, this.choiceEvaluation);

					if (missionVariables.IR_SDF_question_no == 2)
						this._runScreen({ title: " ", messageKey: "IR_PIRATE_SDF_answer_2", choicesKey: "IR_questions" }, this.choiceEvaluation);

					if (missionVariables.IR_SDF_question_no > 2) {
						this._runScreen({
							title: " ", messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
					}
					break;
				}

				if (choice == "IR_E_exit_question_key")
					return;
				else
					this._runScreen({
						title: " ", messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_PIRATE_QUESTIONS";
				break;
			}

		case "IR_YOKOHAMA_QUESTIONS":
			{
				if (choice == "IR_A_shipment_question_key") {
					if (missionVariables.IR_shipment_question_no == 1) {
						this.incrementShipmentQuestion()
						this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_answer_1" });
						missionVariables.IR_YOKOHAMA_deadline = clock.days + 30;
						missionVariables.IR_YOKOHAMA_deadline_saved = clock.days + 30;
						missionVariables.IR_shipment_quest = "SET";
						missionVariables.IR_offer = null;
						worldScripts["IR-shipment.js"].incrementShipmentStatus();
						break;
					}

					if (missionVariables.IR_shipment_question_no == 2 && clock.days < missionVariables.IR_YOKOHAMA_deadline) {
						this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_answer_2", choicesKey: "IR_YOKOHAMA_choices" }, function (choice) {
							if (choice == "IR_YOKOHAMA_yes") {
								if (player.credits >= 1000000) {
									this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_agreed" });
									missionVariables.IR_shipment_quest = "SUCCESS";
									missionVariables.IR_shipment_quest_method = "PURCHASED";
									missionVariables.IR_YOKOHAMA_deadline = null;
									++missionVariables.IR_quest_count;
									this.incrementShipmentQuestion();
									worldScripts["IR-shipment.js"].clearShipmentStatus();
									missionVariables.IR_offer = null;
									player.credits -= 1000000;
								}

								else {
									this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_nomoney" });
									missionVariables.IR_offer = null;
								}
							}

							if (choice == "IR_YOKOHAMA_no") {
								this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_declined" });
								missionVariables.IR_shipment_quest = "ENROUTE";
								this.incrementShipmentQuestion();
								missionVariables.IR_offer = null;
								if (missionVariables.IR_alsto) {
									worldScripts["IR-shipment.js"].incrementShipmentStatus();
								}
							}

							if (choice == "IR_YOKOHAMA_defer") {
								this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_defer" });
								missionVariables.IR_offer = null;
							}
						});
						break;
					}

					if (missionVariables.IR_shipment_question_no == 2 && clock.days > missionVariables.IR_YOKOHAMA_deadline) {
						this._runScreen({ title: expandMissionText("IR_name_yoko"), messageKey: "IR_YOKOHAMA_shipment_toolate" });
						missionVariables.IR_shipment_quest = "DISPATCHED";
						worldScripts["IR-shipment.js"].clearShipmentStatus();
						missionVariables.IR_offer = null;
						break;
					}

					if (missionVariables.IR_shipment_question_no > 2) {
						missionVariables.IR_asked_question = missionVariables.IR_shipment_question_string;
						this._runScreen({
							title: expandMissionText("IR_name_yoko"), overlay: { name: "IR_yk_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}
				}

				if (choice == "IR_E_exit_question_key")
					return;
				else
					this._runScreen({
						title: expandMissionText("IR_name_yoko"), overlay: { name: "IR_yk_logo.png", height: 546 }, messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS";
				break;
			}

		case "IR_PW_QUESTIONS":
			{
				if (choice == "IR_C_SDF_question_key") {
					if (missionVariables.IR_SDF_question_no == 2) {
						this._runScreen({ title: expandMissionText("IR_name_pw"), messageKey: "IR_PW_SDF_answer_1", choicesKey: "IR_continue" }, function (choice) {
							this.$addPadCharacter("devries");
							this.incrementSDFQuestion();
							this._runScreen({ title: " ", messageKey: "IR_SDF_quest_1" });
							missionVariables.IR_SDF_quest = "ADDRESS";
							missionVariables.IR_SDF_deadline = clock.days + 10;
						});
						break;
					}

					if (missionVariables.IR_SDF_question_no == 3) {
						this._runScreen({
							title: expandMissionText("IR_name_pw"), overlay: "IR_pw_logo.png", messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}

					if (missionVariables.IR_SDF_question_no == 5) {
						this._runScreen({ title: expandMissionText("IR_name_pw"), messageKey: "IR_PW_SDF_answer_2" });
						this.incrementSDFQuestion();
						missionVariables.IR_SDF_quest = "PHOTO";
						missionVariables.IR_SDF_deadline = clock.days + 35;
					} else {
						this._runScreen({
							title: expandMissionText("IR_name_pw"), overlay: "IR_pw_logo.png", messageKey: "IR_negative_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
					}
					break;
				}

				if (choice == "IR_E_exit_question_key") {
					missionVariables.IR_offer = "IR_ASKED";
					return;
				} else
					this._runScreen({
						title: expandMissionText("IR_name_pw"), overlay: "IR_pw_logo.png", messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_PW_QUESTIONS";
				break;
			}

		case "IR_NWE_QUESTIONS":
			{
				if (choice == "IR_C_SDF_question_key") {
					if (missionVariables.IR_SDF_question_no == 4) {
						this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_NWE_SDF_answer_1a", choicesKey: "IR_continue" }, function (choice) {
							this.incrementSDFQuestion();
							this._runScreen({ title: " ", messageKey: "IR_NWE_SDF_answer_1b" });
							missionVariables.IR_offer = null;
						});
					}

					if (missionVariables.IR_SDF_question_no < 4 || missionVariables.IR_SDF_question_no > 4) {
						this._runScreen({
							title: expandMissionText("IR_name_nwe"), overlay: { name: "IR_NWE_logo.png", height: 546 }, messageKey: "IR_negative_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
					}
					break;
				}

				if (choice == "IR_D_defences_question_key") {
					if (missionVariables.IR_defences_question_no < 3) {
						this._runScreen({ title: expandMissionText("IR_name_nwe"), messageKey: "IR_NWE_defences_answer_1" });
						missionVariables.IR_defences_question_no = 3;
						missionVariables.IR_offer = null;
						worldScripts["IR-defences.js"].incrementDefencesStatus();
						break;
					}

					if (missionVariables.IR_defences_question_no == 3) {
						this._runScreen({
							title: expandMissionText("IR_name_nwe"), overlay: { name: "IR_NWE_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}
				}

				if (choice == "IR_E_exit_question_key")
					return;
				else
					this._runScreen({
						title: expandMissionText("IR_name_nwe"), overlay: { name: "IR_NWE_logo.png", height: 546 }, messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_NWE_QUESTIONS";
				break;
			}

		case "IR_MAENES_QUESTIONS":
			{
				if (choice == "IR_D_defences_question_key") {
					if (missionVariables.IR_defences_question_no == 1) {
						this._runScreen({ title: expandMissionText("IR_name_quico"), messageKey: "IR_MAENES_defences_answer_1" });
						this.incrementDefencesQuestion();
						missionVariables.IR_offer = null;
						missionVariables.IR_Maenes_visit = "TRUE";
						break;
					}


					if (missionVariables.IR_defences_question_no >= 2) {
						this._runScreen({
							title: expandMissionText("IR_name_quico"), overlay: { name: "IR_quico_logo.png", height: 546 }, messageKey: "IR_no_more_answer",
							choicesKey: "IR_questions"
						}, this.choiceEvaluation);
						break;
					}
				}

				if (choice == "IR_E_exit_question_key")
					return;
				else
					this._runScreen({
						title: expandMissionText("IR_name_quico"), overlay: { name: "IR_quico_logo.png", height: 546 }, messageKey: "IR_negative_answer",
						choicesKey: "IR_questions"
					}, this.choiceEvaluation);
				missionVariables.IR_offer = "IR_MAENES_QUESTIONS";
				break;
			}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.setupQuestions = function () {
	missionVariables.IR_shipment_question_no = 1;
	missionVariables.IR_shipment_question_key = "shipment_question_" + [missionVariables.IR_shipment_question_no];
	missionVariables.IR_shipment_question_string = expandDescription("[shipment_question_string_" + [missionVariables.IR_shipment_question_no] + "]");

	missionVariables.IR_SDF_question_no = 1;
	missionVariables.IR_SDF_question_key = "SDF_question_" + [missionVariables.IR_SDF_question_no];
	missionVariables.IR_SDF_question_string = expandDescription("[SDF_question_string_" + [missionVariables.IR_SDF_question_no] + "]");

	missionVariables.IR_finance_question_no = 1;
	missionVariables.IR_finance_question_key = "finance_question_" + [missionVariables.IR_finance_question_no];
	missionVariables.IR_finance_question_string = expandDescription("[finance_question_string_" + [missionVariables.IR_finance_question_no] + "]");

	missionVariables.IR_defences_question_no = 1;
	missionVariables.IR_defences_question_key = "defences_question_" + [missionVariables.IR_defences_question_no];
	missionVariables.IR_defences_question_string = expandDescription("[defences_question_string_" + [missionVariables.IR_defences_question_no] + "]");

	missionVariables.IR_question_settings = "SET";
}

//-------------------------------------------------------------------------------------------------------------
this.setupStatus = function () {
	missionVariables.IR_shipment_status_no = 0;
	missionVariables.IR_finance_status_no = 0;
	missionVariables.IR_SDF_status_no = 0;
	missionVariables.IR_defences_status_no = 0;
	worldScripts["IR-shipment.js"].setShipmentStatus();
	worldScripts["IR-SDF.js"].setSDFStatus();
	worldScripts["IR-finance.js"].setFinanceStatus();
	worldScripts["IR-defences.js"].setDefencesStatus();
}

//-------------------------------------------------------------------------------------------------------------
this.incrementShipmentQuestion = function () {
	++missionVariables.IR_shipment_question_no;
	missionVariables.IR_shipment_question_key = "shipment_question_" + [missionVariables.IR_shipment_question_no];
	missionVariables.IR_shipment_question_string = expandDescription("[shipment_question_string_" + [missionVariables.IR_shipment_question_no] + "]");
}

//-------------------------------------------------------------------------------------------------------------
this.incrementFinanceQuestion = function () {
	++missionVariables.IR_finance_question_no;
	missionVariables.IR_finance_question_key = "finance_question_" + [missionVariables.IR_finance_question_no];
	missionVariables.IR_finance_question_string = expandDescription("[finance_question_string_" + [missionVariables.IR_finance_question_no] + "]");
}

//-------------------------------------------------------------------------------------------------------------
this.incrementSDFQuestion = function () {
	++missionVariables.IR_SDF_question_no;
	missionVariables.IR_SDF_question_key = "SDF_question_" + [missionVariables.IR_SDF_question_no];
	missionVariables.IR_SDF_question_string = expandDescription("[SDF_question_string_" + [missionVariables.IR_SDF_question_no] + "]");
}

//-------------------------------------------------------------------------------------------------------------
this.incrementDefencesQuestion = function () {
	++missionVariables.IR_defences_question_no;
	missionVariables.IR_defences_question_key = "defences_question_" + [missionVariables.IR_Defences_question_no];
	missionVariables.IR_defences_question_string = expandDescription("[defences_question_string_" + [missionVariables.IR_defences_question_no] + "]");
}

//-------------------------------------------------------------------------------------------------------------
this.DefencesReply = function DefencesReply() {
	--missionVariables.IR_count;

	if (missionVariables.IR_count == 80) {
		this._mfd.$updateMFD("IR_defences_reply_80", null, null, expandMissionText("IR_ruiz_key"));
	}

	if (missionVariables.IR_count == 70) {
		this._mfd.$updateMFD("IR_defences_reply_70");
	}

	if (missionVariables.IR_count == 45) {
		this._mfd.$updateMFD("IR_defences_reply_45", null, null, expandMissionText("IR_ruiz_key"));
	}

	if (missionVariables.IR_count == 20) {
		this._mfd.$updateMFD("IR_defences_reply_20", null, null, expandMissionText("IR_ruiz_key"));
	}

	if (missionVariables.IR_count <= 10) {
		this._mfd.$updateMFD("IR_defences_reply_10", { sec: missionVariables.IR_count }, null, expandMissionText("IR_maenes_dc"));
	}

	if (missionVariables.IR_count == 0) {
		this._mfd.$updateMFD("IR_defences_reply_0", null, null, expandMissionText("IR_maenes_dc"));
		this.DefencesTimer.stop();
		delete this.DefencesTimer;
		missionVariables.IR_count = null;
		missionVariables.IR_defences_quest = "SABOTAGED";
		var cannons = system.shipsWithRole("IR-cannon-core");
		for (var i = 0; i < cannons.length; i++) {
			cannons[i].setAI("dumbAI.plist");
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$addSystemShips = function (role, count, fraction, spread) {
	if (!spread) spread = 10000;
	var wp = system.shipsWithPrimaryRole("buoy-witchpoint")[0];
	var pos = Vector3D.interpolate(wp.position, system.mainStation.position, fraction);
	return system.addShips(role, count, pos, spread);
}

//-------------------------------------------------------------------------------------------------------------
this.$systemShipsPosition = function (fraction) {
	var wp = system.shipsWithPrimaryRole("buoy-witchpoint")[0];
	var pos;
	if (!wp) pos = Vector3D(0, 0, 0);
	else {
		pos = wp.position;
	}
	return Vector3D.interpolate(pos, system.mainStation.position, fraction);
}

//-------------------------------------------------------------------------------------------------------------
this.LaxesoriReply = function LaxesoriReply() {
	this.LaxesoriTimer.stop();
	delete this.LaxesoriTimer;
	this._mfd.$updateMFD(expandMissionText("IR_laxesori_reply"));
}

//-------------------------------------------------------------------------------------------------------------
this.KorshkovReply = function KorshkovReply() {
	this.KorshkovTimer.stop();
	delete this.KorshkovTimer;
	this._mfd.$updateMFD("IR_korshkov_reply", null, null, expandMissionText("IR_aarzari_stn"));
}

//-------------------------------------------------------------------------------------------------------------
//ingame conversations
this.JulietReply = function JulietReply() {
	++missionVariables.IR_count;
	var cherkasova = system.shipsWithRole("IR-cherkasova")[0];

	if (missionVariables.IR_status == "IR_sources_4") {
		if (missionVariables.IR_count == 5) {
			this._mfd.$updateMFD("IR_cherkasova_reply_5", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 12) {
			this._mfd.$updateMFD("IR_cherkasova_reply_12");
		}

		if (missionVariables.IR_count == 22) {
			this._mfd.$updateMFD("IR_cherkasova_reply_22", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 30) {
			this._mfd.$updateMFD("IR_cherkasova_reply_30");
		}

		if (missionVariables.IR_count == 40) {
			this._mfd.$updateMFD("IR_cherkasova_reply_40");
		}

		if (missionVariables.IR_count == 50) {
			this._mfd.$updateMFD("IR_cherkasova_reply_50");
		}

		if (missionVariables.IR_count == 65) {
			this._mfd.$updateMFD("IR_cherkasova_reply_65");
		}

		if (missionVariables.IR_count == 78) {
			this._mfd.$updateMFD("IR_cherkasova_reply_78", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 90) {
			var sdf = system.addShipsToRoute("IR-sdf-imperator", 1, 0.01, "wp");
			for (var i = 0; i < sdf.length; i++) {
				if (!this._sdf_group) this._sdf_group = new ShipGroup("sdf", sdf[0]);
				this._sdf_group.addShip(sdf[i]);
				sdf[i].group = this._sdf_group;
				if (sdf[i].escorts.length > 0) {
					for (var j = 0; j < sdf[i].escorts.length; j++) {
						this._sdf_group.addShip(sdf[i].escorts[j]);
						sdf[i].escorts[j].group = this._sdf_group;
					}
				}
			}
		}

		if (missionVariables.IR_count == 98) {
			var tnk = system.addShipsToRoute("IR-sirius-tanker", 6, 0.01, "wp");
			for (var i = 0; i < tnk.length; i++) {
				this._sdf_group.addShip(tnk[i]);
				tnk[i].grop = this._sdf_group;
				if (tnk[i].escorts.length > 0) {
					for (var j = 0; j < tnk[i].escorts.length; j++) {
						this._sdf_group.addShip(tnk[i].escorts[j]);
						tnk[i].escorts[j].group = this._sdf_group;
					}
				}
			}
		}

		if (missionVariables.IR_count == 98) {
			var trp = system.addShipsToRoute("IR-sdf-transporter", 8, 0.01, "wp");
			for (var i = 0; i < trp.length; i++) {
				this._sdf_group.addShip(trp[i]);
				trp[i].group = this._sdf_group;
				if (trp[i].escorts.length > 0) {
					for (var j = 0; j < trp[i].escorts.length; j++) {
						this._sdf_group.addShip(trp[i].escorts[j]);
						trp[i].escorts[j].group = this._sdf_group;
					}
				}
			}
		}

		if (missionVariables.IR_count == 110) {
			this._mfd.$updateMFD("IR_cherkasova_reply_110");
		}

		if (missionVariables.IR_count == 122) {
			this._mfd.$updateMFD("IR_cherkasova_reply_122", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 130) {
			this._mfd.$updateMFD("IR_cherkasova_reply_130");
		}

		if (missionVariables.IR_count == 150) {
			this._leader = system.shipsWithRole("IR-sdf-imperator")[0];
			this._leader.setAI("route1traderAI.plist");
			this._mfd.$updateMFD("IR_cherkasova_reply_150", null, this._leader);
		}

		if (missionVariables.IR_count == 160) {
			this._mfd.$updateMFD("IR_cherkasova_reply_160", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 170) {
			this._mfd.$updateMFD("IR_cherkasova_reply_170");
		}

		if (missionVariables.IR_count == 180) {
			this._mfd.$updateMFD("IR_cherkasova_reply_180", null, cherkasova, expandMissionText("IR_cherkasova_key"));
			//var leader = system.shipsWithRole("IR-sdf-imperator")[0];
			cherkasova.target = this._leader;
			cherkasova.AIState = "ATTACK_SHIP";
		}

		if (missionVariables.IR_count == 190) {
			this._mfd.$updateMFD("IR_cherkasova_reply_190");
		}

		if (missionVariables.IR_count == 200) {
			this._mfd.$updateMFD("IR_cherkasova_reply_200", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 800) {
			this._mfd.$updateMFD("IR_cherkasova_reply_800", null, this._leader);
			//var leader = system.shipsWithRole("IR-sdf-imperator")[0];
			this._leader.exitSystem();
			missionVariables.IR_status = "IR_interceptionfail_A";
		}
	}

	if (missionVariables.IR_status == "IR_interceptionfail_A") {
		missionVariables.IR_count = 0;
		missionVariables.IR_status = "IR_interceptionfail_B";
		return;
	}

	if (missionVariables.IR_status == "IR_interceptionfail_B") {
		if (missionVariables.IR_count == 15) {
			this._mfd.$updateMFD("IR_intercept_fail");
		}
	}

	if (missionVariables.IR_status == "IR_tankers") {
		missionVariables.IR_count = 0;
		missionVariables.IR_status = "IR_tankers_B";
		return;
	}

	if (missionVariables.IR_status == "IR_tankers_B") {
		if (missionVariables.IR_count == 15) {
			this._mfd.$updateMFD("IR_tankers_reply_15", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 25)
			this.$addSystemShips("IR-navy-frigate", 5, 0.0);
		//system.legacy_addSystemShips("IR-navy-frigate", 5, 0.0);

		if (missionVariables.IR_count == 40)
			this._mfd.$updateMFD("IR_tankers_reply_40");

		if (missionVariables.IR_count == 50)
			this._mfd.$updateMFD("IR_tankers_reply_50", null, null, expandMissionText("IR_juliet_leader"));
	}

	if (missionVariables.IR_status == "IR_imperator") {
		missionVariables.IR_count = 0;
		missionVariables.IR_status = "IR_imperator_B";
		return;
	}

	if (missionVariables.IR_status == "IR_imperator_B") {
		if (missionVariables.IR_count == 10)
			this._mfd.$updateMFD("IR_kinnaird_escape", null, cherkasova, expandMissionText("IR_cherkasova_key"));
	}

	if (missionVariables.IR_status == "IR_courier") {
		missionVariables.IR_count = 0;
		missionVariables.IR_status = "IR_courier_B";
		return;
	}

	if (missionVariables.IR_status == "IR_courier_B") {
		if (missionVariables.IR_count == 5) {
			this._mfd.$updateMFD("IR_kinnaird_disabled", null, cherkasova, expandMissionText("IR_cherkasova_key"));
			this._setInstructionsKey("IR_sources_brief_3");
			missionVariables.IR_status = "IR_sources_5";
			mission.markSystem({ name: this.name, system: 23 });
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.MaenesReply = function MaenesReply() {
	++missionVariables.IR_count;
	var cherkasova = system.shipsWithRole("IR-cherkasova")[0];

	if (missionVariables.IR_status == "IR_LOA_5") {
		if (missionVariables.IR_count == 10) {
			this._mfd.$updateMFD("IR_maenes_reply_10");
		}

		if (missionVariables.IR_count == 20) {
			this._mfd.$updateMFD("IR_maenes_reply_20", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 30) {
			this._mfd.$updateMFD("IR_maenes_reply_30");
		}

		if (missionVariables.IR_count == 40) {
			this._mfd.$updateMFD("IR_maenes_reply_40", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 50) {
			this._mfd.$updateMFD("IR_maenes_reply_50");
		}

		if (missionVariables.IR_count == 80) {
			this._mfd.$updateMFD("IR_maenes_reply_80", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 90) {
			this._mfd.$updateMFD("IR_maenes_reply_90");
		}

		if (missionVariables.IR_count == 105) {
			this._mfd.$updateMFD("IR_maenes_reply_105", null, null, expandMissionText("IR_ruiz_key"));
		}

		if (missionVariables.IR_count == 115) {
			this._mfd.$updateMFD("IR_maenes_reply_115");
		}

		if (missionVariables.IR_count == 125) {
			this._mfd.$updateMFD("IR_maenes_reply_125", null, null, expandMissionText("IR_ruiz_key"));
		}

		if (missionVariables.IR_count == 135) {
			this._mfd.$updateMFD("IR_maenes_reply_135");
		}

		if (missionVariables.IR_count == 255) {
			this._mfd.$updateMFD("IR_maenes_reply_255", null, null, expandMissionText("IR_ruiz_key"));
		}

		if (missionVariables.IR_count == 285) {
			this._mfd.$updateMFD("IR_maenes_reply_285", null, null, expandMissionText("IR_ruiz_key"));
			missionVariables.IR_maenes_cannon = "TRUE";
			var cannons = system.shipsWithRole("IR-cannon-core");
			for (var i = 0; i < cannons.length; i++) {
				cannons[i].setAI("IR-cannonAI.plist");
			}
		}
	}

	if (missionVariables.IR_status == "IR_landers") {
		missionVariables.IR_count = 0;
		missionVariables.IR_status = "IR_landers_B";
		return;
	}

	if (missionVariables.IR_status == "IR_landers_B") {
		if (missionVariables.IR_count == 15) {
			this._mfd.$updateMFD("IR_landers_reply_15", null, cherkasova, expandMissionText("IR_cherkasova_key"));
		}

		if (missionVariables.IR_count == 65 && missionVariables.IR_maenes_cannon != "TRUE") {
			this._mfd.$updateMFD("IR_landers_reply_65", null, null, expandMissionText("IR_ruiz_key"));
		}

		if (missionVariables.IR_count == 120 && missionVariables.IR_maenes_cannon != "TRUE") {
			this._mfd.$updateMFD("IR_landers_reply_120", null, null, expandMissionText("IR_ruiz_key"));
			var cannons = system.shipsWithRole("IR-cannon-core");
			for (var i = 0; i < cannons.length; i++) {
				cannons[i].setAI("IR-cannonAI.plist");
			}
		}
	}

	if (missionVariables.IR_status == "IR_imperator_alt") {
		missionVariables.IR_count = 0;
		missionVariables.IR_status = "IR_imperator_alt_B";
		return;
	}

	if (missionVariables.IR_status == "IR_imperator_alt_B") {
		if (missionVariables.IR_count == 10) {
			this._mfd.$updateMFD("IR_sdf_destroyed", null, cherkasova, expandMissionText("IR_cherkasova_key"));
			this._setInstructionsKey("IR_sources_brief_3");
			mission.markSystem({ name: this.name, system: 23 });
			missionVariables.IR_status = "IR_LOA_6";
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$sendDelayedMessage = function () {
	this._delay = new Timer(this, this.$sendReply.bind(this), 2, 0);
}

//-------------------------------------------------------------------------------------------------------------
this.$sendReply = function $sendReply() {
	worldScripts["IR-mfd.js"].$updateMFD("IR_drone_reply");
}

//-------------------------------------------------------------------------------------------------------------
this.$addPadLogEntry = function (text) {
	var pad = worldScripts.Lib_PAD;
	if (!pad) return;
	pad._setPageEntry("LOGS.GENERIC.list", text);
}

//-------------------------------------------------------------------------------------------------------------
// once we get the brief, add any remaining items to pad
this.$addAllInfoToPad = function () {
	var pad = worldScripts.Lib_PAD;
	if (!pad) return;
	var keys = Object.keys(this.$dataStore);
	for (var i = 0; i < keys.length; i++) {
		var data = pad._getData(keys[i]);
		if (!data) pad._addPageInCategory(keys[i], this.$dataStore[keys[i]], this.$categoryLinks[keys[i]], true);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$addDataToPad = function (key) {
	var pad = worldScripts.Lib_PAD;
	if (!pad) return;
	if (!pad._getData(key)) pad._addPageInCategory(key, this.$dataStore[key], this.$categoryLinks[key], false);
}

//-------------------------------------------------------------------------------------------------------------
// todo: need code to merge drvries and kinnaird
this.$addPadCharacter = function (person) {
	var pad = worldScripts.Lib_PAD;
	if (!pad) return;
	if (!this._padInfo) {
		this._padInfo = [];
	}
	if (this._padInfo.indexOf(person) == -1) this._padInfo.push(person);
	var key = "";
	switch (person) {
		case "ibanez": key = "PERSONS.ADMIRAL IBANEZ"; break;
		case "lindberg": key = "PERSONS.JANNE LINDBERG"; break;
		case "lexicon": key = "PERSONS.LEXICON"; break;
		case "tobias": key = "PERSONS.TOBIAS KING"; break;
		case "isabella": key = "PERSONS.ISABELLA KING"; break;
		case "nash": key = "PERSONS.COMMANDER NASH"; break;
		case "weiss": key = "PERSONS.REINHARDT WEISS"; break;
		case "kinnaird": key = "PERSONS.PIETER KINNAIRD"; break;
		case "cherkasova": key = "PERSONS.MAJOR CHERKASOVA"; break;
		case "ruiz": key = "PERSONS.COLONEL RUIZ"; break;
		case "abonlo": key = "PERSONS.CAPTAIN ABONLO"; break;
		case "devries": key = "PERSONS.JACOB DE VRIES"; break;
	}
	pad._addPageInCategory(key, this.$peopleStore[key], this.$categoryLinks[key], false);
}

//-------------------------------------------------------------------------------------------------------------
// this is to avoid the issue where player.ship.commsMessages appear to come out of nowhere.
this.$sendSystemComms = function (from, msg) {
	if (!player.ship || !player.ship.isValid) return;
	var p = player.ship;
	var temp = system.addShips("[IR-commObject]", 1, p.position.add(p.vectorUp.multiply(300)))[0];
	temp.displayName = from;
	temp.commsMessage(msg, p);
	temp.remove(true);
}

//-------------------------------------------------------------------------------------------------------------
this.$dumpSavedData = function () {
	var k = Object.keys(missionVariables);
	for (var i = 0; i < k.length; i++)
		if (k[i].indexOf("IR_") >= 0) {
			log(this.name, k[i] + " = " + missionVariables[k[i]]);
		}
}

//-------------------------------------------------------------------------------------------------------------
this.turnStation = function (stationEntity, targetEntity) {
	if (!stationEntity.isValid || !targetEntity.isValid) { return; }
	let stationVector = stationEntity.position.subtract(targetEntity.position).direction(); // unit vector pointing away from the sun
	let angle = stationEntity.heading.angleTo(stationVector); // angle between current heading and target heading
	let cross = stationEntity.heading.cross(stationVector).direction(); // set the plane where we should rotate in
	stationEntity.orientation = stationEntity.orientation.rotate(cross, -angle); // re-orient the station away from the sun
}

//-------------------------------------------------------------------------------------------------------------
this.clearIRMissionVariables = function () {
	var k = Object.keys(missionVariables);
	for (var i = 0; i < k.length; i++)
		if (k[i].indexOf("IR_") >= 0) missionVariables[k[i]] = null;

	this.$data = {};
	this._manifest = {};
	this._padInfo = [];
	this.IR_padchars = [];
	this.IR_screen_log = "";
	this.IR_screen_location = "";
	this.IR_manifest = {};
	this.IR_commLog = [];
	this.IR_paddata = {};
}

//-------------------------------------------------------------------------------------------------------------
// appends space to currentText to the specified length in 'em'
this.$padTextRight = function $padTextRight(currentText, desiredLength, leftSwitch) {
	if (currentText == null) currentText = "";
	var space = " ";
	var hairSpace = String.fromCharCode(31);
	var ellip = "…";
	var currentLength = defaultFont.measureString(currentText.replace(/%%/g, "%"));
	var hairSpaceLength = defaultFont.measureString(hairSpace);
	var spaceLength = defaultFont.measureString(space);
	// calculate number needed to fill remaining length
	var spacesNeeded = parseInt(Math.floor((desiredLength - currentLength) / spaceLength));
	if (spacesNeeded < 0) {
		spacesNeeded = 0;
	} else {
		if (!leftSwitch || leftSwitch === false) {
			currentText += new Array(spacesNeeded).join(space);
		} else {
			currentText = new Array(spacesNeeded).join(space) + currentText;
		}
		currentLength = defaultFont.measureString(currentText.replace(/%%/g, "%"));
	}
	var padsNeeded = Math.floor((desiredLength - currentLength) / hairSpaceLength);
	if (padsNeeded < 1) {
		// text is too long for column, so start pulling characters off
		var tmp = currentText;
		do {
			tmp = tmp.substring(0, tmp.length - 2) + ellip;
			if (tmp === ellip) break;
		} while (defaultFont.measureString(tmp.replace(/%%/g, "%")) > desiredLength);
		currentLength = defaultFont.measureString(tmp.replace(/%%/g, "%"));
		padsNeeded = Math.floor((desiredLength - currentLength) / hairSpaceLength);
		currentText = tmp;
	}
	// quick way of generating a repeated string of that number
	if (!leftSwitch || leftSwitch === false) {
		return currentText + new Array(padsNeeded).join(hairSpace);
	} else {
		return new Array(padsNeeded).join(hairSpace) + currentText;
	}
}

//-------------------------------------------------------------------------------------------------------------
// appends space to currentText to the specified length in 'em'
this.$padTextLeft = function $padTextLeft(currentText, desiredLength) {
	return this.$padTextRight(currentText, desiredLength, true);
}

//-------------------------------------------------------------------------------------------------------------
this.$cleanUp = function () {
	delete this.missionScreenOpportunity;
	delete this.shipWillDockWithStation;
	delete this.shipTargetAcquired;
	delete this.shipBeingAttacked;
	delete this.shipWillLaunchFromStation;
	delete this.shipExitedWitchspace;
	delete this.shipEnteredStationAegis;
	delete this.playerBoughtNewShip;
	delete this.playerJumpFailed;
}