"use strict";
this.name = "IR-fuel-station.js";
this.author = "phkb";
this.copyright = "June 2025";
this.description = "Iron Raven fuel station script";
this.version = "2.0";

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
    this._timer = new Timer(this, this.$lookForSample, 1, 1);
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function () {
    this._timer.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.$lookForSample = function $lookForSample() {
    if (!this.ship.target) return;
    var samples = system.shipsWithRole("IR-fuel-sample");
    if (!samples || samples.length == 0) {
        if (this._found == true) this._timer.stop();
        return;
    }
    if (this._logged != true) {
        this._logged = true;
    }
    for (var i = 0; i < samples.length; i++) {
        var tgt = samples[i];
        if (samples[i].position.distanceTo(this.ship) < 3000) {
            if (tgt.velocity.magnitude() == 0) {
                // give it a bit of a push
                tgt.velocity = Vector3D(1, 1, 1);
            }
            tgt.velocity = this.ship.position.subtract(tgt.position).direction().multiply(20).add(tgt.velocity);
        }
    }
    this._found = true;
}