"use strict";
this.name = "IR-fuel-sample.js";
this.author = "Ramirez";
this.copyright = "April 2011";
this.description = "Iron Raven fuel sample script";
this.version = "2.0";

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
	// so the player doesn't loose target lock
	if (worldScripts["IR-finance.js"]._isTargetted == true) {
		player.ship.target = this.ship;
		// only do this once
		delete worldScripts["IR-finance.js"]._isTargetted;
	}

	if (this.ship.primaryRole == "EQ_IR_FUEL_SAMPLE_MINE") {
		if (missionVariables.IR_finance_quest == "IRRADIATE") {
			this.ship.spawn("IR-fuel-sample", 1);
			this.ship.remove();
		}

		if (missionVariables.IR_finance_quest == "IRRADIATE_SUCCESS") {
			this.ship.spawn("IR-fuel-sample", 1);
			this.ship.remove();
		}
	} else {
		if (system.countShipsWithRole("IR-fuelprocessor") == 1) {
			var fuelprocessor = system.shipsWithRole("IR-fuelprocessor")[0];
			fuelprocessor.target = this.ship;
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function () {
	if (this.ship.primaryRole == "IR-fuel-sample") {
		if (missionVariables.IR_finance_quest == "IRRADIATE_SUCCESS") {
			if (system.countShipsWithRole("IR-fuelprocessor") == 1) {
				var fuelprocessor = system.shipsWithRole("IR-fuelprocessor")[0];
				this.ship.target = fuelprocessor;
				if (this.ship.position.distanceTo(this.ship.target) < 250) {
					this.reprocessFuel();
				}
				else return;
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipWasScooped = function (whom) {
	if (this.ship.primaryRole == "IR-fuel-sample" && whom == player.ship) {
		player.ship.awardEquipment("EQ_IR_FUEL_SAMPLE_MINE");
	}

	if (this.ship.primaryRole == "IR-fuel-sample-irradiated" && whom == player.ship) {
		player.ship.awardEquipment("EQ_IR_FUEL_SAMPLE_MINE");
		missionVariables.IR_finance_quest = "IRRADIATE_SUCCESS";
	}
}

//-------------------------------------------------------------------------------------------------------------
this.reprocessFuel = function () {
	var fuelprocessor = system.shipsWithRole("IR-fuelprocessor")[0];
	worldScripts["IR-mfd.js"].$updateMFD("IR_fuel_sample_complete", null, fuelprocessor, expandMissionText("IR_fuel_processor"));
	missionVariables.IR_finance_quest = "REPROCESSED";
	missionVariables.IR_KORSHKOV_deadline = clock.days + 20;
	worldScripts["IR-finance.js"].incrementFinanceStatus();
}

//-------------------------------------------------------------------------------------------------------------
this.checkTemperature = function () {
	if (this.ship.temperature >= 0.7) {
		this.ship.reactToAIMessage("TEMPERATURE_HIGH");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.checkTargetting = function () {
	if (player.ship.target == this.ship) worldScripts["IR-finance.js"]._isTargetted = true;
}