"use strict";
this.name = "IR-finance.js";
this.author = "Ramirez";
this.copyright = "February 2010";
this.description = "Script for maintaining status of IR finance thread";
this.version = "2.0";

this._isTargetted = false;

//-------------------------------------------------------------------------------------------------------------
this.incrementFinanceStatus = function () {
	++missionVariables.IR_finance_status_no;
	if (missionVariables.IR_finance_status_no == 1) mission.markSystem({name:"IR-main-script.js", system:31});
	if (missionVariables.IR_finance_status_no == 2) mission.markSystem({name:"IR-main-script.js", system:31});
	if (missionVariables.IR_finance_status_no == 3) mission.markSystem({name:"IR-main-script.js", system:31});
	if (missionVariables.IR_finance_status_no == 4) mission.markSystem({name:"IR-main-script.js", system:114});
	if (missionVariables.IR_finance_status_no == 6) mission.markSystem({name:"IR-main-script.js", system:219});
	if (missionVariables.IR_finance_status_no == 7) mission.markSystem({name:"IR-main-script.js", system:142});
	if (missionVariables.IR_finance_status_no == 8) mission.markSystem({name:"IR-main-script.js", system:219});
	if (missionVariables.IR_finance_status_no == 2) {
		worldScripts["IR-main-script.js"]._setInstructionsKey(this.buildBrief2Instructions(), "IR-finance.js");
	} else {
		worldScripts["IR-main-script.js"]._setInstructionsKey("IR_finance_brief_" + [missionVariables.IR_finance_status_no], "IR-finance.js");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.clearFinanceStatus = function () {
	worldScripts["IR-main-script.js"]._setInstructionsKey(null, "IR-finance.js");
}

//-------------------------------------------------------------------------------------------------------------
this.setFinanceStatus = function () {
	worldScripts["IR-main-script.js"]._setInstructionsKey("IR_finance_brief_" + [missionVariables.IR_finance_status_no], "IR-finance.js");
}

this.buildBrief2Instructions = function() {
	var text = expandMissionText("IR_finance_brief_2_prefix");
	var first = false;
	if (missionVariables.IR_cargo_radioactives > 0) {
		first = true;
		text += expandMissionText("IR_finance_brief_2_radioactives", {amount: missionVariables.IR_cargo_radioactives});
	}
	if (missionVariables.IR_cargo_minerals > 0) {
		if (first == true) text += ", ";
		first == true;
		text += expandMissionText("IR_finance_brief_2_minerals", {amount: missionVariables.IR_cargo_minerals});
	}
	if (missionVariables.IR_cargo_alloys > 0) {
		if (first == true) text += ", ";
		first = true;
		text += expandMissionText("IR_finance_brief_2_alloys", {amount: missionVariables.IR_cargo_alloys});
	}
	if (missionVariables.IR_cargo_alien_items > 0) {
		if (first == true) text += ", ";
		first = true;
		text += expandMissionText("IR_finance_brief_2_alien_items", {amount: missionVariables.IR_cargo_alien_items});
	}
	if (missionVariables.IR_cargo_platinum > 0) {
		if (first == true) text += ", ";
		text += expandMissionText("IR_finance_brief_2_platinum", {amount: missionVariables.IR_cargo_platinum});
	}
	text += expandMissionText("IR_finance_brief_2_suffix");
	return text;
}