"use strict";
this.name = "IronRaven_Conditions";
this.author = "phkb";
this.copyright = "2025 phkb";
this.description = "Condition script for ships and equipment.";
this.licence = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (eqKey, ship, context) {
    if (context == "scripted") return true;
    switch (eqKey) {
        case "EQ_IR_FUEL_SAMPLE_MINE":
            if (missionVariables.IR_finance_quest == "IRRADIATE" && galaxyNumber == 7 && system.ID == 31) return true;
            break;
        case "EQ_IR_SABOTAGE_MINE":
            if (missionVariables.IR_defences_quest == "DEMO_4" && galaxyNumber == 7 && system.ID == 180) return true;
            break;
    }
    return false;
}

//-------------------------------------------------------------------------------------------------------------
this.allowSpawnShip = function (shipKey) {
    switch (shipKey) {
        case "IR-comray":
        case "IR-giantray":
            if (galaxyNumber == 7) return true;
            break;
        case "IR-quico-viper":
        case "IR-quit-ad":
            if (galaxyNumber == 7 && system.ID == 23) return true;
            break;
        case "IR-korshkov-ad":
            if (galaxyNumber == 7 && system.ID == 31) return true;
            break;
        case "IR-pleasureworld-ad":
            if (galaxyNumber == 7 && system.ID == 119) return true;
            break;
        case "IR-GSE-ad":
            if (galaxyNumber == 7 && system.ID == 219) return true;
            break;
        case "IR-yk-ad":
            if (galaxyNumber == 7 && system.ID == 39) return true;
            break;
        case "IR-policekrait":
            if (galaxyNumber == 7 && system.government == 0) return true;
            break;
    }
    return false;
}