"use strict";
this.name = "IR-cherkasova.js";
this.author = "Ramirez";
this.copyright = "November 2010";
this.description = "Script for Major cherkasova";
this.version = "2.0";

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
	if (missionVariables.IR_status == "IR_IBANEZ_5") {
		/*if (this.ship.displayName == this.ship.name) {
			this.ship.displayName = "Starstrike";
			if (worldScripts.randomshipnames) {
				if (!missionVariables.IR_cherkasova_shipID) {
					missionVariables.IR_cherkasova_shipID = worldScripts.randomshipnames.$randomPoliceName(ship);
				}
				this.ship.displayName += ": " + missionVariables.IR_cherkasova_shipID;
			}
		}*/
	}
}

//-------------------------------------------------------------------------------------------------------------
this.sendWarning = function () {
	worldScripts["IR-mfd.js"].$updateMFD("IR_cherk_return", null, this.ship, "Starstrike");
}

//-------------------------------------------------------------------------------------------------------------
this.shipTargetDestroyed = function () {
	worldScripts["IR-mfd.js"].$updateMFD("IR_starstrike_gotone", null, this.ship);
}

//-------------------------------------------------------------------------------------------------------------
this.shipEnergyIsLow = function () {
	this.ship.energy = 20000;
}

//-------------------------------------------------------------------------------------------------------------
this.watchAim = function() {
	this.ship.commsMessage("IR-watch-aim");
}

//-------------------------------------------------------------------------------------------------------------
//the following functions are taken from Hired Guns OXP
this.locatePlayer = function () {
	this.playerArray = system.shipsWithPrimaryRole("player");
	if (this.playerArray.length > 0) {
		this.ship.target = this.playerArray[0];
		this.ship.reactToAIMessage("PLAYER_FOUND");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.checkPlayerDistance = function () {
	if (!player.ship) {
		return;
	} else
		this.playerDistance = this.ship.position.distanceTo(player.ship);
	
	if (this.playerDistance > 51200) { // if the escort is more than 2 scanner ranges from the player, move it just off-scanner
		let playerDirection = player.ship.position.subtract(this.ship.position).direction();
		let newPosition = player.ship.position.subtract(playerDirection.multiply(30000));
		if (oolite.compareVersion('1.73') <= 0) {
			this.ship.position = newPosition;
		} else {
			this.ship.setPosition(newPosition);
		}
		this.ship.reactToAIMessage("PLAYER_MID");
		return;
	}

	if (this.playerDistance < 25600) {
		this.ship.reactToAIMessage("PLAYER_NEAR");
	} else {
		if (this.playerDistance > 38400 || player.ship.speed > 2000) {
			this.ship.reactToAIMessage("PLAYER_FAR");
		} else {
			this.ship.reactToAIMessage("PLAYER_MID");
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.combatCheck = function () {
	if (this.ship.target && this.ship.target.isDerelict) {
		this.ship.target = null;
		this.ship.reactToAIMessage("TARGET_EJECTED");
	}

	if (!player.ship || !player.ship.position)
	this.playerDistance = this.ship.position.distanceTo(player.ship);
	if (this.playerDistance > 51200) { // if the escort is more than 2 scanner ranges from the player, break off combat
		this.ship.AIState = "LOCATE_PLAYER";
	} else {
		this.ship.reactToAIMessage("ENEMY_FIRE");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.findPlayerHostiles = function () {
	function isHostileToPlayer(entity) {
		return (entity.isThargoid || (entity.isShip && entity.target && entity.target == player.ship && entity.hasHostileTarget && !entity.isDerelict));
	}
	
	var targets = system.filteredEntities(this, isHostileToPlayer, this.ship, this.ship.scannerRange);
	if (targets.length > 0) {
		this.ship.target = targets[0];
		this.ship.reactToAIMessage("HOSTILE_FOUND");
	} else {
		this.ship.reactToAIMessage("NO_HOSTILE_FOUND");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.fireCheck = function () {
	if (player.ship.target == this.ship && this.ship.target.isPlayer) {
		this.ship.reactToAIMessage("FRIENDLY_FIRE");
	} else {
		this.ship.reactToAIMessage("ENEMY_FIRE");
	}
}