"use strict";
this.name = "IR-brief.js";
this.author = "phkb";
this.description = "Adds Iron Raven's GalCop Brief to the Ship's Library";
this.version = "2.0";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (missionVariables.IR_addedBrief && missionVariables.IR_addedBrief == "yes") {
		this._registerIRBrief();
	}
}

//-------------------------------------------------------------------------------------------------------------
this._registerIRBrief = function () {
	missionVariables.IR_addedBrief = "yes";
	var contents = [
		{ level: 0, key: "iron_raven-frontpage", params: [function () { return worldScripts["IR-main-script.js"]._line; }] },
		{ level: 1, key: "iron_raven-commercialorgs" },
		{ level: 2, key: "iron_raven-commercial1", backgrounds: ["IR_lib_korsh_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial2", backgrounds: ["IR_lib_gse_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial3", backgrounds: ["IR_lib_quico_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial4", backgrounds: ["IR_lib_nwe_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial5", backgrounds: ["IR_lib_yk_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial6", backgrounds: ["IR_lib_pw_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial7", backgrounds: ["IR_lib_janes_logo.png", ""] },
		{ level: 2, key: "iron_raven-commercial8", backgrounds: ["IR_lib_sirius_logo.png", ""] },
		{ level: 1, key: "iron_raven-noncommercialorgs" },
		{ level: 2, key: "iron_raven-noncommercial1", backgrounds: ["IR_lib_loa_logo.png", ""] },
		{ level: 2, key: "iron_raven-noncommercial2", backgrounds: ["IR_lib_sdf_logo.png", ""] },
		{ level: 2, key: "iron_raven-noncommercial3", backgrounds: ["IR_lib_ksr_logo.png", ""] },
		{ level: 1, key: "iron_raven-appendix" },
		{ level: 2, key: "iron_raven-objectives" },
		{ level: 2, key: "iron_raven-procedure" },
		{ level: 2, key: "iron_raven-hints" },
	];

	worldScripts["Ships Library"]._registerBook("iron_raven", expandMissionText("iron_raven-brief"), contents, 22);
	worldScripts["IR-main-script.js"].$addAllInfoToPad();
}
