"use strict";

this.name    = "Distant_Thunder";
this.version = "0.1";
this.author  = "Qwen2.5-Max";

// Preload the sound files before first launch
this.missionScreenOpportunity = function () {
    // Load the sound files into Sound objects
    this.planetSound = Sound.load("[aegis-planet]");   // dt_nearing_planet.ogg
    this.stationSound = Sound.load("[aegis-station]"); // dt_nearing_station.ogg

    log(this.name, "Preloaded distant thunder sounds.");
    delete this.missionScreenOpportunity; // Ensure this function runs only once
};

// Event handler for entering planetary vicinity
this.shipEnteredPlanetaryVicinity = function (planet) {
    if (this.planetSound) {
        var soundSource = new SoundSource();
        soundSource.sound = this.planetSound;
        soundSource.volume = 1.0; // Full volume
        soundSource.play();

        log(this.name, "Played sound for nearing planet: " + planet.name);
    } else {
        log(this.name, "Error: Planet sound not loaded.");
    }
};

// Event handler for entering station aegis
this.shipEnteredStationAegis = function (station) {
    if (this.stationSound) {
        var soundSource = new SoundSource();
        soundSource.sound = this.stationSound;
        soundSource.volume = 1.0; // Full volume
        soundSource.play();

        log(this.name, "Played sound for nearing station: " + station.name);
    } else {
        log(this.name, "Error: Station sound not loaded.");
    }
};