// JavaScript for Oolite (ECMAScript 5)
"use strict";

    this.license = "CC-BY-NC-SA 4.0";
    this.author  = "Qwen2.5-Max";
    this.version = "1.4";
    this.name    = "eq_dynooverse_control";

/* ========================================================
        DYNOOVERSE CONTROL

  Updates biases in the Dynooverse worldScript.
  Moods: boom > bloom > random > gloom > doom > neutral > loop
=========================================================== */

// Array of mood options in the desired order
this.moods = ["boom", "bloom", "random", "gloom", "doom", "neutral"];

// Initialize the current mood index
this.currentMoodIndex = -1; // Start uninitialized (-1 means first call sets to "random")

// Helper function to generate a random bias value between 0.33 and 0.66
this._getRandomBias = function () {
    var randomBias = 0.33 + Math.random() * 0.33; // Random value in range [0.33, 0.66]
    return parseFloat(randomBias.toFixed(3)); // Round to 3 decimal places
};

// Function to update biases based on the current mood
this._updateBiases = function (mood) {
    var ws = worldScripts.dynooverse;
    if (ws && ws.biases) {
        var biases;
        switch (mood) {
            case "boom":
                biases = {
                    agriculture: 0.7,
                    industry: 0.7,
                    government: 0.7,
                    techlevel: 0.7,
                    population: 0.7,
                    productivity: 0.7
                };
                log(this.name, "Biases updated to 'Boom' mode.");
                player.consoleMessage("Dynooverse biases updated to 'Boom' mode.", 6);
                break;

            case "bloom":
                biases = {
                    agriculture: 0.6,
                    industry: 0.6,
                    government: 0.6,
                    techlevel: 0.6,
                    population: 0.6,
                    productivity: 0.6
                };
                log(this.name, "Biases updated to 'Bloom' mode.");
                player.consoleMessage("Dynooverse biases updated to 'Bloom' mode.", 6);
                break;

            case "random":
                biases = {
                    agriculture: this._getRandomBias(),
                    industry: this._getRandomBias(),
                    government: this._getRandomBias(),
                    techlevel: this._getRandomBias(),
                    population: this._getRandomBias(),
                    productivity: this._getRandomBias()
                };
                log(this.name, "Biases updated randomly.");
                player.consoleMessage("Dynooverse biases updated randomly.", 6);
                break;

            case "gloom":
                biases = {
                    agriculture: 0.4,
                    industry: 0.4,
                    government: 0.4,
                    techlevel: 0.4,
                    population: 0.4,
                    productivity: 0.4
                };
                log(this.name, "Biases updated to 'Gloom' mode.");
                player.consoleMessage("Dynooverse biases updated to 'Gloom' mode.", 6);
                break;

            case "doom":
                biases = {
                    agriculture: 0.3,
                    industry: 0.3,
                    government: 0.3,
                    techlevel: 0.3,
                    population: 0.3,
                    productivity: 0.3
                };
                log(this.name, "Biases updated to 'Doom' mode.");
                player.consoleMessage("Dynooverse biases updated to 'Doom' mode.", 6);
                break;

            case "neutral":
                biases = {
                    agriculture: 0.5,
                    industry: 0.5,
                    government: 0.5,
                    techlevel: 0.5,
                    population: 0.5,
                    productivity: 0.5
                };
                log(this.name, "Biases returned to neutral settings.");
                player.consoleMessage("Dynooverse biases returned to neutral settings.", 6);
                break;

            default:
                log(this.name, "Error: Unknown mood '" + mood + "'.");
                player.consoleMessage("Error: Unknown mood '" + mood + "'.", 10);
                return;
        }
        ws.biases = biases;
    } else {
        player.ship.removeEquipment("EQ_DYNOOVERSE_CONTROL");
        log(this.name, "Removed EQ_DYNOOVERSE_CONTROL due to missing dynooverse.");
        log(this.name, "Error: dynooverse or its biases property is not available.");
        player.consoleMessage("Error: Dynooverse is required for this equipment.", 10);
    }
};

/* ========================================================
        ACTIVATED FUNCTION

    Moves one step forward in the mood loop.
=========================================================== */

this.activated = function () {
    // Initialize to "random" on the first call
    if (this.currentMoodIndex === -1) {
        this.currentMoodIndex = this.moods.indexOf("random");
    } else {
        // Move to the next mood in the loop
        this.currentMoodIndex = (this.currentMoodIndex + 1) % this.moods.length;
    }

    var mood = this.moods[this.currentMoodIndex];
    this._updateBiases(mood);
};

/* ========================================================
        MODE FUNCTION

    Moves one step backward in the mood loop.
=========================================================== */

this.mode = function () {
    // Initialize to "random" on the first call
    if (this.currentMoodIndex === -1) {
        this.currentMoodIndex = this.moods.indexOf("random");
    } else {
        // Move to the previous mood in the loop
        this.currentMoodIndex = (this.currentMoodIndex - 1 + this.moods.length) % this.moods.length;
    }

    var mood = this.moods[this.currentMoodIndex];
    this._updateBiases(mood);
};

/* ========================================================
            THE END
=========================================================== */