"use strict";

this.name = "Python Squeeze";
this.author = "Reval";
this.description = "Recruit one or more Python II companion traders to accompany you in convoy from witchpoint to Main Station. Choose how many to hire. You are their leader and you must pay them, but they pay you a percentage of their trade earnings on every successful run.";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.0.0";

/* 


*/


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_PS_PYTHON_COMPANION") {		
		pc("Recruiting "+this.$psNumCompanion+"x Python IIc convoy-companions.",9);
		pc("Please verify details on your M.L. F4 Interface.",9);
		this.$psCompanionEnabled="yes";
	} else
	// Service cancellation removal and refund
	if (equipment == "EQ_PS_PYTHON_COMPANION_REM") {
		player.ship.removeEquipment("EQ_PS_PYTHON_COMPANION");
		player.ship.removeEquipment("EQ_PS_PYTHON_COMPANION_REM");
		pc("Dismissing your PYTHON II Companion convoy.",9);
		player.credits += this.$psCost/2;
		pc("Amount refunded: "+ this.$psCost/2,9);
	}
}



this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$psHFExempt;
	// check we have Convoy service, the fee is not paid, and we're not exempt
	if ((this.$psHasCompanion) && (this.$psNumCompanion>0) && (this.$psHandlingPaid==="no") && (this.$psShips.length>0)) {
		var fee = 0;
		for (var x=1; x<= this.$psNumCompanion; x++)
			fee += this.$psHandlingFee;
		// record fee and debit trader's account
		this.$psHandlingFeeTotal += fee;
		player.credits -= fee;
		this.$psHandlingPaid = "yes";
		pc(this.$psNumCompanion+" x Python II Convoy wages: "+fee+" cr",9);
		this.$psHandlingCount++;
		// Leader pays Convoy 5% of earnings per system
		var bonus = Math.floor(this.$psLeaderEarnings*0.05);
		player.credits -= bonus;
		this.$psLeaderBonus = bonus;
		// add it to Total bonuses paid since contract
		this.$psLeaderTotal += bonus;
		pc("Leader bonus for Python II Convoy: "+bonus+" cr",9);
	}
	// Convoy pays leader 10% of trade earnings
	if ((this.$psHasCompanion) && (this.$psNumCompanion>0) && (!this.$psConvoyPaidMe)) {
		var percentpay = Math.floor(this.$psConvoyTotal*0.1);
		if (percentpay>0) pc("PYTHON Convoy percentage: "+percentpay+" cr",9);
		this.$psConvoyEarnings += percentpay;
		player.credits += percentpay;
		this.$psConvoyPercent = percentpay;
		this.$psConvoyPaidMe = true;
	}
	
	if (this.$psHasCompanion) {
		// conditionally take maintenance fee
		if (this.$psNumCompanion>0) this._psDoMaintenance();
		// prepare Companion Contract and Options pages
		this._psPrepAcc(station);
		this._psPrepOpt(station);
		this._psShowStatus();	
	}
}



this.shipLaunchedFromStation = function(stationLaunchedFrom) {
	var pc = player.commsMessage;
	// have convoy Companions been hired?
	this.$psHasCompanion = (player.ship.equipmentStatus ("EQ_PS_PYTHON_COMPANION") === "EQUIPMENT_OK");
	if (this.$psHasCompanion && this.$psNumCompanion>0) {
		pc("PYTHON convoy will rendezvous after Jump.",6);
	} else pc("PYTHON Convoys are hirable from Station!");
}



this.shipEnteredStationAegis = function(station) {
	var pc = player.commsMessage, ps = player.ship, notwith=0;
	if (this.$psHasCompanion && this.$psNumCompanion>0) {
		pc("PYTHON convoy thanks you for your protection!",9);
		// switch convoy AI to 'dock'
		for (var x = 0; x<this.$psShips.length; x++)
			this.$psShips[x].switchAI("dockingAI.plist");
	
		// No percentage if most are not with you!
		try {
			var count = 0, psp = ps.position;
			for (var x = 0; x<this.$psShips.length; x++) {
				if (this.$psShips[x] != null) {
					var dist = Math.floor(psp.distanceTo(this.$psShips[x].position)/100);
					if (dist>500) notwith++;
					count++;
				}
			}
		} catch(err) { /* ship destroyed */ }
		
		if (notwith > (count / 2)) {
			pc("PYTHON Convoy: Leader is not with us. No percentage!");
			this.$psConvoyPaidMe = true;
		}
	}
}



this.shipExitedWitchspace = function() {
	var pc = player.commsMessage, s=system.stations;
	// are we monitoring the convoy?
	this.$psMonitor = true;
	// start the Monitor timer, if already created
	if (this.$psTimer) this.$psTimer.start();
	// muster convoy Companions somewhere near witchpoint
	if (this.$psHasCompanion && this.$psNumCompanion>0) {
		pc("PYTHON Companion convoy arriving...",6);
		this.$psShips = system.addShips("ps_convoy", this.$psNumCompanion);
		var ships = this.$psShips;
		// Count the convoy ships that turned up
		pc(ships.length+" PYTHON Convoy ships have called in.");
		this.$psConvoyStrength = ships.length;
		// Convoy reports-in with applicable information
		var main = system.mainStation.name;
		this.$psConvoyTotal = 0.0;
		// make each Companion a member of a Group
		this.$psGroup = new ShipGroup("PYTHON Convoy",player.ship);
		for(var x=0; x<ships.length; x++) {
			ships[x].setCargoType("SCARCE_GOODS");
			// Convoy's likely earnings this system
			for(var y=0; y<ships[x].cargoList.length; y++) {
				var sc = ships[x].cargoList[y];
				this.$psConvoyTotal += this._psMarketPriceByName(main, sc.commodity, sc.quantity);
			}
			// Leader's likely earnings: for Bonus payment to convoy
			this.$psLeaderEarnings = 0.0;
			for(var m=0; m<manifest.list.length; m++) {
				var mc = manifest.list[m];
				this.$psLeaderEarnings += this._psMarketPriceByName(main, mc.commodity, mc.quantity);
			}
			// TEST 
			this.$psLeaderEarnings = Math.floor(this.$psLeaderEarnings);
			pc("PYTHON Leader earnings this system: "+this.$psLeaderEarnings);
			// add each companion to a Group
			this.$psGroup.addShip(ships[x]);
		}
		// Assess total earnings for convoy at Main Station
		this.$psConvoyTotal = Math.floor(this.$psConvoyTotal);
		pc("PYTHON Convoy Earnings this system: "+this.$psConvoyTotal+" cr",9);
	} else pc("PYTHON Convoys are hirable from Station!");
	// set handling paid to 'no'
	this.$psHandlingPaid = "no";
	this.$psRuns ++;
	this.$psConvoyPaidMe = false;
}



this.shipWillDockWithStation = function(station) {
	// remove fast-docking equipment
	player.ship.removeEquipment("EQ_ET_AUTODOCK");
	// stop the Monitor timer
	if (this.$psTimer) this.$psTimer.stop();
	// disable convoy monitor
	this.$psMonitor = false;
	// nullify Group
	this.$psGroup = null;
}


this.shipWillLaunchFromStation = function(station) {
	// enable fast docking
	this._installAutoDock();
	// set up 'Convoy Monitor' (fires once per second)
	if(!this.$psTimer) this.$psTimer=new Timer(this,this._psMonitorConvoy.bind(this),0,1.0);
}


this._psMonitorConvoy = function() {
var ps = player.ship;

// present distance to station
var spos = system.mainStation.position;
// time to Station at current speed, in minutes
var timetoStation = null;
if (ps.speed>0.0) // avoid division by zero
	 timetoStation = Math.floor((ps.position.distanceTo(spos) / ps.speed) / 60);
// periodically, check distances to each ship
if ((clock.secondsComponent === 1) && (this.$psShips != null) && (this.$psMonitor)) {
	var pc = player.consoleMessage;
	// show time to main Station, at current speed
	// if (timetoStation != null) pc("Time to Station: "+timetoStation+" minutes.",9);
	
	pc(" "); // line-break before list
	for (var x = 0; x<this.$psShips.length; x++) {
		if (this.$psShips[x] != null) {
			try {
				var dist = Math.floor(ps.position.distanceTo(this.$psShips[x].position)/100);
				if (dist>300)pc("Convoy-PYTHON #"+(x+1)+": I am "+dist+" Lk from you - off scan.");
				// retrieve ship if stuck more than 2000 Lk away
				if ((dist>1500) && (!ps.torusEngaged) && (!ps.injectorsEngaged) && (!(ps.speed>ps.maxSpeed))) 
					this.$psShips[x].position = this.$psLastPos;
			} catch(err) {
				player.commsMessage("PYTHON Convoy ship #"+(x+1)+" is not responding.",9);
			}
		}
	}
}
if ((clock.secondsComponent === 10) && (this.$psShips != null) && (this.$psMonitor)) {
	var pcm = player.consoleMessage;
	var ds = Math.floor(this.$psShips[0].desiredSpeed);
	if (ds>0) pcm("PYTHON Convoy: Our designated speed is "+ds,9);
}
// note ship-position one second ago
this.$psLastPos = ps.position;
}




this.playerWillSaveGame = function(message) {
	missionVariables.psNumCompanion = this.$psNumCompanion;
	missionVariables.psCompanionEnabled = this.$psCompanionEnabled;
	// save total fees taken
	missionVariables.psHandlingFeeTotal = this.$psHandlingFeeTotal;
	missionVariables.psMaintenanceFeeTotal = this.$psMaintenanceFeeTotal;
	missionVariables.psDismantlingFeeTotal = this.$psDismantlingFeeTotal;
	missionVariables.psHandlingPaid = this.$psHandlingPaid;
	// system-to-system runs w/pod
	missionVariables.psRuns =this.$psRuns;
	// handling fee count
	missionVariables.psHandlingCount = this.$psHandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.psHFExempt = this.$psHFExempt;
	// maintenance fee count
	missionVariables.psMaintenanceCount = this.$psMaintenanceCount;
	// Cumulative total earned from convoy
	missionVariables.psConvoyEarnings = this.$psConvoyEarnings;
	// Cumulative bonuses paid to convoy
	missionVariables.psLeaderTotal = this.$psLeaderTotal;
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.psNumCompanion != null) 
		this.$psNumCompanion = missionVariables.psNumCompanion;
	if (missionVariables.psCompanionEnabled != null) 
		this.$psCompanionEnabled = missionVariables.psCompanionEnabled;
	// Load total fees taken
	if (missionVariables.psHandlingFeeTotal != null)
		this.$psHandlingFeeTotal = missionVariables.psHandlingFeeTotal;
	if (missionVariables.psHandlingPaid != null)
		this.$psHandlingPaid = missionVariables.psHandlingPaid;
	if (missionVariables.psMaintenanceFeeTotal != null)
		this.$psMaintenanceFeeTotal = missionVariables.psMaintenanceFeeTotal;
	if (missionVariables.psDismantlingFeeTotal != null)
		this.$psDismantlingFeeTotal = missionVariables.psDismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.psRuns != null)
		this.$psRuns = missionVariables.psRuns;
	// Load Handling fee count
	if (missionVariables.psHandlingCount != null)
		this.$psHandlingCount = missionVariables.psHandlingCount;
	// Load handling fee exemption status
	if (missionVariables.psHFExempt != null)
		this.$psHFExempt = missionVariables.psHFExempt;
	// Load Maintenance fee count
	if (missionVariables.psMaintenanceCount != null)
		this.$psMaintenanceCount = missionVariables.psMaintenanceCount;
	// Cumulative total earned from convoy
	if (missionVariables.psConvoyEarnings != null)
		this.$psConvoyEarnings = missionVariables.psConvoyEarnings;
	// Cumulative bonuses paid to convoy
	if (missionVariables.psLeaderTotal != null)
		this.$psLeaderTotal = missionVariables.psLeaderTotal;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// CompanionS PRESENT?
	this.$psHasCompanion = (player.ship.equipmentStatus ("EQ_PS_PYTHON_COMPANNION") === "EQUIPMENT_OK");
	if (this.$psHasCompanion) {
		// prepare pod Account screen
		var sta = player.ship.dockedStation;
		this._psPrepAcc(sta);
		this._psPrepOpt(sta);
		this._psShowStatus();
	}
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// declare & initialize globals
	// Trader may be provided with PYTHON II Companion ships
	this.$psHasCompanion = false;
	// Traders have the option to disable the service
	this.$psCompanionEnabled = "no";
	// Traders may choose the number of ships to accompany them
	this.$psNumCompanion = 3;
	// purchase cost of Companion contract
	this.$psCost = 900;
	// handling fee for Companion Service
	this.$psHandlingFee = 0.05*this.$psCost; 
	this.$psHandlingFeeTotal = 0;
	this.$psHandlingPaid = "yes"; // or "no" - easier than boolean
	this.$psHandlingCount = 0;
	this.$psHFExempt = "no";
	// maintenance fees and wages for convoy Companions
	this.$psMaintenanceFee = 0.075*this.$psCost;
	this.$psMaintenanceFeeTotal = 0;
	this.$psMaintenancePaid = "no" // or "yes"
	this.$psMaintenanceInterval = 10; // in runs (according to cost)
	this.$psMaintenanceCount = 0;
	// fee for cancellation of Companion contraps
	this.$psDismantlingFee = 0.5*this.$psCost; 
	this.$psDismantlingFeeTotal = 0.0;
	// Total cumulative earnings from convoy
	this.$psConvoyEarnings = 0;
	this.$psConvoyPaidMe = false;
	// Leader earnings this system
	this.$psLeaderEarnings = 0.0;
	// Leader total earnings since Convoy contract
	this.$psLeaderTotal = 0.0;
	// Bonus paid by Leader to Convoy this system
	this.$psLeaderBonus = 0.0;
	// Percentage paid by Convoy to Leader this system
	this.$psConvoyPercent = 0.0;
	// how many companions turn up and/or survive
	this.$psConvoyStrength = 0;
	// Total convoy earnings this system
	this.$psConvoyTotal = 0.0;
	// system-to-system runs w/service
	this.$psRuns = 0;
	// global array to hold the convoy
	this.$psShips = null;
	// convoy's Group
	this.$psGroup = null;
	// Are we monitoring?
	this.$psMonitor = false;
}


// assess and take maintenance fee
this._psDoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$psRuns;
	var intv = this.$psMaintenanceInterval;
	var mfee = this.$psMaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$psNumCompanion; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$psMaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc(this.$psNumCompanion,"x PYTHON II Convoy wages: "+fee+" cr",9);
		// update Maintenance count
		this.$psMaintenanceCount++;
	}
}


this._installAutoDock = function() {
	var p = player.ship;
	// give the Companion-contracted trader free fast-docking facilities at any station
	if (p.equipmentStatus("EQ_DOCK_COMP") != "EQUIPMENT_OK") {
			p.awardEquipment("EQ_ET_AUTODOCK");
	}
}



this._psGetRandomInt = function(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}



// price of a good at a given station, in cr
this._psMarketPrice = function(sta, good) {
	var price=0.0, mar=sta.market;
	price = mar[good].price/10;
	return price.toFixed(1);
}



// price of <quantity> <named> good, ie. "furs", at a <named> station, ie. "Coriolis Station"
this._psMarketPriceByName = function(namesta, namegood, quant) {
	var price=0, s=system.stations;
		
	for (var i=0; i<s.length; i++)  {
		if (s[i].name === namesta) { 
			price = this._psMarketPrice(s[i], namegood);
			break;
		}
	}
	return price*quant;
}	
	


// Convoy earnings staus for F5 Missions screen

this._psShowStatus = function() {
	
	var lbs = this.$psLeaderBonus;
	var cps = this.$psConvoyPercent;
	
	var status_LBS = "Bonus paid to Convoy: "+formatCredits(lbs,true,true);
	var status_CPS = "Percentage paid by Convoy: "+formatCredits(cps,true,true);
	
	mission.setInstructions(["PYTHON Convoy:",status_LBS,status_CPS], this.name);
}

	
/* F4 Interfaces */


// create M.L.S.S. 'contract & Account' page 
this._psPrepAcc = function(station) {
	station.setInterface("psAcc",{
	title: "Your PYTHON II Companion convoy Contract",
	category: "C.S.A.",
	summary: "Your Convoy Services Agency PYTHON II Companion(s) account screen shows terms, wages, convoy earnings, and other pertinent information.",
	callback: this._psShowAcc.bind(this)
	});	
}


// show M.L.S.S. 'contract & Account' page
this._psShowAcc = function() {
	var hfc = this.$psHandlingCount;
	var mfc = this.$psMaintenanceCount;
	var mfi = this.$psMaintenanceInterval;
	var hft = this.$psHandlingFeeTotal;
	var mft = this.$psMaintenanceFeeTotal;
	var dft = this.$psDismantlingFeeTotal;
	// Total Leader bonuses to convoy since contract
	var lbc = this.$psLeaderTotal;
		
	var parameters = new Object();
	
	parameters.title = "Convoy Services Agency (C.S.A.)";
	
	parameters.message = "Dear Convoy Leader, \n\n";
	
	if (this.$psNumCompanion>0) 
		parameters.message +="This constitutes your Contract and Account for PYTHON II convoy companion(s) x "+this.$psNumCompanion+": \n\n"; 
	 else
		parameters.message +="You have no Convoy Service contract with us at this time. \n\n";
	
	parameters.message +="Convoy wages paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Convoy maintenance paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Convoy Leader bonuses paid: "+lbc+" cr ("+hfc+") \n"; 
	parameters.message +="Total earnings from Convoy: "+this.$psConvoyEarnings+" cr \n\n";
	
	parameters.message += "Convoy companions expect wages and maintenance for their ships, which you, as part of your contract with our Agency, and as convoy leader, have contracted to cover from your account. In addition, you have agreed to pay the convoy 5% of your station earnings, as bonus and incentive. In return for your protection, each companion will pay you 10% of their trade-earnings. \n\n";
	
	parameters.message += "The wage (0.05 of cost) is levied upon docking, the maintenance fee (0.075 of cost) every "+mfi+" trading runs. \n\n"
	
	parameters.message += "On termination, we must charge a dismissal fee (0.5 of cost) to cover any losses or legal fees incurred during service. \n";
	
	parameters.choicesKey = "psAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("Convoy Services Agency thanks you for your attention.");
	}
}



// create M.L.S.S. 'Companion Options' page 
this._psPrepOpt = function(station) {
	station.setInterface("psOpt",{
	title: "Your C.S.A. PYTHON II Convoy Options",
	category: "C.S.A.",
	summary: "C.S.A. Convoy Services Agency offers you these choices in regard to your PYTHON II convoy Companion contract.",
	callback: this._psShowOpt.bind(this)
	});	
}


// Offer M.L.S.S. Options for Mamba Companion Service
this._psShowOpt = function() {
		
	var parameters = new Object();
	var pc = player.commsMessage;
	
	parameters.title = "Convoy Services Agency (C.S.A.)";
	
	parameters.message = "Dear trader, \n\n";
	
	if (this.$psNumCompanion>0) 
		parameters.message +="C.S.A. Convoy Services Agency is pleased to offer you the following options as to the numbert of Companion craft to be deployed with your ship: \n\n"; 
	 else
		parameters.message +="You have no convoy Companion ships in your employ for this trade-run at this time. Please seleps from the options below: \n\n";
		
	
	parameters.choicesKey = "psOptions";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "0_NONE") this.$psNumCompanion=0; else 
		if (choice === "1_ONE")  this.$psNumCompanion=1; else
		if (choice === "2_TWO")  this.$psNumCompanion=2; else
		if (choice === "3_THREE")this.$psNumCompanion=3; else
		if (choice === "4_FOUR") this.$psNumCompanion=4; else
		if (choice === "5_FIVE") this.$psNumCompanion=5; else
		if (choice === "6_SIX")  this.$psNumCompanion=6;
			
		if (this.$psNumCompanion<1) { 
			this.$psCompanionEnabled="no";
			pc("C.S.A. notes your preference for no convoy."); 
		} else {
			this.$psCompanionEnabled="yes";
			pc("C.S.A. notes your preference for "+this.$psNumCompanion+" convoy Companions.");
		}
	}
}

