"use strict"; 

this.name				= "liners_aurora";
this.author				= "Thargoid";
this.copyright			= "Creative Commons: attribution, non-commercial, sharealike.";
this.description		= "Aurora shipscript";
this.version			= "1.6.2";


// the functions for placing the escorts around the Aurora ...
(function() {
const escortPositions =
[
    // X-shape escort pattern
    new Vector3D(-1, 1,  0),
    new Vector3D( 1, 1,  0),
    new Vector3D(-1, -1, 0),
    new Vector3D( 1, -1, 0)
];

// ... are nicked from Ahruman
this.coordinatesForEscortPosition = function(index)
{
    var highPart = 1 + (index >> 2);  // Equivalent to 1 + Math.floor(position / 4)
    var lowPart = index % 4;
    var spacing = this.ship.collisionRadius * 2.5 * highPart;
    return escortPositions[lowPart].multiply(spacing);
}
}).call(this);

this.shipEnergyIsLow = function()
	{
	if(!this.shipEvacuated)
		{
		this.shipEvacuated = true;
		this.ship.desiredSpeed = 0;
		var leftPods = Math.ceil(Math.random() * 10) + 5;
		var rightPods = Math.ceil(Math.random() * 10) + 5;
        var leftOrientation = this.ship.orientation.multiply([0.7071, 0, 0.7071, 0]);
        var rightOrientation = this.ship.orientation.multiply([0.7071, 0, -0.7071, 0]);
        var leftVelocity = this.ship.vectorRight.multiply(-200).add(this.ship.velocity);
        var rightVelocity = this.ship.vectorRight.multiply(200).add(this.ship.velocity);
		this.ship.commsMessage("Mayday, mayday! Hull breach imminent, all passengers and non-essential crew to the lifepods!");
		
		var offset, pod, fraction, i;
		for(i=0; i < rightPods; i++)
			{
            // ship has a triangular shape
            fraction = Math.random();
			offset = new Vector3D([(1 - fraction) * 1400, 0, (fraction * 4315) - 2155]);
			pod = system.addShips("escape-capsule", 1, this.ship.position.add(offset.rotateBy(this.ship.orientation)), 0)[0];
            pod.orientation = rightOrientation;
            pod.velocity = rightVelocity; // eject them outwards
			}
		
		for(i=0; i < leftPods; i++)
			{
            fraction = Math.random();
			offset = new Vector3D([(1 - fraction) * -1400, 0, (fraction * 4315) - 2155]); 
			pod = system.addShips("escape-capsule", 1, this.ship.position.add(offset.rotateBy(this.ship.orientation)), 0)[0];
            pod.orientation = leftOrientation;
            pod.velocity = leftVelocity;
			}
		}
	}

this.shipEnergyBecameFull = function()
	{
	this.shipEvacuated = false;
	}
