"use strict";
this.name = "LaveAcademy_targetDrone";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Script for the target drones in the shooting gallery of Lave Academy";
this.version = "1.3";

this.shipSpawned = function () {
	this.ship.scannerDisplayColor1 = "yellowColor";
	this.ship.scannerDisplayColor2 = "whiteColor";
	if (!missionVariables.laveAcademy_droneLifetime) {
		log("Lave Academy", "***** ALERT - Target drone lifetime mission variable not set! *****")
		missionVariables.laveAcademy_droneLifetime = 45;
	}
	this.destructTimer = new Timer(this, this.selfDestruct, missionVariables.laveAcademy_droneLifetime);  // set the drone's lifetime.
	this.targetBuoy = system.shipsWithPrimaryRole("laveAcademy_targetBuoy")[0];
}

this.shipDied = function (whom, why) {
	if (this.destructTimer && this.destructTimer.isRunning && whom && whom.isPlayer) {
		this.destructTimer.stop();
		player.score -= 1; // as this is an exam, the drones shouldn't count as kills for rank etc.
		this.targetBuoy.commsMessage(expandDescription("[academy_drone_destroyed]"), player.ship);
	}
}

this.selfDestruct = function selfDestruct () {
	if (!this.ship) {
		return;
	}

	if (!missionVariables.laveAcademy_droneAbort && !player.ship.docked) { // if the exam is still going but the player didn't kill the drone
		this.targetBuoy.commsMessage(expandDescription("[academy_drone_missed]"), player.ship);
	}
	this.ship.explode();
}

this.findBuoy = function () {
	if (!this.ship) {
		return;
	}

	this.buoyDistance = this.ship.position.distanceTo(this.targetBuoy.position); // how far the drone is from the buoy
	if (this.buoyDistance > 24000) { // if the drone is going out of scanner range
		this.ship.AIState = "BACK_TO_BUOY";
	}
}

this.playerWillEnterWitchspace = function () {
	if (this.destructTimer) {
		this.destructTimer.stop();
	}
}