"use strict";
this.name = "LaveAcademy_targetBuoy";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Control of academy target practice buoys in the Lave system";
this.version = "1.3";

this.examStart = function () {
	missionVariables.laveAcademy_droneLifetime = 45;

	if (player.score < 16) { // if player is ranked harmless or mostly harmless, give another 10 seconds to the drone
		missionVariables.laveAcademy_droneLifetime += 10;
	}

	if (player.ship.equipmentStatus("EQ_FUEL_INJECTION") != "EQUIPMENT_OK") { // if player doesn't have fuel injectors, add 15 more seconds
		missionVariables.laveAcademy_droneLifetime += 15;
	}

	if (player.ship.weaponRange == 12500) { // if player has only a short range laser, add 10 more seconds
		missionVariables.laveAcademy_droneLifetime += 10;
	}

	this.examStartTime = clock.absoluteSeconds;
	this.buoyPosition = this.ship.position;
	missionVariables.laveAcademy_droneCount = 0;
	missionVariables.laveAcademy_droneAbort = null;
	player.consoleMessage(expandDescription("[academy_gunnery_exam_started]"), 6);
	player.consoleMessage(expandDescription("[academy_drone_lifetime]", { secs: missionVariables.laveAcademy_droneLifetime }), 6);
	if (this.launchCheckTimer) {
		this.launchCheckTimer.start();
	}
	else {
		this.launchCheckTimer = new Timer(this, this.droneCheck, 0, 1);
	}
}

this.droneCheck = function droneCheck() {
	if (player.ship.docked) { // if the player is docked (at the Academy) then stop the test quietly
		this.launchCheckTimer.stop();
		missionVariables.laveAcademy_droneAbort = true;
		this.ship.AIState = "LIGHTS_OFF";
		missionVariables.laveAcademyExam = null;
		return;
	}

	function isPlayer(entity) { return entity.isShip && entity.isPlayer };
	this.playerInRange = system.filteredEntities(this, isPlayer, this.ship, 25600).length;
	if (this.playerInRange == 0) {
		missionVariables.laveAcademy_droneAbort = true;
		missionVariables.laveAcademy_droneCount -= 1;
		this.cancelExam();
	}

	if (missionVariables.laveAcademy_droneAbort) {
		this.launchCheckTimer.stop();
		return;
	}

	function isTargetDrone(entity) { return entity.isShip && entity.hasRole("laveAcademy_targetDrone") };
	if (system.filteredEntities(this, isTargetDrone, this.ship, 25600).length == 0) {
		if (missionVariables.laveAcademy_droneCount == 15) {
			this.endExam();
		}
		else {
			missionVariables.laveAcademy_droneCount += 1;
			switch (true) {
				case (missionVariables.laveAcademy_droneCount == 1):
					{
						this.ship.commsMessage(expandDescription("[academy_level_one]"), player.ship);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 6):
					{
						this.ship.commsMessage(expandDescription("[academy_level_two]"), player.ship);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 11):
					{
						this.ship.commsMessage(expandDescription("[academy_level_three]"), player.ship);
						break;
					}
			}
			this.examLevel = (Math.ceil(missionVariables.laveAcademy_droneCount * 0.2));
			this.droneRole = "laveAcademy_targetDroneL" + this.examLevel;
			//system.legacy_addShipsWithinRadius(this.droneRole, 1, "abs", this.buoyPosition, 12000);
			var dr = system.addShips(this.droneRole, 1, this.buoyPosition, 12000)[0];
		}
	}
}

this.endExam = function () {
	this.launchCheckTimer.stop();
	if (worldScripts["Welcome Information Script"]) { // if Welcome Mat has been disabled earlier, restart it
		if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
			worldScripts["Welcome Information Script"].welcomeTimer.start();
			if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") {
				player.consoleMessage(expandDescription("[academy_welcome_mat_enabled]"), 6);
			}
		}
	}
	this.examStopTime = clock.absoluteSeconds;
	this.examElapsedTime = Math.floor(this.examStopTime - this.examStartTime);
	this.examTimeMinutes = Math.floor(this.examElapsedTime / 60);
	this.examTimeSeconds = this.examElapsedTime - (60 * this.examTimeMinutes);
	missionVariables.laveAcademy_droneAbort = true;
	this.ship.commsMessage(expandDescription("[academy_exam_complete]", { mins: this.examTimeMinutes, secs: this.examTimeSeconds }), player.ship);
	this.ship.AIState = "LIGHTS_OFF";
	missionVariables.laveAcademyExam = null;
	this.bestTime = (missionVariables.laveAcademy_bestTargetTimeM * 60) + missionVariables.laveAcademy_bestTargetTimeS;

	if (this.bestTime == 0 && this.examElapsedTime > 0) {
		this.ship.commsMessage(expandDescription("[academy_new_best_time]"), player.ship);
		missionVariables.laveAcademy_bestTargetTimeM = Math.floor(this.examElapsedTime / 60);
		missionVariables.laveAcademy_bestTargetTimeS = this.examElapsedTime - (60 * (Math.floor(this.examElapsedTime / 60)));
		return;
	}

	if (this.bestTime > this.examElapsedTime) {
		this.ship.commsMessage(expandDescription("[academy_beat_best_time]"), player.ship);
		missionVariables.laveAcademy_bestTargetTimeM = Math.floor(this.examElapsedTime / 60);
		missionVariables.laveAcademy_bestTargetTimeS = this.examElapsedTime - (60 * (Math.floor(this.examElapsedTime / 60)));
		return;
	}
}

this.cancelExam = function () {
	this.launchCheckTimer.stop();
	this.examStopTime = clock.absoluteSeconds;
	this.examElapsedTime = Math.floor(this.examStopTime - this.examStartTime);
	this.examTimeMinutes = Math.floor(this.examElapsedTime / 60);
	this.examTimeSeconds = this.examElapsedTime - (60 * this.examTimeMinutes);
	missionVariables.laveAcademy_droneAbort = true;
	this.droneArray = system.shipsWithRole("laveAcademy_targetDrone")
	if (this.droneArray.length > 0) {
		this.droneArray.forEach(
			function (drone) {
				drone.remove()
			}
		)
	}
	this.ship.commsMessage(expandDescription("[academy_gunnery_test_abort", { mins: this.examTimeMinutes, secs: this.examTimeSeconds }), player.ship);
	this.ship.AIState = "LIGHTS_OFF";
	missionVariables.laveAcademyExam = null;
	if (worldScripts["Welcome Information Script"]) { // if Welcome Mat has been disabled earlier, restart it
		if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
			worldScripts["Welcome Information Script"].welcomeTimer.start();
			if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") {
				player.consoleMessage(expandDescription("[academy_welcome_mat_enabled]"), 6);
			}
		}
	}
}

this.playerWillEnterWitchspace = function () {
	if (worldScripts["Welcome Information Script"] && !worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
		worldScripts["Welcome Information Script"].welcomeTimer.start();
	}

	if (this.launchCheckTimer) {
		this.launchCheckTimer.stop();
	}
}