"use strict";
this.name = "LaveAcademy";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Control of new additions to the Lave (and other) systems";
this.version = "2.0";

this.extraA = true;   //   Academies in all galaxies? If false only appear at Lave, nowhere else - ignore extraB
this.extraB = false;   //   Single or multiple academies if extraA set. False gives 1 per galaxy, true gives 5

this.oxpcSettings = {
	Info: { Name: this.name, Display: this.name, InfoB: expandDescription("[academy_oxpconfig_bool_info]") },
	Bool0: { Name: "extraA", Def: true, Desc: expandDescription("[academy_config_allgalaxies]") },
	Bool1: { Name: "extraB", Def: false, Desc: expandDescription("[academy_config_multiple]") }
};

this._libSettings = {
	Name: this.name,
	Alias: expandDescription("[academy_config_alias]"),
	Display: expandDescription("[academy_config_display]"),
	Alive: "_libSettings",
	Bool: {
		B0: { Name: "extraA", Def: true, Desc: expandDescription("[academy_config_allgalaxies]") },
		B1: { Name: "extraB", Def: false, Desc: expandDescription("[academy_config_multiple]") },
		Info: expandDescription("[academy_libconfig_bool_info]")
	},
};

this.startUp = function () {
	if (missionVariables.laveAcademy_bestTargetTimeM == null) { missionVariables.laveAcademy_bestTargetTimeM = 0; }
	if (missionVariables.laveAcademy_bestTargetTimeS == null) { missionVariables.laveAcademy_bestTargetTimeS = 0; }
	if (missionVariables.laveAcademy_bestPilotScore == null) { missionVariables.laveAcademy_bestPilotScore = 0; }
	if (missionVariables.laveAcademy_bestPilotTimeM == null) { missionVariables.laveAcademy_bestPilotTimeM = 0; }
	if (missionVariables.laveAcademy_bestPilotTimeS == null) { missionVariables.laveAcademy_bestPilotTimeS = 0; }
	if (missionVariables.laveAcademy_bestDockingScore == null) { missionVariables.laveAcademy_bestDockingScore = 0; }
	if (missionVariables.laveAcademy_bestDockingTimeM == null) { missionVariables.laveAcademy_bestDockingTimeM = 0; }
	if (missionVariables.laveAcademy_bestDockingTimeS == null) { missionVariables.laveAcademy_bestDockingTimeS = 0; }
	this.deactivateWIS = false;

	if (missionVariables.LaveAcademy_extraA) this.extraA = (missionVariables.LaveAcademy_extraA == "1" ? true : false);
	if (missionVariables.LaveAcademy_extraB) this.extraB = (missionVariables.LaveAcademy_extraB == "1" ? true : false);

	this.setUpArrays();
}

this.startUpComplete = function () {
	// register our settings, if Lib_Config is present
	if (worldScripts.Lib_Config) worldScripts.Lib_Config._registerSet(this._libSettings);
}

this.playerWillSaveGame = function () {
	missionVariables.LaveAcademy_extraA = (this.extraA ? "1" : "0");
	missionVariables.LaveAcademy_extraB = (this.extraB ? "1" : "0");
}

this.setUpArrays = function () {
	this.academyList = [0, 1, 2, 3, 4, 5, 6, 7]; // galaxies 0-7
	this.academyList[0] = [7, 173, 168, 133, 4]; // Lave, Esteonbi, Enonla, Esanbe, Xequerin
	this.academyList[1] = [24, 92, 210, 55, 194]; // Maesaron, Erenanri, Reveabe, Legeara, Tigebere
	this.academyList[2] = [58, 165, 106, 198, 164]; // Radiqu, Edxeri, Ceedleon, Atius,Rerebi
	this.academyList[3] = [13, 47, 130, 18, 122]; // Mavelege, Bemate, Cebitiza,  Mausra, Ensoor
	this.academyList[4] = [16, 193, 231, 92, 9]; // Zaaner, Vebi, Inenares, Azaenbi, Dioris
	this.academyList[5] = [151, 6, 85, 146, 240]; // Teesso, Oresmaa, Celaan, Ariqu, Inesbe
	this.academyList[6] = [189, 146, 130, 118, 37]; // Isdilaon, Aenbi, Ataer, Orreedon, Qutegequ
	this.academyList[7] = [177, 31, 211, 157, 20]; // Ceenza, Aarzari, Biatzate, Inbein, Oredrier
}

this.systemCheck = function (planetNum, galNum) {
	if (!this.extraA) // academy at Lave only?
	{
		if (planetNum == 7 && galNum == 0) { return true; }
		else { return false; }
	}
	else {
		if (!this.extraB)	// 1 academy per galaxy
		{
			if (planetNum == this.academyList[galNum][0]) { return true; }
			else { return false; }
		}
		else	// 5 academies per galaxy
		{
			if (this.academyList[galNum].indexOf(planetNum) != -1) { return true; }
			else { return false; }
		}
	}
}

this.setUpSystem = function () {
	if (this.systemCheck(system.ID, galaxyNumber)) {
		var posLA = system.mainStation.position.add(system.mainStation.vectorRight.multiply(50000));
		system.setPopulator("laveAcademy", {
			callback: function (pos) {
				var ws = worldScripts.LaveAcademy;
				// because we're doing the setup during "systemWillPopulate", we don't need a lot of the arrays and checks from v1.33
				// find the academy (if it already exists)
				var academyArray = system.shipsWithPrimaryRole("laveAcademy_academy");
				if (academyArray.length === 0) academyArray = system.addShips("laveAcademy_academy", 1, pos, 0);
				var academy = academyArray[0];
				academy.scannerDisplayColor1 = "greenColor";
				academy.scannerDisplayColor2 = "brownColor";

				// set up the marker buoys
				system.addShips("laveAcademy_wayBuoy", 1, system.mainStation.position.add([0, 20000, 0]));
				ws.targetBuoy = system.addShips("laveAcademy_targetBuoy", 1, academy.position.add([0, 0, 20000]))[0];
				ws.dockingBuoy = system.addShips("laveAcademy_dockingBuoy", 1, academy.position.add([20000, 0, 0]))[0];
				ws.pilotBuoy = system.addShips("laveAcademy_pilotBuoy", 1, academy.position.add([-20000, 0, 0]))[0];

				ws.targetBuoy.AIState = "LIGHTS_OFF";
				ws.dockingBuoy.AIState = "LIGHTS_OFF";
				ws.pilotBuoy.AIState = "LIGHTS_OFF";

				//	Set the academy syllabus on the F4 screen, and remove the trunk ones for this station.
				academy.setInterface("LaveAcademy",
					{
						title: expandDescription("[academy_interface_title]"),
						category: expandDescription("[academy_interface_category]"),
						summary: expandDescription("[academy_interface_summary]"),
						callback: ws.showCourses.bind(ws)
					});
				academy.setInterface("oolite-contracts-cargo", null);
				academy.setInterface("oolite-contracts-parcels", null);
				academy.setInterface("oolite-contracts-passengers", null);
			},
			location: "COORDINATES",
			coordinates: posLA,
			deterministic: true
		});
	}
}

this.showCourses = function () {
	mission.runScreen({
		title: expandDescription("[academy_syllabus_title]"),
		messageKey: "laveAcademy_examOffer",
		choicesKey: "laveAcademy_offerChoice",
		screenID: "lave_academy"
	}, this.choseExam);
}

this.shipLaunchedFromStation = function () {
	if (this.systemCheck(system.ID, galaxyNumber) && this.deactivateWIS) {
		// if Welcome Mat is loaded & running, disable it to stop data messages with the course buoys
		if (worldScripts["Welcome Information Script"]) {
			if (worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
				worldScripts["Welcome Information Script"].welcomeTimer.stop();
				if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") player.consoleMessage(expandDescription("[academy_welcome_mat_disabled]"), 6);
			}
		}
		this.deactivateWIS = false;
	}
}

this.systemWillPopulate = function () {
	this.setUpSystem()
}

this.shipWillLaunchFromStation = function (station) {
	if (station.hasRole("laveAcademy_academy")) {
		// reactivate the trumble mission if it was available before docking.
		missionVariables.trumbles = missionVariables.laveAcademy_storeTrumble;

		switch (missionVariables.laveAcademyExam) { // Get the course started by setting the buoys AI states
			case "TARGET":
				{
					this.targetBuoy.AIState = "LIGHTS_ON";
					this.dockingBuoy.AIState = "LIGHTS_OFF";
					this.pilotBuoy.AIState = "LIGHTS_OFF";
					this.buoyID = this.targetBuoy;
					this.deactivateWIS = true;
					if (this.buoyTimer) { this.buoyTimer.start(); }
					else { this.buoyTimer = new Timer(this, this.checkBuoyDistance, 0, 10); }
					break;
				}
			case "DOCKING":
				{
					this.targetBuoy.AIState = "LIGHTS_OFF";
					this.dockingBuoy.AIState = "LIGHTS_ON";
					this.pilotBuoy.AIState = "LIGHTS_OFF";
					this.buoyID = this.dockingBuoy;
					this.deactivateWIS = true;
					if (this.buoyTimer) { this.buoyTimer.start(); }
					else { this.buoyTimer = new Timer(this, this.checkBuoyDistance, 0, 10); }
					break;
				}
			case "PILOT":
				{
					this.targetBuoy.AIState = "LIGHTS_OFF";
					this.dockingBuoy.AIState = "LIGHTS_OFF";
					this.pilotBuoy.AIState = "LIGHTS_ON";
					this.buoyID = this.pilotBuoy;
					this.deactivateWIS = true;
					if (this.buoyTimer) { this.buoyTimer.start(); }
					else { this.buoyTimer = new Timer(this, this.checkBuoyDistance, 0, 2); }
					break;
				}
			default:
				{
					this.targetBuoy.AIState = "LIGHTS_OFF";
					this.dockingBuoy.AIState = "LIGHTS_OFF";
					this.pilotBuoy.AIState = "LIGHTS_OFF";
					this.deactivateWIS = false;
					break;
				}
		}
	}
}

this.stopTimers = function () {
	if (this.buoyTimer) { this.buoyTimer.stop(); }
	if (this.targetTimer) { this.targetTimer.stop(); }
	if (this.pilotTimer) { this.pilotTimer.stop(); }
	if (this.dockingTimer) { this.dockingTimer.stop(); }

	if (this.targetBuoy && this.targetBuoy.script.launchCheckTimer) this.targetBuoy.script.launchCheckTimer.stop();
	if (this.dockingBuoy && this.dockingBuoy.script.launchCheckTimer) this.dockingBuoy.script.launchCheckTimer.stop();
	if (this.pilotBuoy) {
		if (this.pilotBuoy.script.pilotCourseTimer) this.pilotBuoy.script.pilotCourseTimer.stop();
		if (this.pilotBuoy.script.pilotFinishTimer) this.pilotBuoy.script.pilotFinishTimer.stop();
	}
}

this.shipWillEnterWitchspace = this.shipDied = function () {
	if (this.systemCheck(system.ID, galaxyNumber)) {
		this.stopTimers();
		this.deactivateWIS = false;
		this.targetBuoy.explode();
		this.dockingBuoy.explode();
		this.pilotBuoy.explode();
		missionVariables.laveAcademyExam = null;
		if (worldScripts["Welcome Information Script"]) { // if Welcome Mat has been disabled earlier, restart it
			if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
				worldScripts["Welcome Information Script"].welcomeTimer.start();
				if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") { player.consoleMessage(expandDescription("[academy_welcome_mat_enabled]"), 6); }
			}
		}
	}
}

this.shipWillDockWithStation = function (station) {
	if (this.systemCheck(system.ID, galaxyNumber)) {
		this.deactivateWIS = false;
		missionVariables.laveAcademyExam = null;
		this.stopTimers();
	}

	// this seems unnecessary, as the trumbles mission is only offered at main stations
	if (station.hasRole("laveAcademy_academy")) { // stop the trumble mission offering whilst docked at the academy
		missionVariables.laveAcademy_storeTrumble = missionVariables.trumbles;
		missionVariables.trumbles = "";
	}
}

this.checkBuoyDistance = function checkBuoyDistance() {
	var buoyDistance = player.ship.position.distanceTo(this.buoyID.position); // how far the player ship is from the buoy
	if (buoyDistance < 1000) { // if we're within 1000m.
		this.buoyTimer.stop();
		this.buoyID.AIState = "START_EXAM";
	}
}

this.guiScreenChanged = function () {
	// for GUI screen changes whilst in flight, which we can ignore
	if (!player.ship.docked) return;

	// if we're not at Lave Academy
	if (!player.ship.dockedStation.hasRole("laveAcademy_academy")) return;

	// replace marketplace screen with exam offering mission screen
	if (guiScreen == "GUI_SCREEN_MARKET") this.showCourses();
}


this.choseExam = function (examChoice) {
	switch (examChoice) {
		case "ACADEMY_1_TARGET":
			{
				mission.runScreen({ 
					title: expandDescription("[academy_gunnery_exam]"), 
					messageKey: "laveAcademy_targetInfo", 
					choicesKey: "laveAcademy_targetYesNo", 
					screenID: "lave_academy" }, this.examYesNo);
				break;
			}
		case "ACADEMY_2_PILOT":
			{
				mission.runScreen({ 
					title: expandDescription("[academy_piloting_exam]"), 
					messageKey: "laveAcademy_pilotInfo", 
					choicesKey: "laveAcademy_pilotYesNo", 
					screenID: "lave_academy" }, this.examYesNo);
				break;
			}
		case "ACADEMY_3_DOCKING":
			{
				mission.runScreen({ 
					title: expandDescription("[academy_docking_exam]"), 
					messageKey: "laveAcademy_dockingInfo", 
					choicesKey: "laveAcademy_dockingYesNo", 
					screenID: "lave_academy" }, this.examYesNo);
				break;
			}
		case "ACADEMY_4_RESET":
			{
				missionVariables.laveAcademyExam = null;
				missionVariables.laveAcademy_bestTargetTimeM = 0;
				missionVariables.laveAcademy_bestTargetTimeS = 0;
				missionVariables.laveAcademy_bestPilotTimeM = 0;
				missionVariables.laveAcademy_bestPilotTimeS = 0;
				missionVariables.laveAcademy_bestDockingScore = 0;
				missionVariables.laveAcademy_bestDockingTimeM = 0;
				missionVariables.laveAcademy_bestDockingTimeS = 0;
				mission.runScreen({ 
					title: expandDescription("[academy_syllabus_title]"), 
					messageKey: "laveAcademy_examOffer", 
					choicesKey: "laveAcademy_offerChoice", 
					screenID: "lave_academy" }, this.choseExam);
				break;
			}
		case "ACADEMY_5_DECLINE":
			{
				missionVariables.laveAcademyExam = null;
				break;
			}
	}
}

this.examYesNo = function (selection) {
	switch (selection) {
		case "ACADEMY_1_TARGETYES":
			{
				missionVariables.laveAcademyExam = "TARGET";
				break;
			}
		case "ACADEMY_2_TARGETNO":
			{
				mission.runScreen({ 
					title: expandDescription("[academy_syllabus_title]"), 
					messageKey: "laveAcademy_examOffer", 
					choicesKey: "laveAcademy_offerChoice", 
					screenID: "lave_academy" }, this.choseExam);
				break;
			}
		case "ACADEMY_1_PILOTYES":
			{
				missionVariables.laveAcademyExam = "PILOT";
				break;
			}
		case "ACADEMY_2_PILOTNO":
			{
				mission.runScreen({ 
					title: expandDescription("[academy_syllabus_title]"), 
					messageKey: "laveAcademy_examOffer", 
					choicesKey: "laveAcademy_offerChoice", 
					screenID: "lave_academy" }, this.choseExam);
				break;
			}
		case "ACADEMY_1_DOCKINGYES":
			{
				missionVariables.laveAcademyExam = "DOCKING";
				break;
			}
		case "ACADEMY_2_DOCKINGNO":
			{
				mission.runScreen({ 
					title: expandDescription("[academy_syllabus_title]"), 
					messageKey: "laveAcademy_examOffer", 
					choicesKey: "laveAcademy_offerChoice", 
					screenID: "lave_academy" }, this.choseExam);
				break;
			}
		default:
			{
				missionVariables.laveAcademyExam = null;
				break;
			}
	}
}
