"use strict";
this.name = "LaveAcademy_pilotCircuitBuoy";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Control of pilot course circuit buoys";
this.version = "1.3";

this.buoyActive = function () {
	if (this.playerScanTimer) {
		this.playerScanTimer.start();
	}
	else {
		this.playerScanTimer = new Timer(this, this.rangeCheck, 0, 1);
	}
}

this.rangeCheck = function rangeCheck() {
	if (!this.ship) {
		this.playerScanTimer.stop();
		return;
	}

	if (player.ship.docked) { // if the player is docked (at the Academy) then stop the test quietly
		this.playerScanTimer.stop();
		this.ship.AIState = "LIGHTS_OFF";
		this.ship.scannerDisplayColor1 = "yellowColor";
		this.ship.scannerDisplayColor2 = "whiteColor";
		missionVariables.laveAcademyExam = null;
		return;
	}

	this.buoyDistance = player.ship.position.distanceTo(this.ship.position); // how far the player ship is from the buoy
	if (this.buoyDistance < 1000) { // if we're within 1000m.
		this.playerScanTimer.stop();
		this.ship.AIState = "LIGHTS_OFF";
		player.consoleMessage(expandDescription("[academy_pilot_buoy_reached]", { number: missionVariables.laveAcademy_pilotNextBuoy }), 6);
		this.ship.scannerDisplayColor1 = "yellowColor";
		this.ship.scannerDisplayColor2 = "whiteColor";
		missionVariables.laveAcademy_pilotNextBuoy += 1;
		missionVariables.laveAcademy_pilotNextBuoyName = this.ship.scriptInfo.nextBuoy;
	}
}

this.removeBuoy = function () {
	if (this.playerScanTimer && this.playerScanTimer.isRunning) {
		this.playerScanTimer.stop();
	}
	this.ship.remove();
}

this.playerWillEnterWitchspace = function () {
	if (this.playerScanTimer) {
		this.playerScanTimer.stop();
	}
}