"use strict";
this.name = "LaveAcademy_pilotBuoy";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Control of academy pilot practice course in the Lave system";
this.version = "1.3";

this.examStart = function () { // first set up the asteroids and rings

	this.removeCourse(); // just in case we're repeating the exam and we've still got debris around.

	this.buoy1Position = this.ship.position.add([-20000, 0, 0]);
	this.buoy2Position = this.buoy1Position.add([0, 20000, 0]);
	this.buoy3Position = this.buoy2Position.add([0, 0, -20000]);
	this.buoy4Position = this.buoy3Position.add([-20000, 0, 0]);
	this.buoy5Position = this.buoy4Position.add([0, -20000, 0]);
	this.buoy6Position = this.buoy5Position.add([20000, 0, 0]);
	this.buoy7Position = this.buoy6Position.add([20000, 0, 0]);

	this.ring1Position = this.buoy1Position.add([0, 10000, 0]);
	this.ring2Position = this.buoy3Position.add([-10000, 0, 0]);
	this.ring3Position = this.buoy5Position.add([10000, 0, 0]);

	//system.legacy_addShipsWithinRadius("laveAcademy_pilotAsteroid", 5, "abs", this.buoy2Position, 7000); // 5 rocks around buoy 2.
	system.addShips("laveAcademy_pilotAsteroid", 5, this.buoy2Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotRing", 1, "abs", this.ring1Position, 7000); // 1 bonus ring between buoys 1 & 2.
	system.addShips("laveAcademy_pilotRing", 1, this.ring1Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotAsteroid", 7, "abs", this.buoy3Position, 7000); // 7 rocks around buoy 3.
	system.addShips("laveAcademy_pilotAsteroid", 7, this.buoy3Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotAsteroid", 12, "abs", this.buoy4Position, 7000); // 12 rocks around buoy 4.
	system.addShips("laveAcademy_pilotAsteroid", 12, this.buoy4Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotRing", 2, "abs", this.ring2Position, 7000); // 2 bonus rings between buoys 3 & 4.
	system.addShips("laveAcademy_pilotRing", 2, this.ring2Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotAsteroid", 7, "abs", this.buoy5Position, 7000); // 7 rocks around buoy 5.
	system.addShips("laveAcademy_pilotAsteroid", 7, this.buoy5Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotAsteroid", 5, "abs", this.buoy6Position, 7000); // 5 rocks around buoy 6.
	system.addShips("laveAcademy_pilotAsteroid", 5, this.buoy6Position, 7000);
	//system.legacy_addShipsWithinRadius("laveAcademy_pilotRing", 1, "abs", this.ring3Position, 7000); // 1 bonus rings between buoys 5 & 6.
	system.addShips("laveAcademy_pilotRing", 1, this.ring3Position, 7000);


	// Reset the mission variables, start the clock and tell the player we're underway
	this.examStartTime = clock.absoluteSeconds;
	missionVariables.laveAcademy_pilotScore = 0; // bonus and penalty counter
	missionVariables.laveAcademy_pilotCurrentBuoy = 0; // the number of the buoy we are currently at
	missionVariables.laveAcademy_pilotNextBuoy = 1; //  the number of the next buoy to be reached
	missionVariables.laveAcademy_pilotNextBuoyName = "pilotBuoy1";
	player.consoleMessage(expandDescription("[academy_piloting_exam_started]"), 6);

	if (this.pilotCourseTimer) {
		this.pilotCourseTimer.start();
	}
	else {
		this.pilotCourseTimer = new Timer(this, this.runCourse, 0, 1);
	}
}

this.runCourse = function runCourse() {
	if (player.ship.docked) { // if the player is docked then stop the test quietly
		this.quietEnd();
		return;
	}

	this.examElapsedTime = Math.floor(clock.absoluteSeconds - this.examStartTime); // absolute time since test began, without penalties or bonuses 
	if (this.examElapsedTime > 900) { // if we've been at the test for over 15 minutes
		this.ship.commsMessage(expandDescription("[academy_piloting_expired]"), player.ship);
		this.quietEnd();
		return;
	}

	if (missionVariables.laveAcademy_pilotNextBuoy == 8 || missionVariables.laveAcademy_pilotNextBuoyName == "FinishLine") { // if we reached the 7th buoy
		this.pilotCourseTimer.stop();
		this.finishLine();
		return;
	}

	if (missionVariables.laveAcademy_pilotCurrentBuoy < missionVariables.laveAcademy_pilotNextBuoy) { // if we reached a buoy successfully spawn & set next
		missionVariables.laveAcademy_pilotCurrentBuoy += 1;
		switch (missionVariables.laveAcademy_pilotNextBuoyName) {
			case "pilotBuoy1":
				{
					let pilotBuoy1 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy1');
					pilotBuoy1.position = this.buoy1Position;
					pilotBuoy1.AIState = "LIGHTS_ON";
					pilotBuoy1.scannerDisplayColor1 = "redColor";
					pilotBuoy1.scannerDisplayColor2 = "whiteColor";
					break;
				}

			case "pilotBuoy2":
				{
					let pilotBuoy2 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy2');
					pilotBuoy2.position = this.buoy2Position;
					pilotBuoy2.AIState = "LIGHTS_ON";
					pilotBuoy2.scannerDisplayColor1 = "redColor";
					pilotBuoy2.scannerDisplayColor2 = "whiteColor";
					break;
				}

			case "pilotBuoy3":
				{
					let pilotBuoy3 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy3');
					pilotBuoy3.position = this.buoy3Position;
					pilotBuoy3.AIState = "LIGHTS_ON";
					pilotBuoy3.scannerDisplayColor1 = "redColor";
					pilotBuoy3.scannerDisplayColor2 = "whiteColor";
					break;
				}

			case "pilotBuoy4":
				{
					let pilotBuoy4 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy4');
					pilotBuoy4.position = this.buoy4Position;
					pilotBuoy4.AIState = "LIGHTS_ON";
					pilotBuoy4.scannerDisplayColor1 = "redColor";
					pilotBuoy4.scannerDisplayColor2 = "whiteColor";
					break;

				}
			case "pilotBuoy5":
				{
					let pilotBuoy5 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy5');
					pilotBuoy5.position = this.buoy5Position;
					pilotBuoy5.AIState = "LIGHTS_ON";
					pilotBuoy5.scannerDisplayColor1 = "redColor";
					pilotBuoy5.scannerDisplayColor2 = "whiteColor";
					break;
				}

			case "pilotBuoy6":
				{
					let pilotBuoy6 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy6');
					pilotBuoy6.position = this.buoy6Position;
					pilotBuoy6.AIState = "LIGHTS_ON";
					pilotBuoy6.scannerDisplayColor1 = "redColor";
					pilotBuoy6.scannerDisplayColor2 = "whiteColor";
					break;
				}

			case "pilotBuoy7":
				{
					let pilotBuoy7 = this.ship.spawnOne('laveAcademy_pilotCircuitBuoy7');
					pilotBuoy7.position = this.buoy7Position;
					pilotBuoy7.AIState = "LIGHTS_ON";
					pilotBuoy7.scannerDisplayColor1 = "redColor";
					pilotBuoy7.scannerDisplayColor2 = "whiteColor";
					break;
				}
		}
	}
}

this.finishLine = function () {
	this.ship.AIState = "FINISH_LINE"; // comms message the player to return to the main buoy to finish the course
	if (this.pilotFinishTimer) {
		this.pilotFinishTimer.start();
	}
	else {
		this.pilotFinishTimer = new Timer(this, this.scanPlayer, 0, 1);
	}
}

this.scanPlayer = function scanPlayer() {
	if (player.ship.docked) { // if the player is docked then stop the test quietly
		this.quietEnd();
	}

	this.buoyDistance = player.ship.position.distanceTo(this.ship.position); // how far the player ship is from the main buoy
	if (this.buoyDistance < 1000) { // if we're within 1000m, we can end the test
		this.pilotFinishTimer.stop();
		this.ship.AIState = "LIGHTS_OFF";
		this.examEnd();
	}
}

this.examEnd = function () {
	if (worldScripts["Welcome Information Script"]) { // if Welcome Mat has been disabled earlier, restart it
		if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
			worldScripts["Welcome Information Script"].welcomeTimer.start();
			if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") {
				player.consoleMessage(expandDescription("[academy_welcome_mat_enabled]"), 6);
			}
		}
	}
	this.examStopTime = clock.absoluteSeconds;
	this.examElapsedTime = Math.floor(this.examStopTime - this.examStartTime - missionVariables.laveAcademy_pilotScore);
	this.examTimeMinutes = Math.floor(this.examElapsedTime / 60);
	this.examTimeSeconds = this.examElapsedTime - (60 * this.examTimeMinutes);
	this.removeCourse();
	this.ship.AIState = "LIGHTS_OFF";
	missionVariables.laveAcademyExam = null;
	this.ship.commsMessage(expandDescription("[academy_exam_complete]", { mins: this.examTimeMinutes, secs: this.examTimeSeconds }), player.ship);

	this.bestTime = (missionVariables.laveAcademy_bestPilotTimeM * 60) + missionVariables.laveAcademy_bestPilotTimeS;

	if (this.bestTime == 0 && this.examElapsedTime > 0) {
		this.ship.commsMessage(expandDescription("[academy_new_best_time]"), player.ship);
		missionVariables.laveAcademy_bestPilotTimeM = Math.floor(this.examElapsedTime / 60);
		missionVariables.laveAcademy_bestPilotTimeS = this.examElapsedTime - (60 * (Math.floor(this.examElapsedTime / 60)));
		return;
	}

	if (this.bestTime > this.examElapsedTime) {
		this.ship.commsMessage(expandDescription("[academy_beat_best_time]"), player.ship);
		missionVariables.laveAcademy_bestPilotTimeM = Math.floor(this.examElapsedTime / 60);
		missionVariables.laveAcademy_bestPilotTimeS = this.examElapsedTime - (60 * (Math.floor(this.examElapsedTime / 60)));
		return;
	}
}

this.playerWillEnterWitchspace = this.shipDied = this.quietEnd = function () {
	if (this.pilotCourseTimer) {
		this.pilotCourseTimer.stop();
	}
	if (this.pilotFinishTimer) {
		this.pilotFinishTimer.stop();
	}
	this.removeCourse();
	missionVariables.laveAcademyExam = null;
	missionVariables.laveAcademy_pilotScore = 0;
	missionVariables.laveAcademy_pilotCurrentBuoy = 0;
	missionVariables.laveAcademy_pilotNextBuoy = 1;
	missionVariables.laveAcademy_pilotNextBuoyName = "pilotBuoy1";
	if (worldScripts["Welcome Information Script"]) // if Welcome Mat has been disabled earlier, restart it
	{
		if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
			worldScripts["Welcome Information Script"].welcomeTimer.start();
		}
	}
	return;
}

this.removeCourse = function () {
	this.courseList = system.shipsWithRole("laveAcademy_pilotCourse"); // find all course entities so we can remove them
	if (this.courseList.length > 0) { // if there are parts of the course still present, loop through them and remove
		let loopCounter = 0; // reset the counter
		for (loopCounter = 0; loopCounter < this.courseList.length; loopCounter++) {
			if (this.courseList[loopCounter].scanClass == "CLASS_BUOY") {
				this.courseList[loopCounter].AIState = "REMOVE_BUOY";
			}
			else {
				this.courseList[loopCounter].remove();
			}
		}
	}
}			
