"use strict";
this.name = "LaveAcademy_dockingDrone";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Script for the docking drones in the docking test of Lave Academy";
this.version = "1.3";

this.shipSpawned = function () {
	this.ship.scannerDisplayColor1 = "yellowColor";
	this.ship.scannerDisplayColor2 = "whiteColor";
	this.rotateQ = function (q, axis, angle) { return q.rotate(axis, angle); }

	var buoyArray = system.shipsWithPrimaryRole("laveAcademy_dockingBuoy"); // find the buoy for the docking course

	if (buoyArray.length == 1) { // set the drone at right angles to the vector away from the buoy
		this.dockingBuoy = buoyArray[0];
		let droneVector = this.ship.position.subtract(this.dockingBuoy.position).direction(); // unit vector pointing away from the buoy
		let dronePosition = this.ship.position.add(droneVector.multiply(1000)); // add an offset 1km away from the planet
		let angle = this.ship.heading.angleTo(droneVector); // angle between current heading and target heading
		let cross = this.ship.heading.cross(droneVector).direction(); // set the plane where we should rotate in
		this.ship.orientation = this.rotateQ(this.ship.orientation, cross, -angle); // re-orient the drone at right angle to the buoy vector
		this.ship.position = dronePosition; // move the drone 1km away from the buoy, to ensure there's room for traverse
	}
	else { // randomise the ring's orientation instead
		// when would we get here?
		// only spawn code is inside laveAcademy_dockingBuoy, which should mean the buoyArray.length = 1
		// maybe if the buoy has been destroyed, in which case the course cannot start
		// because you have to get close to the buoy to trigger it. I think this is redundant code
		this.newW = (Math.random() * 2) - 1; // a value between -1 and 1 for each component
		this.newX = (Math.random() * 2) - 1;
		this.newY = (Math.random() * 2) - 1;
		this.newZ = (Math.random() * 2) - 1;
		this.newOrientation = new Quaternion(this.newW, this.newX, this.newY, this.newZ);
		this.ship.orientation = this.newOrientation;
	}

	this.destructTimer = new Timer(this, this.selfDestruct, 180);  // give the drone a 3 minute lifetime.
}

this.flyThru = function () {
	this.destructTimer.stop();
	this.dockingBuoy.commsMessage(expandDescription("[academy_traverse_success]"), player.ship);
	this.ship.remove();
}

this.selfDestruct = function selfDestruct () {
	if (!missionVariables.laveAcademy_droneAbort && !player.ship.docked) { // if the exam is still going but the player didn't "dock" in time
		this.dockingBuoy.commsMessage(expandDescription("[academy_traverse_failed]"), player.ship);
	}
	this.ship.remove();
}

this.shipTakingDamage = function (amount, fromEntity, damageType) {
	if (fromEntity && fromEntity.isPlayer && amount && amount > 0 && damageType && damageType === "scrape damage") {
		this.dockingBuoy.commsMessage(expandDescription("[academy_ring_scrape]"), player.ship);
		player.ship.energy += amount;
		this.ship.energy += amount;
	}
}

this.playerWillEnterWitchspace = function () {
	if (this.destructTimer) {
		this.destructTimer.stop;
	}
}
