"use strict";
this.name = "LaveAcademy_dockingBuoy";
this.author = "Thargoid";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Control of academy docking practice buoys in the Lave system";
this.version = "1.3";

this.examStart = function () {
	this.examStartTime = clock.absoluteSeconds;
	this.buoyPosition = this.ship.position;
	missionVariables.laveAcademy_droneCount = 0;
	missionVariables.laveAcademy_droneAbort = null;
	player.consoleMessage(expandDescription("[academy_docking_exam_started]"), 6);
	if (this.launchCheckTimer) {
		this.launchCheckTimer.start();
	}
	else {
		this.launchCheckTimer = new Timer(this, this.droneCheck, 0, 1);
	}
}

this.droneCheck = function droneCheck() {
	if (player.ship.docked) {// if the player is docked (at the Academy) then stop the test quietly
		this.launchCheckTimer.stop();
		missionVariables.laveAcademy_droneAbort = true;
		this.ship.AIState = "LIGHTS_OFF";
		missionVariables.laveAcademyExam = null;
		return;
	}

	function isPlayer(entity) { return entity.isShip && entity.isPlayer };
	this.playerInRange = system.filteredEntities(this, isPlayer, this.ship, 25600).length;
	if (this.playerInRange == 0) {
		this.launchCheckTimer.stop();
		missionVariables.laveAcademy_droneCount -= 1;
		this.cancelExam();
	}

	if (missionVariables.laveAcademy_droneAbort) {
		this.launchCheckTimer.stop();
		return;
	}

	function isDockingDrone(entity) { return entity.isShip && entity.hasRole("laveAcademy_dockingDrone") };
	if (system.filteredEntities(this, isDockingDrone, this.ship, 25600).length == 0) {
		if (missionVariables.laveAcademy_droneCount == 10) {
			this.endExam();
		}
		else {
			missionVariables.laveAcademy_droneCount += 1;
			switch (true) {
				case (missionVariables.laveAcademy_droneCount == 1):
					{
						this.ship.commsMessage(expandDescription("[academy_level_one]"), player.ship);
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL1", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL1", 1, this.buoyPosition, 14000);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 2 || missionVariables.laveAcademy_droneCount == 3):
					{
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL1", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL1", 1, this.buoyPosition, 14000);
						break;
					}

				case (missionVariables.laveAcademy_droneCount == 4):
					{
						this.ship.commsMessage(expandDescription("[academy_level_two]"), player.ship);
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL2a", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL2a", 1, this.buoyPosition, 14000);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 5):
					{
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL2b", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL2b", 1, this.buoyPosition, 14000);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 6):
					{
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL2c", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL2c", 1, this.buoyPosition, 14000);
						break;
					}

				case (missionVariables.laveAcademy_droneCount == 7):
					{
						this.ship.commsMessage(expandDescription("[academy_level_three]"), player.ship);
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL3a", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL3a", 1, this.buoyPosition, 14000);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 8):
					{
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL3b", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL3b", 1, this.buoyPosition, 14000);
						break;
					}
				case (missionVariables.laveAcademy_droneCount == 9):
					{
						//system.legacy_addShipsWithinRadius("laveAcademy_dockingDroneL3c", 1, "abs", this.buoyPosition, 14000);
						system.addShips("laveAcademy_dockingDroneL3c", 1, this.buoyPosition, 14000);
						break;
					}
			}
		}
	}
}

this.endExam = function () {
	this.launchCheckTimer.stop();
	if (worldScripts["Welcome Information Script"]) { // if Welcome Mat has been disabled earlier, restart it
		if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
			worldScripts["Welcome Information Script"].welcomeTimer.start();
			if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") {
				player.consoleMessage(expandDescription("[academy_welcome_mat_enabled]"), 6);
			}
		}
	}
	this.examStopTime = clock.absoluteSeconds;
	this.examElapsedTime = Math.floor(this.examStopTime - this.examStartTime);
	this.examTimeMinutes = Math.floor(this.examElapsedTime / 60);
	this.examTimeSeconds = this.examElapsedTime - (60 * this.examTimeMinutes);
	missionVariables.laveAcademy_droneAbort = true;
	this.ship.commsMessage(expandDescription("[academy_exam_complete]", { mins: this.examTimeMinutes, secs: this.examTimeSeconds }), player.ship);
	this.ship.AIState = "LIGHTS_OFF";
	missionVariables.laveAcademyExam = null;
	this.bestTime = (missionVariables.laveAcademy_bestDockingTimeM * 60) + missionVariables.laveAcademy_bestDockingTimeS;

	if (this.bestTime == 0 && this.examElapsedTime > 0) {
		this.ship.commsMessage(expandDescription("[academy_new_best_time]"), player.ship);
		missionVariables.laveAcademy_bestDockingTimeM = Math.floor(this.examElapsedTime / 60);
		missionVariables.laveAcademy_bestDockingTimeS = this.examElapsedTime - (60 * (Math.floor(this.examElapsedTime / 60)));
		return;
	}

	if (this.bestTime > this.examElapsedTime) {
		this.ship.commsMessage(expandDescription("[academy_beat_best_time]"), player.ship);
		missionVariables.laveAcademy_bestDockingTimeM = Math.floor(this.examElapsedTime / 60);
		missionVariables.laveAcademy_bestDockingTimeS = this.examElapsedTime - (60 * (Math.floor(this.examElapsedTime / 60)));
		return;
	}
}

this.cancelExam = function () {
	this.examStopTime = clock.absoluteSeconds;
	this.examElapsedTime = Math.floor(this.examStopTime - this.examStartTime);
	this.examTimeMinutes = Math.floor(this.examElapsedTime / 60);
	this.examTimeSeconds = this.examElapsedTime - (60 * this.examTimeMinutes);
	missionVariables.laveAcademy_droneAbort = true;
	this.droneArray = system.shipsWithRole("laveAcademy_dockingDrone")
	if (this.droneArray.length > 0) {
		this.droneArray.forEach(
			function (drone) {
				drone.remove()
			}
		)
	}
	player.commsMessage(expandDescription("[academy_dock_test_abort]", { mins: this.examTimeMinutes, secs: this.examTimeSeconds }), 10);
	this.ship.AIState = "LIGHTS_OFF";
	missionVariables.laveAcademyExam = null;
	if (worldScripts["Welcome Information Script"]) { // if Welcome Mat has been disabled earlier, restart it
		if (!worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
			worldScripts["Welcome Information Script"].welcomeTimer.start();
			if (player.ship.equipmentStatus("EQ_WELCOME_MAT") == "EQUIPMENT_OK") {
				player.consoleMessage(expandDescription("[academy_welcome_mat_enabled]"), 6);
			}
		}
	}
}

this.playerWillEnterWitchspace = function () {
	if (worldScripts["Welcome Information Script"] && !worldScripts["Welcome Information Script"].welcomeTimer.isRunning) {
		worldScripts["Welcome Information Script"].welcomeTimer.start();
	}

	if (this.launchCheckTimer) {
		this.launchCheckTimer.stop();
	}
}
