"use strict";
this.name = "phkb_sidewinder_conditions_script";
this.author = "phkb";
this.copyright = "2021 phkb";
this.license = "CC BY-NC-SA 4.0";

this.allowOfferShip = function(shipKey) {
    // only offer certain styles/colours on a regular basis
    var keys = {
        0: [ 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,0],
        1: [12,13,14,15,16,17,18,19,20,21,22,0],
        2: [23,24,25,26,27,28,29,30,31,32,33,0],
        3: [34,35,36,37,38,39,40,41,42,43,44,45],
    }
    var week = parseInt(clock.daysComponent / 7) % 4;  // will be 0-3
    var period = parseInt(clock.daysComponent / 30) % 4;  // will be 0-3
    var keylist = keys[period];
    var avail = [];
    switch (week) {
        case 0: 
            avail.push(keylist[2]);
            avail.push(keylist[3]);
            avail.push(keylist[9]);
            break;
        case 1:
            avail.push(keylist[8]);
            avail.push(keylist[5]);
            avail.push(keylist[10]);
            break;
        case 2:
            avail.push(keylist[1]);
            avail.push(keylist[7]);
            avail.push(keylist[0]);
            break;
        case 3:
            avail.push(keylist[4]);
            avail.push(keylist[6]);
            avail.push(keylist[11]);
            break;
    }
    for (var i = 0; i < avail.length; i++) {
        if ((shipKey + "E").indexOf("_" + avail[i] + "E") >= 0) return true;
    }
    return false;
}