"use strict";
this.name = "QuickVisa";
this.author = "phkb";
this.description = "Adds Quick-Visa Self Service stations and alerts player when visas are required at system stations.";
this.copyright = "2025 phkb";
this.license = "CC BY-NC-SA 4.0";

this._settings = {
    _visaGov3PriceFactor: 50,
    _visaGov4PriceFactor: 50,
    _visaGov7PriceFactor: 50,
    _spawnGov3Stations: true,
    _spawnGov4Stations: true,
    _spawnGov7Stations: true,
    _enableWPMessages: true
};

this._visaConfig = {
    Name: this.name,
    Display: expandMissionText("visa_config_display"),
    Alias: expandMissionText("visa_config_alias"),
    Alive: "_visaConfig",
    Bool: {
        B0: { Name: "_settings._spawnGov3Stations", Def: true, Desc: expandMissionText("visa_config_spawn_gov3") },
        B1: { Name: "_settings._spawnGov4Stations", Def: true, Desc: expandMissionText("visa_config_spawn_gov4") },
        B2: { Name: "_settings._spawnGov7Stations", Def: true, Desc: expandMissionText("visa_config_spawn_gov7") },
        B3: { Name: "_settings._enableWPMessages", Def: true, Desc: expandMissionText("visa_config_wpmessages") }, 
        Info: expandMissionText("visa_config_bool_info")
    },
    SInt: {
        S0: { Name: "_settings._visaGov3PriceFactor", Def: 50, Min: 1, Max: 100, Desc: expandMissionText("visa_config_factor_gov3") },
        S1: { Name: "_settings._visaGov4PriceFactor", Def: 50, Min: 1, Max: 100, Desc: expandMissionText("visa_config_factor_gov4") },
        S2: { Name: "_settings._visaGov7PriceFactor", Def: 50, Min: 1, Max: 100, Desc: expandMissionText("visa_config_factor_gov7") },
        Info: expandMissionText("visa_config_sint_info")
    },
};

//----------------------------------------------------------------------------------------
this.startUpComplete = function() {
    if (worldScripts.WireframeShipImages) {
        if (!worldScripts.WireframeShipImages._gameShips["Quick-Visa Self-Service"]) {
            worldScripts.WireframeShipImages._gameShips["Quick-Visa Self-Service"] = "fuel_station_ir";
        }
    }
    // register our settings, if Lib_Config is present
    if (worldScripts.Lib_Config) {
        worldScripts.Lib_Config._registerSet(this._visaConfig);
    }
    if (missionVariables.QuickView_Settings) {
        this._settings = JSON.parse(missionVariables.QuickView_Settings);
    }
}

//----------------------------------------------------------------------------------------
this.playerWillSaveGame = function() {
    missionVariables.QuickView_Settings = JSON.stringify(this._settings);
}

//----------------------------------------------------------------------------------------
this.systemWillPopulate = function() {
    var gov = system.government;
    if ((gov === 3 && this._settings._spawnGov3Stations) || 
        (gov === 4 && this._settings._spawnGov4Stations) || 
        (gov === 7 && this._settings._spawnGov7Stations)) { // dictator, communist, corporate
		if (system.countShipsWithRole("visa-station") == 0) {
            // numbers between -1 and 1;
            var xf = (system.scrambledPseudoRandomNumber(277) * 2) - 1;
            var yf = (system.scrambledPseudoRandomNumber(377) * 2) - 1;
			var stnPos = Vector3D(5000 * xf, 5000 * yf, 5000); 
			system.setPopulator("visa-station", {
				priority: 200,
				location: "COORDINATES",
				coordinates: stnPos,
				groupCount: 1,
				callback: function (pos) {
					system.addShips("visa-station", 1, pos, 0);
				},
				deterministic: true
			});
		}
    }
}

//----------------------------------------------------------------------------------------
this.shipExitedWitchspace = function() {
    if (!this._settings._enableWPMessages) return;
    function getWPBuoy(entity) {
        return (entity.isShip && (entity.hasRole("buoy-witchpoint") || (entity.isStation && entity.allegiance === "galcop")));
    }
    var dip = worldScripts.DayDiplomacy_060_Citizenships;
    if (!dip) return;
    var gov = system.government;
    if (gov === 3 || gov === 4 || gov === 7) { // dictator, communist, corporate
        if (!dip.$hasPlayerVisa(system.ID) && !dip.$hasPlayerCitizenship(galaxyNumber, system.ID)) {
            var targets = system.filteredEntities(this, getWPBuoy);
            if (targets.length > 0) {
                for (var i = 0; i < targets.length; i++) {
                    targets[i].commsMessage(expandMissionText("visa_missing_alert"), player.ship);
                }
            }
        }
    }
}

//----------------------------------------------------------------------------------------
this.$updatePF2Docks = function() {
    var pf2 = system.shipsWithRole("planetFall2_surface");
    if (!pf2 || pf2.length == 0) return;
    for (var i = 0; i < pf2.length; i++) {
        var land = pf2[i];
        land.performedDockRequest = false;
    }
}