this.name	= "murphy-thargoid-drive.js";
this.author	= "Capt. Murphy";
this.copyright= "2012 - inspired by work by Switeck, Okti, and Mauiby de Fug";
this.license	= "CC BY-NC-SA 3.0"; // see http://creativecommons.org/licenses/by-nc-sa/3.0/ for more info. Feel free to adapt any of this code for your own use.
this.credits	= "Inspired by similar work by Mauiby de Fug, Okti and Switeck. A big thank-you to Switeck in particular for getting me interested in this concept, exhaustive testing, and for his constructive comments and discussion. Model for Scoopable Thargoid Witchspace Drive courtesy of Thargoid. Also thanks to Okti, Eric Walch and Micha for testing prototype."
this.description= "Worldscript for Thargoid Witchspace Drive.";
this.version	= "0.9.5.9";
// Hacked up by Switeck to add extra capabilities... in 2025!

"use strict";

// OXPConfig2 attributes
this.oxpcSettings = {
	Info: {Name:"murphy-thargoid-drive.js",Display:"Thargoid Witchspace Drive",Notify:true,InfoB:"Please see OXP spoilers.rtf for an explanation of settings."},
	Bool0: {Name:"dynamicTAF",Def:true,Desc:"Dynamic TAF."},
	Bool1: {Name:"updateRouteMidChain",Def:true,Desc:"Dynamic Route Updating."},
	Bool2: {Name:"updateRouteModBool",Def:true,Desc:"Quicker transit times."},
	Bool3: {Name:"loggingEnabled",Def:false,Desc:"Enable Log Messages."}
}

this.oxpcNotifyOnChange = function(what)
{
 if(!this.updateRouteModBool) this.updateRouteModifier = 0.667	// results in travel times roughly equivalent to an "OPTIMIZE_BY_DISTANCE" route of standard jumps.
 else this.updateRouteModifier = 0.999;// results in travel times roughly equivalent to an "OPTIMIZE_BY_TIME" route of standard jumps. Can be quicker on some routes.
}

// these variables are the defaults for those that can modified via OXPConfig if installed.
this.updateRouteMidChain = true; // will dynamically update jump routes to improve travel time (in game hours)
this.updateRouteModifier = 0.999; // default for fastest in game hours travel times.
this.updateRouteModBool = false; // used by OXPconfig.
this.dynamicTAF = true; // varies TAF during jumps to improve user experience of travel times.
this.loggingEnabled = true; // if true enables log commands in script

// not included in OXPConfig settings.
this.disableEquipment = false; // flag for use by other OXPs scripts to temporarily disable Thargoid Witch Space Drive. If true attempting to activate the drive will fail. Accessed via worldScripts["murphy-thargoid-drive.js"].disableEquipment
this.method = "OPTIMIZED_BY_TIME"; // method used by route finder to calculate quickest route - do not change.
this.cheat = false; // if true player is awarded a fully functional Thargoid Witchspace Drive with the 'best' parameters at startUp. If the game is saved it will be removed again on reloading the save game, and replaced by some Trumbles.... ;-)
this.test = false; // if true player will always encounter a scoopable Thargoid Witchspace Drive pod when killing a Thargoid in Interstellar space, irrespective of the player.score.

// default attributes for drive - if edited here must also edit this.setVariables = function()
this.driveCounter = 0; // a persistent count of how many drives the player has fitted.
this.powerRequirement = 0.9; // default power requirement of the drive
this.detectChance = 0.2; // default chance of detection by police in high tech (12 and above systems). Also chance of thargoid presence on arrival at destination.
this.damageChance = 0.4; // default chance of equipment damage at end of jumpchain and of drive destruction if damaged.
this.disableNormalSpaceStart = true; // prevents drive activation in normal space.

this.startUp = function()
{
	if(missionVariables.murphy_thargoid_drive_driveCounter) this.driveCounter = missionVariables.murphy_thargoid_drive_driveCounter;
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && this.driveCounter < 5) { // legit installed drive.
		this.setVariables();
		return;
	}
	if(this.driveCounter === 5) { // drive installed by cheat mode
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.ship.awardEquipment("EQ_TRUMBLE");
		this.cheat = false;
		this.driveCounter = 0;
		if(this.loggingEnabled) log(this.name,"Thargoid Witchspace Drive previously awarded in cheat mode removed, and replaced with a special gift.");
	}
	if(this.cheat) { // install drive in cheat mode.
		player.ship.awardEquipment("EQ_MURPH_THARGOID_DRIVE");
		this.driveCounter = 5;
		this.setVariables();
		if(this.loggingEnabled) log(this.name,"Thargoid Witchspace Drive awarded in cheat mode.");
	}
}

this.playerWillSaveGame = function()
{
	missionVariables.murphy_thargoid_drive_driveCounter = this.driveCounter;
}

this.equipmentDamaged = function(equipment)
{
	if(equipment === "EQ_MURPH_THARGOID_DRIVE" && Math.random() < this.damageChance) {
		player.consoleMessage("Thargoid Witchspace Drive Destroyed!",15);
		player.ship.removeEquipment(equipment);
		player.ship.energy -= player.ship.energy*Math.random();
		return;
	}
	if(equipment === "EQ_MURPH_THARGOID_DRIVE_TOFIT" || equipment === "EQ_MURPH_THARGOID_DRIVE") player.ship.setEquipmentStatus(equipment,"EQUIPMENT_OK");
}

this.playerBoughtEquipment = function(equipment)
{
	if(equipment === "EQ_MURPH_THARGOID_DRIVE_QUOTE" && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK" && system.government === 0 && system.techLevel > 6) {
		this.showScreen = true;
		this.missionScreenOpportunity();
	}
	if(equipment === "EQ_MURPH_THARGOID_DRIVE_REMOVAL" && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && system.techLevel > 12) {
		this.showScreen = true;
		this.missionScreenOpportunity2();
	}
	if(equipment === "EQ_MURPH_THARGOID_DRIVE_TOFIT_REMOVAL" && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK"  && system.techLevel > 12) {
		this.showScreen = true;
		this.missionScreenOpportunity3();
	}
}

this.setVariables = function()
{
	switch (this.driveCounter) {
		case 0:
		break;
		case 1:
		this.powerRequirement = 0.9;
		this.detectChance = 0.2;
		this.damageChance = 0.4;
		this.disableNormalSpaceStart = true;
		break;
		case 2:
		this.powerRequirement = 0.6;
		this.detectChance = 0.1;
		this.damageChance = 0.2;
		this.disableNormalSpaceStart = true;
		break;
		case 3:
		this.powerRequirement = 0.3;
		this.detectChance = 0.05;
		this.damageChance = 0.1;
		this.disableNormalSpaceStart = true;
		break;
		default:
		this.powerRequirement = 0.1;
		this.detectChance = 0.025;
		this.damageChance = 0.05;
		this.disableNormalSpaceStart = false;
	}
}

this.missionScreenOpportunity = function()
{
	if(!this.showScreen) return;
	delete this.showScreen;
	switch (this.driveCounter) {
		case 0:
		this.fittingCost = 10000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive1", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
		break;
		case 1:
		this.fittingCost = 20000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive2", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
		break;
		case 2:
		this.fittingCost = 40000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive3", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
		break;
		default:
		this.fittingCost = 80000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive4", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
	}
}

this.missionScreenOpportunity2 = function()
{
	if(!this.showScreen) return;
	delete this.showScreen;
	switch (this.driveCounter) {
		case 1:
		this.fittingCost = 1000;
		mission.runScreen({title:"Thargoid Witchspace Drive Removal", messageKey:"murphy-thargoid-drive1r", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice2);
		break;
		case 2:
		this.fittingCost = 4000;
		mission.runScreen({title:"Thargoid Witchspace Drive Removal", messageKey:"murphy-thargoid-drive2r", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice2);
		break;
		case 3:
		this.fittingCost = 10000;
		mission.runScreen({title:"Thargoid Witchspace Drive Removal", messageKey:"murphy-thargoid-drive3r", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice2);
		break;
		default:
		this.fittingCost = 40000;
		mission.runScreen({title:"Thargoid Witchspace Drive Removal", messageKey:"murphy-thargoid-drive4r", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice2);
	}
}

this.missionScreenOpportunity3 = function()
{
	if(!this.showScreen) return;
	delete this.showScreen;
		this.fittingCost = 1000;
		mission.runScreen({title:"Thargoid Witchspace Drive Core Selling", messageKey:"murphy-thargoid-drive0r", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice3);
}

this.choice3 = function(choice)
{
	if(choice === "1_YES") {
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT_REMOVAL");
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT");
		player.credits += this.fittingCost;
		clock.addSeconds(3000+Math.floor(Math.random()*1000));
		player.consoleMessage("Thargoid Witchspace Drive core sold.",10);
		return;
	}
	player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT_REMOVAL");
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK") player.consoleMessage("Thargoid Witchspace Drive core not removed.",10);
}

this.choice2 = function(choice)
{
	if(choice === "1_YES") {
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_REMOVAL");
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.credits += this.fittingCost;
		if(this.driveCounter == 1) clock.addSeconds(100000+Math.floor(Math.random()*100000));
		if(this.driveCounter == 2) clock.addSeconds(80000+Math.floor(Math.random()*40000));
		if(this.driveCounter == 3) clock.addSeconds(60000+Math.floor(Math.random()*20000));
		if(this.driveCounter > 3) clock.addSeconds(6000+Math.floor(Math.random()*4000));
		player.consoleMessage("Thargoid Witchspace Drive removed.",10);
		return;
	}
	player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_REMOVAL");
	player.consoleMessage("Thargoid Witchspace Drive not removed.",10);
}

this.choice = function(choice)
{
	if(choice === "1_YES") {
		if(player.credits < this.fittingCost) {
			player.consoleMessage("Not enough credits to purchase fitting of Thargoid Witchspace Drive.",10);
			player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
			return;
		}
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT");
		player.ship.awardEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.credits -= this.fittingCost;
		clock.addSeconds(216000+(this.fittingCost*10)); // emulates source code calculation for time adjustment.
		player.consoleMessage("Thargoid Witchspace Drive fitted. Press shift-N followed by N to activate.",10);
		if(this.driveCounter < 4) this.driveCounter++;
//		if(this.driveCounter < 4 && Math.random() > this.driveCounter*0.2 - (system.techLevel-7)*0.4) this.driveCounter++;	// Doesn't always advance anymore?
		this.setVariables();
		return;
	}
	player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
	player.consoleMessage("Thargoid Witchspace Drive not fitted. Remains in manifest(N/A).",10);
}

this.shipKilledOther = function(target,how)
{
//	if(!system.isInterstellarSpace || target.roles.indexOf("thargoid") === -1 || player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" || player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK" || (this.drivePod && this.drivePod.isValid)) return;
	if(target.roles.indexOf("thargoid") === -1 || player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK" || (this.drivePod && this.drivePod.isValid)) return;	// Find a Thargoid anywhere and you have a chance of getting its drive core!
	var chance;
	chance = Math.min(0.25,player.score/25600);
	if(Math.random() < chance || this.test) {
		this.drivePod = system.addShips("murphy_thargoid_drive_pod",1,target.position,25)[0];
		this.drivePod.scannerDisplayColor1 = "orangeColor"; this.drivePod.scannerDisplayColor2 = "greenColor";
		player.consoleMessage("Unusual radiation source detected. Cannot identify.",10);
		if(this.drivePodTimer && this.drivePodTimer.isRunning){this.drivePodTimer.stop();delete this.drivePodTimer;}
		this.drivePodTimer = new Timer(this,this.explodeDrivePod,(60 + Math.ceil(Math.random()*120)));
	}
}

this.explodeDrivePod = function(){if(this.drivePod && this.drivePod.isValid)this.drivePod.explode();}

this.shipScoopedOther = function(whom)
{
	if(whom.primaryRole === "murphy_thargoid_drive_pod") {
		player.ship.awardEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT");
		player.consoleMessage("Scooped unusual Thargoid technology. Scanning. Check Status Screen (F5).",6);
	}
}

this.shipWillDockWithStation = function(station)
{
	if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") !== "EQUIPMENT_OK" && system.government === 0 && system.techLevel > 6 && !station.isMainStation) missionVariables.murphy_thargoid_drive_equipmentAvailable = "true"
//	else if((player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK") && station.isMainStation && this.detected) {
	else if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK") if(station.isMainStation && this.detected) {
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.bounty += 100;
		player.credits = Math.max(0, player.credits - 1000);	// 1000 credit fine, reducing to 0 credits if below 1000!
		clock.addSeconds(100000 - this.driveCounter*20000);	// takes roughly 1 day's time... easier to remove more advanced Thargoid Witchspace Drive due to less mess left behind!
		player.consoleMessage("Galcop customs have detected Illegal Thargoid Technology on your ship. Ship raided by customs and Thargoid Witchspace Drive impounded. Legal penalty and fines applied.",20);
	} else if(system.techLevel > 12 && !station.isMainStation) missionVariables.murphy_thargoid_drive_equipmentAvailable = "true";
	delete this.detected;
}

this.shipLaunchedFromStation = function(station)
{
	if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}
	delete missionVariables.murphy_thargoid_drive_equipmentAvailable;
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_QUOTE") === "EQUIPMENT_OK") player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_REMOVAL") === "EQUIPMENT_OK") player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_REMOVAL");
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT_REMOVAL") === "EQUIPMENT_OK") player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT_REMOVAL");
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && (Math.random() < (this.detectChance + ((system.government + system.techLevel - 16)/100)))) {this.policeScanTimer = new Timer(this, this.scanForThargoidDrive,30,30); if(this.loggingEnabled){log(this.name,"Police scanner Timer initialised.");}}
	if(missionVariables.murphy_thargoid_drive_driveCounter) this.startUp;	// To catch in-station changes!
}

this.shipDied = function()
{if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}}

this.scanForThargoidDrive = function()
{
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") !== "EQUIPMENT_OK"){this.policeScanTimer.stop();delete this.policeScanTimer;return;}
	var police;
	var counter;
	police = system.shipsWithPrimaryRole("police",player.ship,player.ship.scannerRange);
	if(police.length > 0) {
		var arrayLength = police.length;
		for (counter = 0; counter < arrayLength;counter++) {
			if(!police[counter].target && Math.random() < 0.5) {
				player.bounty+=250;
				police[counter].target = player.ship;
				police[counter].switchAI("policeInterceptAI.plist");
				police[counter].commsMessage("Thargoid drive signature detected! Must be some sort of decoy - shoot to kill!",player.ship);
				this.detected = true;
				this.policeScanTimer.stop();
				delete this.policeScanTimer;
				break;
			}
		}
	}
}

this.shipExitedWitchspace = function()
{
	if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}
	if(!system.isInterstellarSpace && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && Math.random() < this.detectChance + (system.government + system.techLevel - 16)/100) {this.policeScanTimer = new Timer(this, this.scanForThargoidDrive,30,30); if(this.loggingEnabled){log(this.name,"Police scanner Timer initialised.");}}
	if(this.jumping && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK") {delete this.playerJumpSuccess; this.jumpFunction(); return;} // if part way through jump chain continue.
}

// if part way through jump chain set playerJumpSuccess flag on wormhole entry, and increase TAF to 16 for jump.
this.shipWillEnterWitchspace = function(type)
{if(type === "wormhole" && this.jumping) {this.playerJumpSuccess = true; this.misjumpCounter++; player.ship.energy = player.ship.maxEnergy - (player.ship.maxEnergy * this.powerRequirement); if(this.dynamicTAF) timeAccelerationFactor = 16;}}

// called from equipmentScript to start jump chain
this.initialJump = function()
{
 if(this.loggingEnabled) log(this.name,"this.initialJump called from equipment script.");
 if(this.disableEquipment) {
	if(this.loggingEnabled) log(this.name,"Equipment disabled as this.disableEquipment flag set by other OXP.");
	player.consoleMessage("Could not activate Thargoid Witchspace Drive - malfunction - unknown cause!",6);
	return;
 }
 if(this.jumping) { // if activated during existing jump chain will abort existing jump chain
	this.abortJump = true;
	if(this.loggingEnabled) log(this.name,"this.initialJump called during jump chain - will abort jump chain.");
	player.consoleMessage("Thargoid Witchspace Drive deactivated - jump chain aborting!",6);
//	this.$twd_stop();	// Added this line since it wasn't actually stopping the jumps!
	return;
 }
 if(!system.isInterstellarSpace && this.disableNormalSpaceStart) {player.consoleMessage("Thargoid Witchspace Drive blocked by local star's gravity well. This equipment can only be activated in Interstellar space.",6); return;} // optionally disable starting the equipment in normal space
 if(system.ID === player.ship.targetSystem) { // warn player and abort jump if targetSystem is same as system.ID.
	if(this.loggingEnabled) log(this.name,"No target system set. Aborting jump.");
	player.consoleMessage("Please select a target system on the Long Range Chart before activating Thargoid Witchspace Drive.",6);
	return;
 }
 if(player.ship.energy < player.ship.maxEnergy * this.powerRequirement) {
	if(this.loggingEnabled) log(this.name,"Not enough energy to initialise jump.");
	player.consoleMessage("Energy too low to activate Thargoid Witchspace Drive.",6);
	return;
 }
 if(this.timeCheckTimer && this.timeCheckTimer.isRunning) {
	this.timeCheckTimer.stop();
	delete this.timeCheckTimer;
	delete this.expectedTime;
	delete this.startTime;
	if(this.loggingEnabled) log(this.name,"Time check timer not completed prior to initialising new jump. Timer stopped and variables cleared.");
 }
 if(this.dynamicTAF) timeAccelerationFactor = 1;
 delete this.jumpArray; // delete jumpArray from previous use
 this.targetSystem = player.ship.targetSystem; // get target system
 this.getRoute(); // call function to calculate initial jump chain.
 if(!this.jumpArray) { // if no valid route end function.
	if(this.loggingEnabled) log(this.name,"No valid route from system:"+ system.ID+" to system:"+player.ship.targetSystem);
	player.consoleMessage("No valid route to target system.",6);
	return;
 }
	this.jumping = true; // flag used to note that player is in jump chain
	if(this.loggingEnabled) log(this.name,"this.jumpArray: "+this.jumpArray+" ,this.jumpArray.length: "+this.jumpArray.length);
	this.misjumpCounter = 0; // counter for actual number of jumps utilised.
	this.shortenChain = 0;
	this.repeatTolerance = 16 - this.driveCounter*2; // was 13;
	this.jumpFunction(true); // start jumpFunction with parameter true as first jump in chain.
}

this.getRoute = function()
{
	var sysInRange = SystemInfo.systemsInRange(7); // get array of systems in range of a jump
	if(sysInRange.length > 0) {
	var arrayLength = sysInRange.length;
	var counter;
	var sysInRangeID = new Array(sysInRange.length)
	for (counter = 0; counter < arrayLength;counter++) sysInRangeID[counter] = sysInRange[counter].systemID;	// make an array of systems IDs in range.
	if(this.loggingEnabled) log(this.name,"Calculate route first stage. Systems in range: "+sysInRangeID);
	var timeFromSys = new Array(sysInRangeID.length);
	var distance;
	var routeTime;
	for (counter = 0; counter < arrayLength;counter++) {	// make an array of the jump times from those systems to the target with a modifier for a misjump in the direction of that system.
	if(System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method)) {
		distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,sysInRangeID[counter]));
		routeTime = System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time + (distance*distance*this.updateRouteModifier);
		timeFromSys[counter] = Number(routeTime.toFixed(2));
	} else timeFromSys[counter] = 9999;
	}
	if(this.loggingEnabled) log(this.name,"Calculated jump chain travel times from nearby systems: "+timeFromSys);
	var firstjumpSysTime = timeFromSys[0];
	var firstjumpSysID = sysInRangeID[0];
	for (counter = 0; counter < arrayLength;counter++) {	// chose system with shortest travel time to target
		if(timeFromSys[counter] <= firstjumpSysTime){firstjumpSysTime = timeFromSys[counter];firstjumpSysID = sysInRangeID[counter];}
		if(this.loggingEnabled) log(this.name,"timeFromSys[counter]:" + timeFromSys[counter] + " sysInRangeID[counter]:" + sysInRangeID[counter] + " firstjumpSysTime:" + firstjumpSysTime + " firstjumpSysID:" + firstjumpSysID);
	}
	if(firstjumpSysTime !== 9999) { // means that there was no valid route to target system.
	if(!this.expectedTime) { // set expected time of arrival if route was normal jumps.
		if(!system.isInterstellarSpace) this.expectedTime = System.infoForSystem(galaxyNumber,system.ID).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time
		else this.expectedTime = firstjumpSysTime;
		this.startTime = clock.seconds;
	}
	if(this.jumpArray) { // if updating route mid chain do some checks...
		if(this.loggingEnabled) log(this.name,"jumpArray[jumpCounter]: "+ this.jumpArray[this.jumpCounter] + " alternative: "+ firstjumpSysID);
		if(this.jumpArray[this.jumpCounter] === firstjumpSysID) {
			this.shortenChain = 0;
			if(this.loggingEnabled)log (this.name,"Retaining current jump chain, no better option.");
			return;
		}// don't update if already on best route
		if(this.jumpArray[this.jumpCounter - 1] === firstjumpSysID){
			this.shortenChain++;
			if(this.shortenChain > this.repeatTolerance){
				this.shortenChain = 0;
				if(this.loggingEnabled) log (this.name,"Retaining current jump chain - have recalculated to same target more than "+(this.repeatTolerance+1)+" times.");
				if(this.repeatTolerance > 0) this.repeatTolerance--
				return;
			}
		} // shorten some very long jump chains by setting limit on repeated misjump to same system. Now requires better-than-bare-minimum drive!
		if(this.driveCounter > 1) if((System.infoForSystem(galaxyNumber,firstjumpSysID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter]))=== 0 || (this.jumpArray[this.jumpCounter-1] !== firstjumpSysID && (System.infoForSystem(galaxyNumber,firstjumpSysID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter-1])) === 0))) || (this.jumpCounter-2 !==0 && this.jumpArray[this.jumpCounter-2] === firstjumpSysID)) {
			this.shortenChain = 0;
			if(this.loggingEnabled) log (this.name,"Retaining current jump chain, avoiding loop.");
			return;
		}//avoids loops if route includes a 0 distance pair.
		distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter]));
		if(distance <= 7) {
			routeTime = Number((System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time + (distance*distance*this.updateRouteModifier)).toFixed(2));
			if(routeTime <= firstjumpSysTime) {
				this.shortenChain = 0;
				if(this.loggingEnabled) log (this.name,"Retaining current jump chain. Current Route Time: "+routeTime+" Alternative Route Time: "+firstjumpSysTime);
				return;
			} // don't update if already on best route
		} else {	// if distance isn't <= 7 then we can infer it is > 7!
			distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter-1]));
			routeTime = Number((System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter-1]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time + (distance*distance*this.updateRouteModifier)).toFixed(2));
			if(routeTime <= firstjumpSysTime) {
				this.shortenChain = 0;
				if(this.loggingEnabled) log (this.name,"Retaining current jump chain. Current Route Time: "+routeTime+" Alternative Route Time: "+firstjumpSysTime);
				return;
			} // don't update if already on best route
		}
	}
	this.firstjumpID = new Array;
	this.firstjumpID[0] = firstjumpSysID;
	this.jumpArray = System.infoForSystem(galaxyNumber,this.firstjumpID[0]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route;
//	} else this.unreachableSystem(sysInRangeID);	// FOR TESTING ONLY!
	} else if(this.driveCounter >1) this.unreachableSystem(sysInRangeID);	// Unreachable systems now require better-than-bare-minimum drive!
	if(this.driveCounter >3) {	// HAD to place shortcuts here, because the destinations aren't unreachable...just LONG.
		var testArray = this.jumpArray;
		if(galaxyNumber === 0) {
			if(this.targetSystem === 247) {
				if(system.ID === 74) this.jumpArray =[194,247];
				if(system.ID===194) this.jumpArray =[74,247];
			}
		}
		if(galaxyNumber === 1) {
			if(this.targetSystem === 192) {
				if(system.ID === 12) this.jumpArray =[172,12,12,12,10,192];
				if(system.ID === 10) this.jumpArray =[172,12,12,12,10,192];
				if(system.ID===172) this.jumpArray =[12,12,12,12,10,192];
			}
			if(this.targetSystem === 27) {
				if(system.ID===175) this.jumpArray =[220,192,175,175,27];
				if(system.ID===192) this.jumpArray =[220,175,192,175,175,27];
				if(system.ID===220) this.jumpArray =[175,192,175,175,27];
			}
			if(this.targetSystem ===100) {
				if(system.ID===  37) this.jumpArray =[255,100];
				if(system.ID===255) this.jumpArray =[37,100];
			}
		}
		if(galaxyNumber === 5) {
			if(this.targetSystem === 100) {
				if(system.ID === 89) this.jumpArray =[148,100];
				if(system.ID===148) this.jumpArray =[89,100];
			}
			if(this.targetSystem === 108) {
				if(system.ID === 26) this.jumpArray =[244,108];
				if(system.ID===244) this.jumpArray =[26,108];
			}
			if(this.targetSystem === 244) {
				if(system.ID===143) this.jumpArray =[108,244];
				if(system.ID===108) this.jumpArray =[143,244];
			}
			if(this.targetSystem === 238) {
				if(system.ID===137) this.jumpArray =[251,238];
				if(system.ID===251) this.jumpArray =[137,238];
			}
			if(this.targetSystem === 214) {
				if(system.ID === 36) this.jumpArray =[221,45,45,36,45,45,36,214];
				if(system.ID === 45) this.jumpArray =[154,36,45,45,36,214];
				if(system.ID===154) this.jumpArray =[45,36,45,45,36,214];
				if(system.ID===221) this.jumpArray =[45,45,36,45,45,36,214];
			}
		}
		if(this.jumpArray != testArray) this.unreachableJumpChain = true;	// Even though not unreachable, must treat as such or jump logic will override the set path!
		var testArray = null;	// Only used to determine if jumpArray was changed.
	}
	if(!this.jumpArray) {
		if(this.loggingEnabled) log(this.name,"No valid route from system:"+ system.ID+" to system:"+player.ship.targetSystem);
		player.consoleMessage("No valid route to target system.",6);
		return;
	}
	this.jumpArray = this.firstjumpID.concat(this.jumpArray);
	this.jumpCounter = 1;
	if(this.loggingEnabled) log(this.name,"Jump path calculated to: "+ this.jumpArray,this.driveCounter);
	}
}

// used for special cases - crossing Great Rift and getting to Oresrati.
this.unreachableSystem = function(sysInRangeID)
{
	if(this.loggingEnabled) log(this.name,"this.unreachableSystem called.",this.driveCounter);
	if(galaxyNumber < 6) return;
	var timeFromSys = new Array(sysInRangeID.length);
	var counter;
	var distance;
	var routeTime;
	var arrayLength = sysInRangeID.length;
	var firstStageDest;
	var timeFromSys = new Array(sysInRangeID.length)
// Since only the best drive version can start from a regular system, no need to check for it!
	if(galaxyNumber ===6) { // first look at cases where player is already at a 'gateway' system for a Great Rift crossing.
	if(system.ID === 89 || system.ID === 194 || system.ID === 17 || system.ID === 178 || system.ID === 36 || system.ID === 46 || system.ID === 180 || system.ID === 192 || system.ID === 212) {
		this.unreachableJumpChain = true;
		if(!this.expectedTime) {this.expectedTime = "Route not possible by normal jumps."; this.startTime = clock.seconds;}
		this.firstjumpID = new Array;
		this.firstjumpID[0] = system.ID;
		switch (system.ID) {
		case 89:
		this.jumpArray = [194];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 194:
		this.jumpArray = [89];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 17:
		this.jumpArray = [178];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 178:
		this.jumpArray = [17];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 36:
		this.jumpArray = [212,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 46:
		this.jumpArray = [36,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 180:
		this.jumpArray = [36,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 192:
		this.jumpArray = [212,36,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 212:
		this.jumpArray = [36,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		}
		return;
	} // otherwise check which side of rift we are on and set a first stage destination as a gateway system
	if(System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 89),this.method)) {
		routeTime = System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 89),this.method).time;
		if(routeTime < System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 194),this.method).time) firstStageDest = 89
		else firstStageDest = 194;
		if(routeTime > System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 212),this.method).time && System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 194),this.method).time > System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 212),this.method).time && this.driveCounter > 2) firstStageDest = 212;
	} else firstStageDest = 17;
	} // next look at case of jump to Oresrati from gateway systems
	if(galaxyNumber === 7 && this.targetSystem === 162 && system.ID !== 162) if(system.ID === 118 || system.ID === 121 || system.ID === 9) {
	this.firstjumpID = new Array;
	if(system.ID === 118 || system.ID === 121) {
		this.firstjumpID[0] = 121;
		this.jumpArray =[9,88,118,88,162];
	} else {
		this.firstjumpID[0] = 9;
		this.jumpArray =[121,88,118,88,162];
	}
	this.unreachableJumpChain = true;
	if(!this.expectedTime) {this.expectedTime = "Route not possible by normal jumps."; this.startTime = clock.seconds;}
	return;
	} else {	// otherwise set either 9 or 121 as first stage destination
		if(this.driveCounter > 2 && (player.ship.galaxyCoordinates.x > 21 || player.ship.galaxyCoordinates.y <192)) firstStageDest = 9
		else firstStageDest = 121;
	}
// then go on to create jumpArray to appropriate gateway system, the misjump route, and remainder of route.
	for (counter = 0; counter < arrayLength;counter++) {
	if(System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, firstStageDest),this.method)) {
		distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,sysInRangeID[counter]));
		routeTime = System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, firstStageDest),this.method).time + (distance*distance*this.updateRouteModifier);
		timeFromSys[counter] = routeTime;
	} else timeFromSys[counter] = 9999;
	}
	if(this.loggingEnabled) log(this.name,"Calculated times from nearby systems: "+timeFromSys);
	var firstjumpSysTime = timeFromSys[0];
	var firstjumpSysID = sysInRangeID[0];
	for (counter = 1; counter < arrayLength;counter++) if(timeFromSys[counter] < firstjumpSysTime){firstjumpSysTime = timeFromSys[counter];firstjumpSysID = sysInRangeID[counter];}
	if(firstjumpSysTime !== 9999) {
	if(!this.expectedTime) {this.expectedTime = "Route not possible by normal jumps."; this.startTime = clock.seconds;}
	this.firstjumpID = new Array;
	this.firstjumpID[0] = firstjumpSysID;
	this.jumpArray = System.infoForSystem(galaxyNumber,this.firstjumpID[0]).routeToSystem(System.infoForSystem(galaxyNumber, firstStageDest),this.method).route;
	if(firstStageDest === 89) {
		if(this.driveCounter > 3) this.jumpArray.push(89,194) // Misjump to Maedreale and then misjump to Tiared
		else this.jumpArray.push(89,89,89,194); // Misjump as close as possible to Maedreale and then misjump to Tiared
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route); // before misjumping across the rift to Articeso and following rest of route.
	}
	if(firstStageDest === 194) {
		if(this.driveCounter > 3) this.jumpArray.push(194,89) // Misjump to Tiared and then misjump to Maedrale
		else this.jumpArray.push(194,194,194,89); // Misjump as close as possible to Tiared and then misjump to Maedrale
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
	}
	if(firstStageDest === 17) {
		if(this.driveCounter > 3) this.jumpArray.push(17,178); // Misjump to Esarxeve and then misjump to Xeona
		else this.jumpArray.push(17,17,17,178); // Misjump as close as possible to Esarxeve and then misjump to Xeona
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route); // before misjumping across the rift to Belera and following rest of route.
	}
	if(firstStageDest === 212) {
		if(this.driveCounter > 3) this.jumpArray.push(212,36,212,180,192) // Misjump close to 212 and then misjump to 36
		else this.jumpArray.push(212,212,212,36,212,180,192); // Misjump as close as possible to 212 and then misjump to 36
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
	}
	if(firstStageDest === 9) if(this.driveCounter > 3) this.jumpArray.push(9,121,88,118,88,162) // add Oresrati misjump chain
		else this.jumpArray.push(9,9,9,121,88,118,88,162); // add Oresrati misjump chain -- duplicate route starting from 9 instead of 121!).
	if(firstStageDest === 121)  if(this.driveCounter > 3) this.jumpArray.push(121,9,88,118,88,162) // add Oresrati misjump chain
		else this.jumpArray.push(121,121,121,9,88,118,88,162); // add Oresrati misjump chain (thanks to Okti and onewayticket).
	if(player.ship.galaxyCoordinates.x >=20 && player.ship.galaxyCoordinates.x <=21 && player.ship.galaxyCoordinates.y >211 && player.ship.galaxyCoordinates.y <213 && galaxyNumber ===7 && this.targetSystem === 162 && this.driveCounter > 2) this.jumpArray = [88,118,88,162]; // add Oresrati misjump chain -- starting in interstellar space between 9 and 121!
	if(this.loggingEnabled) log(this.name,"Jump Route:",this.jumpArray,"other vars:",firstStageDest,firstjumpID,firstjumpSysID,firstjumpSysTime);
	this.unreachableJumpChain = true;
	}
}

 this.jumpFunction = function(firstjump)
{
//	if(this.loggingEnabled) log(this.name,"this.jumpFunction called with firstjump flag: " + firstjump);
	if(!firstjump && this.jumpEntity && this.jumpEntity.isValid) this.jumpEntity.remove(true); // removes jumpEntity from previous jump if present.
	if(this.jumpCounter >= this.jumpArray.length || this.abortJump || (!system.isInterstellarSpace && this.driveCounter <4)) { // checks if last jump was final jump, 'stuck' at a system, or if player has reactivated equipment part way through chain -- and if so end function
		if(this.loggingEnabled) log(this.name,"Jump ended. Total Misjumps: "+this.misjumpCounter);
		player.consoleMessage("Jump ended. Total Misjumps: "+this.misjumpCounter,12);
//		if(Math.random() < this.detectChance*Math.log(Math.max(1,this.misjumpCounter))) system.addGroup("thargoid",Math.ceil((Math.random()+Math.random())*Math.log(Math.max(1,this.misjumpCounter))),player.ship,20000);	// Thargoids detected you and hitchhike on your wormhole!
		if(Math.random() < this.detectChance*Math.log(Math.max(1,this.misjumpCounter-this.driveCounter*2))) system.addGroup("thargoid",Math.ceil((Math.random()+Math.random())*Math.log(Math.max(1,this.misjumpCounter-this.driveCounter*2))),player.ship,20000);	// Thargoids detected you and hitchhike on your wormhole!
		if(Math.random() < this.damageChance && this.misjumpCounter > 2) {
			var equipment = player.ship.equipment;
			var index = Math.floor(Math.random()*equipment.length);
			player.ship.setEquipmentStatus(equipment[index],"EQUIPMENT_DAMAGED");
			player.consoleMessage(equipment[index].name+ " damaged in transit!",15);
		} else {player.ship.awardEquipment("EQ_RENOVATION"); player.ship.removeEquipment("EQ_RENOVATION");}	// This line is bizarre!	Does it instantly repair the ship?
		player.ship.energy = player.ship.maxEnergy - (player.ship.maxEnergy * this.powerRequirement);
		if(this.expectedTime) this.timeCheckTimer = new Timer(this,this.timeCheck,1,1)	// was 0.25,0.25)
		else this.$twd_stop();
		return;
	}
	if(!firstjump) { // if part way through jump chain set timer for next jump
		if(!this.unreachableJumpChain && this.updateRouteMidChain) this.getRoute(); // call function to update route
		this.jumpTimer = new Timer(this, this.startnextJump,1,1);	// was 0.25,0.25);
		return;
	} // otherwise carry on for first jump
	this.jumpFailed = 1; // set jumpFailed flag to 1
	this.nextJump(); // start jump
}

// called by timer every second if part way through jump chain. Next jump only starts once !clock.isAdjusting returns false. This is to avoid issues with memory spiking and to allow other OXP scripts time to do their stuff.
this.startnextJump = function()
{
//	if(!clock.isAdjusting) { // on second iteration when clock.isAdjusting is false start next jump;
	if(!clock.isAdjusting && player.ship.energy > (player.ship.maxEnergy * this.powerRequirement)) { // on second iteration when clock.isAdjusting is false start next jump;
		if(timeAccelerationFactor > 1 && this.dynamicTAF) timeAccelerationFactor = 1;	// speed things up a bit over original...hopefully without disasters!
		if(this.jumpTimer) {
			this.jumpTimer.stop();
			delete this.jumpTimer;
		}
		this.jumpFailed = 1;
		if(this.jumpCounter) if(this.jumpCounter <= this.jumpArray.length) this.nextJump();
	}
}

// this function starts the jump
this.nextJump = function()
{
	if(this.jumpFailed >= 15 || this.abortJump || !this.jumpArray || this.jumpArray == null || (!system.isInterstellarSpace && this.driveCounter <4 && this.jumpCounter < this.jumpArray.length)) { // if jumpEntity fails to create a wormhole or player fails to collide with wormhole and there have been 15 re-tries... then quit trying to make new wormholes!
		log(this.name,"Jump chain failure. Long range jump aborted. Total Misjumps: "+this.misjumpCounter);
		player.consoleMessage("Jump chain failure! Long range jump aborted. Total Misjumps: "+this.misjumpCounter,9);
		if(Math.random() < this.detectChance*Math.log(Math.max(1,this.misjumpCounter-this.driveCounter*2))) system.addGroup("thargoid",Math.ceil((Math.random()+Math.random())*Math.log(Math.max(1,this.misjumpCounter-this.driveCounter*2))),player.ship,20000);	// Thargoids detected you and hitchhike on your wormhole!
		this.$twd_stop();
		return;
	}
	var nextdest = this.jumpArray[this.jumpCounter];
	var dist = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,nextdest));
// the jump chain is a series of misjumps - if the next system in the jumpArray is <= 7 lightyears set it as destination and misjump - if it is > 7 lightyears retain last jump target system and misjump a bit closer. As the jumpArray is optimised by time at some point the next system should always be within range, I think!!! ;-)
	if(dist <= 7) {
		if((system.ID == nextdest || dist == 0) && this.jumpCounter < this.jumpArray.length) {	// Catches arriving at a regular system breaking rest of jump chain!
			this.jumpCounter++;
			this.repeatTolerance = 15 - this.driveCounter; // was 13;
			this.nextJump();
			return;
		}
		if(dist < 0.8) {
			if(this.driveCounter==3 && (this.repeatTolerance < 8 || !this.unreachableJumpChain)) player.ship.scriptedMisjumpRange = .75;
			if(this.driveCounter > 3 && (this.repeatTolerance < 7 || !this.unreachableJumpChain)) player.ship.scriptedMisjumpRange = .9999999;
			this.repeatTolerance--;
		} else if(this.driveCounter > 1) this.repeatTolerance = 16 - this.driveCounter*2;
		this.jumpCounter++;
		this.jumpCounterInc = true;
		if(this.driveCounter==1) this.repeatTolerance = 14;
	} else {
		nextdest = this.jumpArray[(this.jumpCounter - 1)];
		if(this.driveCounter > 3) {
			this.repeatTolerance--;
			player.ship.scriptedMisjumpRange = .9999999;	// Misjumps extremely close to current target system to overcome looping misjumps. Only works with BEST version of drive!
		} else {
			this.repeatTolerance = 16 - this.driveCounter*2;
			if(this.driveCounter==3) player.ship.scriptedMisjumpRange = .75;	// Next-to-best drive now gets a double-Misjump to current target system to overcome looping misjumps to the same system.
		}
	}
	if(this.jumpCounter < this.jumpArray.length && (this.driveCounter < 4 || (dist > 0.4 && dist < 7) || (this.repeatTolerance > 6 && this.unreachableJumpChain))) player.ship.scriptedMisjump = true;
//	if(this.jumpCounter < this.jumpArray.length && (this.driveCounter < 4 || (dist > 0.4 && dist < 7) || this.repeatTolerance > 0 || this.unreachableJumpChain)) player.ship.scriptedMisjump = true;
	if(this.loggingEnabled) log(this.name,"Current location: "+ system.ID +" Jump destination: "+ nextdest +" Distance: "+(Number(dist).toFixed(1))+" (mis)jump number: "+ this.jumpCounter +" X, Y: "+ (Number(player.ship.galaxyCoordinates.x).toFixed(6)),(Number(player.ship.galaxyCoordinates.y).toFixed(6))+ " problem flags: "+ this.misjumpCounter, this.shortenChain, this.repeatTolerance, player.ship.scriptedMisjump, player.ship.scriptedMisjumpRange);

	if(system.isInterstellarSpace) player.commsMessage("At x,y: "+Number(player.ship.galaxyCoordinates.x).toFixed(4)+" , "+Number(player.ship.galaxyCoordinates.y).toFixed(4)+" , Misjumps: "+this.misjumpCounter,9)
	else player.commsMessage("At system #"+system.ID+" x,y: "+player.ship.galaxyCoordinates.x+" , "+player.ship.galaxyCoordinates.y+" , Misjumps: "+this.misjumpCounter,9);
	this.jumpEntity = system.addShips("alloy",1,[-9E7*(1+Math.random()), -9E7*(1+Math.random()), -9E7*(1+Math.random())],0)[0]; // spawn jumpEntity FAR from anything!	Try alloy or ico for jump object!
	this.jumpEntity.fuel = 7; // ensure jumpEntity has full tank
	var jumpsuccess = this.jumpEntity.exitSystem(nextdest); // and create wormhole
	if(!jumpsuccess) { // if jump failed try again after incrementing jumpFailed flag. This will result in the jumpEntity spawning further ahead of the player and a reduced velocity boost.
		if(this.jumpCounterInc){this.jumpCounter--; delete this.jumpCounterInc;}
		this.jumpEntity.remove(true);
		this.jumpFailed++;
		if(this.loggingEnabled) log(this.name,"Jump FAILED: "+ jumpsuccess,jumpFailed,this.repeatTolerance,this.jumpCounter);
		this.nextJump();
		return;
	} else player.ship.position = this.jumpEntity.position.add(player.ship.heading.multiply(-150));	// Almost unavoidable when player's ship is moved in front of the wormhole!
//	(-130));	// Unavoidable when player's ship is moved into the wormhole! All you'll typically see is a flash of light and then the wormhole tunnel.
	this.jumpEntity.switchAI("missileAI.plist");
	this.jumpEntity.AIState ="EXPLODE";
	this.jumpEntity.remove(true);
}

this.$twd_stop = function ()
{
	if(this.dynamicTAF) timeAccelerationFactor = 1;
	delete this.jumpArray;
	delete this.jumpCounter;
	delete this.jumping;
	delete this.unreachableJumpChain;
	delete this.misjumpCounter;
	delete this.abortJump;
	delete this.startTime;
	delete this.expectedTime;
	if(this.jumpTimer) {
		this.jumpTimer.stop();
		delete this.jumpTimer;
	}
	if(this.timeCheckTimer) {
		this.timeCheckTimer.stop();
		delete this.timeCheckTimer;
	}
}

this.playerWillEnterWitchspace = function()
{
	if(this.jumpTimer) {
		this.jumpTimer.stop();
		delete this.jumpTimer;
	}
	if(this.timeCheckTimer) {
		this.timeCheckTimer.stop();
		delete this.timeCheckTimer;
	}
	if(this.jumpEntity) this.jumpEntity.remove(true);
}

this.timeCheck = function()
{
	if(!clock.isAdjusting) {
		this.timeCheckTimer.stop();
		delete this.timeCheckTimer;
		var timeTaken = Number(((clock.seconds-this.startTime)/3600).toFixed(1));
		if(this.expectedTime !== "Route not possible by normal jumps.") this.expectedTime = Number(this.expectedTime.toFixed(1));
		if(this.loggingEnabled) log(this.name,"Expected time (Normal Jumps) "+this.method+": "+this.expectedTime+" Actual time (misjumps): "+ timeTaken);
		player.consoleMessage("Best Time (Quirium Drive): "+ this.expectedTime +" Actual Time (Thargoid Witchspace Drive): "+ timeTaken +".",15);
		this.$twd_stop();
	}
}